package edu.mayo.genotype;

public class SnpScoreComparator implements java.util.Comparator<Snp> {
	public int compare(Snp s1,Snp s2) {

		if(s1==s2) {
			return 0;
		} else if (s1==null) {
			return 1;
		} else if (s2==null) {
			return -1;
		}
		boolean onlyChoice1 = s1.isUniquelyCovers() && !s1.isExcluded();
		boolean onlyChoice2 = s2.isUniquelyCovers() && !s2.isExcluded();
		boolean s1oblig = s1.isObligate() && !s1.isExcluded();
		boolean s2oblig = s2.isObligate() && !s2.isExcluded();
		if(((s1oblig  ))) {
			if(!((s2oblig))) {
				return -1;
			} 
		}
		if(((s2oblig  ))) {
			if(!((s1oblig ))) {
				return 1;
			}
		}
		if(s1.isExcluded() && ! s2.isExcluded()) {
			return 1;
		} else if (s2.isExcluded() && !s1.isExcluded()) {
			return -1;
		}

		// if both obligates or not obligates ==> let the rest of the rules apply.
		if(onlyChoice1 && !onlyChoice2) {
			return -1;
		} else if ((!onlyChoice1) && onlyChoice2) {
			return 1;
		}
		double c1 = s1.getSuccessProb();
		double c2 = s2.getSuccessProb();
		if(c1==c2) {
			double fac1 = SnpScorer.getLocationClassScore(s1.getLocation());
			double fac2 = SnpScorer.getLocationClassScore(s2.getLocation());
			if(fac1>fac2) {// more positive is better.
				return -1;
			} else if (fac1<fac2) {
				return +1;
			} else {
				int nbin1 = s1.getNbins();
				int nbin2 = s2.getNbins();
				if(nbin1>nbin2) {
					return -1; // put Snp1 first because it touches more bins.
				} else if (nbin1==nbin2) {
					double sco1 = s1.getScore();
					double sco2 = s2.getScore();
					if(sco1>sco2) {
						return -1;
					} else if (sco2>sco1) {
						return 1;
					} else {
						if(s1.getId()==s2.getId()) {
							return 0;
						} else {
							if(s1.getId()<s2.getId()) {
								return -1;
							} else {
								return 1;
							}
						}
					}
				} else {
					return 1;
				}
			}
		} else {
			if(c1>c2) {
				return -1; // put c1 first.
			} else return +1;
		}
	}
}
