package edu.mayo.genotype;

public class SnpCoverageComparator  implements java.util.Comparator<Snp> {

	public int compare(Snp s1,Snp s2) {

		if(s1==s2) {
			return 0;
		} else if (s1==null) {
			return +1; // put s2 first
		} else if (s2==null) {
			return -1; // put s1 first
		}
		boolean s1oblig = s1.isObligate()|| s1.isObligateButNotGenotyped();
		boolean s2oblig = s2.isObligate()|| s2.isObligateButNotGenotyped();	
		if(s1.isExcluded() && ! s2.isExcluded()) {
			return 1;
		} else if (s2.isExcluded() && !s1.isExcluded()) {
			return -1;
		}

		if(s1oblig  && !s2oblig) {
			return -1;
		} else if(s2oblig && !s1oblig) {
			return 1;
		}
		// put obligates first
		if (s1oblig&& s2oblig) {
			if((!s1.isExcluded()) && s2.isExcluded()) {
				return 1;
			} else if ((!s2.isExcluded()) && s1.isExcluded()) {
				return -1;
			}
		}
		// both are excluded (or not ) .. and both are selected (or not)

		int nbin1 = s1.getNbins();
		int nbin2 = s2.getNbins();

		if(nbin1>nbin2) {
			return -1; // put Snp1 first because it touches more bins.
		} else if (nbin1<nbin2) {
			return 1;
		} else{
			int[] bins1 = s1.getBins();
			int[] bins2 = s2.getBins();
			boolean samePattern=true;
			boolean s1alwaysGT=true; // e.g. SNP 1 encloses all the bins that 2 does and maybe more
			boolean s2alwaysGT=true;// e.g. SNP 2 encloses all the bins that 1 does and maybe more
			if(bins1!=null && bins2!=null) {
				for(int i = 0;i<bins1.length;i++) { // nbin1==nbin2
					if(bins1[i]!=bins2[i]) {
						samePattern=false;
						if(bins1[i]==0) {
							s1alwaysGT=false;
						} else if(bins2[i]==0) {
							s2alwaysGT=false;
						}
					}
				}
			} else {
				if(bins1!=bins2) {
					if(bins1==null) {
						return 1;
					} else {
						return -1;
					}
				}
				samePattern=true;
			}
			if(samePattern || !(s1alwaysGT ||s2alwaysGT)) {
				double p1 = s1.getSuccessProb();
				double p2 = s2.getSuccessProb();
				if(p1==p2) {
					double fac1 = SnpScorer.getLocationClassScore(s1.getLocation());
					double fac2 = SnpScorer.getLocationClassScore(s2.getLocation());
					if(fac1>fac2) {// more positive is better.
						return -1;
					} else if (fac1<fac2) {
						return +1;
					} else {
						double sco1 = s1.getScore();
						double sco2 = s2.getScore();
						if(sco1>sco2) {
							return -1;
						} else if (sco1<sco2) {
							return 1;
						} else {
							if(s1.getId()<s2.getId()) {
								return -1;
							} else if (s1.getId()>s2.getId()) {
								return 1;
							} else {
								return 0;
							}
						}
					}
				} else if(p1>p2) {
					return -1;
				} else {
					return 1;
				}
			} else {
				if(s1alwaysGT) {
					return -1;
				} else if(s2alwaysGT){ // s2alwaysGT == true;
					return 1;
				} else {
					double p1 = s1.getSuccessProb();
					double p2 = s2.getSuccessProb();
					if(p1==p2) {
						double fac1 = SnpScorer.getLocationClassScore(s1.getLocation());
						double fac2 = SnpScorer.getLocationClassScore(s2.getLocation());
						if(fac1>fac2) {// more positive is better.
							return -1;
						} else if (fac1<fac2) {
							return 1;
						} else {
							double sco1 = s1.getScore();
							double sco2 = s2.getScore();
							if(sco1>sco2) {
								return -1;
							} else if (sco1<sco2) {
								return 1;
							} else {
								if(s1.getId()<s2.getId()) {
									return -1;
								} else if (s1.getId()>s2.getId()) {
									return 1;
								} else {
									return 0;
								}
							}
						}
					} else if(p1>p2) {
						return -1;
					} else {
						return 1;
					}
					
					
				}
			}
		}
	}
}
