package edu.mayo.genotype;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Iterator;
import java.util.HashSet;
import java.io.PrintStream;

public class Snp {
	// Class level variables for Object Manager
	  private static int nsnps=0; // used to allocate unique IDS, maximum SNP id allocated
	  private static int snpCount=0; // used to count SNPs.
	  private static HashMap<String,Snp> haveSnp = new HashMap<String,Snp>(20000);
	  private static HashMap<String,Snp> snpByPosIndex = new HashMap<String,Snp>();

	  private static int indexSize=10000;
	  private static Snp[] snpIndex = new Snp[indexSize]; // Rebuildable index of all Snps
	  
	  // Instance variables
	  private String snpName=null;
	  private int snpid=0;


	  private int nbins=0; // number of pop + overlapping pops
	  private int[] bins=null;// vector of bin flags: kth element is binid in kth population"

	  private String chromosome=SNPPicker.chromosome ==null ? null : SNPPicker.chromosome.toUpperCase();
	  private int DEFAULT_POS=-1;
	  private int position =DEFAULT_POS;
	  private String maf_string =""; // in reality should have one per pop.. this is only a reflection of the input.

	  // Scoring variables.
	  private double score=SNPPicker.defaultScore;  // (design score of that snp .. from 0..100, -1 means not in file, -99 means unknown to Illumina)
	  private String scoreClass ="0"; // Design category 0,... Groups Scores  {"0","0.25","0.5","0.75","1"};
	  private String validationClass = SNPPicker.defaultValidationClass;// For Illumina 1-not validated, 2-validated, 3 golden-gate validated

	  private String location="unspecified"; // coding, non-coding, nonsynon,synon, etc... See SnpScorer Class
	  private int location_class=0; // 0 = unspecified == default., higher is better.


	  private double failProb =SNPPicker.DEFAULT_FAIL_PROB; // Probability of Failure of Assay design. (SNP could still be homoz)	  
	  private double successProb = 1-SNPPicker.DEFAULT_FAIL_PROB; // This will get multiplied by the location dependent Score.. and
	  							// will no longer be a probability.

	  // Solution-related Variables
	  
	  private boolean excluded=false; // Must be excluded of solution. from input .. or from resolving too-close SNPS
	  private boolean obligate=false; // Must be part of solution. from input .. or from resolving too-close SNPS
	  private boolean selected = false; //  selected
	  private boolean fixed = false; // Fixed to be selected or not Selected by Snps Too Close.
	  
	  private boolean fixed_multi_test;
	  
	  private boolean uniquelyCovers=false; // This SNP is needed because it uniquely covers a bin.

	  // Variables for Exploring solutions

	  private boolean tmpSelected=false;
	  private boolean hasBeenReset=false;

	  
	  
	  // Variables for best solution so-far
	  private boolean bestSelected=false;
	  private boolean bestWasTransfered=false;

	  // Variables for loading tagger format.. Temporary valid, one Pop at a time.
	  private HashMap<String,Double> r2=null;
	  private int preBin=0; // Keep track of new Bins overlapping this SNP
	  
	  // Variable for printing
	  protected boolean wasPrinted=false;
	  private double utility=0.0;  // Utility of this SNP if this was the only one selected.
	  private double incrementalUtility=0.0; // This is the value that will be reported.
	  private double currentUtility=0.0; // incremental utility divided by the number of beads - used for sorting.
	  private int selectionOrder=0;
	  
	  private boolean obligateButNotGenotyped=false;
	  
	  private HashSet<String> synonyms = null;
	  // 
	  String alleles=""; // for report and to use in nI2beads
	  String gene=""; // for report only, from illumina
	  String geneId=""; // No data source for it.
	  String source=""; // No data source for it.
	  
	  String build="36";  // Genome build From annotation file
	  String dbsnpid=""; 
	  private static HashMap<String,Snp> dbsnpid2Snp = new HashMap<String,Snp>();
	  int OPAid=0; // 0 = no conflicts, 1,2,3,4 .. fixed.
	  
	  /* Infinium II uses red for A+T and green for C/G ==>
	   * can handle with one bead type ddU{[A/G], [C/T], [A/C], [G/T], but A/T and C/G SNP require two beads. 
	   */
	  int nI2beads=1;
	  
	  //private String warning=null;
	  
	  /**
	   * 
	   * @param npop requires total number of population to sim
	   * @param name e.g.dbsnpid 
	   * @param binid  existing binid (or 0) Bin will not be created
	   */

	  public Snp(int popid,String _name,int binid) {
		  String name = (_name ==null ? "" : _name.toLowerCase());
		  if(popid>SNPPicker.maxBinPop) {
			  SNPPicker.maxBinPop+=5;
		  }
		  if(haveSnp.containsKey(name)) {
			  Snp s=  haveSnp.get(name);
			  if(s!=null) {
				  s.addBin(binid, popid);
				  return;
			  } else {
				  haveSnp.remove(name); // remove null mapping
			  }
		  }
		  this.snpName=name;
		  this.bins=new int[SNPPicker.maxBinPop]; // Maximum size of nbins==npop add 1 for Dummy Bin
		  for(int i=0;i<this.bins.length;i++) {
			  this.bins[i]=0;
		  }
		  if(popid>0 && binid>0) {
			  this.bins[popid-1]=binid;
			  this.nbins=1;
		  } else {
			  this.nbins=0;
		  }
		  Snp.nsnps++; // Incremental counted for Snpids
		  Snp.snpCount++; // Current number of SNPs
		  this.snpid=nsnps;
		  if(this.snpName.length()>0) {
			  haveSnp.put(this.snpName,this);
		  }
		  updateIndex(this);
		  this.r2= new HashMap<String,Double>();
		  this.preBin=0;
		  this.score = SNPPicker.defaultScore;
	  }
	  /**
	   * Assign that bin for that population for this SNP object
	   * @param binid
	   * @param popid
	   */
	  public void addBin(int binid,int popid) {
		  if(popid>0 && binid>0) {
			  if(popid>=bins.length) {
				  System.err.println("Too many populations, popid ("+Integer.toString(popid)+ ")> maxpop("+Integer.toString(bins.length) +"): Increase default -maxpop in SNPPicker.java"); System.err.flush();
				  System.exit(-1);
			  }
			  if(bins[popid-1]==0) {
				  nbins++;
			  }
			  bins[popid-1]=binid;
		  }
	  }

	  /**
	   * Delete that bin for that population for this SNP object .. and delete associated bin Edges.
	   * @param binid
	   * @param recursive If true, will also delete the bin.
	   */
	  public void deleteBin(int binid,boolean recursive) {
		  int dnbins=0;
		  if(this.bins !=null) {
			  for(int i=0;i<this.bins.length;i++) {
				  if(this.bins[i]==binid) {
					  this.bins[i]=0;
				  }
				  if(this.bins[i]>0) {
					  dnbins++;
					  Bin b = Bin.getBinById(this.bins[i]);
					  b.deleteBinEdge(binid,this.snpid,true); // process both "ends" of the bin.
					  this.bins[i]=0;
				  }
			  }
		  }
		  this.nbins = Utils.sumGT0(this.bins);
		  
		  if(recursive) {
			  Bin.deleteByName(Bin.getBinById(binid).getName(), false);
		  }
	  }
	  public void deleteAllBins(boolean recursive) {

		  if(this.bins !=null) {
			  for(int i=0;i<this.bins.length;i++) {
				  if(this.bins[i]>0) {
					  Bin b = Bin.getBinById(this.bins[i]);
					  if(b!=null) {
						  for(int j=i+1;j<this.bins.length;j++) {
							  if(this.bins[j]>0) {
								  b.deleteBinEdge( this.bins[j],this.snpid,true); // process both "ends" of the bin.
							  }
						  }
						  if(recursive) {
							  Bin.deleteByName(Bin.getBinById( this.bins[i]).getName(), false);
						  }
					  }
				  }
				  this.bins[i]=0;
			  }
		  }  
		  this.nbins=0;
		 
	  }
	  /** 
	   *  For testing, need to be able to delete all the data and reload.
	   */
	  public static void clear(boolean recursive) {
		  if(snpIndex!=null && nsnps>0) {
			  	for(int i=0;i<snpIndex.length;i++) {
			  		Snp s =  snpIndex[i];
			  		if(s!=null) {
			  			s.deleteAllBins(recursive);
			  		}
			  	}
			  
		  }
		  Snp.snpIndex=new Snp[indexSize];
		  Snp.dbsnpid2Snp.clear();
		  Snp.sortedByPosAll.clear();
		  Snp.maxLevel=0;
		  Snp.haveSnp.clear();
		  Snp.nsnps=0;
		  Snp.snpCount=0;
	  }
	  
	  private static void updateIndex(Snp newSnp) {
		  if(newSnp!=null){
			  if(snpIndex==null) {
				  indexSize=10000;
				  snpIndex = new Snp[indexSize];

			  } else if (nsnps>indexSize) {
				  int newIndexSize=Math.max(2*nsnps,2*indexSize);
				  Snp[] tmp = new Snp[newIndexSize];
				  int i=0;
				  for(;i<indexSize;i++) {
					  tmp[i]=snpIndex[i];
				  }
				  snpIndex=tmp;
				  indexSize=newIndexSize;
			  }
			  snpIndex[Snp.nsnps-1]=newSnp;
		  }

	  }
	  
	  public static Snp getSnpById(int id) {
		  if(id<=0 || id>indexSize) {
			  return null;
		  }
		  return snpIndex[id-1];
	  }
	  public static Snp getSnpByPos(int pos,String chr) {
		  String snp_key = Integer.toString(pos) + "-"+(chr==null ? "" : chr.toLowerCase());
		  return snpByPosIndex.get(snp_key);
	  }
	  public String getSnpName() {return snpName;}
	  public int getId() {return snpid;}
	  public static Snp getSnpByName(String name) {
		  	String lname = (name==null? "" : name.toLowerCase());
		  	if(lname.length()==0) {
		  		return  null;
		  	}
		  	Snp ss = haveSnp.get(lname);
		  	return ss;
	  }
	  public static boolean haveSnp(String _name) {
		  if(haveSnp==null) {
			  return false;
		  }
		  String name = (_name==null ? "" : _name.toLowerCase());
		  if(haveSnp==null || haveSnp.containsKey(name)) {
			  return true;
		  } else {
			  return false;
		  }
	  }
	  public static boolean deleteByName(String _snpname,boolean recursive) {
		  String snpname = (_snpname==null ? "" : _snpname.toLowerCase());
		  Snp rmsnp = null;
		  int snp_pos=-99;
		  String snp_chrom = null;
		  if(haveSnp.containsKey(snpname)) {
			  rmsnp =  haveSnp.get(snpname);  
		  } else if (Snp.dbsnpid2Snp.containsKey(snpname)) {
			  rmsnp = Snp.dbsnpid2Snp.get(snpname); 
		  } else {
			  return false;
		  }
		  int rmid=-1;

		  if(rmsnp!=null) {
			  snp_pos = rmsnp.getPosition();
			  snp_chrom = rmsnp.getChromosome();
			  rmid = rmsnp.getId();
			  if(recursive) {
				  int[] rmbins = rmsnp.getBins();
				  if(rmbins!=null) {
					  for(int i=0;i<rmbins.length;i++) {
						  if(rmbins[i]>0) {
							  Bin b = Bin.getBinById(rmbins[i]);
							  if(b!=null) {
								  b.deleteSnp(rmsnp,false);
							  }
							  rmbins[i]=0;
						  }
					  }
				  }
				  rmsnp.nbins=0;
			  }
		  }
		  haveSnp.remove(snpname);
		  Snp.dbsnpid2Snp.remove(snpname);
		  if(rmsnp!=null) {
			  if(rmsnp.synonyms!=null) {
				  Iterator<String> it = rmsnp.synonyms.iterator();
				  while(it.hasNext()) {
					  String syn_name =  it.next();
					  haveSnp.remove(syn_name);
					  Snp.dbsnpid2Snp.remove(syn_name);
				  }
			  }
			  if(!rmsnp.getSnpName().equals(snpname)) {
				  if(haveSnp.containsValue(rmsnp.getSnpName())) {
					  haveSnp.remove(rmsnp.getSnpName());
				  }
				  if(Snp.dbsnpid2Snp.containsValue(rmsnp.getSnpName())) {
					  Snp.dbsnpid2Snp.remove(rmsnp.getSnpName());
				  }
			  }
			  if(haveSnp.containsValue(rmsnp)) {
				  haveSnp.remove(rmsnp);
			  }
			  if(Snp.dbsnpid2Snp.containsValue(rmsnp)) {
				  Snp.dbsnpid2Snp.remove(rmsnp);
			  }
			  // Last resort .. if the SNP tracking is buggy.
			  // This is an n^2 process.. which is why we created synonyms.. to avoid this.
			  if(haveSnp.containsValue(rmsnp)) {
				  System.err.println("SNPPicker:deleteByName : Hack to fix BUG: Having problem deleting "+snpname);
				  System.err.flush();
				  // Synonyms
				  Set<String> keys = haveSnp.keySet();
				  Iterator<String> its = keys.iterator();
				  Set<String> toRemove = new HashSet<String>();
				  while(its.hasNext())
				  {
					  String syn =  its.next();
					  Snp synSnp =  haveSnp.get(syn);
					  if(rmsnp.equals(synSnp)) {
						  toRemove.add(syn);					  
					  }
				  }
				  Iterator<String> itk = toRemove.iterator();
				  while(itk.hasNext()) {
					  String syn =  itk.next();
					  if(haveSnp.containsKey(syn)) {
						  haveSnp.remove(syn);
					  }
				  }
			  }
		  }
		  if(rmid>0) {
			  snpIndex[rmid-1]=null;
			  Snp.snpCount--;
			  //rmid>0 only possible if have SNP
			  if(snp_pos>0 && snp_chrom!=null && (!snp_chrom.equals("-99")) && snp_chrom.length()>0) { 
				  String osnp_key = Integer.toString(snp_pos) +"-"+snp_chrom;
				  if(Snp.snpByPosIndex.containsKey(osnp_key)) {
					  Snp.snpByPosIndex.remove(osnp_key);
				  }
			  }
			  return true;
		  } else {
			  return false;
		  }
		 
	  }
	  
	  /**
	   * This is the method to call to add Snps
	   * @param snpname
	   * @param binname
	   * @param popid
	   * @param npop
	   */
	  public static void addSnpEdge(String _snpname, String binname, int popid) throws Exception {
		  String snpname = (_snpname==null ? "": _snpname.toLowerCase());
		  Snp s =  haveSnp.get(snpname);
		  //System.out.print("g");System.out.flush();
		  Bin b = Bin.getBinByName(binname);
		  if(b==null) {
			  if(SNPPicker.verbose) {
				  System.out.print("AddSNPEdge: added bin"+binname+"\n");System.out.flush();
			  }
			  b= new Bin(binname, popid,popid);
		  }
		 // System.out.print("b");System.out.flush();
//		  System.out.println("AddSnpEdge: s="+snpname+", b="+binname+", popid="+popid);

		  if(s==null) {
			  s=new Snp(popid,snpname,b.getId());
			  if(SNPPicker.verbose) {
				  System.out.println("SNPPicker:AddSnpEdge: WARNING: Added SNP s="+snpname+", b="+binname+", popid="+popid);
			  }
		  } else {
			  // if this snp already existed, then we're adding an edge to another bin
			  s.addBin(b.getId(),b.getPopid());
		  }
		  //System.out.print("|");System.out.flush();
		  String bchr = b.getChromosome();
		  String schr = s.getChromosome();
		  if(bchr==null || bchr.length()==0 || bchr.startsWith("-")) {
			  if(schr!=null && schr.length()>0 && !schr.equals("-99")) {
				  // if one SNP has chromosomal annotation, propagate to all in bin.
				  b.setChromosome(schr);
				  Snp[] bsnps = b.getSnps();
				  if(bsnps!=null) {
					  for(int k=0;k<bsnps.length;k++) {
						  Snp tsnp = bsnps[k];
						  if(tsnp!=null) {
							  String tchr = tsnp.getChromosome();
							  if(tchr==null || tchr.length()==0 || tchr.equals("-99")) {
								  tsnp.setChromosome(schr);
							  }
						  }
					  }
				  }
			  }
		  } else if (schr!=null && schr.length()>0 && !schr.equals("-99")) {
			  if(b.getNsnps()>1) {
				  if(!bchr.equalsIgnoreCase(schr) && (!bchr.equals("-99")) && (!schr.equals("-99"))) {
					  System.err.println("SNPPicker:WARNING: The bin "+binname+" (on chrom "+bchr+") contains a SNP ("+s.getSnpName()+") on chromosome "+schr+"\n");
					  System.err.flush();
				  }
			  } else { // this Empty bin got the default chromosome assignment..
				  b.setChromosome(schr);
			  }
		  } else if(schr==null || schr.length()==0 || schr.equals("-99")) {
			  s.setChromosome(bchr);
		  }
		  //System.out.print(".");System.out.flush();
		  b.addSnp(s);
		  s.addBinEdgesToBins();
	  }

	  /*
	   * Utility function for addSnpEdge.
	   *
	   */
	  private void addBinEdgesToBins() {
		  // This is an incremental function.
		  // it HAS to be called everytime by addSnpEdge.
		  if(this.bins==null) {return;}
		  if(this.nbins <=1) {
			  return;// Need at least 2 Bins to have edges.
		  }
		  int j=0;
		  while(j<this.bins.length) {// This next segment won't link snps if there is only one bin.
			  if(this.bins[j]>0) {
				  Bin b1 = Bin.getBinById(this.bins[j]);
				  if(b1==null) {
					  b1=null;// stop point for debugger
					  System.err.println("SNPPicker:addBinEdgesToBin: BUG could not find bin for snp "+this.getSnpName()+"\n");
					  Exception e = new Exception();
					  e.printStackTrace();
					  System.err.flush();
					  System.out.flush();
					  System.exit(-1);
				  } else {
					  int i=0;
					  while(i<j) {
						  if(this.bins[i]>0) {
							  b1.addBin(this.bins[i],this.snpid); // addBin Function, by default, processes other bin too.
						  }
						  ++i;
					  }
				  }
			  }
			  ++j;
		  }
	  }

	  public static void processMinScore() throws Exception {
		  for(int i=0;i<Snp.indexSize;i++) {
			  Snp s =  Snp.snpIndex[i];
			  if(s!=null) {
				  if(s.getScore()<SNPPicker.minScore) {
					  if(s.isObligateButNotGenotyped()) {
						// don't care about score, we already know this SNP worked.  
					  } else {
			  			s.setExcluded(true);
			  			s.setFixed(true);  
					  }
				  }
			  }
		  }
	  }
	  
	  public static boolean addScore(String _snpname, double zeroOneScore) throws Exception {
		  String snpname = (_snpname==null ? "" : _snpname.toLowerCase());
		  	Snp s =  haveSnp.get(snpname);
		  	if(s!=null) {
		  		s.setScore(zeroOneScore);
		  		if((zeroOneScore<SNPPicker.minScore)  && !SNPPicker.computeUtilityOnly) {
		  			s.setExcluded(true);
		  			s.setFixed(true);
		  		}
		  		return true;
		  	} else {
		  		return false;
		  	}
	  }
	/**
	 * @return the nsnps
	 */
	public static int getNsnps() {
		return Snp.nsnps;
	}
	public static int getSnpCount() {
		return Snp.snpCount;
	}
	public int[] getBins() {
		return bins;
	}
	public int getNbins() {
		return nbins;
	}

	public int getSnpid() {
		return snpid;
	}
	
	public String getChromosome() {
		return chromosome;
	}
	public void setChromosome(String this_chromosome) {
		String new_chrom = (this_chromosome==null ? "" : this_chromosome.toUpperCase());
		if(!new_chrom.equals(this.chromosome)) {
			if(this.position!=DEFAULT_POS) {
				String osnp_key = Integer.toString(this.position) +"-"+(this.chromosome==null ? "" : this.chromosome);
				if(Snp.snpByPosIndex.containsKey(osnp_key)) {
					Snp.snpByPosIndex.remove(osnp_key);
				}
			}
			this.chromosome = new_chrom;
			if(this.position!=DEFAULT_POS) {
				String snp_key = Integer.toString(this.position) +"-"+this.chromosome;
				Snp.snpByPosIndex.put(snp_key, this);
			}
		}
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String tlocation) {
		if(tlocation == null) {
			this.location=null;
		} else 
		this.location = tlocation.toLowerCase();
	}
	public int getLocation_class() {
		return location_class;
	}
	public void setLocation_class(int location_class) {
		this.location_class = location_class;
	}
	public int getPosition() {
		return position;
	}
	public void setPosition(int _position) {
		if(this.position!=DEFAULT_POS) {
			// position already Set for this SNP.
			String osnp_key = Integer.toString(this.position) +"-"+(this.chromosome==null ? "" : this.chromosome);
			if(Snp.snpByPosIndex.containsKey(osnp_key)) {
				Snp.snpByPosIndex.remove(osnp_key);
			}
			if(this.chromosome!=null && this.chromosome.length()>0) {
				// There is no way to track when the setChromosome function is called.
				// 
					osnp_key = Integer.toString(this.position) +"-";
					if(Snp.snpByPosIndex.containsKey(osnp_key)) {
						Snp.snpByPosIndex.remove(osnp_key);
					}
			}
		}
		this.position = _position;
		if(this.position!=DEFAULT_POS) {
			String snp_key = Integer.toString(_position) +"-"+(this.chromosome==null ? "" : this.chromosome);
			Snp.snpByPosIndex.put(snp_key, this);
		}
	}
	public double getScore() {
		return score;
	}
	public void setScore(double score) {
		this.score = score;
	}
	public String getScoreClass() {
		return scoreClass;
	}
	public void setScoreClass(String scoreClass) {
		this.scoreClass = scoreClass;
	}
	public String getValidationClass() {
		return validationClass;
	}
	public void setValidationClass(String validationClass) {
		this.validationClass = validationClass;
	}
	public boolean isExcluded() {
		return excluded;
	}
	
	/**
	 * Set a SNP to Excluded. Once set to Excluded, can't change your mind once SNPs are being selected.
	 * @param recursive , whether to apply to Bins
	 */

	public void setExcluded(boolean recursive) throws Exception {
		if(this.selected) {
			System.err.println("SNPPicker:setExcluded:BUG: cannot exclude a selected SNP "+this.dbsnpid);System.err.flush();
			System.out.flush();
			throw new Exception("SNPPicker:setExcluded:BUG: cannot exclude a selected SNP"+this.dbsnpid);
		}
		boolean wasAlreadyExcluded = this.excluded;
		this.excluded = true;
		this.selected=false;
		this.tmpSelected=false;
		this.uniquelyCovers=false;
		if(recursive) {
			if(this.bins!=null) {
				for(int i=0;i<this.bins.length;i++) {
					if(this.bins[i]>0) {
						Bin b = Bin.getBinById(this.bins[i]);
						if(b!=null) {
							b.excludeSnp(this,false);
							if(!wasAlreadyExcluded) {
								b.incNExcluded();
							}
							int[] selsnps = b.getSelectedSnpIds();
							boolean wasSelected=false;
							int nsel=0;
							if(selsnps!=null) {
								nsel=selsnps.length;
								for(int j=0;(!wasSelected) && j<selsnps.length;j++) {
									if(selsnps[j]==this.getId()) {
										wasSelected=true;
										nsel--;
									}
								}
							}
							b.setNSelected(nsel);

							if(nsel==0) {
								int[] remainingSnpids = b.getAvailableSnpIds(false);
								if(remainingSnpids!=null && remainingSnpids.length==1) {
									Snp s = Snp.getSnpById(remainingSnpids[0]);
									if(s!=null) {
										s.setUniquelyCovers(b.getId());
									}
								}
							}
						}
					}
				}
			}
		}
	}
	public boolean isObligate() {
		return obligate;
	}
	/**
	 * Set a SNP to Obligate. Once set to Obligate, can't change your mind
	 *
	 */
	public void setObligate(boolean recursive) {
		this.obligate = true;
		//this.setSelected(true,recursive);
		if(recursive) {
			if(this.bins!=null) {
				for(int i=0;i<this.bins.length;i++) {
					if(this.bins[i]>0) {
						Bin b = Bin.getBinById(this.bins[i]);
						b.setObligate(this,false); // no recursive call
					}
				}
			}
		}
		
	}
	public double getFailProb() {
		if(this.obligateButNotGenotyped && SNPPicker.obligateIncludeNGFileOverRule) {
			return 0.0;
		} else {
			return failProb;
		}
	}
	public void setFailProb(double failProb) {
		
		if(this.obligateButNotGenotyped && SNPPicker.obligateIncludeNGFileOverRule) {
			this.failProb =0.0d;
			this.successProb=1.0d;
		} else {
			this.failProb = failProb;
			this.successProb=1.0d - failProb;
		}
	}
	public static void computeSNPProbs() {
		

		for(int snpid=1;snpid<=indexSize;snpid++) {
			Snp s = Snp.getSnpById(snpid);
			if(s!=null) {
				double score = s.getScore();
				String validationClass = s.getValidationClass();
				double fp = ProbabilityFromScore.getFailProb(score,validationClass);
				s.setFailProb(fp);
				fp = s.getFailProb();
				s.setSuccessProb(1.0d-fp);
			}
		}
		/*
		Default Snp categories were selected using the SIFT/polyphen categorization as well as dbSNP and other tools.
		1+(importance)(1/(r^2)-1)/10  [should use exact r^2, but in this implementation, use parameter r^2]
		*/
		
	}

	
	private static TreeSet<Snp> sortedByPosAll =null;
	private static void updateSortedSnps(boolean force) {
		if(snpIndex!=null) {
			if(force || sortedByPosAll==null) {
				TreeSet<Snp> t = new TreeSet<Snp>(new SnpOrderComparator());
				for(int i=0;i<snpIndex.length;i++) {
					Snp s = snpIndex[i];
					if(s!=null) {
						t.add(s);
					}
				}
				sortedByPosAll=t;
			}
		}
	}
	/**
	 * Cluster all the SNPs.
	 * @param tooClose
	 * @param obligateOrSelected
	 * @param ignoreExcluded
	 * @param nOPA
	 * @return
	 */
	public static ArrayList<ArrayList<Snp>> findContigousSNP(int tooClose,boolean obligateOrSelected,boolean ignoreExcluded,int nOPA) {
		if(tooClose==0) {
			return null;
		}
		if(nOPA<0) {
			return new ArrayList<ArrayList<Snp>>(); // do nothing
		}
		updateSortedSnps(false);
		ArrayList<ArrayList<Snp>> al =findContigousSNP(Snp.sortedByPosAll,tooClose,obligateOrSelected,ignoreExcluded,nOPA);
		return al;

	}
	/**
	 * Find list of clusters of SNPs that are too close, with greater than nOPA snps (if nOPA==0, return all clusters)
	 * If a SNP is obligate and not to be genotyped, then it is excluded from the proximity search unless nOPA==0 (exclude all SNPs)
	 * @param sortedByPos
	 * @param tooClose
	 * @param obligateOrSelected if true, restrict the search to only obligate or selected.(instead of all available (or all if ignoreExcluded param also true)
	 * @param ignoreExcluded if true, consider the excluded SNPS as well.
	 * @param nOPA
	 * @return
	 */	
	public static ArrayList<ArrayList<Snp>> findContigousSNP(TreeSet<Snp> sortedByPos, int tooClose,boolean obligateOrSelected,boolean ignoreExcluded,int nOPA) {

		if(nOPA<0 || sortedByPos==null || sortedByPos.size()==0) {
			return new ArrayList<ArrayList<Snp>>();
		}		
		ArrayList<ArrayList<Snp>> l = new ArrayList<ArrayList<Snp>>();
		Iterator<Snp> it = sortedByPos.iterator();

		int lastPos=-(tooClose+1);
		
		ArrayList<Snp> l0 = new ArrayList<Snp>();
		int n=0; // n+1 == Number of SNPs involved in a cluster.
		String lastChr="";
		Snp lastSnp=null;
		while(it.hasNext()) {
			Snp s =  it.next();
			String chr = s.getChromosome();
			int nbins = s.getNbins();
			int pos = s.getPosition();
			boolean OKSNP=false; // only consider SNPs without bins if the option  nOPA demands it .. or if it's an obligate.
			if(nOPA==0 || !(s.isObligateButNotGenotyped())) {
				if((nbins>0 || nOPA==0) ) {
					OKSNP=true;
				}
			}
			// Look at choosable SNPs
			// a SNP is either not selected(excluded or not) or selected (obligate or not)
			//
			if(OKSNP) {
				if((obligateOrSelected && ((s.isObligate()) || s.isSelected()) && ((!ignoreExcluded)  || !s.isExcluded()))
						|| 
						((!obligateOrSelected) && ((!ignoreExcluded)  || !s.isExcluded()))
				) {
					if(pos>0) {
						if((  (chr==null || chr.length()==0 || chr.equals("-99")) 
							&&(lastChr==null || lastChr.length()==0 || lastChr.equals("-99"))) 

							|| (chr.equals(lastChr) && !chr.equals("-99"))) {
							// both chromosome unknowns or same chromosome
							if(pos-lastPos<tooClose) {
								n++;
								if(n==1 && lastSnp!=null) {
									l0.add(lastSnp);
									n++;
								}
								l0.add(s);
							} else if (n>0) {
								// End of a Cluster
								if(nOPA==0 || (nOPA>0 && n>nOPA)) {// if nOPA==0, I want all clusters back., nOPA<0 none
									l.add(l0);
									l0=new ArrayList<Snp>();
								} else {
									l0.clear();
								}
								n=0;
							}
						} else if (n>0) {
							// End of a SNP Cluster because switch chromosome.
							if(nOPA==0 || (nOPA>0 && n>nOPA)) {
								l.add(l0);
								l0=new ArrayList<Snp>();
							} else {
								l0.clear();
							}
							n=0;
						}
						lastPos=pos;
						lastChr=chr;
						lastSnp = s;
					} else {// pos==-1
						System.err.println("SNPPicker:WARNING: Snp "+s.getSnpName()+"["+s.getDbsnpid()+"] does not have a valid position");
					}
				}
			}
		}
		if(n>0) {
			if(nOPA==0 || (nOPA>0 && n>nOPA)) {
				l.add(l0);
			}
		}
		return l;
	}

	
	/**
	 * Take a Linked List of Contiguous Snps and Cluster them further according their common bins.
	 */
	
	public static ArrayList<ArrayList<Snp>> clusterSnpCluster(ArrayList<ArrayList<Snp>> listOfListOfSnps) {
		if(listOfListOfSnps==null || listOfListOfSnps.size()==1) {
			return listOfListOfSnps; // no further clustering possible.
		}
		int bsize = Bin.getNbins();
		ArrayList<ArrayList<Snp>> lls=listOfListOfSnps;
		int nclust = lls.size();
		boolean[] deleteElement = new boolean[nclust];
		ArrayList<int[]> binslists = new ArrayList<int[]>();
		for (int i=0;i<nclust;i++) {
			deleteElement[i]=false;
			List<Snp> l = lls.get(i);
			int[] binlist = new int[bsize+1];
			Iterator<Snp> itl = l.iterator();
			while(itl.hasNext()) {
				Snp s = itl.next();
				if(s!=null) {
					int[] sbins = s.getBins();
					if(sbins!=null) {
						for(int k=0;k<sbins.length;k++) {
							int binid = sbins[k];
							if(binid>0) {
								binlist[binid-1]=1;
							}
						}
					}
				}
			}
			binslists.add(binlist); // vector of bins coverage flags (0 or 1) for each bin in all datasets.
		}
		// Link all Clusters that are linked by bins.
		// XXX - recode this
		for(int i=0;i<nclust;i++) {
			if(!deleteElement[i]) { // if group of SNPS not already linked.
				ArrayList<Snp> sl0 = lls.get(i);
				Snp s0 = sl0.get(0);
				String chr0 = s0.getChromosome();
				for(int j=i+1;j<nclust;j++) {
					if(!deleteElement[j]) {
						List<Snp> sl1 = lls.get(j);
						Snp s1 = sl1.get(0);
						String chr1 = s1.getChromosome();
						if(chr0==null || chr1==null || chr1.equals(chr0)) {
							if(shareBins( binslists.get(i), binslists.get(j))) {
								deleteElement[j]=true;
								sl0.addAll(sl1);
								lls.set(i,sl0);
								// not necessary  lls.set(j, null);
								addToBinCount((int[])binslists.get(i),(int[])binslists.get(j)); // add to first bin.
								j=i; // restart overlap search .. assume it's going to be j++'ed.
							}
						}
					}
				}
			}
		}
		for(int i=nclust-1;i>=0;i--) {// must delete from end.. other indexes are meaningless
			if(deleteElement[i]) {
				lls.remove(i);
			}
		}
		return lls;
	}
		
	private static boolean shareBins(int[] b1,int[] b2) {
		if(b1==null || b2==null || b1.length!=b2.length) {
			System.err.println("Bug: bin vectors of different length or null");System.err.flush();
			System.out.flush();
			System.exit(-1);
		}
		for(int i=0;i<b1.length;i++) {if(b1[i]==1 && b1[i]==b2[i]) return true;}
		return false;
	}
	private static void addToBinCount(int[] b1,int[] b2) {
		if(b1==null || b2==null || b1.length!=b2.length) {
			System.err.println("Bug: bin vectors of different length or null");System.err.flush();
			System.out.flush();
			System.exit(-1);
		}
		for(int i=0;i<b1.length;i++) {if(b2[i]==1) {b1[i]=1;}}
	}

	public boolean isSelected() {
		return selected;
	}
	/**
	 * Selecting a SNP is a hard to reverse action.
	 * 
	 * @param recursive, to set the Bins.
	 */
	public void setSelected(boolean newstate,boolean recursive) throws Exception {
		if(this.fixed && (this.selected != newstate)) {
			Exception e = new Exception("SNPPicker:BUG:setSelected trying to select/unselect a fixed SNP ");
			e.printStackTrace();
			throw e;
		}
		if(this.selected && newstate) {
			return;// already selected .. nothing to do.
		}
		if((!newstate) && this.selected) {
			//  unselect .. this is so unsafe.. some TMP cached (e.g. maxCoverage) variables get out of whack. only use at the end.
			this.hasBeenReset=false;
		}
		this.selected = newstate;
		this.tmpSelected = newstate;
		
		if(this.isExcluded() && this.isSelected() && !(this.isObligate() || this.isObligateButNotGenotyped())) {
			// by default setObligate sets the SNP ==> to de-select it, we have to
			// allow obligates to be de-selected.
			System.err.println("SNPPicker:BUG: setSelected: Cannot select an excluded SNP " + this.getSnpName()+"  \n");
			Exception e = new Exception("SNPPicker:BUG: setSelected: Cannot select an excluded SNP " + this.getSnpName()+"  \n");
			e.printStackTrace();
			throw e;
		}

		if(recursive) {
			if(this.bins!=null) {
				for(int i=0;i<this.bins.length;i++) {
					if(this.bins[i]>0) {
						Bin b = Bin.getBinById(this.bins[i]);
						if(b!=null) {
							b.selectSnpId(this.snpid,newstate,false);
						}
					}
				}
			}
		}
	}

	public boolean canISelect(boolean tmpToo) throws Exception {
		if(SNPPicker.tooClose<=0) {
			return true;
		} else {
			if(Cluster.getNclusters()==0) {
				throw new Exception("Called canISelect before building clusters");
			}
			Cluster c = Cluster.getClusterForSnp(this);
			if(c!=null) {
				return c.canISelect(this,tmpToo);
			} else {
				throw new Exception("SNPPicker: SNP " + this.getSnpName()+" not mapped to cluster");
			}
		}
	}
	
	
	public static ArrayList<Bin> getBinsForSnpList(List<Snp> snpList) {
		if(snpList!=null) {
			ArrayList<Bin> bv = new ArrayList<Bin>();
			int lsize = snpList.size();
			for(int j=0;j<lsize;j++) {
				Snp s = snpList.get(j);
				int[] sbins = s.getBins();
				if(sbins!=null) {
					for(int k=0;k<sbins.length;k++) {
						int bid = sbins[k];
						if(bid>0) {
							Bin b = Bin.getBinById(bid);
							if(b!=null) {
								if(!bv.contains(b) ) {
									bv.add(b);
								}
							} else {
								s.warning("This SNP refers to deleted bins.");
								System.err.flush();
								System.out.flush();
								System.exit(-1);
							}
						}
					}
				}
			}
			return bv;
		}
		return null;
	}
	
	/**
	 * Find Clusters of Snp Cluster linked by their bins.. Solutions have to be optimized for the group.
	 *  Process Snps that are too close, only allowing up to nOPA 
	 * 			Dynamically explore parameter space to find the best solution.. of
	 *          either picking a snp that is too close, or another one.
	 * @param tooClose
	 * @param obligateOrSelected
	 * @param ignoreExcluded
	 * @param nOPA
	 * @param fixall boolean indicator to tell whether we fix/exclude all the conflicting SNPs or we try to find an optimal set to fix.
	 * @return
	 */


	public static ArrayList<ArrayList<Snp>> processSnpTooClose(int tooClose,int nOPA, boolean fixall) throws Exception {
		if(nOPA<=-1 || tooClose==0) { // Skip examination of SNPs that are too close.
			return null;
		}
		boolean obligateOrSelected=false;// take any SNP
		boolean ignoreExcluded=true; // unless they are excluded
		if(nOPA==0) {
			ignoreExcluded=false; // nOPA==0 is looking for ANY snps too close (wether genotyped or not)
		}
		ArrayList<ArrayList<Snp>> c = null;
		ArrayList<ArrayList<Snp>> c0 = null;
		updateSortedSnps(true);
		if(nOPA==0) { // reject any Snps that are too close to each other. Don't even Keep one of them.
					  // The fear is that SNP under the probe could interfere with the performance of the assay.
			c= clusterSnpCluster(findContigousSNP(tooClose,obligateOrSelected,ignoreExcluded,nOPA));
			if(c==null) {
				return c;
			}
			c0=c;
			Snp.fixSnpsInWindows(c);
			int nClusters = c.size();
			// Get all bins for those Snps
			// If any of those bins is a singleton, output an error message
			HashSet<Bin> binSet = new HashSet<Bin>();
			for(int i=0;i<nClusters;i++) {
				List<Bin> bv = getBinsForSnpList(c.get(i));
				binSet.addAll(bv);
			}
			if(nOPA==0) { 
				Iterator<Bin> it = binSet.iterator();
				while(it.hasNext()) {
					Bin b =  it.next();
					int nleft=0;
					Snp[] snps = b.getSnps();
					for(int i=0;i<snps.length;i++) {
						if(snps[i]!=null) {
							if(!snps[i].isExcluded()) {
								nleft++;
							}
						}
					}
					if(nleft==0) {
						b.setStatus(1); // done with this bin.
						System.err.println("SNPPicker:WARNING: Singleton Bin "+b.getName()+" in population "+Population.getPopById(b.getPopid()).getName()+"has 0 bins because all the tagsnps were close to other SNPS and -OPA 0 option was selected\n");
					}
				}
			}
		} else {
			{
				int ndel = Snp.deleteWithoutBins();
				
			}//XXXXXXXXX TRACE XXXXXXXXX with chr1 example for position 205013, file "4" (gene 3586) hapmap morebins 1,2,16
			c= clusterSnpCluster(findContigousSNP(tooClose,obligateOrSelected,ignoreExcluded,nOPA));
			if(c==null) {
				return null;
			} else if(fixall) {
				// This is now the only section being executed by SNPPicker2.
				Snp.fixSnpsInWindows(c);
				return c;
			} else {
				
				// SNPPicker 1.0 Processing proceeds below to fix some of the tag SNPs.
			}
			c0=c;

			// First we process Bins for which there is little choice.(#remaining SNPs<= Number of Needed Snps)
			// Then we proceed to resolve conflicts between SNPs that are too close(including obligates)

			// The position in c is implicitely the snpclusterid.
			ArrayList<ArrayList<Bin>> binCluster = new ArrayList<ArrayList<Bin>> ();
			int nClusters = c.size();
			// Collect the list of bins that contain the Snps involved in a cluster.	
			for(int i=0;i<nClusters;i++) {
				ArrayList<Bin>  bv = getBinsForSnpList(c.get(i));
				if(bv!=null && bv.size()>0) {
					binCluster.add(bv);
				}
			}
			
			// Select or reject(to eliminate clusters) SNPs for bins with #remaining SNPs<= Number of Needed Snps
			// note that SNP flag uniquelyCovers is not activated yet.
//			c=binsWithLittleChoice(c,binCluster, tooClose,nOPA); XXX There is bug in here XXX .. don't use it!
			// note that if c gets modified, so does binCluster
			if((!fixall) && c!=null) {
				nClusters = c.size();
				// Now process all the clusters 
				if(SNPPicker.verbose) {
					System.out.println("nCluster="+nClusters);System.out.flush();
				}
				for(int i=0;i<nClusters;i++) {
					if(SNPPicker.verbose) {
						System.out.println("Cluster="+i);System.out.flush();
					}
					ArrayList<Bin> bl = binCluster.get(i); // Bins in a too-close cluster
					List<Snp> sl = c.get(i); // Snps in a too-close cluster [may include obligate SNPs not in any bins]
					TreeSet<Snp> clusteredSnpsByPos = new TreeSet<Snp>(new SnpOrderComparator());
					clusteredSnpsByPos.addAll(sl);
					Snp[] snpsInDangerZoneByPos =  clusteredSnpsByPos.toArray(new Snp[sl.size()]);
					if(snpsInDangerZoneByPos!=null) {
						// XXX 3/2008 for some reason I don't understand some SNPs make it here having been selected (obligates should have been unselected)
						for(int is=0;is<snpsInDangerZoneByPos.length;is++) {
							Snp ss = snpsInDangerZoneByPos[is];
							ss.setSelected(false, true);
						}
						
					}
					if(SNPPicker.verbose) {
						System.out.println("gb2p");System.out.flush();
					}
					Bin[] binsToPick = getBinsToPick(bl,snpsInDangerZoneByPos,true); // Does not include obligate and Excludes(but taken into account)
					// Pick set of Best Scoring SNPs in Danger Zone.
					if(SNPPicker.verbose) {
						System.out.println("gb2p-done");System.out.flush();
					}
					if((binsToPick!=null && binsToPick.length>0) || (sl!=null && sl.size()>0)) {
						if(SNPPicker.verbose) {
							System.out.println("b2pd="+binsToPick.length);System.out.flush();
						}

						HashMap<String,Snp> sdz= new HashMap<String,Snp>(2*sl.size());
						for(int is=0;is<sl.size();is++) {
							Snp s = snpsInDangerZoneByPos[is];
							sdz.put(Integer.toString(s.getPosition()),s);
						}
						if(SNPPicker.verbose) {
							System.out.println("sdz="+sdz.size());System.out.flush();
						}
						int binToPickIndex =0;
						long cpuend = System.currentTimeMillis()+SNPPicker.getMaxCPU();
						SolutionTracker soln = new SolutionTracker();
						soln.computeMaxObligates(sl);
						if(bl!=null) {
							if(SNPPicker.verbose) {
									System.out.print("b2p binnames=");
							}
							for(int ib=0;ib<bl.size();ib++) {
								Bin b = bl.get(ib);
								if(SNPPicker.verbose) {
									System.out.print(b.getName());
									System.out.print(",");
								}
								b.cacheMaxScore(true); // true==nclude tmpSelected
								b.cacheMaxCoverage(true); // true means include tmpSelected
								b.resetTmpSolution(true);
							}
							if(SNPPicker.verbose) {
								System.out.println("");System.out.flush();
							}
						}

						Snp.maxLevel=0;
						HashSet<Bin> uniqH = new HashSet<Bin>();
						int binsToPickSize=0;
						if(binsToPick!=null && binsToPick.length>0) {
							binsToPickSize=binsToPick.length;
							int status = pickBinsTooClose(cpuend,nOPA,snpsInDangerZoneByPos,sdz,binsToPick,binToPickIndex,soln);
							if(status==-1) {
								if(soln.hasCompleteSolution()) {
									System.err.println("Ran out of CPU time for tooCloseSNPs but found full solution\n");
								} else if(soln.hasSolution()) {
									System.err.println("Ran out of CPU time for tooCloseSNPs but found partial solution\n");
								} else {
									System.err.println("Ran out of CPU time for tooCloseSNPs and did not find a solution\n");
								}
							}
							System.err.flush();
						
							for(int k=0;k<binsToPick.length;k++){
								uniqH.add(binsToPick[k]);
							}

						// Keep BestSolution for Snps in the danger zone.. and exclude all other Snps in the Danger Zone
							Iterator<Bin> itb = uniqH.iterator();
							while(itb.hasNext()) {
								Bin b2p = itb.next();
								b2p.finalPick(true,true); // only Fix SNPs for the SNPs selected in the best solution
														  // the SNPs are fixed only.. not selected!
								b2p.resetTmpSolution(true);// erase the tmpSelected data
							}
						}
						if(SNPPicker.verbose) {
							System.out.println("b2p:finished fixing");System.out.flush();
							System.out.println("b2p:excluding non-fixed obligates");System.out.flush();
						}
						for(int k=0;k<sl.size();k++) {
							Snp s = sl.get(k);
							if(s.isObligate()) {
								boolean alreadyExcluded = s.isExcluded(); // already excluded obligates may have been processed before .. or score excluded.
								if(!(s.isSelected() || s.isExcluded()|| s.isFixed())) {
									// final pick on obligate that was unselected due to too-close proximity with other SNPs (in SNPPicker class)
									s.finalPick(true, true, true);
									if(s.isExcluded() && !alreadyExcluded) {
										// since we eliminated SNPs with low score, we know this obligate has to be in too-close conflict.
										// for nOPA>0
										if(SNPPicker.verbose) {
											System.out.println("SNPPicker:WARNING: Obligate "+s.getSnpName()+"["+s.getDbsnpid() +"] was not selected because of proximity to other obligates ");
										}
									} 
								} else if (!(s.isSelected() || s.isExcluded())) {
									s.setSelected(true, true);
								}
								s.setFixed(true);
							} 
						}
						
						
						if(soln.hasSolution() && soln.hasCompleteSolution()) {
							if(SNPPicker.verbose) {
								System.out.println("ps2c: done with complete solution");System.out.flush();
							}
							// complete solution is defined at all the bins and the maximum possible number of obligates.
						} else{// partial or no solution.
							// e.g. we can attempt to do better.
							if(SNPPicker.verbose) {
								System.out.println("ps2c:check4more");System.out.flush();
							}
							if(binsToPick!=null && binsToPickSize>0) {
								if(!soln.hasSolution()) {
									System.err.println("SNPPicker:WARNING:Did not find any solution for SNPs too close(DP to "+Snp.maxLevel+" part way to"+binsToPickSize+", excluding all Snps in the Danger Zones for: "+bins2String(uniqH.toArray(new Bin[0]) ));
									//
								} else if (!soln.hasCompleteSolution()) {
									System.err.println("SNPPicker:WARNING:Only found partial solution (found "+soln.getTried()+" partial solns) for SNPs too close: "+bins2String(uniqH.toArray(new Bin[0]) ));
								}
								System.err.println("SNPPicker:WARNING:Filling in with greedy too-close solution: "+bins2String(uniqH.toArray(new Bin[0]) ));
							} else {
								System.err.println("SNPPicker:WARNING:Filling in with greedy too-close solution: for (obligates SNPs?) only for cluster "+i+", nsnps="+sl.size()+", nbins="+bl.size()+", bins="+bins2String(bl.toArray(new Bin[0]) )+", snpsInDangerZone.length="+(snpsInDangerZoneByPos==null ? 0:snpsInDangerZoneByPos.length ));

								if(SNPPicker.verbose) {
									System.out.println("SNPPicker:WARNING:Filling in with greedy too-close solution: for (obligates SNPs?) only for cluster "+i+", nsnps="+sl.size()+", nbins="+bl.size()+", bins="+bins2String(bl.toArray(new Bin[0]) )+", snpsInDangerZone.length="+(snpsInDangerZoneByPos==null ? 0:snpsInDangerZoneByPos.length ));
								}

							}
							if(SNPPicker.verbose) {
								System.out.println("bp2:greed");System.out.flush();
							}
							// don't need to sort whole list, just to find the "best" SNP..
							// the metric should be to pick the SNP with the
							int nexti = findNextPickableSnp(snpsInDangerZoneByPos,nOPA,tooClose);
							while(nexti!=-1) {
								 Snp s = snpsInDangerZoneByPos[nexti];
								 //s.setSelected(true, true);
								 s.setFixed(true); 
								 if(SNPPicker.verbose) {
									 System.out.println("Fixed/Selected Next Pickable ="+s.getSnpName());System.out.flush();
								 }
								 nexti = findNextPickableSnp(snpsInDangerZoneByPos,nOPA,tooClose);
							}
						}
						if(SNPPicker.verbose) {
							System.out.println("ps2c:exclude not fixed and unfix the selected snps in dgz");System.out.flush();
						}
						// If a SNP in danger zone was not selected, it must be excluded.
						for(int is=0;is<snpsInDangerZoneByPos.length;is++ ){
							Snp s = snpsInDangerZoneByPos[is];
							if(s.isObligate()) {
								if(SNPPicker.verbose) {
									System.out.println("SNPPicker:INFO: Obligate "+s.getSnpName()+" fixed="+(s.isFixed() ? " fixed ":" not fixed ")+",selected="+(s.isSelected() ? "selected": "not selected")+", excluded="+(s.isExcluded() ? "excluded":"not excluded"));System.out.flush();
								}
							}
							if(!(s.isExcluded() || s.isSelected() || s.isFixed())) {
								if(SNPPicker.verbose) {
									System.out.println("SNPPicker:INFO: excluding "+s.getSnpName());System.out.flush();
								}
								s.setExcluded(true); // recursive=true(e.g do bins).
								// Note that this also excludes Obligates that were de-selected.
								s.setFixed(true); // whether selecting or rejecting, this SNP is now fixed.
								if(s.isObligate()) {
									if(SNPPicker.verbose) {
										System.out.println("Fixing obligate"+s.getSnpName());System.out.flush();
									}
								} else {
									if(SNPPicker.verbose) {
										System.out.println("Excluding not fixed or Selected "+s.getSnpName());System.out.flush();
									}
								}
							}
							// unFIX the SNPs in the danger zone so that they potentially can be selected.
							if(s.isFixed()) {
								if(!(s.isSelected()|| s.isExcluded())) {
									s.setFixed(false);// free to be selected
									if(SNPPicker.verbose) {
										System.out.println("Fixed/Selected Optimal Soln too-close SNP="+s.getSnpName());System.out.flush();
									}
									if(s.isObligate()) {
										System.err.println("SNPPicker: BUG :processSnpTooClose :Obligates should be selected or excluded in Danger Zone : "+s.getSnpName());System.err.flush();
									}
								} 
							}
						}
						if(SNPPicker.verbose) {
							System.out.println("ps2c:clearing outside the dgz");System.out.flush();
						}
						// Now clear fixed SNPs not in danger zone.
						if(bl!=null) {
							if(SNPPicker.verbose) {
								System.out.println("blsize"+bl.size());System.out.flush();
							}
							for(int is=0;is<bl.size();is++) {
								if(SNPPicker.verbose) {
									System.out.println("is="+is);System.out.flush();
								}
									Bin b = bl.get(is);
									if(b!=null) {
										Snp[] toFixSnps =b.getSnps();
										if(toFixSnps!=null) {
											if(SNPPicker.verbose) {
												System.out.println("toFix 4 is="+is);System.out.flush();
											}
											for(int i2=0;i2<toFixSnps.length;i2++) {
												Snp s2f = toFixSnps[i2];
												if(s2f!=null && s2f.isFixed() && !(s2f.isSelected() || s2f.isExcluded())) {
													s2f.setFixed(false);
													if(SNPPicker.verbose) {
														System.out.println("Unfixing "+s2f.getSnpName());System.out.flush();
													}
												}
											}
										}
										// reseting TMP solution.
										b.resetTmpSolution(true);
									}
							}
						}
						if(SNPPicker.verbose) {
							System.out.println("cleared outside the dgz");System.out.flush();
						}
					} // if binsToPick

				} // for i.. nClusters
			} // c!=null
		} // if nOPA==0 ... else
		
		return c0;
	}
	
	/*
	 * 
	 * Function to take an Arraylist of Arraylist of SNPs. Each List of SNP is assume to be a  group
	 *  of SNPs that need to be picked together (e.g. SNPs too close)
	 *  This creates new bin edges so that the SNPs will cluster together.
	 * @param Arraylist of Arraylist of SNPs Objects 
	 * @return the number of new bin edges created
	 */
	public static int addBinEdgesForTooCloseGroups(ArrayList<ArrayList<Snp>> c) {
		int nedges = BinEdge.getNbinedges();
		for(int i=0;i<c.size();i++) {
			ArrayList<Snp> sl = (ArrayList<Snp>)c.get(i); // Snps in a too-close cluster [may include obligate SNPs not in any bins]
			if(sl!=null) {
				for(int j1=0;j1<sl.size();j1++) {
					Snp s1 =  sl.get(j1);
					if(s1!=null) {
						int[] bs1 =s1.getBins();
						if(bs1!=null) {
							for(int k1=0;k1<bs1.length;k1++) {
								if(bs1[k1]>0) {
									Bin b1 =Bin.getBinById(bs1[k1]);
									int a=1;
									if(b1.getName().equals("AFR-GPC6|10082;SNPApp_AFR_0.90_0.05_1228_1232Hapmap10082ldselect.out/13:38") ||
											b1.getName().equals("CEU-GPC6|10082;SNPApp_EUR_0.90_0.05_1228_1231Hapmap10082ldselect.out/13:34") ||
											b1.getName().equals("AFR-GPC6|10082;SNPApp_AFR_0.90_0.05_1228_1232Hapmap10082ldselect.out/13:536") ||
											b1.getName().equals("CEU-STAT1|6772;SNPApp_EUR_0.90_0.05_1228_1231Hapmap6772ldselect.out/2:18") ||
											b1.getName().equals("AFR-STAT1|6772;SNPApp_AFR_0.90_0.05_1228_1232Hapmap6772ldselect.out/2:35")
									) {
										a++; // debugger breakpoint.
									}
									if(b1!=null) {
										for(int j2=j1+1;j2<sl.size();j2++) {
											Snp s2 =  sl.get(j2);
											if(s2!=null) {
												int[] bs2 =s2.getBins();
												if(bs2!=null) {
													for(int k2=0;k2<bs2.length;k2++) {
														if(bs2[k2]>0 && bs1[k1]!=bs2[k2]) {
															b1.addBin(bs2[k2], s2.getId());// also adds BinEdge and links the bins
															Bin b2 =Bin.getBinById(bs2[k2]);
															if(b2!=null) {
																if(b2.getName().equals("AFR-GPC6|10082;SNPApp_AFR_0.90_0.05_1228_1232Hapmap10082ldselect.out/13:38") ||
																		b2.getName().equals("CEU-GPC6|10082;SNPApp_EUR_0.90_0.05_1228_1231Hapmap10082ldselect.out/13:34") ||
																		b2.getName().equals("AFR-GPC6|10082;SNPApp_AFR_0.90_0.05_1228_1232Hapmap10082ldselect.out/13:536") ||
																		b2.getName().equals("CEU-STAT1|6772;SNPApp_EUR_0.90_0.05_1228_1231Hapmap6772ldselect.out/2:18") ||
																		b2.getName().equals("AFR-STAT1|6772;SNPApp_AFR_0.90_0.05_1228_1232Hapmap6772ldselect.out/2:35")
																) {
																	a++; // debugger breakpoint.
																}
																b2.addBin(bs1[k1], s1.getId());
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			
		}
		return (BinEdge.getNbinedges() -nedges);
	}
	
	
	/**
	 * greedy function to find the next best SNP to pick.
	 * 	Create and index that given snpid, get the index in snpsInDangerZoneByPos
	 * Order the snps in danger zone in groups according to bin content, 
	 *             then sorted by Score, then NPop
	 *    bin order is:
	 *       0 bins with no chosen SNP and only single choice (should be none left): 
	 *       1 bins with less choices than needed.
	 *       2 bins with same number of choices than needed
	 *       3 bins with only one more choice than needed
	 *       4 all other bins.
	 * do not include SNP in list (exclude & fix it) if bin is full.
	 * Pick SNPs one SNP at a time and update the order of SNPs every time.
	 *    before adding a SNP, check if it creates a cluster (don't I have a function for that?)
	 * 
	 *
	 * @param snpsInDangerZoneByPos
	 * @param nOPA
	 * @param tooClose
	 * @return
	 */

	public static int findNextPickableSnp(Snp[] snpsInDangerZoneByPos,int nOPA,int tooClose) {
 
		int b_category=5;
		//int b_chosen=Integer.MAX_VALUE;
		//int b_tochoose = 0;
		//int b_spare=Integer.MAX_VALUE;
		int b_locClass = Integer.MAX_VALUE;// smaller values is best.
		double b_snpprob=0.0;
		int b_snpPops = 0;
		int ib=-1;
		int nbest=0;
		for(int i=0;i<snpsInDangerZoneByPos.length;i++) {
			Snp s = snpsInDangerZoneByPos[i]; 
			if(s!=null && !( s.isExcluded() || s.isFixed() || s.isTmpSelected() || s.isObligateButNotGenotyped() )) {
				// Now check if it is in a cluster if would choose it.
				int nSelInWin = countTmpSelInWin(snpsInDangerZoneByPos,i,tooClose);
				if(nSelInWin<=nOPA) {
					// selecting this SNP would not be in conflict with those already chosen/obligate-chosen
					nbest++;
					if(s.isObligate()) {// de-selected obligates
						if(ib==-1) {
							ib=i;
							continue;
						} else {
							Snp prevBest = snpsInDangerZoneByPos[ib];
							if(!prevBest.isObligate()) {
								ib=i;
							} else {
								if( s.getFailProb() <prevBest.getFailProb()) {
									ib=i;
								} else if (s.getFailProb() ==prevBest.getFailProb()) {
									if(s.getScore()> prevBest.getScore()) {
										ib=i;
									} else if ((s.getScore()== prevBest.getScore())) {
										if(s.getNbins() >prevBest.getNbins()) {
											ib=i;
										}
									}
								}
							}
						}
						continue;
					}
					// XXX -- For SNPs touching multiple bins, take the "bin order" from the worst-off bin (e.g. the top category)
					int binCategory=5;
					int s_chosen=Integer.MAX_VALUE;
					int s_tochoose = 0;
					int s_spare=Integer.MAX_VALUE;
					double s_snpprob=s.getSuccessProb();
					int s_snpPops = 0; // will be incremented as loop through bins.
					int[] binsids = s.getBins();
					if(binsids!=null) {
						for(int j=0;j<binsids.length;j++) {
							int bid=binsids[j];
							if(bid>0) {
								s_snpPops++; // Chose to prioritize SNPs with larger overall coverage, rather than current coverage.
								Bin b = Bin.getBinById(bid);
								if(b!=null) {
									if(!b.isFull(true)) {
										int n_chosen = b.getNFixedOrObligateOrSelected();
										int n_tochoose = b.getNSB()-n_chosen;
										int nObligsToChoose = b.getUnPickedObligates();
										if(nObligsToChoose>n_tochoose) {
											n_tochoose=nObligsToChoose;
										}
										if(n_tochoose>0 ) {
											int[] avail = b.getAvailableSnpIds(false); // Fixed, Obligates, Selected, Excluded not available.
											if(avail!=null) {
												int n_avail = avail.length;
												if(n_avail>0) {
													int n_spare = n_avail-n_tochoose;
													// finally a bin with s snps to choose.
													// check if this bin is worst-off than previous bins for this snp
													if(nObligsToChoose>0) {
														// We don't bother finding the "best" bin if multiple meet the criteria.
														s_chosen=0;
														s_tochoose=n_tochoose;
														s_spare=n_spare;
														binCategory=0;
													} else if( n_chosen==0 && n_tochoose>0) {
													
														// We don't bother finding the "best" bin if multiple meet the criteria.
														s_chosen=0;
														s_tochoose=n_tochoose;
														s_spare=n_spare;
														binCategory=0;
													} else {
														if(n_spare==0 && n_tochoose>n_avail && binCategory>0) {
															binCategory=1;
															s_chosen=n_chosen;
															s_tochoose=n_tochoose;
															s_spare=0;
														} else if (n_spare==0 && n_tochoose==n_avail && binCategory>1) {
															binCategory=2;
															s_chosen=n_chosen;
															s_tochoose=n_tochoose;
															s_spare=0;
														} else if (n_spare==1 && binCategory>2) {
															binCategory=3;
															s_chosen=n_chosen;
															s_tochoose=n_tochoose;
															s_spare=1;
														} else if (n_spare>1 && binCategory>3) {
															binCategory=4;
															s_chosen=n_chosen;
															s_tochoose=n_tochoose;
															s_spare=n_spare;
														}
													}
												} else {
													System.err.println("SNPPicker: BUG: In greedy too-close, should not have no available SNPs in this bin\n");
													System.err.flush();
													System.out.flush();
													System.exit(-1);
												}//n_avail
											}//avail!=null
										}
									}
								}//b!=null
							}//bid>0
						} // for
					}//binsid!=null
					if(binCategory<b_category) {
						if(s_snpprob>b_snpprob) {
							if(s_snpPops>b_snpPops || (s_snpPops==b_snpPops && s.getLocation_class()>b_locClass)) {
								b_category=binCategory;
								//b_chosen=s_chosen;
								b_snpprob=s_snpprob;
								ib=i;
								b_snpPops = s_snpPops;
								b_locClass=s.getLocation_class();
								//b_spare = s_spare;
								//b_tochoose=s_tochoose;
							}
						}
					}
				}// nSelInWin<=nOPA
			}//s!=null or s already selected
		} // for loop over i - position
		return ib;

	}
	
	/**
	 *  Recursive function to pick a SNP in the binsToPick[binToPickIndex] Thid doesn't obligately pick the SNPs
	 *    It just finds the best set of SNPs in the danger zone to pick..(avoiding the creation of cluster of too-close SNPs)
	 * @param snpsInDangerZoneByPos Original List of Snps in danger zone, sorted by position.
     * @param sdz HashMap by position, same data as snpsInDangerZoneByPos
	 * @param binsToPick 
	 * @param binToPickIndex
	 * @return status status == 1=> Found a best solution
	 * 		status == -1 ==> aborted early because of CPU time .. but might still have a solution..
	 * 		status == 0 found no solution
	 */ 
	
	private static int maxLevel=0;

	// This is a private function because calling functions need to set maxLevel=0
	private static int pickBinsTooClose(long cpuend,int nOPA,Snp[] snpsInDangerZoneByPos,HashMap<String,Snp> sdz,Bin[] binsToPick,int binToPickIndex, SolutionTracker soln) throws Exception {
		// 

		int status =0;
		if(binToPickIndex>maxLevel) {maxLevel=binToPickIndex;}
		Bin b = binsToPick[binToPickIndex];
		int nTODO = b.getNSB()-b.getTmpNSelected();
		int nObligsNotPicked = b.getUnPickedObligates();
		if(nObligsNotPicked>nTODO) {
			nTODO=nObligsNotPicked;
		}
		if(SNPPicker.verbose) {
			System.out.println(b.getName()+" binToPickIndex="+binToPickIndex+", len="+binsToPick.length);
 			System.out.flush();
		}
 		
		if(nTODO<=0) { // Picked all SNPs for this bin from overlap with other bins.
				// Skip picking any more SNPs for this bin (it is full)
			int newstatus=0;
			if(SNPPicker.verbose) {
				System.out.println("for bin "+b.getName()+", nsb="+b.getNSB()+", ntmpsel="+b.getTmpNSelected());
			}
			if(binsToPick.length-1==binToPickIndex) {// last picked bin! We have a solution.
				newstatus =SolutionTracker.updateTmpScore(binsToPick,soln);
				if (newstatus==1) {
					if(SNPPicker.verbose) {
						System.out.println("Got a DP soln from skipping bin "+b.getName());System.out.flush();
					}
				}
			} else {
				// Skip picking this bin and continue
				if(SNPPicker.verbose) {
					System.out.println("pb2c: no more 2 pick--> skipping bin  "+b.getName());System.out.flush();
				}
				newstatus = pickBinsTooClose(cpuend,nOPA,snpsInDangerZoneByPos,sdz,binsToPick,binToPickIndex+1,soln);
			}
			if(newstatus==-1) {// CPU Runtime limit exceeded
				System.err.println("SNPPicker:WARNING: pickBinsTooClose ran out of CPUTIME at bin "+b.getName());System.err.flush();
				return -1;
			} else if (newstatus==1) {
				return 1;
			}
			return 0; // partial soln only.
		}

		int ibest=b.findBestUnpickedSnpOutsideDangerZone(sdz); // best unpicked
		if(SNPPicker.verbose) {
			System.out.println("ibest=" +ibest+ " for bin="+b.getName());System.out.flush();
		}
		// index of ibest refers to snps in b.getMaxScoringSnps
		Snp[] snps = b.getMaxScoringSnps();// does not included selected and excluded SNPs.
		//		best leftover tag outside danger_zone and 
		//	each leftover tag in danger zone in order of best scoring first. (though obligates gets priority)
		if(snps!=null) {
			for(int i=0;i<snps.length;i++) { // loop over snps in bin.
				Snp s = snps[i];
				if(s!=null) {
					boolean cannotPick = s.isExcluded() || s.isTmpSelected() || s.isObligateButNotGenotyped(); 

					// isSelected SNps could be set from bins with little choice.
					if(!cannotPick) {
						int jdanger=0;
						// new print
						if(SNPPicker.verbose) {
							System.out.println(" for bin="+b.getName()+", snp["+i+"] ="+s.getId()+","+s.getSnpName()+"["+s.getDbsnpid()+"]"+", not out of the question");
						}
						boolean inDangerZone = false;
						{
							for(int j=0;j<snpsInDangerZoneByPos.length;j++) {
								if(snpsInDangerZoneByPos[j].getId()==s.getId()) {
									inDangerZone=true;
									jdanger=j;
									break;
								}
							}
						}
						
						if(inDangerZone) { // only look at solutions for Snps in Danger Zone (and one SNP outside danger zone .. later)
							boolean canPick=true;
							if(SNPPicker.verbose) {
								System.out.println(" for bin="+b.getName()+", snp["+i+"] ="+s.getId()+","+s.getSnpName()+"["+s.getDbsnpid()+"]"+", in Danger Zone");
							}
							//		What would happen if we picked this SNP? We only want to 
							//			mark picked SNP as selected as long as it does not create a size #nOPA region of selected SNPs.
							// scan snpsInDangerZoneByPos and make sure that we don't create a cluster of size>=#nOPA
 							int nInWin=0;
 							{
								nInWin = countTmpSelInWin(snpsInDangerZoneByPos,jdanger,SNPPicker.getTooClose());
								if(nInWin>nOPA) {
									canPick=false;
								}
							}
							if(canPick) {
								if(SNPPicker.verbose) {
									System.out.println(" for bin="+b.getName()+", snp["+i+"] ="+s.getId()+","+s.getSnpName()+"["+s.getDbsnpid()+"]"+", CANPICK in Danger Zone");
								}
								if(binsToPick.length-1==binToPickIndex) {// last picked bin! We have a solution.
									s.setTmpSelected(true,true);
									int newstatus =SolutionTracker.updateTmpScore(binsToPick,soln);
									s.setTmpSelected(false,true);
									if(newstatus==1) {
										if(SNPPicker.verbose) {
											System.out.println("got complete soln @ end of DP.");System.out.flush();
										}
										status=1;
									}
									if(SNPPicker.verbose) {
										System.out.println(" for bin="+b.getName()+", snp["+i+"] ="+s.getId()+","+s.getSnpName()+"["+s.getDbsnpid()+"]"+", Got solution");
									}
								} else {
									//  Pick this SNP and call recursive
									if(SNPPicker.verbose) {
										System.out.println(" for bin="+b.getName()+", snp["+i+"] ="+s.getId()+","+s.getSnpName()+"["+s.getDbsnpid()+"]"+", recursive pick in Danger Zone");
									}
									s.setTmpSelected(true,true);
									int newstatus = pickBinsTooClose(cpuend,nOPA,snpsInDangerZoneByPos,sdz,binsToPick,binToPickIndex+1,soln);
									s.setTmpSelected(false,true);
									if(newstatus==-1) {// CPU Runtime limit exceeded
										if(SNPPicker.verbose) {
											System.out.println("pb2c: out of CPU after recursive call");System.out.flush();
										}
										return -1;
									} else if (newstatus==1) {
										if(SNPPicker.verbose) {
											System.out.println("pb2c: got soln after DP call");System.out.flush();
										}
										status=1;
									} else {
										// status =0 .. e.g. partial solution back from DP.
									}
								}
							} else {// canPick
								if(SNPPicker.verbose) {
									System.out.println(" for bin="+b.getName()+", snp["+i+"] ="+s.getId()+","+s.getSnpName()+"["+s.getDbsnpid()+"]"+", CANNOT PICK in Danger Zone (nInWin="+nInWin+")");
								}
							}
						} // in DangerZone
					} // if(!cannotPick) {
				}//s!=null
			} // loop over snps
		} // snps!=null


		if(ibest!=-1) { // There exist a "Best" snp outside the danger zone.
			if(SNPPicker.verbose) {
				System.out.println("now try ibest for bin "+b.getName());System.out.flush();
			}
			Snp sbest = snps[ibest];
			if(!(sbest.getTmpSelected() || sbest.isSelected() )) {
				// then pick ibest SNP if exist or has not been already selected..
				sbest.setTmpSelected(true,true);
				int newstatus=0;
				if(binsToPick.length-1==binToPickIndex) {
					newstatus =SolutionTracker.updateTmpScore(binsToPick,soln);
					if(newstatus==1) {
						if(SNPPicker.verbose) {
							System.out.println("pb2c: got ibest soln");System.out.flush();
						}
					}
				} else {
					newstatus = pickBinsTooClose(cpuend,nOPA,snpsInDangerZoneByPos,sdz,binsToPick,binToPickIndex+1,soln);
					if(newstatus==1) {
						if(SNPPicker.verbose) {
							System.out.println("pb2c: got ibest soln after DP call");System.out.flush();
						}
					}
				}
				sbest.setTmpSelected(false,true);
				if(newstatus==1) {
					status=1;
				} else if(status==-1) {// CPU Runtime limit exceeded
					System.err.println("SNPPicker:WARNING CPU limit reached");System.err.flush();
					return -1;
				}
			} else {
				throw new Exception("Algorithmic Bug: Should not have a selected best non-selected");
			}
		} else {
			if(SNPPicker.verbose) {
				System.out.println("no ibest to try for "+b.getName());System.out.flush();
			}
		}


		{
			if(SNPPicker.verbose) {
				System.out.println("try to skip bin "+b.getName());System.out.flush();
			}
			// Try Skipping this bin to find a better solution.
			int newstatus=0;
			if(binsToPick.length-1==binToPickIndex) {// This is the last bin .. just don't select any SNP to skip.
				newstatus =SolutionTracker.updateTmpScore(binsToPick,soln);
			} else {
				// Skip picking this bin and continue
				if(SNPPicker.verbose) {
					System.out.println("pb2c: trying to skip bin  "+b.getName());System.out.flush();
				}
				//just don't select any SNP to skip.
				newstatus = pickBinsTooClose(cpuend,nOPA,snpsInDangerZoneByPos,sdz,binsToPick,binToPickIndex+1,soln);
			}
			if (newstatus==1) {
				if(SNPPicker.verbose) {
					System.out.println("Got a DP soln from skipping bin "+b.getName());System.out.flush();
				}
				status=1;
			} else if(newstatus==-1) {// CPU Runtime limit exceeded
					System.err.println("SNPPicker:WARNING: ran out of CPU time for bin "+b.getName());System.err.flush();
				return -1;
			}
		}

		if(soln.hasSolution() && soln.hasCompleteSolution()){
			if(SNPPicker.verbose) {
				System.out.println("pb2c: Hooray Complete soln");System.out.flush();
			}
			return 1; // complete solution by skipping picking a snp for this bin (for this list index)
		} else if(soln.hasSolution()) {
			if(SNPPicker.verbose) {
				System.out.println("pb2c: partial only");System.out.flush();
			}
			return 0;
		} else {
			// Check CPU runtime limit.
			if(System.currentTimeMillis()>cpuend) {
				System.err.println("SNPPicker:WARNING pb2c: ran out of time");System.err.flush();
				if(SNPPicker.verbose) {
					System.out.println("SNPPicker:WARNING pb2c: ran out of time");System.out.flush();
				}
				return -1;
			}
			if(SNPPicker.verbose) {
				System.out.println("pb2c: no solution");System.out.flush();
			}
			return 0; // no complete solution.
		}

	}
	
	

	
	/**
	 * Compute the number of already selected SNPs that are too close to this SNP. The center SNP always counts for 1.
	 * @param snpsInDangerZoneByPos - List of SNPs that are in Cluster of too-close Snps
	 * @param jdanger
	 * @param tooClose
	 * @return
	 */
	    
	public static int countTmpSelInWin(Snp[] snpsInDangerZoneByPos,int jdanger,int tooClose) {
		if(tooClose>0) {
			boolean countObligates=true;
			return countTmpSelInWin(snpsInDangerZoneByPos,jdanger, tooClose, countObligates);
		} else {
			return 0;
		}
	}
	
	    
	/**
	 * Compute the number of already selected SNPs that are too close to this SNP. The center SNP always counts for 1.
	 * The function starts by delineating the cluster of "selected" too close centered around this SNP.
	 * It then proceeds to find the maximal scoring window around this SNP.. because
	 *   this "score" represents the minimum number of OPAs that will include this SNP
	 *     and not cause conflicts (with this SNP) .. other SNPs in that sub-cluster
	 *     could still have problems with one another.
	 * @param snpsInDangerZoneByPos - List of SNPs that are in Cluster of too-close Snps
	 * @param jdanger
	 * @param tooClose
	 * @return
	 */
	    
	public static int countTmpSelInWin(Snp[] snpsInDangerZoneByPos,int jdanger,int tooClose, boolean includeNonExcludedObligates) {
		if(tooClose==0) {
			return 0;
		}
		Snp dangerSnp = snpsInDangerZoneByPos[jdanger];
		int dangerPos = dangerSnp.getPosition();
		String dchr = dangerSnp.getChromosome();
		if(dchr==null || dchr.equals("-99")) {
			dchr="";
		}
		String schr = dchr;
		if(dangerPos<0) { // unknown position
			return 1; // itself.
		}
		if(SNPPicker.verbose) {
			 System.out.println("dangerPos="+dangerPos);
		}
		int lastPos = dangerPos;
		int lastGoodPos=dangerPos;
		int pos = dangerPos;

		int j=jdanger;
		if(SNPPicker.verbose) {
			System.out.print("lastJ");
		}
		{
			Snp s = snpsInDangerZoneByPos[j];			
			schr = s.getChromosome();
			if(schr==null || schr.equals("-99")) {
				schr="";
			}
		}
		// Scan forward until we find the first consecutive selected snps further apart than too close.
		while(((schr.length()>0 && schr.equals(dchr)) || (schr.length()==0 && pos>=lastPos && pos>0)) && pos-lastPos<=tooClose && j<(snpsInDangerZoneByPos.length-1)) {
			Snp s = snpsInDangerZoneByPos[j];
			if(schr.length()>0) {
				if((!s.isExcluded()) 
						&&   (( s.isSelected()
								|| s.isTmpSelected() 
								|| (includeNonExcludedObligates && s.isObligate() &&!s.isExcluded())))   
						) {
					if(schr.equals(dchr)) {
						lastPos=lastGoodPos;
						lastGoodPos=pos;
//						System.out.print("+");
					}
				}
			}
			j++;
			s = snpsInDangerZoneByPos[j];		
			schr = s.getChromosome();
			if(schr==null || schr.equals("-99")) {
				schr="";
			}
			pos = s.getPosition();
		}
		int lastJ=j; 
		if(pos-lastPos>tooClose) {
			lastJ=j-1;
			if(SNPPicker.verbose) {
				System.out.print("-");
			}
			if(lastJ<0) {
				lastJ=0;
				if(SNPPicker.verbose) {
					System.out.print("0");
				}
			}
			if(lastJ<jdanger) {
				lastJ=jdanger;
				System.out.print("reset");
			}
		}
		if(SNPPicker.verbose) {
			System.out.println("==>"+lastJ+",pos="+snpsInDangerZoneByPos[lastJ].getPosition());
		}
		// scan backward.
		j=jdanger;
		schr = dchr;
		lastPos = dangerPos;
		lastGoodPos=dangerPos;
		pos = dangerPos;
		if(SNPPicker.verbose) {
			System.out.print("firstJ");
		}
		while(((schr.length()>0 && schr.equals(dchr)) || schr.length()==0) && lastPos-pos<=tooClose && j>0) {
			j--;
			Snp s = snpsInDangerZoneByPos[j];
			schr = s.getChromosome();
			if(schr==null || schr.equals("-99")) {
				schr="";
			}
			if(schr.length()>0) {
				if((!s.isExcluded()) 
						&&   ((s.isTmpSelected() || (includeNonExcludedObligates && s.isObligate() )))   
						) {
					if(schr.equals(dchr) ) {
						lastPos=lastGoodPos;
						lastGoodPos=pos;
						System.out.print("-");
					}
				}
			}
			pos = s.getPosition();
		}
		int firstJ=j;
		if(lastPos-pos>tooClose) {
			firstJ=j+1;
			System.out.print("+");
			if(firstJ>snpsInDangerZoneByPos.length-1) {
				firstJ=snpsInDangerZoneByPos.length-1;
				System.out.print("last");
			}
			if(firstJ>jdanger) {
				firstJ=jdanger;
				System.out.print("reset");
			}
		}
		if(SNPPicker.verbose) {
			System.out.println("==>"+firstJ+",pos="+snpsInDangerZoneByPos[firstJ].getPosition());
		}
		int nWinMax=0; // The target SNP should at least create a maximal window with one SNP.
		if(SNPPicker.verbose) {
			System.out.println("sdz.len="+snpsInDangerZoneByPos.length+", firstJ="+firstJ+",jdanger="+jdanger+",lastJ="+lastJ);
		}
		if(!(firstJ==lastJ && firstJ==jdanger)) {
			for(int jj=firstJ;jj<=lastJ;jj++) {// jj is the "start" of the test window.
					Snp s = snpsInDangerZoneByPos[jj];
					schr = s.getChromosome();
					if(schr==null || schr.equals("-99")) {
						schr="";
					}
					int nWin=0;
					if(schr.length()>0) {
						// only start a loop on a Snp with known chrom
						int jloop = jj;
						pos = s.getPosition();
						if(schr.length()>0 && schr.equals(dchr)) {
							// only start a window on same chromosome as the "danger" SNP.
							Snp loopSnp = snpsInDangerZoneByPos[jloop];
							int loopPos = loopSnp.getPosition();
							String loopChr = schr;
							while(loopPos-pos<=tooClose && jloop<=lastJ && loopChr.length()>0) {
								if((!loopSnp.isExcluded()) 
										&&   ((loopSnp.isTmpSelected() || (includeNonExcludedObligates && loopSnp.isObligate() &&!loopSnp.isExcluded())))   
										  ) {
									if(schr.length()>0 && loopChr.equals(schr) ) {
										nWin++;
										if(SNPPicker.verbose) {
											System.out.println("nWin++ with sel="+(loopSnp.isSelected() ?"true":"false")+",tmpsel="+(loopSnp.isTmpSelected() ?"true":"false")+",isFixed="+(loopSnp.isFixed() ? "true":"false"));
										}
									}
								} else if (jloop==jdanger) {
									nWin++;// always count the calling SNP.
								}
								jloop++;
								if(jloop<snpsInDangerZoneByPos.length) {
									loopSnp = snpsInDangerZoneByPos[jloop];
									loopChr =loopSnp.getChromosome();
									if(loopChr==null || loopChr.equals("-99")) {
										loopChr="";
									}
								}
							}
							if(SNPPicker.verbose) {
								System.out.println("loop nWin="+nWin);
							}
								
						} else if (jloop==jdanger) {
							nWin=1;
						}
					} else if (jj==jdanger) {
						nWin=1;
					}
					if(nWin>nWinMax) {
						nWinMax=nWin;
					}
			}// for( int jj
		} else {
			nWinMax=1;
		}
		if(nWinMax<1) {
			nWinMax=1;
		}
		if(SNPPicker.verbose) {
			System.out.println("nWinMax="+nWinMax);
		}
		return nWinMax;
		
	}
	    
	/**
	 * NO LONGER USED in SNPPICKER2
	 *  return set of bins with little choice as to which SNPs to pick.
	 * Also excludes worst scoring SNPs to avoid OPA overlap.
	 * This cannot be called with tmpSelected snps.
	 * 
	 * @param c List of SNPClusters 
	 * @param binCluster List of the Bin corresponding to the SNP clusters
	 * @param tooClose
	 * @param nOPA
	 * @return
	 */
	
	private static ArrayList<ArrayList<Bin>> binsWithLittleChoice( ArrayList<ArrayList<Snp>> c, ArrayList<ArrayList<Bin>> binCluster, int tooClose,int nOPA) throws Exception{
		if(c==null) {
			return null;
		}
		int nClusters = c.size();
		int nRejectedSnps=0;
		for(int i=0;i<nClusters;i++) {
			List<Bin> bl = binCluster.get(i);
			// ArrayList sl = (ArrayList)c.get(i);
			// Make a list of Bins with as many Snps to pick (e.g. NSb-nobligate=1)
			// as are available in the bin (usually singletons)
			{
				// Find all the SNPS in low-choice bins.
				// ArrayList bsingle = new ArrayList();
				TreeSet<Snp> sNeeded = new TreeSet<Snp>(new SnpOrderComparator());
				for(int j=0;j<bl.size();j++) {
					Bin b = bl.get(j);
					if(b!=null) {
						int nChoices = b.getNSB()-b.getNSelected(); // Number to choose (obligates are counted as selected)
						int[] available = b.getAvailableSnpIds(false); // false= Don't look at the Tmp Selected status on SNPs
						if(nChoices>0) {
							if(available!=null) {
								if(available.length<nChoices) {
									b.warning("SNPPicker: WARNING: Not enough tag-snps available to select for bin "+b.getName());
									nChoices=available.length;
								}
								if(nChoices==available.length) {
									for(int k=0;k<available.length;k++) {
										sNeeded.add(Snp.getSnpById(available[k]));
									}
									// selected SNps include obligates
									Snp[] selSnps = b.getSnps();
									if(selSnps!=null && selSnps.length>0) {
										for(int k=0;k<selSnps.length;k++) {
											Snp s =selSnps[k];
											if(s!=null) {
												if((!s.isExcluded()) && (s.isSelected() || (s.isObligate() &&  !s.isExcluded() ) || (s.isFixed() && !s.isExcluded()))) { // selected and obligates
													sNeeded.add(s);
												}
											}
										}
									}
								} else {
									// have some choices, so leave up to rest of code to decide
								} // nCHoices== available.length
							} else { // available==null 
								if(b.getNSelected()==0) {
									b.warning("Cannot select any tag-snps for bin "+j+" ");
								} else {
									b.warning("Not enough tag-snps available to select for bin "+j+" : Already "+b.getNSelected()+" chosen");
								}
							} // available!=null
						} // nChoices>0
					}//b!=null
				} // loop over bins in that cluster

				if(sNeeded.size()>0) {// Found Some Snps in bins with little choice.

					// If the SNPs in these bins alone cause too-close clusters.. we KNOW that the only solution will be to eliminate some of the SNPs.
					// XXXX --  The problem here is that too-close SNPs (not in that one bin) are not considered.
					ArrayList<ArrayList<Snp>> contigousSingleChoiceSnps = findContigousSNP(sNeeded, tooClose,false,true,nOPA);
					while(contigousSingleChoiceSnps!=null && contigousSingleChoiceSnps.size()>0 && sNeeded.size()>0) {

							//(XXX Here could do an exhaustive di-tag search) .. instead of deleting bin.. (student project)
						// SNPs are sorted in order of those needed because they uniquely tag a bin, then highest score.
						
						int nC = contigousSingleChoiceSnps.size();
						int badcount=0;
						
						TreeSet<Snp> tNeeded = new TreeSet<Snp>(new SnpScoreComparator());
						for(int k=0;k<nC;k++) {
							tNeeded.addAll(contigousSingleChoiceSnps.get(k));
						}
						//if those marked Snps make up a cluster of size >#O, 
						//	greedily trim the cluster the worst Snps firts
						// The SNPs are sorted to put single-choice SNPs first
						// and worst scoring with in multiple choice bins last.
						// Delete last Snp in tNeeded
						//   also delete it from sNeeded
						int lastindx = tNeeded.size()-1;
						Object[] tNeeded_list = tNeeded.toArray();
						Snp worstSnp = (Snp)tNeeded_list[lastindx];
						while(lastindx>0 && (worstSnp==null || (worstSnp.isSelected() || worstSnp.isExcluded() || worstSnp.isObligate()))) {
							lastindx--;
							worstSnp = (Snp)tNeeded_list[lastindx];
						}
						if(worstSnp==null || worstSnp.isSelected() || worstSnp.isExcluded()) {
							// Make sure that this didn't happen because of unselected obligates
							lastindx = tNeeded.size()-1;
							worstSnp = (Snp)tNeeded_list[lastindx];
							while(lastindx>0 && (worstSnp==null || (worstSnp.isSelected() || worstSnp.isExcluded()))) {
								lastindx--;
								worstSnp = (Snp)tNeeded_list[lastindx];
							}
						}
						if(!(worstSnp.isSelected())) {
							if(!worstSnp.isExcluded()) {
								nRejectedSnps++;
								worstSnp.warning("Rejected SNP because it was the worst scoring SNP that was too close to other SNPS. ");
								System.err.flush();
//								worstSnp.setExcluded(true); // Permanent exclusion will also process the Bins... and the Bin Objects will issue messages if they are excluded.						
								// unique coverage is automatically updated when setting excluded
								worstSnp.setFixed(true);
							}
							sNeeded.remove(worstSnp);
						} else {
							StringBuffer binString = new StringBuffer();
							for(int l=0;l<bl.size();l++) {
								Bin bb = bl.get(l);
								binString.append(";");
								binString.append(bb.getName());
							}
							System.err.println("SNPPicker:WARNING: Too many already selected  SNPs too close to each other "+binString.substring(1)+"\n");
							System.err.flush();
							badcount++;// exit the loop, nothing more can be done.condition.
						}
						if(badcount==1) {
							contigousSingleChoiceSnps=null;// nothing else can be done for all sub-cluster  --> exit.
						} else {
							contigousSingleChoiceSnps = findContigousSNP(sNeeded, tooClose,false,true,nOPA);
						}
					} // while
					Iterator<Snp> sn = sNeeded.iterator();
					while(sn.hasNext()) {
						Snp sn_sel = sn.next();
						if(sn_sel!=null && !(sn_sel.isSelected() || sn_sel.isExcluded() || (sn_sel.getNbins()==0 && !sn_sel.isObligate()))) {
							sn_sel.setSelected(true,true);
							sn_sel.setFixed(true);
						}
					}
				} // sNeeded

			}
		} // End of For Loop over Clusters


		// XXX Reclustering all SNPs is not ideal if use this program for whole genome .. could use better tracking of rejected Snps
		if(nRejectedSnps>0) {
			//recluster snps in this Collection if have set unavailable SNPs (nRejectedBins=0;)
			// will ignore Excluded Snps
			// We recluster all bins even though we wouldn't need to if we had fancier tracking 
			c = clusterSnpCluster(findContigousSNP(tooClose,false,true,nOPA));
			if(c==null) {
				binCluster.clear();
				return null;
			}
			nClusters = c.size();
			// Snps that could be excluded on the basis of too little choice were already.
			// any leftover snps will be dealth with by the main program.
			binCluster.clear();
			// Collect the list of bins that contain the Snps involved in a cluster.	
			for(int i=0;i<nClusters;i++) {
				ArrayList<Bin> bv = getBinsForSnpList(c.get(i));
				if(bv==null || bv.size()==0) {
					bv=bv;// break for debugger .. but this happens when not-in-dataset are examined for purposed of tooClose
				}
				binCluster.add(bv);
			}
			return binCluster; // new bin clusters
		}
		return binCluster; // old bin clusters
}
/**
 * Internal function to get list of bins to try to get Bins that are too close.. 
 * @return
 */
	private static Bin[] getBinsToPick(ArrayList<Bin> bins,Snp[] snpsInDangerZone,boolean pickAllUnpickedObligates) {
		//brute-force: Bin Picking order doesn't change the solution if there is a solution
		//		that involves all bins. So pick bin order that minimizes combinatorics and works through
		//			the bins with the most constraints first. (because will stop once CPU limit is reached)
		//
		//  create binTopick = Array of binids to pick a Snp from. (if have Nsb>1, put Nsb copies of Bin in List)
		//   Order is Bins with only 1 choice(no choice)
		//   then bins with minimum amount of alternative to putting their SNPs in the danger zone
		//      (e.g. bins who have to pick the most of their SNPs in the danger zone)
		//	    and minimal number of alternative SNPs to pick in the danger zone
		//      minimal snps_available_for_picking_not_in_dangerzone-Nsb
		//         if negative ==> must pick Snps in Danger zone
		//         If positive or 0 ==> don't Have to pick Snp in danger zone
		//         then, if equal, minimal snps_in_danger_zone
		//   then the bins with minimal Snps_not_in_danger zone.
	  
	   //If a Bin is full, exclude from binToPick list.
	if(SNPPicker.verbose) {
		System.out.println("gp2p_start");System.out.flush();
    }
	if(bins==null || snpsInDangerZone==null) {
		System.err.println("SNPPicker: WARNING: bins or snpsInDangerZone null");
		System.err.println("SNPPIcker:WARNING: gp2p called with bins="+(bins == null ? "null" : "not null")+", and snpsInDangerZone "+(snpsInDangerZone==null ? "null" : "not null"));
		System.err.flush();
		return null;
	}
	TreeSet<Bin> binToPickSorted= new TreeSet<Bin>(new SnpTooCloseBinOrderComparator(bins,snpsInDangerZone));
	Iterator<Bin> itb = bins.iterator();
	if(itb==null) {
		if(SNPPicker.verbose) {
			System.out.println("gp2p: iterator_null");System.out.flush();
		}
		return null;
	}
	while(itb.hasNext()) {

		Bin badd = itb.next();
		if(SNPPicker.verbose) {
			System.out.println("badd="+(badd == null ? "null" : "not null"));System.out.flush();
		}
		
		if(badd!=null && (!badd.isFull(true))  ) { // A bin is not full if all obligates have not been picked.
			int nselected = badd.getNSelected(); // Includes Obligates
			int nToSelect = badd.getNSB()-nselected; 
			int nUnselectedObligs = badd.getUnPickedObligates();
			if(SNPPicker.verbose) {
				System.out.println("nToSelect="+nToSelect+",nUnselectedObligates="+nUnselectedObligs);System.out.flush();
			}
			if(nUnselectedObligs>nToSelect) {
				nToSelect=nUnselectedObligs;
			}
			if(nToSelect>0) {
				 int[] available = badd.getAvailableSnpIds(true); // (includes unselected or unexcluded obligates)/
				//int navail =badd.getNsnps()-badd.getNExcluded()-badd.getNSelected();
				 int navail=0;
				 if(available!=null) {
					 navail=available.length;
				 }
				 if(SNPPicker.verbose) {
					 System.out.println("navail="+navail);System.out.flush();
				 }
				if(navail<nToSelect) {
					if(navail==0 && nselected==0 && badd.getNSB()>0) {
						badd.warning("could not select any tagsnps for this bin");
					} else {
						badd.warning("Could not find enough tag snps to fill up bin according to rules for number of wanted tags as fn of the number of SNPs in bin");
					}
					nToSelect=navail;
				}
				if(nToSelect>0) {
					for(int j=0;j<nToSelect;j++) {
						if(SNPPicker.verbose) {
							System.out.println("adding="+j);System.out.flush();
						}
						binToPickSorted.add(badd);
					}
				}
			}
		} else if (badd==null) {
			if(SNPPicker.verbose) {
				System.out.println("gp2p_badd_null");System.out.flush();
			}
			return null;
		}
	}
	if(SNPPicker.verbose) {
		System.out.println("gp2p_filled");System.out.flush();
	}
	Bin[] binsToPick = new Bin[binToPickSorted.size()];
	Iterator<Bin> itbs = binToPickSorted.iterator();
	int j=0;
	while(itbs.hasNext()) {
		binsToPick[j++]= itbs.next();
	}
	if(SNPPicker.verbose) {
		System.out.println("gp2p_end");System.out.flush();
	}
	return binsToPick;
}
		


	public double getSuccessProb() {
		return successProb;
	}
	public void setSuccessProb(double successProb) {
		if(this.obligateButNotGenotyped && SNPPicker.obligateIncludeNGFileOverRule) {
			this.successProb = 1.0d;
			this.failProb=0.0d;
		} else {
			this.successProb = successProb;
			this.failProb=1.0d-successProb;
		}
	}

/**
 * 
 * @param sid
 * @param processBin
 */
	public static void tmpSelectSnpId(int sid,boolean processBin) {
		Snp s = Snp.getSnpById(sid);
		s.setTmpSelected(true,processBin);
	}
	
	/**
	 * Reset TMP solution to "selected" status Picks up Obligate and already selected Snps.
	 * @param processBinToo
	 */
	public void resetTmpSolution(boolean processBinToo) {
	//	if(!hasBeenReset) {
			hasBeenReset=true;
			this.tmpSelected=this.selected; // Picks up Obligate (if selected) and already selected Snps.
			if(processBinToo) {
				if(this.bins!=null) {
					for(int i=0;i<this.bins.length;i++) {
						// Call finalPick for Bins.
						int bid=bins[i];
						if(bid>0) {
							Bin b = Bin.getBinById(bid);
							b.resetTmpSolution(false);
						}
					}
				}
			}
	//	}
	}
	/**
	 * Move temporary solution to best-so-far solution
	 *
	 */
	public void pickBestSoFarAndReset(boolean processBinToo) {
	//	if(!this.bestWasTransfered) {
			this.bestWasTransfered=true;
			this.bestSelected=this.tmpSelected;
			resetTmpSolution(false);
			if(processBinToo) {
				// Loop over bins and
				// mark BINS that contain this SNP .. and call with processSnpToo=false;
				if(this.bins!=null) {
					for(int i=0;i<this.bins.length;i++) {
						// Call finalPick for Bins.
						int bid =this.bins[i];
						if(bid>0) {
							Bin b = Bin.getBinById(bid);
							b.pickBestSoFarAndReset(false);
						}
					}
				}
			}
	//	}
	}
	/**
	 * Move temporary solution to best-so-far solution
	 *
	 */
	public void pickBestSoFar(boolean processBinToo) {
		this.bestSelected=this.tmpSelected ; // This allows optimization over obligates.
		this.bestWasTransfered=true;
		if(processBinToo) {
			// Loop over bins and
			// mark BINS that contain this SNP .. and call with firstCall=false;
			if(this.bins!=null) {
				for(int i=0;i<this.bins.length;i++) {
					// Call finalPick for Bins.
					int bid=this.bins[i];
					if(bid>0) {
						Bin b = Bin.getBinById(bid);
						b.pickBestSoFar(false);
					}
				}
			}
		}
	}
	
	
	/**
	 * Move best-so-far solution to the final solution.
	 * @param selectOrExclude If true, either move to selected or excluded. 
	 *                      If False, then only process selected
	 * @param processBinToo
	 */
	
	public void finalPick(boolean selectOrExclude, boolean processBinToo,boolean setObligateIfSelected) throws Exception {
		// mark this SNP as selected.. 
		// can reverse one's mind about selecting a SNP unless excluded/fixed/obligate
		if(!(this.isExcluded() || this.isFixed() || this.isObligate() || this.isObligateButNotGenotyped())) {
			if(this.bestSelected) {
				this.setSelected(true,processBinToo);
				this.setTmpSelected(true,processBinToo);
				
			} else {
				this.setSelected(false,processBinToo);
				this.setTmpSelected(false,processBinToo);
				if (selectOrExclude) {
					this.setExcluded(processBinToo);
				}
			}
		}
		if(setObligateIfSelected && this.isObligate() &&  this.isBestSelected() && (!this.isExcluded())) {
				this.setSelected(true,processBinToo);
				this.setTmpSelected(true,processBinToo);
		}
		if(processBinToo && this.bins!=null) {
			for(int i=0;i<this.bins.length;i++) {
				int bid = this.bins[i];
				if(bid>0) {
					Bin b = Bin.getBinById(bid);
					if(b!=null) {
						b.finalPick(false, false);
					}
				}
			}
		}
	}
	
	
	public boolean isTmpSelected() {
		return tmpSelected;
	}
	
	/*
	 * select (or temporately deselect) SNP ids.
	 */
	public void setTmpSelected(boolean tmpSelected, boolean processBins) {
		this.tmpSelected = tmpSelected;
		this.bestWasTransfered=false;
		hasBeenReset=false;
		if(processBins) {
			if(this.bins!=null) {
				for(int i=0;i<this.bins.length;i++) {
					int bid=this.bins[i];
					if(bid>0) {
						Bin b = Bin.getBinById(bid);
						b.tmpSelectSnpId(tmpSelected,this.getId(),false);
					}
				}
			}
		}
	}
	public boolean getTmpSelected() {
		return this.tmpSelected;
	}
	public void warning (String msg) {
		System.err.println("SNPPicker:WARNING :"+msg+": Snp "+this.getSnpName());
		System.err.flush();
		//this.warning=msg;
	}


	public boolean isBestSelected() {
		return bestSelected;
	}
	public void setBestSelected(boolean bestSelected) {
		this.bestSelected = bestSelected;
	}
	
	/**
	 * Sets the flag that says that this SNP has to be part of the final solution.
	 * @param binid
	 */
	public void setUniquelyCovers(int binid) {
		//XXX For now we don't store the binid (could be unique for multiple bins)
		this.uniquelyCovers=true;
	}

	public boolean isFixed() {
		return fixed;
	}
	public void setFixed(boolean fixed) {
		this.fixed = fixed;
	}
	public boolean isUniquelyCovers() {
		return uniquelyCovers;
	}
	
	

	public double getR2(String binname) {
		Double d = (Double) r2.get(binname);
		if(d==null) {
			return -1.0d;
		} else {
			return d.doubleValue();
		}
	}
	public void setR2(double r2,String binname) {
		this.r2.put(binname, new Double(r2));
	}
	public void resetR2() {
		this.r2= new HashMap<String,Double>();
	}
	public int incrementPreBin() {
		return ++this.preBin;
	}
	public int decrementPreBin() {
		return --this.preBin;
	}
	public int getPreBin() {
		return this.preBin;
	}
	public void setPreBin(int pb) {
		this.preBin=pb;
	}
	/**
	 * return the number of populations that this SNP is part of.
	 * @return
	 */
	public int getNPop() {
		int npop =0;
		if(this.bins!=null) {
			for(int i=0;i<this.bins.length;i++) {
				if(this.bins[i]!=0) {npop++;}
			}
		}
		if(npop!=nbins) {
			(new Exception()).printStackTrace();
			System.err.println("SNPPicker:ERROR: nbins!= count of npop\n");
			System.err.flush();
			System.out.flush();
			System.exit(-1);
		}
		return npop;
	}

	private static final String twobeads = "]AT]TA]CG]GC]A/T]T/A]C/G]G/C]A|T]T|A]C|G]G|C]S]W]A-T]T-A]C-G]G-C]";
	public void setAlleles(String _alleles) {
		this.alleles= _alleles;
		
		  /* Infinium II uses red for A+T and green for C/G ==>
		   * can handle with one bead type ddU{[A/G], [C/T], [A/C], [G/T], but A/T and C/G SNP require two beads. 
		   */
		if(alleles!=null && alleles.length()>0) {
			this.nI2beads=1;
			String al = alleles;
			if(al.startsWith("[") || al.startsWith("(")) {
				al=al.substring(1);
			}
			if(al.endsWith("]") || al.endsWith(")")) {
				al=al.substring(0,al.length()-1);
			}
			if(twobeads.indexOf("]"+al+"]")>=0) {
				this.nI2beads=2;
			}
		}
	}
	public String getAlleles() {
		return this.alleles;
	}
	public int getNI2beads() {
		if(SNPPicker.infinium) {
			return nI2beads;
		} else {
			return 1;
		}
	}
	public void setNI2beads(int ni2beads) {
		nI2beads = ni2beads;
	}
	public void setGene(String gene) {
		this.gene=gene;
	}
	public String getGene() {
		return this.gene;
	}
	public void setGeneId(String geneid) {
		this.geneId=geneid;
	}
	public String getGeneId() {
		return this.geneId;
	}
	public String getBuild() {
		return build;
	}
	public void setBuild(String build) {
		this.build = build;
	}
	public String getSource() {
		return source;
	}
	public void setSource(String source) {
		this.source = source;
	}
	public String getDbsnpid() {
		return dbsnpid;
	}
	public void setDbsnpid(String _dbsnpid) throws Exception {
		String dbsnpid = (_dbsnpid ==null ? "" : _dbsnpid.toLowerCase());
		if(this.dbsnpid!=null && this.dbsnpid.length()>0) {
			//dbsnpid2Snp.remove(this.dbsnpid);
			// keep old name in haveSNP

		} else if(dbsnpid!=null && dbsnpid.length()>0 && dbsnpid2Snp.containsKey(dbsnpid)) {
			Snp otherSnp = (Snp) dbsnpid2Snp.get(dbsnpid);
			if(otherSnp!=null && !this.equals(otherSnp)) {
				System.err.flush();
				System.out.flush();
				throw new Exception("same dbsnpid "+dbsnpid+"assigned to two different SNPs "+this.getId()+"["+this.getSnpName()+"],"+otherSnp.getId()+"["+otherSnp.getSnpName()+"]");
			}
		}
		haveSnp.put(dbsnpid, this);
		dbsnpid2Snp.put(dbsnpid, this);
		this.dbsnpid = dbsnpid;
	}
	public static Snp getSnpByDbsnpid(String _dbsnpid) {
		String dbsnpid = (_dbsnpid ==null ? "" : _dbsnpid.toLowerCase());
		if(dbsnpid.length()>0) {
			Snp s = (Snp) dbsnpid2Snp.get(dbsnpid);
			return s;
		}
		return (Snp) null;
	}
	
	public static int countInSameOPa(Snp[] snpsInDangerZoneByPos,int jdanger,int tooClose, int avoidOPA) {
		return countInSameOPa(snpsInDangerZoneByPos,jdanger,tooClose, avoidOPA,false);
	
	}
	// Count the number of selected SNPs in same OPAs as the avoidOPA and around the jdanger SNP
	
	public static int countInSameOPa(Snp[] snpsInDangerZoneByPos,int jdanger,int tooClose, int avoidOPA,boolean includeNonExcludedObligates) {
		
		Snp dangerSnp = snpsInDangerZoneByPos[jdanger];
		int dangerPos = dangerSnp.getPosition();
		String dchr = dangerSnp.getChromosome();
		if(dchr==null || dchr.equals("-99")) {
			dchr="";
		}
		String schr = dchr;
		if(dangerPos<0) { // unknown position
			return 1; // itself.
		}
		int nWin=0;
		int lastPos = dangerPos;
		int pos = dangerPos;

		int j=jdanger;

		// Scan forward until we find the first gap of length tooClose
		while(((schr.length()>0 && schr.equals(dchr)) || schr.length()==0) && pos-lastPos<=tooClose && j<(snpsInDangerZoneByPos.length-1)) {
			j++;
			Snp s = snpsInDangerZoneByPos[j];
			schr = s.getChromosome();
			if(schr==null || schr.equals("-99")) {
				schr="";
			}
			lastPos=pos;
			pos = s.getPosition();
		}
		int lastJ=j; 
		if(pos-lastPos>tooClose) {
			lastJ=j-1;
			if(lastJ<0) {
				lastJ=0;
			}
		} // else j==the last one.

		// scan backward.
		j=jdanger;
		schr = dchr;

		while(((schr.length()>0 && schr.equals(dchr)) || schr.length()==0)  && lastPos-pos<=tooClose && j>0) {
			j--;
			Snp s = snpsInDangerZoneByPos[j];
			schr = s.getChromosome();
			if(schr==null || schr.equals("-99")) {
				schr="";
			}
			lastPos=pos;
			pos = s.getPosition();
		}
		int firstJ=j;
		if(lastPos-pos>tooClose) {
			firstJ=j+1;
			if(firstJ>=snpsInDangerZoneByPos.length) {
				firstJ=snpsInDangerZoneByPos.length-1;
			}
		}
		for(j=firstJ;j<=lastJ;j++) {
			Snp s=snpsInDangerZoneByPos[j];
			int opaid = s.getOPAid();
			if((avoidOPA==opaid) &&(s.isSelected() ||((s.isObligate() || s.isObligateButNotGenotyped()) && includeNonExcludedObligates  && !s.isExcluded() ) ) && !s.isExcluded()) {
				nWin++;
//				System.err.println("same OPA: name="+s.getSnpName()+", pos="+s.getPosition());
			}
		}
		
		return nWin;
		
	}
	
	private static void computeOPAid() {
		if(SNPPicker.nOPA<=0) {
			// rejected all too-close SNPs or ignored that fact.
			for(int i=0;i<Snp.snpIndex.length;i++) {
				Snp s= Snp.snpIndex[i];
				if(s!=null) {
					if(s.isSelected()) {
						s.setOPAid(0);
					} else {
						s.setOPAid(-1);
					}
				}
			}
			return;
		}
		
		updateSortedSnps(true);
		Iterator <Snp>its = Snp.sortedByPosAll.iterator();
		Snp[] ssnps = new Snp[sortedByPosAll.size()];

		int i=0;
		while(its.hasNext()) {
			Snp s =  its.next();
			ssnps[i++]=s;
			s.resetTmpSolution(false); // otherwise countInWin won't work.
		}
		int nOPA = SNPPicker.nOPA;
		for(int j=0;j<i;j++) {
			Snp s = ssnps[j];
			// count Selected Snps in window.
			if(s!=null) {
				if(s.isExcluded() || !s.isSelected()) {
					s.setOPAid(-1);
				} else {
					int nin = countTmpSelInWin(ssnps,j,SNPPicker.tooClose);// Count selected& tmpSelected in window.
					int opaid=0;
					while(nin>nOPA) {
//						    System.err.println("in loop since nin>nOPA");
							opaid++;
							s.setOPAid(opaid);
							nin = countInSameOPa(ssnps,j,SNPPicker.tooClose,opaid);
//							System.err.println("Searching for free opa: " +s.getSnpName()+" , status="+s.getStatusNote()+", opaid="+opaid+",nin="+nin+",pos="+s.getPosition());

					}
					// opaid 0 means no-conflicts, opaid!=0 means exclusive sets.
					s.setOPAid(opaid);
					if(opaid>nOPA) {
						System.err.println("Warning: Some SNPs were put in more OPAs than requested: " +s.getSnpName()+" , status="+s.getStatusNote()+", opaid="+opaid+",nOPA="+nOPA+",pos="+s.getPosition());

					}
				}
			}
		}
	}
	/**
	 * If bins were independent, then we could sort SNP by prob. * number of SNPs in bin.
	 * Bins are not independent, so a SNP utility is also a function of how
	 * many bins it covers, how many bins it uniquely covers, and the bin size.
	 * We want to order SNPs with the idea that not the whole list will be selected.
	 *    (The Caveat is that with an ideal solution with a smaller number of SNPs may
	 *     not have been the same as the truncated solution with no constraint on the total
	 *     number of SNPs.)
     *        
     *        0 -initialize selectionOrder=0 (on SNP)
     *        (everytime will assign a SNP to a selection order, increment
     *         the selection order by 1)
     *         initialize current_utility=Prob * (Number of SNPs per bins)
	 *        1- Sort Snps by utility 
	 *        2 -Loop over all SNPs (in utility order) 
	 *            and set the selectionOrder obligate SNPs (but not forced in)
	 *        every time we select a SNP.
	 *        Go over all bins it touches and
	 *        remove from the TreeSet all the non-selected SNPs in those bins
	 *        recompute the utility as current_utility=incremental utility.
	 *          and reinsert in the TreeSet all the SNPs just modified
	 *        3- Start from the top of the list and update selection order on 
	 *          SNPs (updating SNP current_utility as in 2).
	 * 
	 * @return vector of Snp objects sorted  by utility
	 */
	private static Snp[] snpsByUtility() {
		TreeSet<Snp> t = new TreeSet<Snp>(new SnpUtilityComparator());
		// First Pass, obligates.
		if(SNPPicker.verbose) {
			System.out.println("Computing utility of obligates\n");System.out.flush();
		}
		for(int i=0;i<indexSize;i++) {
			Snp s =  snpIndex[i];
			if(s!=null) {
				s.setSelectionOrder(0);
				s.setWasPrinted(false);
				s.computeIncrementalUtility(true); // currentUtility=incremental/(number of beads)
				s.utility=s.incrementalUtility; // Switched to reporting incremental (without dividing by nbeads) instead of current (used for sorting)
				if((s.isObligate() || s.isObligateButNotGenotyped())&& !s.isExcluded()) {
					t.add(s);
				}
			}
		}
		System.out.println("Computing incremental utility for obligates vs obligates\n");System.out.flush();
		Snp[] osnps = new Snp[t.size()];
		Iterator<Snp> it = t.iterator();
		int ii=0;
		while(it.hasNext()) {
			osnps[ii++]= it.next();
		}
		int selOrder=1;
		for(int i=0;i<osnps.length;i++) {
			Snp s = osnps[i];
			s.setSelectionOrder(selOrder);
			// remove Snp from t and update currentUtility to
			// the incremental value for all other SNPs sharing
			// a bin with the selected SNP.
			updateSetForSnp(t,s);
			selOrder++;
			s.setWasPrinted(true);
		}
		t.clear(); // clean up object.
		
		//
		// 2nd pass selected or Fixed.
		//
		System.out.println("Computing selected(includes fixed selected .. but not obligates) utility");
		System.out.flush();
		Snp sss=null;
		int n_not_selected=0;
		try {
			for(int i=0;i<indexSize;i++) {
				sss =  snpIndex[i];
				if(sss!=null) {
					if( sss.isSelected() && sss.getNbins()>0 && !(sss.isObligate() || sss.isObligateButNotGenotyped())) { // Only count obligates once.
//						System.out.println("SNP:["+i+"]="+sss.getId());System.out.flush();
						t.add(sss);
//						System.out.println("Added SNP:["+i+"]="+sss.getId());System.out.flush();
					} else {
						n_not_selected++;
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			if(sss==null) {
				System.err.println("Error on filling treeset for null SNP");		
			} else {
				System.err.println("Error on filling treeset for snp"+sss.getId());
			}
			System.err.flush();
		}
		

		int nts=t.size();
		System.out.println("Computing incremental utility for multiple SNPs per bin : selected(non-obligate)=" + nts);
		System.out.flush();
		Snp[] orderedSnps = new Snp[nts];
		it = t.iterator();
		int i=0;
		while(it.hasNext()) {
			Snp s =  it.next();
			if(s!=null ) {
				orderedSnps[i++]=s;
			}
		}
		nts=i;

		for(i=0;i<nts;i++) {
			Snp s = orderedSnps[i];
//			System.out.println("Removing SNP ="+s.getId());System.out.flush();
			s.setSelectionOrder(selOrder);
			// remove Snp from t and update currentUtility to
			// the incremental value for all other SNPs sharing
			// a bin with the selected SNP.
			updateSetForSnp(t,s);// Delete this SNP from Set and 
			// The treeset will be modified upon return and iterators are not usable.
			selOrder++;
			s.setWasPrinted(true);
		}
		System.out.println("Created list of SNPs sorted by utility");System.out.flush();

		TreeSet<Snp> ts = new TreeSet<Snp>(new SnpSelectionOrderComparator());
		

		for(i=0;i<indexSize;i++) {
			Snp s =  snpIndex[i];
			if(s!=null) {
				if(s.getSelectionOrder()>0) { // obligates and selected 
					ts.add(s);
					s.setWasPrinted(false);
				}
			}
		}

		Snp[] sortedSnps = new Snp[selOrder-1+n_not_selected];
		int ns=0;

		Iterator<Snp> its = ts.iterator();
		while(its.hasNext()) {
			Snp s =  its.next();
			sortedSnps[ns++]=s;
		}

// Now add the not-selected SNPs at the end of the list.
		for(i=0;i<indexSize;i++) {
			Snp s = snpIndex[i];
			if(s!=null) {
				if(s.getSelectionOrder()<=0) { // excluded or not chosen.
					sortedSnps[ns++]=s;
					s.setWasPrinted(false);
				}
			}
		}
		System.out.println("Returned list of SNPs sorted by utility");System.out.flush();
		return sortedSnps;
	}

	/**
	 * 	 every time we select a SNP.
	 *   Go over all bins it touches and
	 *   remove from the TreeSet all the non-selected SNPs in those bins
	 *   recompute the utility as current_utility=incremental utility. (e.g. only count already selected SNPs)
	 *   and reinsert in the TreeSet all the SNPs just modified
	 * @param t
	 * @param s
	 */
	
	private static void updateSetForSnp(TreeSet<Snp> t,Snp s) {
		if(t==null || s==null) {
			return;
		}
		t.remove(s); // No harm done if s is not in t.
		HashSet<Snp> SnpsRemoved = new HashSet<Snp>();
		HashSet<Snp> unSelectedSnps = new HashSet<Snp>();
		HashSet<Bin> touchBins = new HashSet<Bin>();
		int[] binids = s.getBins();
		if(binids!=null && binids.length>0) {
			for(int i=0;i<binids.length;i++) {
				  int bid = binids[i];
				  if(bid>0) {
					  Bin b = Bin.getBinById(bid);
					  if(b==null) {
						  System.err.println("SNPPicker:updateSetForSNP : ERROR could not find bin for binid="+bid);System.err.flush();
					  } else {
						  touchBins.add(b);
						  Snp[] ss = b.getSnps();
						  if(ss!=null) {
							  for(int j=0;j<ss.length;j++) {
								  Snp sj = ss[j];
								  if(sj!=null) {
									  int ord = sj.getSelectionOrder();
									  if(ord==0) {// not yet selected.
										  unSelectedSnps.add(sj);
										  if(t.remove(sj)) {
											  if(SNPPicker.verbose) {
												  System.out.println("Removing "+sj.getId());
											  }
											  SnpsRemoved.add(sj);
										  }
									  }
								  }
							  }
						  }
					  }
				  }
			}
			Iterator<Snp> fixit=unSelectedSnps.iterator();
			while(fixit.hasNext()) {
				Snp s2fix =  fixit.next();
				s2fix.computeIncrementalUtility(true);
			}
			Iterator<Snp> addback=SnpsRemoved.iterator();
			while(addback.hasNext()) {
				Snp s2add =  addback.next();
				t.add(s2add);
			}
		}
		return;
	}
	
	public static void outHeader(PrintStream outStream) {
		outStream.println("hugo_gene_name\tentrez_gene_id\tsnp_source\tgenome_build\tchromosome\tchr_pos_bp\tsource_id\tdbsnp_rsid\tld_bin\ttag_snp\tmaf\tgenotype\tlocation_in_gene\tassay_score\tnum_beads\tbins\tnSites\tnote\tpopulations\tOPAid\ttobegenotyped\tpoptagged\tutility\tincrementalUtility\tsource\tProbability");
		outStream.flush();
	}
	
	public static void outAll(PrintStream outStream) {
		System.out.println("Computing OPA id\n");System.out.flush();
		computeOPAid();
		System.out.println("Computing utility\n");System.out.flush();
		Snp[] sortedSnps = snpsByUtility();

		for(int i=0;i<indexSize;i++) {
			Snp s =  snpIndex[i];
			if(s!=null ) {
				s.setWasPrinted(false);
			}
		}
		System.out.println("Printing "+sortedSnps.length+" SNPs\n");System.out.flush();

		for(int i=0;i<sortedSnps.length;i++) {
			Snp s =  sortedSnps[i];
//			System.out.println("printing SNP "+i);System.out.flush();
			if(s!=null) {
				try {
				
					int nb = s.getNbins();
					
					if(nb<=0 && (!(s.isObligate() || s.isObligateButNotGenotyped()))) {
						// Skip this.. this SNP was only retained because of the annotation 
						// s.out(System.out); // debugging
					} else {
						s.out(outStream);
						s.setWasPrinted(true);
					}
					
				} catch (Exception e) {
					System.err.println(e.getMessage());
					e.printStackTrace();
					System.err.flush();
				}
			}
		}
		
		
	}
	public void out(PrintStream outStream) {

		StringBuffer out = new StringBuffer();

		StringBuffer binsnames = new StringBuffer();
		StringBuffer nSitesString = new StringBuffer();
		StringBuffer nPopString = new StringBuffer();
		StringBuffer geneString = new StringBuffer();
		StringBuffer geneidString = new StringBuffer();
		StringBuffer sourceString = new StringBuffer();

		int nPTag=0;
		if(this.bins!=null) {
			for(int i=0;i<this.bins.length;i++) {
				if(this.bins[i]>0) {
					Bin b = Bin.getBinById(this.bins[i]);
					String bgene =b.getGene();
					
					if(bgene==null || bgene.length()==0) {bgene = this.gene;}
					String bgeneid =b.getGeneId();
					if(bgeneid==null || bgeneid.length()==0) {bgeneid = this.geneId;}
					
					if(bgeneid!=null && bgeneid.length()>0 && (bgene==null || bgene.length()==0)) {
						bgene =  SNPPicker.GENE2GENEID.get(bgeneid);
						b.setGene(bgene);
					}
					if((bgeneid==null ||  bgeneid.length()==0) && bgene!=null && bgene.length()>0) {
						bgeneid =  SNPPicker.GENEID2GENE.get(bgene);
						b.setGeneId(bgeneid);
					}
					
					String bname = b.getOutputName();
					binsnames.append(",");binsnames.append(bname);
					String nSitesStr = Integer.toString(b.getNSites());
					nSitesString.append(",");nSitesString.append(nSitesStr);
					String popName = Population.getPopById(b.getBasePopId()).getOutputName();
					

					nPopString.append(",");nPopString.append(popName);
					nPTag++;

					String bsource =b.getSource();
					if(bsource==null || bsource.length()==0) {bsource = this.source;}
					if(this.source==null || this.source.length()==0) {this.source=bsource;}
					geneString.append(",");geneString.append(bgene);
					geneidString.append(",");geneidString.append(bgeneid);
					sourceString.append(",");sourceString.append(bsource);
				}	
			}
		}
		if(geneString.length()>0) {
			out.append(geneString.substring(1));
		} else {
			out.append(this.gene);
		}
		out.append("\t");
		if(geneidString.length()>0) {
			out.append(geneidString.substring(1));
		} else {
			out.append(this.geneId);
		}
		out.append("\t");
		if(sourceString.length()>0) {
			out.append(sourceString.substring(1));
		} else {
			out.append(this.source);
		}
		out.append("\t");
		out.append(this.build);out.append("\t");
		out.append(this.chromosome ==null ? "" : this.chromosome.toUpperCase());out.append("\t");//4
		out.append(this.position);out.append("\t");
		out.append(this.getSnpName());out.append("\t");
		out.append(this.dbsnpid);out.append("\t");

		out.append(binsid2String(this.bins));  //8
		out.append("\t"); // binid from ldselect.. which doesn't make sense for multi-pop/sources.
		
		if((!this.isObligate()) && this.bins!=null && this.nbins>0 && (this.nbins>1 || (Utils.sumGT0(this.bins)>0 ))) {
			out.append("1");out.append("\t"); // this SNP is a tag SNP for at least 1 population and not an obligate.
		} else {
			out.append("0");out.append("\t"); //obligates are not tags	
		}
		out.append(this.maf_string);out.append("\t"); // maf - Would need one per population and I could get it from Affy.. but it's a lot of trouble.
		out.append(this.alleles);out.append("\t");
		out.append(this.location);out.append("\t");
		out.append(this.score);out.append("\t");
		
// This next part of the output is not in the base Mayo Tabular.
// added fields:          num_beads bins nSites note populations OPAid utility incrementalUtility 	
		out.append(this.nI2beads);out.append("\t"); // numbeads for Infinium II 
		
		if(binsnames.length()>0) {
			out.append(binsnames.substring(1)); //15
		}
		out.append("\t");
		if(nSitesString.length()>0) {
			out.append(nSitesString.substring(1));
		}
		out.append("\t");
		
		String note = this.getStatusNote(); //17
		out.append(note);out.append("\t");
		
		if(nPopString.length()>0) {
			out.append(nPopString.substring(1));
		} else {
			out.append(0);
		}
		out.append("\t");
		out.append(this.OPAid);out.append("\t");
		if((this.isSelected() || this.isObligate()) && !this.isExcluded()) {
			out.append("1");out.append("\t");
		} else {
			out.append("0");out.append("\t"); // obligates not genotyped and unselected or excluded SNPs.
		}
		out.append(nPTag);out.append("\t");
		out.append(this.utility);out.append("\t");
		out.append(this.incrementalUtility);out.append("\t");
		out.append(this.source);out.append("\t");
		//out.append(this.getLocation());out.append("\t");
		out.append(this.getSuccessProb());
		
		outStream.println(out.toString());outStream.flush();

	}
	
	public String getStatusNote() {
		if(this.obligateButNotGenotyped) {
			return "obligate_not_genotyped_not_in_bins";
		}
		if(this.fixed_multi_test) {
			return "multi-SNP test";
		}
		if(this.obligate && (!this.fixed) && this.selected  && !this.excluded) {//1
			return "obligate";
		} else if(obligate && fixed && selected && !excluded) {//2
			return "obligate_fixed_proximity";
		} else if((excluded  || !selected) && obligate) {//3
			if(this.getScore()>SNPPicker.minScore) {
				return "obligate_excluded_proximity";
			} else {
				return "obligate_excluded_lowscore";
			}
		} else if((excluded || !selected)&& !obligate) {//5
			if("-99".equals(this.getChromosome())) {
				return "excluded_illumina_99annotation"; // new flag 3/13/07
			} else if(this.getScore()>=SNPPicker.minScore) {
				return "excluded_optimization";
			} else if(this.getScore()<=SNPPicker.badscore_double) {
				return "excluded_badilluminascore";
			} else {
				return "excluded_lowscore";
			}
		} else if (selected && fixed && (!obligate) && !excluded) {//6
			return "fixed_proximity";
		} else if (Utils.sumGT0(this.bins)>0 && selected && !(fixed || obligate || excluded)) {//7
			return "tagSNP";
		} else if(this.nbins>0) {
			return "not_selected_Tag";
		} else {
			return "non_tag";
		}
	}
	
	/**
	 * Compute the value of adding this SNP to the list of selected SNPs.
	 * 
	 * 
	 * @param noValueInExtraSnps if true, added utility is 0 for adding one SNP more than needed.
	 */
	
	private void computeIncrementalUtility(boolean noValueInExtraSnps) {
		if((!this.selected) || this.wasPrinted) {
			this.utility=0.0;
			this.incrementalUtility=0.0;
			this.currentUtility=0.0;
			return ;
		}
		double tutility=0.0;
		if(this.bins!=null) {
			for(int i=0;i<this.bins.length;i++) {
				int bid = this.bins[i];
				if(bid>0) {
					Bin b = Bin.getBinById(bid);
					boolean oldWasPrinted = this.wasPrinted;
					this.wasPrinted=false;
					double oldscore = b.getBinPrintScore();
//					System.out.print("incremental utility SCORE for SNP "+this.snpName+", with (nbins="+this.nbins+"), obligate="+(this.obligate ? "T":"F")+", oldscore="+oldscore+"\n");
					this.wasPrinted=true;
					double newscore = b.getBinPrintScore();
//					System.out.print("incremental utility SCORE for SNP "+this.snpName+", with (nbins="+this.nbins+"), obligate="+(this.obligate ? "T":"F")+", newscore="+newscore+"\n");

					if(noValueInExtraSnps) {
						int nSnps = b.countPrintSelectedSnps();
						int nNeeded = b.getNSB();
						if(nSnps<=nNeeded) {
							tutility +=(newscore-oldscore);
						}
					} else {
						tutility +=(newscore-oldscore);
					}
					this.wasPrinted=oldWasPrinted;
				}
			}
		}
//		System.out.print("incremental utility for SNP "+this.snpName+", with (nbins="+this.nbins+"), obligate="+(this.obligate ? "T":"F")+", incr-util="+tutility+"\n");
		this.incrementalUtility = tutility;
		tutility=tutility/(1+this.nI2beads);
		this.currentUtility=tutility;
	}
	
	public static void outEmpty(String binname,int numberOfSites,String gene, String chromosome,String position,PrintStream outStream) {
		StringBuffer out = new StringBuffer();
		Bin b = Bin.getBinByName(binname);
		String build = "";
		int bid =0;
		String populations="";
		String reasons="No_SNP_Selected";
		String bname = binname;

		if(b!=null) {
			bname = b.getOutputName();
			populations = Population.getPopById(b.getBasePopId()).getName();
			bid = b.getId();
			Snp[] sss=b.getSnps();
			if(sss!=null) {
				for(int i=0;i<sss.length;i++) {
					Snp ss = sss[i];
					if(ss!=null) {
						if( (build==null || build.length()==0)) {build = ss.getBuild();}
						String note = ss.getStatusNote();
						if(note!=null && note.length()>0) {
							if(reasons.length()>0) {
								reasons = reasons + ",";
							}
							reasons = reasons + note;
						}
					}
				}
			}
		} else {
			System.err.println("SNPPicker:ERROR: unknown binname in outEmpty function");System.err.flush();
			System.out.flush();
			System.exit(-1);
		}
		
	
		out.append(gene);out.append("\t"); // hugo gene name
		out.append(b.getGeneId()); // entrez geneid
		out.append("\t");
		out.append(b.getSource()); // bin snp source
		out.append("\t");
		out.append(build);out.append("\t"); //genome_build
		out.append(chromosome);out.append("\t");
		out.append(position);out.append("\t");
		out.append("\t"); // source id
		out.append("\t"); // dbsnp id
		out.append(bid);out.append("\t");
		out.append("0\t"); //tag snp flag
		out.append("\t"); // maf
		out.append("\t"); // genotype
		out.append("\t"); // Functional Location Class.
		out.append("0.0\t"); // assay_score
		out.append("0\t"); // numbeads for Infinium II
		out.append(bname);out.append("\t");
		out.append(numberOfSites);out.append("\t");  // nSites - Would need one per population and I could get it from Affy.. but it's a lot of trouble.
		out.append(reasons);out.append("\t");
		out.append(populations);out.append("\t"); // populations
		out.append("0\t"); //OPAid
		out.append("0\t"); //selected or obligate
		out.append("0\t"); //Number of populations tagged.
		
		out.append("0\t"); //utility
		out.append("0\t"); //incremental utility

		out.append("");// Probability
		
		
		outStream.println(out.toString());
	
	}
	public static Snp[] getSnpIndex() {
		return Snp.snpIndex;
	}
	public int getOPAid() {
		return OPAid;
	}
	public void setOPAid(int aid) {
		OPAid = aid;
	}
	
	public static String bins2String(Bin[] binlist) {
		StringBuffer binsnames = new StringBuffer();
		if(binlist!=null) {
			for(int i=0;i<binlist.length;i++) {
				Bin b=  binlist[i];
				if(b!=null) {
					String bname = b.getName();
					int ppos = bname.indexOf(":");
					int dpos = bname.indexOf(":DupFile");
					if(dpos>=ppos) {
						// format ls DupFilenn 
						int p2 = bname.indexOf("-",dpos+":DupFile".length());
						bname = bname.substring(0,dpos) + bname.substring(p2);
					}
					binsnames.append(",");binsnames.append(bname);
				}	
			}
			return binsnames.substring(1);
		} else {
			return "";
		}
	}
	public static String binsid2String(int[] binlist) {
		StringBuffer binsnames = new StringBuffer();
		if(binlist!=null) {
			for(int i=0;i<binlist.length;i++) {
				int ib =binlist[i];
				if(ib>0) {
					Bin b = Bin.getBinById(ib);
					String bname = b.getName();
					int ppos = bname.indexOf(":");
					int dpos = bname.indexOf(":DupFile");
					if(dpos>=ppos) {
						// format ls DupFilenn 
						int p2 = bname.indexOf("-",dpos+":DupFile".length());
						bname = bname.substring(0,dpos) + bname.substring(p2);

					}
					binsnames.append(",");binsnames.append(bname);
				}	
			}
			if(binsnames.length()>0) {
				return binsnames.substring(1);
			} else {
				return "";
			}
		} else {
			return "";
		}
	}
	
	
	protected boolean isWasPrinted() {
		return wasPrinted;
	}
	protected void setWasPrinted(boolean wasPrinted) {
		this.wasPrinted = wasPrinted;
	}
	public double getCurrentUtility() {
		return currentUtility;
	}
	private void setCurrentUtility(double newCurrentUtility) {
		this.currentUtility = newCurrentUtility;
	}
	public double getUtility() {
		return utility;
	}
	private void setUtility(double newUtility) {
		this.utility = newUtility;
	}
	public int getSelectionOrder() {
		return selectionOrder;
	}
	private void setSelectionOrder(int selectionOrder) {
		this.selectionOrder = selectionOrder;
	}
	
	public void setupMAFString(String mafString) {
		if(this.maf_string!=null && this.maf_string.length()==0) {
			this.maf_string=mafString;
		}
	}
	
	public void setMAFString(String mafString) {
		this.maf_string=mafString;
	}
	public String getMAFString() {
		return this.maf_string;
	}
	public void setSnpName(String _newSnpName) {
		String newSnpName = (_newSnpName==null ? "": _newSnpName.toLowerCase());
		if(this.snpName !=null && this.snpName.equals(newSnpName) ) {
			// do nothing.
		} else if (this.snpName == null) {
			this.snpName = newSnpName;
			 haveSnp.put(newSnpName,this);			
		} else {
				if (haveSnp.containsKey(this.snpName)) {
					haveSnp.remove(this.snpName);
				} else {
					System.err.println("SNP "+this.snpName+" not in index");
				}
				String oldSnpName = this.snpName;
				this.snpName = newSnpName;
				haveSnp.put(newSnpName,this);
				if(Snp.dbsnpid2Snp.containsKey(oldSnpName)) {
					Snp.dbsnpid2Snp.remove(oldSnpName);
				}
				if(newSnpName.startsWith("rs")) {
					Snp.dbsnpid2Snp.put(newSnpName,this);
				}
		}
	}
	
	public static void addSnpNameSynonym(Snp s, String _newSnpName) {
		if(s!=null && _newSnpName!=null && _newSnpName.length()>0) {
			String newSnpName =  _newSnpName.toLowerCase();
			if(s.synonyms==null) {
				s.synonyms = new HashSet<String>();
				s.synonyms.add(newSnpName);
			}
			if(haveSnp.containsKey(newSnpName)) {
				Snp s2 = haveSnp.get(newSnpName);
				if (! s.equals(s2)) {
					System.err.println("SNPPicker: addSnpNameSynonym: conflict, trying to set as synonyms two different SNPs "+s2.getSnpName()+" and "+newSnpName);				}
			} else {
				haveSnp.put(newSnpName,s);			
			}
		}
	}


	
	public boolean isFixed_multi_test() {
		return fixed_multi_test;
	}
	public void setFixed_multi_test(boolean fixed_multi_test) {
		this.fixed_multi_test = fixed_multi_test;
	}
	public static void fixObligates() throws Exception {
		if(snpIndex!=null ) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s =  snpIndex[i];
				if(s!=null) {
					if(s.isObligate() || s.isObligateButNotGenotyped()) {
						if(!s.isExcluded()) {
							if(!s.isSelected()) {
								s.setSelected(true, true);
							}
						}
						s.setFixed(true);
					}
				}
			}
		}
	}
	public boolean isObligateButNotGenotyped() {
		return obligateButNotGenotyped;
	}
	public void setObligateButNotGenotyped(boolean obligateButNotGenotyped) {
		this.obligateButNotGenotyped = obligateButNotGenotyped;
	}
	public void updateSnpName(String snpname,String _dbsnpid) throws Exception {
		if(snpname!=null && snpname.length()>0) {
			snpname = snpname.toLowerCase();
			String oldSnpName = this.getSnpName();
			if(oldSnpName!=null && oldSnpName.length()>0) {
				oldSnpName = oldSnpName.toLowerCase();
				if(!snpname.equals(oldSnpName)) {
					if((!oldSnpName.startsWith("rs")) && snpname.startsWith("rs")) {
						this.setDbsnpid(snpname);
						this.setSnpName(snpname);
					} else if (oldSnpName.startsWith("rs") && snpname.startsWith("rs")) {
						Snp.addSnpNameSynonym(this,snpname);
					} else if(oldSnpName.startsWith("rs")) {
						snpname = oldSnpName;
					} else {
						snpname  = this.getSnpName();
					}
				}
				if(_dbsnpid!=null && _dbsnpid.length()>0) {
					if(!(_dbsnpid.equals(snpname) || oldSnpName.equals(_dbsnpid))) {
						if(!this.getSnpName().startsWith("rs")) {
							this.setDbsnpid(_dbsnpid);
							this.setSnpName(_dbsnpid);
						}
					}
				}
			} else if(snpname!=null && snpname.length()>0) {
				if(snpname.startsWith("rs")) {
					this.setSnpName(snpname);
					this.setDbsnpid(snpname);
					if (_dbsnpid!=null && _dbsnpid.length()>0 && !_dbsnpid.equals(snpname)) {
						Snp.addSnpNameSynonym(this,_dbsnpid);
					}
				} else if (_dbsnpid!=null && _dbsnpid.length()>0) {
					this.setDbsnpid(_dbsnpid);
					this.setSnpName(_dbsnpid);
				} else {
					this.setSnpName(snpname);
				}
			} else { // both null
				if(_dbsnpid==null || _dbsnpid.length()==0) {
					snpname = this.chromosome+"-"+Integer.toString(this.position);
					this.setSnpName(snpname);
				} else {
					this.setDbsnpid(_dbsnpid);
					this.setSnpName(_dbsnpid);
				}
			}
		}
	}

	static public  int deleteWithoutBins() throws Exception {
		// Delete all Snps not associated with a bin.(or not tag snps)
		// Delete Snps without bins. (unless they are obligate not genotyped)
		// They were only needed for the  SnpTooClose tests if nOPA==0
		int nSnpsIndex = Snp.getSnpIndex().length;
		Snp[] snpindex = Snp.getSnpIndex();
		int ndel=0;
		for(int i=0;i<nSnpsIndex;i++) { //
			Snp s=snpindex[i];
			if(s!=null) {
				if( (s.isExcluded()) && !(s.isObligate())) {
					int nb= s.getNbins();
					if(nb==0 ) {// i.e. not TagSNPs, but in the bin... or score too low.
						Snp.deleteByName(s.getSnpName(), true);
						ndel++;
						snpindex[i]=null;
					}
				}
			}
		}
		return ndel;
	}
	public static int fixSnpsInWindows(ArrayList<ArrayList<Snp>> c) throws Exception {
		int nWindows = c.size();
		// Collect the list of bins that contain the Snps involved in a windows.
		// for nOPA==0, we act as if fixall is always true.
		int nfixed=0;
		for(int i=0;i<nWindows;i++) {
			ArrayList<Snp> snpList = c.get(i);
			int lsize = snpList.size();
			// XXX Could use di-tag break-up to resolve those bins.
			// Mark those SNPs as excluded
			for(int j=0;j<lsize;j++) {
				Snp s = snpList.get(j);
//				s.setSelected(false, true);// only sets back to unselected if SNPs was already selected.
				s.setFixed(true);
				nfixed++;
			}
		}
		return nfixed;
	}
	
	/*
	 * Unselect and Fix  Type II SNPs (those requiring more than one bead type
	 *    Unfixing must be done at cluster level only.
	 *    Do not fix obligates or Excluded SNPs.
	 */
	public  static int fixAndUnselectTypeII() throws Exception {
		// Delete all Snps not associated with a bin.(or not tag snps)
		// Delete Snps without bins. 
		// They were only needed for the  SnpTooClose tests if nOPA==0
		int nSnpsIndex = Snp.getSnpIndex().length;
		int nfixed=0;
		for(int i=1;i<=nSnpsIndex;i++) { //
			Snp s = Snp.getSnpById(i);
			if(s!=null) {
				if (s.getNI2beads()>1 && ! (s.isObligate() || s.isObligateButNotGenotyped())) {
					if(!(s.isExcluded() && s.isFixed())) {// Don't fix SNPs from Exclude file.. or those excluded from score
						s.setSelected(false, true);
						s.setFixed(true);
						nfixed++;
					}
				}
			}
		}
		return nfixed;
	}
	
	/*
	 * @returns a position sorted treeset of SNPs from an ArrayList of List of Snps.
	 */
	public static TreeSet<Snp> expandListToTreeSet(ArrayList<ArrayList<Snp>> l) {
		TreeSet<Snp> ml = new TreeSet<Snp> (new SnpOrderComparator());
		if(l==null || l.size()==0) {
			return ml;
		}
		Iterator<ArrayList<Snp>> itl = l.iterator();
		while(itl.hasNext()) {
			ArrayList<Snp> ls = itl.next();
			Iterator<Snp> its = ls.iterator();
			while(its.hasNext()) {
				Snp s = its.next();
				if(s!=null && !ml.contains(s)) {
					ml.add(s);
				}
			}
		}
		return ml;
	}
	public static int countSelected() {
		int nsel=0;
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isSelected()) {
						nsel++;
					}
				}
			}
		}
		return nsel;
	}
	public static int[] getObligatesIndex() {
		int nObligs=0;
		int[] obligatesIndex = new int[0];
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isObligate() && ! s.isExcluded()) {
						nObligs++;
					}
				}
			}
			obligatesIndex = new int[nObligs];
			nObligs=0;
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isObligate() && ! s.isExcluded()) {
						obligatesIndex[nObligs++]=i;
					}
				}
			}
			
		}
		return obligatesIndex;
	}
	public static int[] getExcludedIndex() {
		int nObligs=0;
		int[] obligatesExcludedIndex = new int[0];
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isObligate() && s.isExcluded()) {
						nObligs++;
					}
				}
			}
			obligatesExcludedIndex = new int[nObligs];
			nObligs=0;
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isObligate() && s.isExcluded()) {
						obligatesExcludedIndex[nObligs++]=i;
					}
				}
			}
			
		}
		return obligatesExcludedIndex;
	}
	public static int[] getObligatesNotGenotypedIndex() {
		int nObligs=0;
		int[] obligatesNotGenotypedIndex = new int[0];
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isObligateButNotGenotyped() ) {
						nObligs++;
					}
				}
			}
			obligatesNotGenotypedIndex = new int[nObligs];
			nObligs=0;
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(s.isObligateButNotGenotyped()) {
						obligatesNotGenotypedIndex[nObligs++]=i;
					}
				}
			}
			
		}
		return obligatesNotGenotypedIndex;
	}
	public static int[] getPickableSnpsIndex() {
		int nObligs=0;
		int[] pickableSnpsIndex = new int[0];
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(!(s.isObligateButNotGenotyped() || s.isObligate() || s.isExcluded()) ) {
						nObligs++;
					}
				}
			}
			pickableSnpsIndex= new int[nObligs];
			nObligs=0;
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					if(!(s.isObligateButNotGenotyped() || s.isObligate() || s.isExcluded())) {
						pickableSnpsIndex [nObligs++]=i;
					}
				}
			}
			
		}
		return pickableSnpsIndex;
	}

	public static void resetAll() {
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					s.reset();
				}
			}
		}
	}
	public static void tmpToSelected() {
		if(snpIndex!=null) {
			for(int i=0;i<snpIndex.length;i++) {
				Snp s = snpIndex[i];
				if(s!=null) {
					
					try {
						if((s.isTmpSelected() || s.isObligate())) {
							if(!s.isSelected()) {
								s.setSelected(true, true);
							}
						} else if(s.isSelected() && ! s.isObligate()) {
							s.setSelected(false,true);
						}
					} catch (Exception e) {
						e.printStackTrace();
						System.err.println(e.getMessage());
						System.err.flush();
						System.out.flush();
						System.exit(-1);
					}

				}
			}
		}
	}
	/*
	 * Delete any choice from a SNP
	 * 
	 */
	public void reset() {

		// Solution-related Variables
		this.selected = false; //  selected
		this.fixed = false; // Fixed to be selected or not Selected by Snps Too Close.
		if(this.score < SNPPicker.badscore_double) {
			this.fixed=true;
		}
		// Variables for Exploring solutions
		this.tmpSelected=false;
		this.hasBeenReset=false;
		this.uniquelyCovers=false;
		
		// Variables for best solution so-far
		this.bestSelected=false;
		this.bestWasTransfered=false;
		

		// Variable for printing and assigning to OPA
		this.wasPrinted=false;
		this.utility=0.0d;
		this.currentUtility=0.0d;

		this.OPAid=0;

	}
	
	/*
	 * Delete any choice from a SNP
	 * 
	 */
	public void resetExceptBest() {

		// Solution-related Variables
		this.selected = false; //  selected
		this.fixed = false; // Fixed to be selected or not Selected by Snps Too Close.
		if(this.score < SNPPicker.badscore_double) {
			this.fixed=true;
		}
		// Variables for Exploring solutions
		this.tmpSelected=false;
		this.hasBeenReset=false;
		this.uniquelyCovers=false;
		
		// Variables for best solution so-far


		// Variable for printing and assigning to OPA
		this.wasPrinted=false;
		this.utility=0.0d;
		this.currentUtility=0.0d;

		this.OPAid=0;

	}
	
	private static TreeSet<Snp> snpsTooClose= new TreeSet<Snp>(new SnpOrderComparator());
	private static ArrayList<ArrayList<Snp>>tooCloseClusters = null;
	private static HashSet<String> tooClosePairs = new HashSet<String>(4*Snp.indexSize);
	private static HashMap<Integer,Integer> tooCloseSnpToClusterId = new HashMap<Integer,Integer>(2*Snp.indexSize);
	
	/*
	 * Populate ordered snpsTooClose list 
	 * (see also Constructor that populates orderedSnps
	 */
	public static void populateTooClose() { // only do this once.
		if(Snp.tooCloseClusters==null && SNPPicker.tooClose!=0) {
			// Cluster SNPs in this Cluster and create a sorted list of tooClose SNPs.
			// That list can then be scanned for SNPs that are too Close.
			// by helper functions like canISelect.
			TreeSet<Snp> t = new TreeSet<Snp>(new SnpOrderComparator());
			for(int i=0;i<Snp.snpIndex.length;i++) {
				Snp s = Snp.snpIndex[i];
				if(s!=null && !(s.isObligateButNotGenotyped() || (s.isExcluded() && SNPPicker.nOPA!=0 ))) {
					t.add(s);
				}
			}
			Snp.tooCloseClusters = Snp.findContigousSNP(t,SNPPicker.tooClose,false,true,SNPPicker.nOPA);
			snpsTooClose= Snp.expandListToTreeSet(tooCloseClusters);
			//
			// Create a HashSet of pairs of ids that are too close (hasmap.put(id1+id2) [ being in the same tooCloseCluster is not enough]
			Iterator<ArrayList<Snp>> itls = tooCloseClusters.iterator();
			int cidint = 0;
			while(itls.hasNext()) {
				ArrayList<Snp> ls = itls.next();
				cidint++;
				Integer cid = Integer.valueOf(cidint);
				Iterator<Snp> its = ls.iterator();
				while(its.hasNext()) {
					Snp s = its.next();
					tooCloseSnpToClusterId.put(Integer.valueOf(s.getId()),cid);
					Iterator<Snp> its2 = ls.iterator();
					int i1 = s.getId();
					int p1 = s.getPosition();
					String str1 = Integer.toString(i1)+"-";
					while(its2.hasNext()) {
						Snp s2 = its2.next();
						int i2 = s2.getId();
						if(i1!=i2) {
							int p2 = s2.getPosition();
							if(Math.abs(p1-p2)<SNPPicker.tooClose) {
								String str2 = Integer.toString(i2);
								String key = (new StringBuffer(str1)).append(str2).toString();
								tooClosePairs.add(key);
							}
						}
					}
				}
			}
			// Does not include all SNPs, just ones in too Close groups within clusters.
			if(Snp.snpsTooClose==null) {
				Snp.snpsTooClose = new TreeSet<Snp>(new SnpOrderComparator());
			}
		}
	}
	
	
	/*
	 * 
	 * Function to count the number of OPA required to select all SNPs without conflicts by searching for the biggest continuous
	 * cluster. This function is used by the optimal solution search.
	 * this function does NOT assume that obligates are selected.. they have to be explicitely selected to count.
	 */
	public static int nOPAForTmpSolution(HashMap<Bin,Integer> bins2pick,boolean exitEarly, int minOPA) {
		if(SNPPicker.tooClose>0 && SNPPicker.nOPA>=0) {
			if(Snp.snpsTooClose==null || Snp.snpsTooClose.size()<=1) {
				return 1;
			}
			HashSet<Snp> selSnps = new HashSet<Snp>();
			Iterator<Bin> itb = bins2pick.keySet().iterator();
			while(itb.hasNext()) {
				Bin b = itb.next();
				if(b!=null) {
					Snp[] ss = b.getSnps();
					if(ss!=null) {
						for(int i=0;i<ss.length;i++) {
							Snp s = ss[i];
							if(s!=null && (s.isTmpSelected() ) && !(s.isObligateButNotGenotyped() && (SNPPicker.nOPA!=0 && s.isExcluded()))) {
								selSnps.add(s);
							}
						}
					}
				}
			}
			Iterator<Snp> os = Snp.snpsTooClose.iterator();
			int lastPos = -(SNPPicker.tooClose+1);
			int needOPA=1;
			ArrayList<Snp> snpStack = new ArrayList<Snp>();
			int stackSize=0;
			// The maximum number of OPA's is determined by the
			// maximal number of SNPs in a 60bp window.
			// Groups of SNPs linked by 60BP constraints, can be simply
			// accomodated with nOPA=2 (if only 2 SNPs max per 60bp windows), by alternating
			int nsnpsinsoln=0;
			while(os.hasNext()) {
				Snp s = os.next();
				if(s!=null && (s.isTmpSelected() ) && (!s.isExcluded()) && selSnps.contains(s) ) {
					nsnpsinsoln++; // just need for debugging.
					int newPos = s.getPosition();
					int currentOPA=1;
					if(newPos-lastPos>=SNPPicker.tooClose) {
						stackSize=0;
						snpStack.clear();
					} else {
						if(stackSize==1) {
							currentOPA=2;// Don't need to remove last one since we know it is within 60bp
						} else {
							int nRemove=0;
							for(int i=stackSize-1;i>=0;i--) {
								Snp sstack = snpStack.get(i);
								int stackPos = sstack.getPosition();
								int diff = newPos-stackPos;
								if(diff<SNPPicker.tooClose) {
									currentOPA++;
								} else{
									nRemove++;
								}
							}
							for(int i=1;i<=nRemove;i++) {
								snpStack.remove(0);
							}
							stackSize-=nRemove;
						}
						if(currentOPA>needOPA){
							needOPA=currentOPA;
							if(exitEarly && needOPA>minOPA){
								return needOPA;
							}
						}
					}
					snpStack.add(s);
					stackSize++;
					lastPos=newPos;
				}
			}
			return needOPA;
		} else {
			return 0;
		}

	}
	
	public static int[] getGreedyOrder(Snp[] snpList,boolean reverseOrder) {
		if(snpList==null || snpList.length==0) {
			return new int[0];
		}
		int[] order = new int[snpList.length]; // First Object on Stack .. to allow clean dealloc

		java.util.Comparator<Snp> comp = new SnpCoverageComparator();
		TreeSet<Snp> t= new TreeSet<Snp>(comp);
		int[] tmpIndex = new int[Snp.indexSize];
		for(int i=0;i<snpList.length;i++) {
			Snp s= snpList[i];
			if(s!=null) {
				tmpIndex[s.getId()]=i;
				t.add(s);
			}
		}
		Iterator<Snp> it = t.iterator();
		int i=0;
		if(reverseOrder) {
			i=t.size()-1;
		}
		while(it.hasNext()) {
			Snp s= it.next();
			order[i] = tmpIndex[s.getId()];
			if(reverseOrder) {
				i--;
			} else {
				i++;
			}
		}
		return order;
	}
	public String getBinsString() {
		int[] binids = this.getBins();
		if(binids==null) {
			return "";
		}
		StringBuffer bf = new StringBuffer();
		for(int i=0;i<binids.length;i++) {
			int bid = binids[i];
			if(bid>0) {
				Bin b=Bin.getBinById(bid);
				if(b!=null) {
					if(bf.length()>0) {
						bf.append(" , ");
					}
					bf.append(b.getName());
				}
			}
		}
		return bf.toString();
	}
	

	
} // end of Snp class
