package edu.mayo.genotype;


import java.util.HashMap;
import java.util.HashSet;

import java.lang.Long;
import java.util.Iterator;
import java.util.Set;
import java.util.Map;

/**
 * 
 * @author Hugues Sicotte, Copyright 2007
 *
 * Class to hold data Structure for one or more SNPs (edge) connecting two Bins. 
 */
public class BinEdge extends Object {
 

	private static int nbinedges=0;
	private static Map<String,BinEdge> haveBinEdge = new HashMap<String,BinEdge>();
	
	private int binedgeid;
	private Snp[] snpids=null; // Index that is as long as there are Snps
	private int nsnps=0;
	private int binid1;
	private int binid2;
	private Bin bin1=null;
	private Bin bin2 = null;

	// "Other" max score (Maximum score of tag snp in bin(1 or 2), but NOT in this edge)
	private double omaxscore1=0; // filled by a call to cacheMaxScores
	private double omaxscore2=0; // filled by a call to cacheMaxScores
	
	private int validflag=0; // (Temporary flag used during the search : 0 = available, 1-selected

	
	// These 4 fields are filled during the Construction of Cluster and are needed to order
	// binedges in optimal search order for solution.
	private int order=-1; // ordering needed by Cluster.pickBins() and BinEdgeComp, it's the index in the cluster
	private int snpMaxpop=0; // maximum number of populations a snp touches
	private int snpidMaxpop=0; // snp id of that one.
	private double snpMaxpopScore=0.0; // score of the maxpop snp
	
	private int weight=0; // bin1.Nedges + bin2.Nedges (2 means a single pair)
	
	private boolean isReal=true; // true if at least one of the SNPs in the edge is shared by the two bins.
	// 
	
	public int getSnpmaxpop() {
		return snpMaxpop;
	}
	public void setSnpmaxpop(int snpMaxpop) {
		this.snpMaxpop = snpMaxpop;
	}
	public int getSnpidmaxpop() {
		return snpidMaxpop;
	}
	public void setSnpidmaxpop(int snpidMaxpop) {
		this.snpidMaxpop = snpidMaxpop;
	}
	public double getSnpmaxpopscore() {
		return snpMaxpopScore;
	}
	public void setSnpmaxpopscore(double snpMaxpopScore) {
		this.snpMaxpopScore = snpMaxpopScore;
	}
	public int getOrder() {
		return order;
	}
	public void setOrder(int order) {
		this.order=order;
	}
	
	/**
	 * @return the nsnps
	 */
	public int getNsnps() {
		return nsnps;
	}

	/**
	 * @return the omaxscore1
	 */
	public double getOmaxscore1() {
		return omaxscore1;
	}
	/**
	 * @param omaxscore1 the omaxscore1 to set
	 */
	public void setOmaxscore1(double omaxscore1) {
		this.omaxscore1 = omaxscore1;
	}
	/**
	 * @return the omaxscore2
	 */
	public double getOmaxscore2() {
		return omaxscore2;
	}
	/**
	 * @param omaxscore2 the omaxscore2 to set
	 */
	public void setOmaxscore2(double omaxscore2) {
		this.omaxscore2 = omaxscore2;
	}
	/**
	 * @return the snpids
	 */
	public Snp[] getSnpids() {
		return this.snpids;
	}

	/**
	 * @return the validflag
	 */
	public int getValidflag() {
		return validflag;
	}
	/**
	 * @param validflag the validflag to set
	 */
	public void setValidflag(int validflag) {
		this.validflag = validflag;
	}
	/**
	 * @return the binedgeid
	 */
	public int getBinedgeid() {
		return binedgeid;
	}
	/**
	 * @return the binid1
	 */
	public  int getBinid1() {
		return binid1;
	}
	/**
	 * @return the binid2
	 */
	public  int getBinid2() {
		return binid2;
	}
	/**
	 * Not public Constructor: use  getBinEdge instead, which avoids duplication.
	 * 
	 * @param binid
	 * @param obinid
	 */
	
	 BinEdge(int binid,int obinid) {
		this.binid1=binid;
		this.binid2=obinid;
		nbinedges++;
		binedgeid=nbinedges;
	
		long hkey = (long)0;
		if(binid<obinid) {
			hkey=((long)binid*Bin.MAXBIN) +((long)obinid);
		} else {
			hkey=((long)obinid*Bin.MAXBIN) +((long)binid);
		}
		Long key = Long.valueOf(hkey);
		String keyStr = key.toString();
		haveBinEdge.put(keyStr,this);
		// The rest of the bin-edge auto-cluster the bins.
		Bin b1 = Bin.getBinById(binid);
		Bin b2 = Bin.getBinById(obinid);
		String b1name = b1.getName();
		String b2name = b2.getName();
		
		this.weight = b1.getNsnps()+b2.getNsnps();
		Bin b1last = b1.getLastBin();// last or current bin.
		Bin b2last = b2.getLastBin();
		if(!(b1last.getId()==b2last.getId())) {
			// Don't link them if they are already in same chain
			Bin b2first = b2.getFirstBin();
			b1last.setNextbin(b2first);
			b2first.setPrevbin(b1last);
		}
		this.bin1=b1;
		this.bin2=b2;
	}
	/**
	 * 
	 * returns existing BinEdge or new one
	 * 
	 * @param binid
	 * @param obinid
	 * @return
	 */
	public static BinEdge getBinEdge(int binid, int obinid) {
		long hkey = (long)0;
		if(binid<obinid) {
			hkey=((long)binid*Bin.MAXBIN) +((long)obinid);
		} else {
			hkey=((long)obinid*Bin.MAXBIN) +((long)binid);
		}
		Long key = Long.valueOf(hkey);
		String keyStr = key.toString();
		BinEdge b = (BinEdge) haveBinEdge.get(keyStr);
		if(b==null) {
			return new BinEdge(binid,obinid);
		} else {
			return b;
		}
	}
	public static void delete(BinEdge be) {
		if(be!=null) {
			Set<String> toremove = new HashSet<String>();
			Set<Map.Entry<String,BinEdge>> bes = haveBinEdge.entrySet();
			for(Iterator<Map.Entry<String,BinEdge>> it = bes.iterator();it.hasNext();it.next()) {
				Map.Entry<String,BinEdge> e= it.next();
				String key = e.getKey();
				BinEdge b = e.getValue();
				if(b.equals(be)) {
					toremove.add(key);
				}
			}
			Iterator<String> trit = toremove.iterator();
			while(trit.hasNext()) {
				String key = trit.next();
				haveBinEdge.remove(key);
			}			
		}
	}
	public static Set<BinEdge> getBinEdges(int bid) {

			Set<BinEdge> toReturn = new HashSet<BinEdge>();
			Set<Map.Entry<String,BinEdge>> bes = haveBinEdge.entrySet();
			for(Iterator<Map.Entry<String,BinEdge>> it = bes.iterator();it.hasNext();) {
				Map.Entry<String,BinEdge> e= it.next();
				BinEdge b = e.getValue();
				if(b.getBinid1()==bid || b.getBinid2()==bid) {
					toReturn.add(b);
				}
			}
			return toReturn;
	}
	 public static BinEdge getByBinIds(int binid,int obinid) {
			long hkey = (long)0;
			if(binid<obinid) {
				hkey=((long)binid*Bin.MAXBIN) +((long)obinid);
			} else {
				hkey=((long)obinid*Bin.MAXBIN) +((long)binid);
			}
			Long key = Long.valueOf(hkey);
			String keyStr = key.toString();
			return (BinEdge) haveBinEdge.get(keyStr);
		 
	 }
	/**
	 * @param snpids the snpids to set
	 */
	public Snp addSnp(int snp_id) {
		if(snp_id<0) {	
			return null;
		}
		Snp s = Snp.getSnpById(snp_id);
		if(s==null) {
			return null;  
		}
		if(snpids==null) {
			snpids = new Snp[10];
			snpids[0]=s;
			this.nsnps=1;
			for(int i=1;i<snpids.length;i++) {
				snpids[i]=null;
			}
		} else {
			boolean newSnp=true;
			int firstFree=-1;
			for(int i=0;i<snpids.length;i++) {
				if(snpids[i]==null && firstFree==-1) {
					firstFree=i;
				} else if (snpids[i]!=null) {
					if(snpids[i].getId()==snp_id) {
						newSnp=false;
						break;
					}
				}
			}
			if(newSnp) {
				if (firstFree ==-1 && nsnps>=snpids.length) {
					Snp[] tmp = new Snp[2*nsnps];
					int i =0;
					for(;i<snpids.length;i++) {
						tmp[i]=snpids[i];
					}
					for(;i<tmp.length;i++) {
						tmp[i]=null;
					}

					snpids=tmp;
				}
				if(firstFree==-1) {
					firstFree=nsnps;
				}
				snpids[firstFree]=s;
				nsnps++;
				this.weight = this.bin1.getNsnps()+this.bin2.getNsnps();
			}
		}
		return s;
	}
	/**
	 * @param snpids the snpids to set
	 */
	
	public void deleteSnp(int snp_id) {
		 if(snpids!=null) {
			 boolean foundSnp=false;
			 int i=0;
			 for(i=0;i<snpids.length;i++) {
				 if(snpids[i]!=null && snpids[i].getId()==snp_id) {foundSnp=true;break;}
			 }
			 if(foundSnp) {
				  for(;i<snpids.length-1;i++) {
					  snpids[i]=snpids[i+1];
				  }
				  nsnps--;
				  snpids[nsnps]=null;
			  }
		  }
	}
	/**
	 * Need to Call Bin's cacheMaxScore
	 * 
	 *
	 */
	public void cacheMaxScores(boolean tmpToo) throws Exception {
		// pass snps in this BinEdge as exclusion list for MaxScore Calculation by Bin
		
		Bin b = Bin.getBinById(this.binid1);
		b.cacheMaxScore(tmpToo);
		this.omaxscore1=b.getMaxScoreNotInList(this.snpids);
		b = Bin.getBinById(binid2);
		b.cacheMaxScore(tmpToo);
		this.omaxscore2=b.getMaxScoreNotInList(this.snpids);
		
	}
	
	public static void buildMaximums() throws Exception {

		  if(haveBinEdge!=null) {
			  Set<Map.Entry<String, BinEdge>> s = haveBinEdge.entrySet();
			  for (Map.Entry<String, BinEdge> me : s) {	  
				  BinEdge be = me.getValue();
				  be.cacheMaxScores(false); // Only consider real tag SNPs.
			  }
		  }
	  }
	  /** Pick Best SNP by Score **/
	 public void pickBestSnp()throws Exception {
		 double bestScore = -100000.0d;
		 double bestProb = -1.0d;
		 int bestid=-1;
		 for(int i=0;i<snpids.length;i++) {
			 Snp s = snpids[i];
			 if(s!=null && !(s.isSelected() || s.isExcluded())) {
				 double newProb = s.getSuccessProb();
				 if(newProb>bestProb ||
				    (newProb==bestProb && s.getScore()>bestScore)) {
					 bestScore = s.getScore();
					 bestProb = newProb;
					 bestid=i;
				 }
			 }
		  }
		 if(bestid!=-1) {
			 snpids[bestid].setSelected(true,true); // set to true.. and recursively pick bins too
		 }
	 }	

	/**
	 * @return the nbinedges
	 */
	public static int getNbinedges() {
		return nbinedges;
	}
	public void setWeight(int weight) {
		
		this.weight =weight;
	}
	
	public int getWeight() {
		return weight;		
	}
	/* THis code not right anymore. Weight is computed differently.
	public int computeWeight() {
		Bin b1 = Bin.getBinById(binid1);
		Bin b2 = Bin.getBinById(binid2);
		return  b1.getNbinedges() +b2.getNbinedges();		
	}

	public int computeValidWeight() {
		Bin b1 = Bin.getBinById(binid1);
		Bin b2 = Bin.getBinById(binid2);
		BinEdge[] be1 = b1.getBinedges();
		BinEdge[] be2 = b2.getBinedges();
		int nw=0;
		for(int i =0;i<be1.length;i++) {
			if(be1[i].getValidflag()==0) {nw++;}
		}
		for(int i =0;i<be2.length;i++) {
			if(be2[i].getValidflag()==0) {nw++;}
		}

		return nw;
	}
	*/
	
	/**
	 * Pick the SNP that touches the most populations, then the SNP with the best probability of success.
	 * @return true if could pick a SNP
	 */
	public int pickBestTouchSnp() {
		double bestFailProb=2;
		int maxpop=-1;
		int bestid=-1;
		int navail=0;
		int bestLoc =-1000;
		double bestScore=-100000.0d;
		if(snpids!=null) {
			for(int i=0;i<snpids.length;i++) {
				Snp s = snpids[i];
				try {
					if(s!=null && (!(s.isSelected() || s.isTmpSelected() || s.isExcluded() || s.isFixed())) && s.canISelect(true)) {
						navail++;
						if(SNPPicker.verbose) {
							System.out.println("SNP "+s.getSnpName()+",failProb="+s.getFailProb()+",locclass ="+s.getLocation_class()+",score="+s.getScore());
						}
						if((s.getNbins()>maxpop)
								|| (s.getNbins()==maxpop && s.getFailProb()<bestFailProb )
								|| (s.getNbins()==maxpop && s.getFailProb()==bestFailProb && s.getLocation_class()>bestLoc)
								|| (s.getNbins()==maxpop && s.getFailProb()==bestFailProb && s.getLocation_class()==bestLoc && s.getScore()>bestScore)
						        ) {
							if(SNPPicker.verbose) {
								System.out.println("SNP "+s.getSnpName()+" was best");
							}
							bestFailProb=s.getFailProb();
							bestLoc = s.getLocation_class();
							maxpop = s.getNbins();
							bestScore = s.getScore();
							bestid=i;
						}
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if(navail==0) {
				// XXX Many legitimate reasons why this could happen.. but we should try to filter out BE's without any more tagSNPs to pick.
				return -1;
			} else {
				Snp s = snpids[bestid];
				s.setTmpSelected(true, true); // Set SNP to Temporarely Selected and Bin Too.
				return bestid;
			}
		} else {
			return -1;
		}
	}

	
	/**
	 * Pick the SNP that touches the most populations, then the SNP with the best probability of success.
	 * @return true if could pick a SNP
	 */
	public Snp getMostReliableAvailableSnp() {
		int maxpop=0;
		Snp bestSnp=null;
		int navail=0;
		double maxScore=Double.POSITIVE_INFINITY;
		double maxProb = 0.0d;
		if(snpids!=null) {
			for(int i=0;i<snpids.length;i++) {
				Snp s = snpids[i];
				try {
					if(s!=null && (!s.isTmpSelected()) && (!s.isExcluded()) && s.canISelect(false)) {
						navail++;
						if(s.getSuccessProb()>maxProb
								|| (s.getSuccessProb()==maxProb && s.getScore()>maxScore)
								|| (s.getSuccessProb()==maxProb && s.getScore()==maxScore && s.getNPop()>maxpop)) {
							maxpop = s.getNPop();
							maxScore = s.getScore();
							maxProb = s.getSuccessProb();
							bestSnp=s;
						}
					}
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		return bestSnp;
	}
	
	public boolean isReal() {
		return isReal;
	}
	public static void computeIsReal() {
		Set<Map.Entry<String,BinEdge>> bes = haveBinEdge.entrySet();
		for(Iterator<Map.Entry<String,BinEdge>> it = bes.iterator();it.hasNext();) {
			Map.Entry<String,BinEdge> e= it.next();
			BinEdge b = e.getValue();
			if(b !=null) {
				b.setIsReal();
			}
		}	
	}

	/*
	 * true if the bin edge has a snp that contains both bins
	 */
	public void setIsReal() {
		isReal=false;
		boolean gotbin1=false;
		boolean gotbin2=false;
		if(snpids!=null) {
			for(int i=0;i<snpids.length;i++) {
				Snp s = snpids[i];
				if(s!=null) {
					int[] bs =s.getBins();
					if(bs!=null) {
						for(int j=0;j<bs.length && !(gotbin1 || gotbin2);j++) {
							if(bs[j]==this.binid1) {
									gotbin1=true;
							} else if (bs[j]==this.binid2) {
									gotbin2=true;
							}
						}
					}
				}
			}
		}
		if(gotbin1 && gotbin2) {
			isReal=true;
		}
	}
	

/**
 * 
 * Function to count SNPs that need to be chosen for bins in an edge
 *    and returns the list of SNPs that can be chosen amongst
 *    To be choosable  
 *    		it must be unselected (or not even tmpSelected if tmpToo==true)
 *    		it must be in both bins
 *    		at least one of the bins must not be "full" according to the rules.
 *    @returns an int[]. First entry is the number of (shared) SNPs to choose from(nChoose), 2nd is number of SNPs that are needed among those common tag SNPs, the next nChoose entries are the list of snpids 
 */

public int[] getSnpIdsToChoose(boolean tmpToo) {
	
	int[] list2Choose=null;
	

	Bin b1 = Bin.getBinById(this.binid1);
	Bin b2 = Bin.getBinById(this.binid2);
	int besnps = (snpids==null ? 0: snpids.length);
	// only set Status based on permanently selected SNPs
	
//	int b1status=0;
//	int b2status=0;

	int nToChoose1=b1.getNRemainingToChoose(tmpToo);
	if(nToChoose1==0) {
//		b1status=1;
	}
	int nToChoose2=b2.getNRemainingToChoose(tmpToo);
	if(nToChoose2==0) {
//		b2status=1;
	}
	

	int nToChoose=0;
	int nTotalToChoose=nToChoose1+nToChoose2;
	// Look at common SNPs.
	if(snpids!=null) { // no SNP in this bin-Edge, so there should be no common tag SNPs.
		int[] ssids1 = b1.getAvailableSnpIds(tmpToo);
		int[] ssids2 = b2.getAvailableSnpIds(tmpToo);
		if(ssids1 !=null && ssids2!=null && ssids1.length>0 && ssids2.length>0) {
			int max2Choose = Math.max(nToChoose1, nToChoose2);// Maximum Shared SNPs to choose
			list2Choose=new int[2+Math.min(ssids1.length ,ssids2.length)];
			for(int i=0;i<=ssids1.length;i++) {
				for(int j=0;j<=ssids2.length;j++) {
					if(ssids1[i]==ssids2[j]) {
						list2Choose[3+nToChoose]=ssids1[i]; // Only care about SNPs in two bins.
						nToChoose++;
					}
				}
			}
			list2Choose[0]=nToChoose; // Number of SNPs to choose From
			nTotalToChoose -=nToChoose; // eliminate double counting.
			if(nToChoose>max2Choose) {
				nToChoose=max2Choose; 
			}
			list2Choose[1]=nToChoose; // Number of SNPs to choose
			list2Choose[2]=nTotalToChoose; // Number of SNPs that can be chosen in both bins.
			
			if(nToChoose>0) {
				boolean valid=false;
				for(int j=0;j<besnps;j++) {
					Snp s = this.snpids[j];
					if(s!=null && !( ((!tmpToo ) && s.isSelected()) || s.isExcluded() || (tmpToo && s.isTmpSelected()) )) {
						valid=true;
						break;// at least 1 SNP available
					}
				}
				// we check the tmp-dependent status of bins here..

				if(valid) {// at least 1 SNP available
					//Both bins still need more SNPs.(and have more SNPS left to pick).. with tmpToo taken into account.
//					this.setValidflag(0);// available.
				} else {
//					this.setValidflag(1);// 1- fully chosen / unavailable.	
					nToChoose=0;
				}
			}
		}
	}
	if(list2Choose==null) { // no SNPs in common between two bins.
		list2Choose = new int[3];
		list2Choose[0]=0;
		list2Choose[1]=0;
		list2Choose[2]=nTotalToChoose;
		
	}
	return list2Choose;
}

/*
 * Routine to find the absolute minimum number of tag SNPs that can be chosen
 * to satisfy the minimal number of tag SNP requirements of two bins.
 * 
 * @param toChoose array obtained by calling be.getSnpIdsToChoose(false), if null then will be filled by this routine.

// Have to pick all those tag SNPs because there is no choice to make.
// ... unless there is a probability cutoff on one
//  of the bins tied to this bin edge.. and
//  the compound probability of the k-1 top prob SNPs are above
//  the cutoff
public int computeMinNumberOfSnpsLeftToChooseFrom(int[] toChoose,boolean tmpToo) {
	if(toChoose==null) {
		toChoose=this.getSnpIdsToChoose(false);
	}
	int nToChooseFrom = toChoose[0]; // Number of tag SNPs to choose from in overlap region
	int nToChoose = toChoose[1];// Max number of Tag SNPs to choose in overlap region
	int nToChooseBetween2Bins = toChoose[2];

	int nToChoose1=Bin.getBinById(this.getBinid1()).getNRemainingToChoose(tmpToo);
	int nToChoose2=Bin.getBinById(this.getBinid2()).getNRemainingToChoose(tmpToo);
	// XXX The next two functions don't actually exist ..yet
	int nMinToChoose1=Bin.getBinById(this.getBinid1()).getNMinRemainingToChoose(tmpToo);
	int nMinToChoose2=Bin.getBinById(this.getBinid2()).getNMinRemainingToChoose(tmpToo);

	if(SNPPicker.minMAF>=1.0) {
		return nToChooseMin1+nToChooseMin2;
	} else {
		Choices are
			1- Minimal number in each bin separately
			2 - Some shared SNPs
		XXX This becomes complicated.
	
}
*/



} // end of BinEdgeclass
