parseVCF <- function( VCF.filename, genome.ver = "hg19", 
                      sel.info.attr = c("QD","ReadPosRankSum","DP","FS","MQ"),
                      with.fliter = TRUE)
{
  
  tmp.vcf <- suppressWarnings(readVcf(file=VCF.filename,genome=genome.ver))
  
  info.res <- as.data.frame(info(tmp.vcf))
  
  check.flag <- is.element(sel.info.attr,colnames(info.res))
  if(!all(check.flag))
  {
    stop(paste("the following attribute(s) not available in provided VCF: \n",
               sel.info.attr[which(check.flag==FALSE)])
         )
  }
  
    
  N.attri <- length(sel.info.attr)
  N.var <- nrow(info.res)
  attri.mtx <- mat.or.vec(N.var,N.attri)
  colnames(attri.mtx) <- sel.info.attr
  rownames(attri.mtx) <- rownames(info.res)
  for(k in 1:N.attri)
  {
    attri.mtx[,k] <- as.numeric(info.res[[sel.info.attr[k]]])
  }
  
  ret.res <- list()
  ret.res$attri.mtx <- attri.mtx
  
  if(with.fliter) # with VQSR results, usually for comparison purpose
  {
    ret.res$filt.vec <- filt(tmp.vcf)
    ret.res$VQSR.score <- info.res[["VQSLOD"]]
  }
  
  ret.res$GT.vec <- geno(tmp.vcf)$GT
  ret.res$pos.vec <- paste(rowData(tmp.vcf)@seqnames, start(rowData(tmp.vcf)@ranges),sep=":")

  return(ret.res)
}
