#!/usr/bin/perl
### Use Gene2Splices.txt file to create bed file for all annot exons
use strict;
use warnings;

my %cnt;
my $list='';

open (DAT, $ARGV[0]);
## /data1/bsi/refdata/bictools/annotation/UCSC/ucsc_refflat_2010-08-02.txt
while (my $l = <DAT>) {
    chomp $l;
    my @a = split('\s+', $l);
    my @starts = split(',', $a[9]);
    my @stops = split(',', $a[10]);

    for (my $i=0; $i<$a[8]; $i++) {
	my $str = "$a[2]_$starts[$i]_$stops[$i]";
	if ($list !~ / $str /) {
	    $list .= " $str ";
	    if (!defined $cnt{$a[0]}) {$cnt{$a[0]} = 1;}
	    else {$cnt{$a[0]}++;}
	    print "$a[2]\t$starts[$i]\t$stops[$i]\t$a[0],$cnt{$a[0]},$a[1]\n";
	}
    }
}
close DAT;

exit;

=head
open (DAT, $ARGV[0]);
## /data1/bsi/refdata/UCSC/hg18.refSeqGenes.table
my $l = <DAT>; ## Header
while ($l = <DAT>) {
    chomp $l;
    my @a = split('\s+', $l);
    my @starts = split(',', $a[9]);
    my @stops = split(',', $a[10]);

    for (my $i=0; $i<$a[8]; $i++) {
	my $str = "$a[2]_$starts[$i]_$stops[$i]";
	if ($list !~ / $str /) {
	    $list .= " $str ";
	    if (!defined $cnt{$a[12]}) {$cnt{$a[12]} = 1;}
	    else {$cnt{$a[12]}++;}
	    print "$a[2]\t$starts[$i]\t$stops[$i]\t$a[12],$cnt{$a[12]},$a[1]\n";
	}
    }
}
close DAT;

exit;
=cut
