fitRVmodel <- function( input.mtx, DB.filename, DB.ID="rsid", pos.vec=NULL,
                        model.type="adaboost", ada.n=5e3)
{
  
  model.type <- tolower(model.type)
  
  provided.model.type.vec <- 
    c("glm.bino","glm.gaus","gam.bino","gam.gaus","adaboost","huberized","bernoulli")
  
  if(!is.element(model.type, provided.model.type.vec))  {
    stop("Input model type is not supported! \n")
  }
  
 
  tmp.read <- unlist(read.delim(gzfile(DB.filename),header=FALSE,colClasses="character"))
if(DB.ID=="rsid")	{
  train.label <- as.numeric(is.element(rownames(input.mtx),tmp.read))	}
if(DB.ID=="pos" & !is.null(pos.vec)) {
	train.label <- as.numeric(is.element(pos.vec,tmp.read))  }	

  cat("\n distribution of variants in given SNP database (1 = in, 0 = not in) \n")
  print(table(train.label))
 
  
  if (model.type=="glm.bino")  { RV.res <- glm(train.label~input.mtx,family=binomial) }
  if (model.type=="glm.gaus")  { RV.res <- glm(train.label~input.mtx,family=gaussian) }
  if (model.type=="gam.bino")  { RV.res <- gam(train.label~input.mtx,family=binomial) }
  if (model.type=="gam.gaus")  { RV.res <- gam(train.label~input.mtx,family=gaussian) }
  
  if (model.type=="adaboost" | model.type=="huberized" | model.type=="bernoulli"){  
    RV.res <- gbm.fit(x=input.mtx,y=train.label,n.trees=ada.n,interaction.depth=2,
                 distribution=model.type,verbose=FALSE) 

    RV.res$fitted.values <-  plogis(RV.res$fit) 
	# convert it to the 0-1 scale since the adaboost method gives the predictions on logit scale. 
 	# http://stats.stackexchange.com/questions/37497/how-to-use-r-gbm-with-distribution-adaboost
  }
  
  
  RV.res$ID <- rownames(input.mtx)
  RV.res$train.label <- train.label
  
  return(RV.res)
  
}
