#!/usr/bin/perl

# This script will convert a UCSC reflat file into a bed file of exon positions
# Saurabh Baheti baheti.saurabh@mayo.edu

use strict;
use warnings;


if(scalar(@ARGV) != 1){
	print "USAGE: convert_reflat_to_bed.pl <input reflat file> \n";
}else{
	my $input = $ARGV[0];
	#my $output = $ARGV[1];
	my $gene_col = 0;
	my $chr_col = 2;
	my $strand_col = 3;
	my $exons_start_col = 9;
	my $exons_stop_col = 10;

	open IN, "<$input" or die "opening $input\n";
	#open OUT, ">$output" or die "opening $output\n";
	
	
	while(<IN>){
		my $row = $_;
		chomp $row;
		# skip header if present
		next if($row =~ "^#");
		my @line = split("\t",$row);
		my $gene = $line[$gene_col];
		my $chrom = $line[$chr_col];
		my $strand = $line[$strand_col];
		my @exons_start = split(",",$line[$exons_start_col]);
		my @exons_stop = split(",",$line[$exons_stop_col]);
		for(my $i = 0; $i < scalar(@exons_start); $i++){
			print $chrom."\t".$exons_start[$i]."\t".$exons_stop[$i]."\t".$gene."\t".$strand."\n";
		}	
	}
	
	close IN;
	#close OUT;

	
}


