RVdisplay <- 
  function( VCFfilename, outputFilename, sel.X.attri, sel.Y.attri, 
            all.color="black", train.color="red", all.pch=1, train.pch=2,
            given.xlim=NULL, given.ylim=NULL,
            density.lwd=2, point.cex=1.2, point.lwd=1.5, lab.cex=1.5,
            legend.position="topright") {
  
  require(VariantAnnotation)
  tmp.VCFname <- VCFfilename  
  tmp.VCFres <- readVcf(file=tmp.VCFname,genome="hg19")
  train.label <- as.numeric(info(tmp.VCFres)[,"TRAIN"])
  
  nanvec <- (!is.na(  info(tmp.VCFres)[,sel.X.attri]  )) &
    (!is.na(  info(tmp.VCFres)[,sel.X.attri]  ))  
  png(outputFilename,units="in", width=11, height=8.5, res=300)
  nan.idx <- which(nanvec)
  N.nan.var <- length(nan.idx)
  x <- as.vector(info(tmp.VCFres)[nan.idx,sel.X.attri])
  y <- as.vector(info(tmp.VCFres)[nan.idx,sel.Y.attri])
  
  #length(train.label)
  #length(nan.idx)
  
  trainSet.idx <- which(train.label[nan.idx]==1)
  color.vec <- rep(all.color,N.nan.var)
  color.vec[trainSet.idx] <- train.color
  
  pch.vec <- rep(all.pch,N.nan.var)
  pch.vec[trainSet.idx] <- train.pch
  
  
  zones <- matrix(c(2,0,1,3), ncol=2, byrow=TRUE)
  layout(zones, widths=c(4/5,1/5), heights=c(1/5,4/5))
  add.label.mar <- 1.5
  add.density.mar <- 1.2
  
  par(mar=c(3+add.label.mar,3+add.label.mar,
            1+add.density.mar,1+add.density.mar))
  plot(x,y,xlab=sel.X.attri,ylab=sel.Y.attri,
       xlim=given.xlim, ylim=given.ylim, 
       type="p",cex=point.cex,cex.lab=lab.cex,
       pch=pch.vec,col=color.vec,lwd=point.lwd)
  legend(legend.position, c("remaining variants","train variants"),
         pt.lwd=point.lwd,
         pch=c(all.pch,train.pch),
         col=c(all.color,train.color),cex=lab.cex)
  
  xlimvec <- par("xaxp")[1:2]
  ylimvec <- par("yaxp")[1:2]
  
  x.density <- density(x)
  train.x.density <- density(x[trainSet.idx])
  max.Xden.lim <- max(c(x.density$y,train.x.density$y))
  
  par(mar=c(0,3+add.label.mar,1,1+add.density.mar))
  plot( x.density$x, x.density$y, main="",xlab="",ylab="",
        xlim=xlimvec,ylim=c(0,max.Xden.lim), 
        type="l", col=all.color, lwd=density.lwd)
  lines( train.x.density$x, train.x.density$y,main="",xlab="",
         ylab="",
         col=train.color,lwd=density.lwd)
  
  
  #=== y attribute
  
  y.density <- density(y)
  train.y.density <- density(y[trainSet.idx])
  max.Yden.lim <- max(c(y.density$y,train.y.density$y))
  
  #=== to this point
  par(mar=c(3+add.label.mar,0,1+add.density.mar,1))
  plot( y.density$y, y.density$x, main="",xlab="",ylab="",
        ylim=ylimvec,xlim=c(0,max.Yden.lim), 
        type="l",col=all.color,lwd=density.lwd)
  lines( train.y.density$y, train.y.density$x, main="",xlab="",ylab="",
         col=train.color,lwd=density.lwd)
  dev.off()
  
}
