
stdin <- commandArgs(TRUE) 

if(length(stdin) != 4){
  	stop("ERROR! Incorrect number of arguments. \nUSAGE: display.R [input VCF file] [library paths] [path to the script] [output file]")
}


inputVCF <- stdin[1]
library <- stdin[2]
scriptPath <- stdin[3]
outputFile <- stdin[4]
script<-paste(scriptPath,"funcs/RVdisplay.R",sep="/")
source(script)
### setting R library
.libPaths(library)
require(VariantAnnotation)
require(gbm)
require(mgcv)
	
#RVdisplay(VCFfilename=inputVCF,sel.X.attri="ReadPosRankSum",sel.Y.attri="QD")
RVdisplay(VCFfilename=inputVCF,outputFilename=outputFile,sel.X.attri="ReadPosRankSum",sel.Y.attri="QD",
             given.xlim=c(-5,5),legend.position="bottomleft", density.lwd=3)

