#!/bin/bash

#
#   Arguments check and usage information
#   Saurabh Baheti baheti.saurabh@mayo.edu
#   Mar 16 2014

usage()
{
cat << EOF
######
##      RVboost v0.1 installation script
##      Script Options:
##      -r	-		<refernce genome>	(REQUIRED) full/path/to/reference genome FASTA file used to align the reads to get the BAM file
##      -h	-		Display this usage/help text (No arg)
##
#################################################################################################################
##
## Authors:             Saurabh Baheti
## Creation Date:       May 14 2014
## Last Modified:       May 14 2014
##
## For questions, comments, or concerns, contact Saurabh (baheti.saurabh@mayo.edu)
##
#################################################################################################################
EOF
}

while getopts "r:h" OPTION; do
  case $OPTION in
        h) usage
        exit ;;
        r) ref_genome=$OPTARG ;;
   \?) echo "Invalid option: -$OPTARG. See output file for usage." >&2
       usage
       exit ;;
    :) echo "Option -$OPTARG requires an argument. See output file for usage." >&2
       usage
       exit ;;
  esac
done

if [[ -z "$ref_genome"  && ! -s "$ref_genome" ]]
then
        echo "Must provide at least required options. See output file for usage." >&2
        usage
        exit 1;
fi



#if [ $# != 1 ]; then echo -e "\ndescription: set up script to install all the required tools and resource to run the pipeline. \n\nusage:./setup.sh <ref genome fasta file used for aligning BAM file>"; exit 1; fi


INSTALL_DIR=$(pwd)
BIN_DIR=$INSTALL_DIR/bin

echo -e "=========================================="
echo -e "RVboost PIPELIE (v0.1) installation script"
echo -e "=========================================="

SAMTOOLS="$BIN_DIR/samtools"
echo -e "Checking samtools directory...\n"
[ -d "$SAMTOOLS" ] || { echo -e "Error: directory '$SAMTOOLS' does not exist!" ; exit 1 ; }
echo -e "ok"

BEDTOOLS="$BIN_DIR/bedtools"
echo -e "Checking bedtools directory...\n"
[ -d "$BEDTOOLS" ] || { echo -e "Error: directory '$BEDTOOLS' does not exist!" ; exit 1 ; }
echo -e "ok"


BLAT="$BIN_DIR/blatSrc"
echo -e "Checking blat directory...\n"
[ -d "$BLAT" ] || { echo -e "Error: directory '$BLAT' does not exist!" ; exit 1 ; }
echo -e "ok"


SCRIPTS="$INSTALL_DIR/src"
echo -e "Checking RVboost wrapper script directory...\n"
[ -d "$SCRIPTS" ] || { echo -e "Error: directory '$SCRIPTS' does not exist!" ; exit 1 ; }
echo -e "ok"

RESOURCES="$INSTALL_DIR/resources"
echo -e "Checking RVboost resources  directory...\n"
[ -d "$RESOURCES" ] || { echo -e "Error: directory '$RESOURCES' does not exist!" ; exit 1 ; }
echo -e "ok"

Rlibs="$INSTALL_DIR/Rlibs"
echo -e "Checking RVboost Rlibs  directory...\n"
[ -d "$Rlibs" ] || { echo -e "Error: directory '$Rlibs' does not exist!" ; exit 1 ; }
echo -e "ok"

#
# check for required executables
#

#### check for gcc complier
echo -e "Checking executables .....\n"
gcc=`gcc --version 2>&1`
if [[ ! `echo $gcc | grep gcc` ]]; then echo -e "no gcc compiler installed. Please install a gcc compiler "; exit 1;
else ver=`echo $gcc | awk '{print $3}'`;echo -e "gcc version: $ver                                      already installed, nothing to do ...\n";fi
echo -e "ok"
#### check and add Perl to env variable
perl=`which perl`
pp=`perl --version`
if [[ ! `echo $pp | grep Perl`  ]];then echo -e "No perl found, please install perl before using the tool ";exit 1;
else ver=`echo $pp | awk -F ',' '{print $2}'`;echo -e "perl version: $ver                                      already installed, nothing to do ...\n";fi
echo -e "ok"
java=`which java`
jj=`java -version 2>&1 | head -n 1 | awk -F '"' '{print $2}' | awk -F'.' 'BEGIN {OFS="."} {print $1,$2} '`
if [[ $(echo "$jj == 1.7" | bc) -ne 0 ]]; then echo -e "correct version of JAVA is installed";
else echo -e "1.7 version of JAVA is required to run the pipeline ....";exit 1; fi

if [[ ! $jj ]];then echo -e "No JAVA found, please install java before using the tool";exit 1;
else ver=` java -version 2>&1 | head -n 1| awk '{print $3}'`;echo -e "java version: $ver                                      already installed, nothing to do ...\n";fi
echo -e "ok"
r_exe=`which R`
rr_version=`R --version 2>&1`
rr=`R --version 2>&1 |head -n 1 | awk '{print $3}' | awk -F'.' '{print $1}'`
if [[ $(echo "$rr == 3" | bc) -ne 0 ]]; then echo -e "correct version of R is installed";
else echo -e "version 3 or greater of R is required to run the pipeline ....";exit 1; fi
if [[ ! `echo $rr_version | grep 'R version'` ]];then echo -e "No R found, please install R before using the tool";exit 1;
else ver=`echo $rr_version | awk '{print $3}'`;echo -e "R version: $ver                                      already installed, nothing to do ...\n";fi
echo -e "ok"
r_exe=${r_exe%*/*}


#
# Compile each package
#

echo -e "Installing samtools...\n"
cd "$BIN_DIR/samtools"
`make --quiet > $BIN_DIR/samtools/log.txt 2>&1`
cd "$INSTALL_DIR"
echo -e "ok"

echo -e "Installing bedtools...\n"
cd "$BIN_DIR/bedtools"
bed=`make --quiet > $BIN_DIR/bedtools/log.txt 2>&1`
cd "$INSTALL_DIR"
echo -e "ok"
#rm log.txt

echo -e "Installing BLAT...\n"
#if [ ! -d "$HOME/bin/$MACHTYPE" ] ; then
#mkdir -p "$HOME/bin/$MACHTYPE"
#fi
#if [ ! -d "$BLAT/lib/$MACHTYPE" ] ; then
#mkdir -p "$BLAT/lib/$MACHTYPE"
#fi
#cd "$BLAT"
#make "MACHTYPE=$MACHTYPE" --quiet
if [ "$(uname)" == "Darwin" ]; then
    blat=$BIN_DIR/blatSrc/macOSX.i386/
	# Do something under Mac OS X platform        
elif [[ "$(expr substr $(uname -s) 1 5)" == "Linux"  || "$(uname)" == "Linux" ]]; then
	blat=$BIN_DIR/blatSrc/linux.x86_64/
    # Do something under Linux platform
fi
echo -e "ok"

echo -e "Installing R packages ....\n"
cd $Rlibs
echo -e ".libPaths(\"$Rlibs\")" > $Rlibs/Install.R
echo -e "source(\"http://bioconductor.org/biocLite.R\")" >> $Rlibs/Install.R
echo -e "biocLite(\"VariantAnnotation\")" >> $Rlibs/Install.R
echo -e "install.packages(\"gbm_2.1.tar.gz\",repos = NULL, type=\"source\",quiet = TRUE)" >> $Rlibs/Install.R
echo -e "install.packages(\"mgcv_1.7-28.tar.gz\",repos = NULL, type=\"source\",quiet = TRUE) " >> $Rlibs/Install.R

$r_exe/Rscript $Rlibs/Install.R > $Rlibs/log.txt 2>&1
if [ $? -ne 0 ]
then
	echo -e "R pakages failed to install ..."
	exit 1;
fi
	
cd ..

#clear

#### resources
echo -e "creating the index for the reference genome ....\n"
cp $ref_genome $RESOURCES/reference.fa
ref=$RESOURCES/reference.fa
$SAMTOOLS/samtools faidx $RESOURCES/reference.fa
echo -e "ok"

### get java,R,perl path
echo -e "creating the reference files from refflat file for exons bed file ....\n"
$perl $SCRIPTS/createExonBed.pl $RESOURCES/refFlat.txt | $BEDTOOLS/bin/sortBed -i stdin> $RESOURCES/exons.bed
echo -e "ok"

echo -e "creating the reference files from refflat file for coding bed file ....\n"
$perl $SCRIPTS/convert_reflat_to_bed.pl $RESOURCES/refFlat.txt | $BEDTOOLS/bin/sortBed -i stdin | $BEDTOOLS/bin/mergeBed -i stdin > $RESOURCES/coding.bed
echo -e "ok"
#blat=$HOME/bin/$MACHTYPE
echo -e "creating the config file to run your sample ....\n"
config=$INSTALL_DIR/src/config.txt
config=$( cat $config | tr "\n" "||")
config=${config//@INSTALL_DIR@/$INSTALL_DIR}
config=${config//@JAVA@/$java}
config=${config//@PERL@/$perl}
config=${config//@R_EXE@/$r_exe}
config=${config//@REF_GENEOME@/$ref}
config=${config//@BLAT@/$blat}

echo $config | tr "||" "\n" > $INSTALL_DIR/config.txt
echo -e "ok"

clear

echo -e "RVboost succesfully is installed\n"
echo -e "The installation directory is $INSTALL_DIR\n"
echo -e "Add this path to your shell script environment file. (e.g, export RVboost=$INSTALL_DIR for bash) \n"






