/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class VariantsToTable
extends RodWalker<Integer, Integer> {
    @Input(fullName="variant", shortName="V", doc="Input VCF file", required=true)
    public List<RodBinding<VariantContext>> variants;
    @Output(doc="File to which results should be written", required=true)
    protected PrintStream out;
    @Argument(fullName="fields", shortName="F", doc="The name of each field to capture for output in the table", required=true)
    public List<String> fieldsToTake = new ArrayList<String>();
    @Advanced
    @Argument(fullName="showFiltered", shortName="raw", doc="If provided, field values from filtered records will be included in the output", required=false)
    public boolean showFiltered = false;
    @Advanced
    @Argument(fullName="maxRecords", shortName="M", doc="If provided, we will emit at most maxRecord records to the table", required=false)
    public int MAX_RECORDS = -1;
    int nRecords = 0;
    @Argument(fullName="splitMultiAllelic", shortName="SMA", doc="If provided, we will split multi-allelic records into multiple lines of output", required=false)
    public boolean splitMultiAllelic = false;
    @Advanced
    @Argument(fullName="allowMissingData", shortName="AMD", doc="If provided, we will not require every record to contain every field", required=false)
    public boolean ALLOW_MISSING_DATA = false;
    private static final String MISSING_DATA = "NA";
    public static Map<String, Getter> getters = new HashMap<String, Getter>();

    @Override
    public void initialize() {
        this.out.println(Utils.join((String)"\t", this.fieldsToTake));
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        for (VariantContext vc : tracker.getValues(this.variants, context.getLocation())) {
            if (!this.showFiltered && !vc.isNotFiltered()) continue;
            for (List<String> record : VariantsToTable.extractFields(vc, this.fieldsToTake, this.ALLOW_MISSING_DATA, this.splitMultiAllelic)) {
                this.out.println(Utils.join((String)"\t", record));
            }
        }
        return 1;
    }

    @Override
    public boolean isDone() {
        boolean done;
        boolean bl = done = this.MAX_RECORDS != -1 && this.nRecords >= this.MAX_RECORDS;
        if (done) {
            logger.warn((Object)("isDone() will return true to leave after " + this.nRecords + " records"));
        }
        return done;
    }

    private static final boolean isWildCard(String s) {
        return s.endsWith("*");
    }

    private static List<List<String>> extractFields(VariantContext vc, List<String> fields, boolean allowMissingData, boolean splitMultiAllelic) {
        int numRecordsToProduce = splitMultiAllelic ? vc.getAlternateAlleles().size() : 1;
        ArrayList<List<String>> records = new ArrayList<List<String>>(numRecordsToProduce);
        for (int i = 0; i < numRecordsToProduce; ++i) {
            records.add(new ArrayList(fields.size()));
        }
        for (String field : fields) {
            if (splitMultiAllelic && field.equals("ALT")) {
                VariantsToTable.addFieldValue(VariantsToTable.splitAltAlleles(vc), records);
                continue;
            }
            if (getters.containsKey(field)) {
                VariantsToTable.addFieldValue(getters.get(field).get(vc), records);
                continue;
            }
            if (vc.hasAttribute(field)) {
                VariantsToTable.addFieldValue(vc.getAttribute(field, null), records);
                continue;
            }
            if (VariantsToTable.isWildCard(field)) {
                HashSet<String> wildVals = new HashSet<String>();
                for (Map.Entry elt : vc.getAttributes().entrySet()) {
                    if (!((String)elt.getKey()).startsWith(field.substring(0, field.length() - 1))) continue;
                    wildVals.add(elt.getValue().toString());
                }
                String val = MISSING_DATA;
                if (wildVals.size() > 0) {
                    ArrayList toVal = new ArrayList(wildVals);
                    Collections.sort(toVal);
                    val = Utils.join((String)",", toVal);
                }
                VariantsToTable.addFieldValue(val, records);
                continue;
            }
            if (!allowMissingData) {
                throw new UserException(String.format("Missing field %s in vc %s at %s", field, vc.getSource(), vc));
            }
            VariantsToTable.addFieldValue(MISSING_DATA, records);
        }
        return records;
    }

    private static void addFieldValue(Object val, List<List<String>> result) {
        int numResultRecords = result.size();
        if (numResultRecords == 1) {
            result.get(0).add(val.toString());
        } else if (val instanceof List && ((List)val).size() == numResultRecords) {
            List list = (List)val;
            for (int i = 0; i < numResultRecords; ++i) {
                result.get(i).add(list.get(i).toString());
            }
        } else {
            String valStr = val.toString();
            for (List<String> record : result) {
                record.add(valStr);
            }
        }
    }

    public static List<List<String>> extractFields(VariantContext vc, List<String> fields, boolean allowMissingData) {
        return VariantsToTable.extractFields(vc, fields, allowMissingData, false);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
    }

    private static String getAlleleDisplayString(VariantContext vc, Allele allele) {
        StringBuilder sb = new StringBuilder();
        if (vc.hasReferenceBaseForIndel() && !vc.isSNP()) {
            sb.append((char)vc.getReferenceBaseForIndel().byteValue());
        }
        sb.append(allele.getDisplayString());
        return sb.toString();
    }

    private static Object splitAltAlleles(VariantContext vc) {
        int numAltAlleles = vc.getAlternateAlleles().size();
        if (numAltAlleles == 1) {
            return VariantsToTable.getAlleleDisplayString(vc, vc.getAlternateAllele(0));
        }
        ArrayList<String> alleles = new ArrayList<String>(numAltAlleles);
        for (Allele allele : vc.getAlternateAlleles()) {
            alleles.add(VariantsToTable.getAlleleDisplayString(vc, allele));
        }
        return alleles;
    }

    static {
        getters.put("CHROM", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getChr();
            }
        });
        getters.put("POS", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getStart());
            }
        });
        getters.put("REF", new Getter(){

            @Override
            public String get(VariantContext vc) {
                StringBuilder x = new StringBuilder();
                x.append(VariantsToTable.getAlleleDisplayString(vc, vc.getReference()));
                return x.toString();
            }
        });
        getters.put("ALT", new Getter(){

            @Override
            public String get(VariantContext vc) {
                StringBuilder x = new StringBuilder();
                int n = vc.getAlternateAlleles().size();
                if (n == 0) {
                    return ".";
                }
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        x.append(",");
                    }
                    x.append(VariantsToTable.getAlleleDisplayString(vc, vc.getAlternateAllele(i)));
                }
                return x.toString();
            }
        });
        getters.put("EVENTLENGTH", new Getter(){

            @Override
            public String get(VariantContext vc) {
                int maxLength = 0;
                for (Allele a : vc.getAlternateAlleles()) {
                    int length = a.length() - vc.getReference().length();
                    if (Math.abs(length) <= Math.abs(maxLength)) continue;
                    maxLength = length;
                }
                return Integer.toString(maxLength);
            }
        });
        getters.put("QUAL", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Double.toString(vc.getPhredScaledQual());
            }
        });
        getters.put("TRANSITION", new Getter(){

            @Override
            public String get(VariantContext vc) {
                if (vc.isSNP() && vc.isBiallelic()) {
                    return VariantContextUtils.isTransition((VariantContext)vc) ? "1" : "0";
                }
                return "-1";
            }
        });
        getters.put("FILTER", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.isNotFiltered() ? "PASS" : Utils.join((String)",", (Collection)vc.getFilters());
            }
        });
        getters.put("ID", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getID();
            }
        });
        getters.put("HET", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHetCount());
            }
        });
        getters.put("HOM-REF", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHomRefCount());
            }
        });
        getters.put("HOM-VAR", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHomVarCount());
            }
        });
        getters.put("NO-CALL", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNoCallCount());
            }
        });
        getters.put("TYPE", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getType().toString();
            }
        });
        getters.put("VAR", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHetCount() + vc.getHomVarCount());
            }
        });
        getters.put("NSAMPLES", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNSamples());
            }
        });
        getters.put("NCALLED", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNSamples() - vc.getNoCallCount());
            }
        });
        getters.put("MULTI-ALLELIC", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Boolean.toString(vc.getAlternateAlleles().size() > 1);
            }
        });
        getters.put("GQ", new Getter(){

            @Override
            public String get(VariantContext vc) {
                if (vc.getNSamples() > 1) {
                    throw new UserException("Cannot get GQ values for multi-sample VCF");
                }
                return String.format("%.2f", -10.0 * vc.getGenotype(0).getLog10PError());
            }
        });
    }

    public static abstract class Getter {
        public abstract String get(VariantContext var1);
    }
}

