/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.Arrays;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@Requires(value={DataSource.READS})
public class ReadClippingStatsWalker
extends ReadWalker<ReadClippingInfo, Integer> {
    @Output
    protected PrintStream out;
    @Argument(fullName="mappedOnly", shortName="mo", doc="when this flag is set (default), statistics will be collected on mapped reads only, while unmapped reads will be discarded", required=false)
    protected boolean MAPPED_ONLY = true;
    @Argument(fullName="skip", shortName="skip", doc="When provided, only every skip reads are analyzed", required=false)
    protected int SKIP = 1;

    @Override
    public ReadClippingInfo map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (AlignmentUtils.isReadUnmapped((SAMRecord)read) && this.MAPPED_ONLY) {
            return null;
        }
        ReadClippingInfo info = new ReadClippingInfo();
        info.rg = read.getReadGroup();
        if (info.rg == null) {
            throw new UserException.ReadMissingReadGroup((SAMRecord)read);
        }
        block5: for (CigarElement elt : read.getCigar().getCigarElements()) {
            if (elt.getOperator() == CigarOperator.N) continue;
            switch (elt.getOperator()) {
                case H: 
                case S: {
                    ++info.nClippingEvents;
                    info.nClippedBases += elt.getLength();
                }
                case M: 
                case D: 
                case P: 
                case I: {
                    info.readLength += elt.getLength();
                    continue block5;
                }
                case N: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Case statement didn't deal with cigar op: " + elt.getOperator());
        }
        return info;
    }

    @Override
    public Integer reduceInit() {
        this.out.println(Utils.join((String)" \t", Arrays.asList("ReadGroup", "ReadLength", "NClippingEvents", "NClippedBases", "PercentClipped")));
        return 0;
    }

    @Override
    public Integer reduce(ReadClippingInfo info, Integer sum) {
        if (info != null) {
            if (sum % this.SKIP == 0) {
                String id = info.rg.getReadGroupId();
                this.out.printf("%s\t %d\t %d\t %d\t %.2f%n", id, info.readLength, info.nClippingEvents, info.nClippedBases, 100.0 * MathUtils.ratio((int)info.nClippedBases, (int)info.readLength));
            }
            return sum + 1;
        }
        return sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
    }

    public class ReadClippingInfo {
        SAMReadGroupRecord rg;
        int readLength;
        int nClippingEvents;
        int nClippedBases;
    }
}

