/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reference.ReferenceDataSource;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.filters.Platform454Filter;
import org.broadinstitute.sting.gatk.filters.PlatformUnitFilter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.SeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrack;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.indels.VCFIndelAttributes;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.refseq.RefSeqCodec;
import org.broadinstitute.sting.utils.codecs.refseq.RefSeqFeature;
import org.broadinstitute.sting.utils.codecs.refseq.Transcript;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.collections.CircularArray;
import org.broadinstitute.sting.utils.collections.PrimitivePair;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;
import org.broadinstitute.sting.utils.interval.OverlappingIntervalIterator;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

@ReadFilters(value={Platform454Filter.class, MappingQualityZeroFilter.class, PlatformUnitFilter.class})
public class SomaticIndelDetectorWalker
extends ReadWalker<Integer, Integer> {
    @Output(doc="File to write variants (indels) in VCF format", required=true)
    protected VCFWriter vcf_writer = null;
    @Argument(fullName="outputFile", shortName="O", doc="output file name (BED format). DEPRECATED> Use --bed", required=true)
    @Deprecated
    File output_file;
    @Argument(fullName="metrics_file", shortName="metrics", doc="File to print callability metrics output", required=false)
    public PrintStream metricsWriter = null;
    @Hidden
    @Input(fullName="genotype_intervals", shortName="genotype", doc="Calls will be made at each position within the specified interval(s), whether there is an indel or not", required=false)
    public IntervalBinding<Feature> genotypeIntervalsFile = null;
    @Hidden
    @Argument(fullName="unpaired", shortName="unpaired", doc="Perform unpaired calls (no somatic status detection)", required=false)
    boolean call_unpaired = false;
    boolean call_somatic;
    @Argument(fullName="verboseOutput", shortName="verbose", doc="Verbose output file in text format", required=false)
    File verboseOutput = null;
    @Argument(fullName="bedOutput", shortName="bed", doc="Lightweight bed output file (only positions and events, no stats/annotations)", required=false)
    File bedOutput = null;
    @Deprecated
    @Argument(fullName="minCoverage", shortName="minCoverage", doc="indel calls will be made only at sites with tumor coverage of minCoverage or more reads; with --unpaired (single sample) option, this value is used for minimum sample coverage. INSTEAD USE: T_COV<cutoff (or COV<cutoff in unpaired mode) in -filter expression (see -filter).", required=false)
    int minCoverage = 6;
    @Deprecated
    @Argument(fullName="minNormalCoverage", shortName="minNormalCoverage", doc="used only in default (somatic) mode;  normal sample must have at least minNormalCoverage or more reads at the site to call germline/somatic indel, otherwise the indel (in tumor) is ignored. INSTEAD USE: N_COV<cutoff in -filter expression (see -filter).", required=false)
    int minNormalCoverage = 4;
    @Deprecated
    @Argument(fullName="minFraction", shortName="minFraction", doc="Minimum fraction of reads with CONSENSUS indel at a site, out of all reads covering the site, required for making a call (fraction of non-consensus indels at the site is not considered here, see minConsensusFraction). INSTEAD USE: T_INDEL_F<cutoff (or INDEL_F<cutoff in unpaired mode) in -filter expression (see -filter).", required=false)
    double minFraction = 0.3;
    @Deprecated
    @Argument(fullName="minConsensusFraction", shortName="minConsensusFraction", doc="Indel call is made only if fraction of CONSENSUS indel observations at a site wrt all indel observations at the site exceeds this threshold. INSTEAD USE: T_INDEL_CF<cutoff (or INDEL_CF<cutoff in unpaired mode) in -filter expression (see -filter).", required=false)
    double minConsensusFraction = 0.7;
    @Deprecated
    @Argument(fullName="minIndelCount", shortName="minCnt", doc="Minimum count of reads supporting consensus indel required for making the call.  This filter supercedes minFraction, i.e. indels with acceptable minFraction at low coverage (minIndelCount not met) will not pass. INSTEAD USE: T_CONS_CNT<cutoff (or CONS_CNT<cutoff in unpaired mode) in -filter expression (see -filter).", required=false)
    int minIndelCount = 0;
    @Argument(fullName="refseq", shortName="refseq", doc="Name of RefSeq transcript annotation file. If specified, indels will be annotated with GENOMIC/UTR/INTRON/CODING and with the gene name", required=false)
    String RefseqFileName = null;
    @Argument(shortName="filter", doc="One or more logical expressions. If any of the expressions is TRUE, putative indel will be discarded and nothing will be printed into the output (unless genotyping at the specific position is explicitly requested, see -genotype). Default: T_COV<6||N_COV<4||T_INDEL_F<0.3||T_INDEL_CF<0.7", required=false)
    public ArrayList<String> FILTER_EXPRESSIONS = new ArrayList();
    @Hidden
    @Argument(fullName="indel_debug", shortName="idebug", doc="Detailed printout for debugging, do not turn this on", required=false)
    Boolean DEBUG = false;
    @Argument(fullName="window_size", shortName="ws", doc="Size (bp) of the sliding window used for accumulating the coverage. May need to be increased to accomodate longer reads or longer deletions. A read can be fit into the window if its length on the reference (i.e. read length + length of deletion gap(s) if any) is smaller than the window size. Reads that do not fit will be ignored, so long deletions can not be called if window is too small", required=false)
    int WINDOW_SIZE = 200;
    @Argument(fullName="maxNumberOfReads", shortName="mnr", doc="Maximum number of reads to cache in the window; if number of reads exceeds this number, the window will be skipped and no calls will be made from it", required=false)
    int MAX_READ_NUMBER = 10000;
    private WindowContext tumor_context;
    private WindowContext normal_context;
    private int currentContigIndex = -1;
    private int contigLength = -1;
    private int currentPosition = -1;
    private String refName = null;
    private Writer output = null;
    private GenomeLoc location = null;
    private long normalCallsMade = 0L;
    private long tumorCallsMade = 0L;
    boolean outOfContigUserWarned = false;
    private LocationAwareSeekableRODIterator refseqIterator = null;
    private Set<String> normalSamples;
    private Set<String> tumorSamples;
    private int NQS_WIDTH = 5;
    private Writer bedWriter = null;
    private Writer verboseWriter = null;
    private static String annGenomic = "GENOMIC\t";
    private static String annIntron = "INTRON";
    private static String annUTR = "UTR";
    private static String annCoding = "CODING";
    private static String annUnknown = "UNKNOWN";
    private SAMRecord lastRead;
    private byte[] refBases;
    private ReferenceDataSource refData;
    private Iterator<GenomeLoc> genotypeIntervalIterator = null;
    private GenomeLoc currentGenotypeInterval = null;
    private long lastGenotypedPosition = -1L;
    private JexlEngine jexlEngine = new JexlEngine();
    private ArrayList<Expression> jexlExpressions = new ArrayList();
    private static final String[] normalMetricsCassette = new String[4];
    private static final String[] tumorMetricsCassette = new String[4];
    private static final String[] singleMetricsCassette = new String[4];
    private static final int C_COV = 0;
    private static final int C_CONS_CNT = 1;
    private static final int C_INDEL_F = 2;
    private static final int C_INDEL_CF = 3;

    private Set<VCFHeaderLine> getVCFHeaderInfo() {
        HashSet<VCFHeaderLine> headerInfo = new HashSet<VCFHeaderLine>();
        headerInfo.add(new VCFHeaderLine("source", "SomaticIndelDetector"));
        headerInfo.add(new VCFHeaderLine("reference", this.getToolkit().getArguments().referenceFile.getName()));
        headerInfo.addAll(VCFIndelAttributes.getAttributeHeaderLines());
        if (this.call_somatic) {
            headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine("SOMATIC", 0, VCFHeaderLineType.Flag, "Somatic event"));
        }
        HashSet<Object> args = new HashSet<Object>();
        args.add(this);
        args.addAll(this.getToolkit().getFilters());
        Map<String, String> commandLineArgs = this.getToolkit().getApproximateCommandLineArguments(args);
        for (Map.Entry<String, String> commandLineArg : commandLineArgs.entrySet()) {
            headerInfo.add(new VCFHeaderLine(String.format("SID_%s", commandLineArg.getKey()), commandLineArg.getValue()));
        }
        for (String fileName : this.getToolkit().getArguments().samFiles) {
            headerInfo.add(new VCFHeaderLine("SID_bam_file_used", fileName));
        }
        return headerInfo;
    }

    @Override
    public void initialize() {
        this.call_somatic = !this.call_unpaired;
        this.normal_context = new WindowContext(0, this.WINDOW_SIZE);
        this.normalSamples = new HashSet<String>();
        if (this.bedOutput != null && this.output_file != null) {
            throw new UserException.DeprecatedArgument("-O", "-O option is deprecated and -bed option replaces it; you can not use both at the same time");
        }
        if (this.RefseqFileName != null) {
            logger.info((Object)("Using RefSeq annotations from " + this.RefseqFileName));
            RMDTrackBuilder builder = new RMDTrackBuilder(this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary(), this.getToolkit().getGenomeLocParser(), this.getToolkit().getArguments().unsafe);
            RMDTrack refseq = builder.createInstanceOfTrack(RefSeqCodec.class, new File(this.RefseqFileName));
            this.refseqIterator = new SeekableRODIterator(refseq.getHeader(), refseq.getSequenceDictionary(), this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary(), this.getToolkit().getGenomeLocParser(), refseq.getIterator());
        }
        if (this.refseqIterator == null) {
            logger.info((Object)"No gene annotations available");
        }
        int nSams = this.getToolkit().getArguments().samFiles.size();
        if (this.call_somatic) {
            if (nSams < 2) {
                throw new UserException.BadInput("In default (paired sample) mode at least two bam files (normal and tumor) must be specified");
            }
            this.tumor_context = new WindowContext(0, this.WINDOW_SIZE);
            this.tumorSamples = new HashSet<String>();
        }
        int nNorm = 0;
        int nTum = 0;
        for (SAMReaderID rid : this.getToolkit().getReadsDataSource().getReaderIDs()) {
            Tags tags = rid.getTags();
            if (tags.getPositionalTags().isEmpty() && this.call_somatic) {
                throw new UserException.BadInput("In default (paired sample) mode all input bam files must be tagged as either 'normal' or 'tumor'. Untagged file: " + this.getToolkit().getSourceFileForReaderID(rid));
            }
            boolean normal = false;
            boolean tumor = false;
            for (String s : tags.getPositionalTags()) {
                if ("NORMAL".equals(s.toUpperCase())) {
                    normal = true;
                    ++nNorm;
                }
                if (!"TUMOR".equals(s.toUpperCase())) continue;
                tumor = true;
                ++nTum;
            }
            if (this.call_somatic && normal && tumor) {
                throw new UserException.BadInput("Input bam file " + this.getToolkit().getSourceFileForReaderID(rid) + " is tagged both as normal and as tumor. Which one is it??");
            }
            if (this.call_somatic && !normal && !tumor) {
                throw new UserException.BadInput("In somatic mode all input bams must be tagged as either normal or tumor. Encountered untagged file: " + this.getToolkit().getSourceFileForReaderID(rid));
            }
            if (!this.call_somatic && (normal || tumor)) {
                System.out.println("WARNING: input bam file " + this.getToolkit().getSourceFileForReaderID(rid) + " is tagged as Normal and/or Tumor, but somatic mode is not on. Tags will ne IGNORED");
            }
            if (this.call_somatic && tumor) {
                for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader(rid).getReadGroups()) {
                    this.tumorSamples.add(rg.getSample());
                }
            } else {
                for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader(rid).getReadGroups()) {
                    this.normalSamples.add(rg.getSample());
                }
            }
            if (this.genotypeIntervalsFile == null) continue;
            GenomeLocSortedSet locs = IntervalUtils.sortAndMergeIntervals((GenomeLocParser)this.getToolkit().getGenomeLocParser(), (List)this.genotypeIntervalsFile.getIntervals(this.getToolkit()), (IntervalMergingRule)IntervalMergingRule.OVERLAPPING_ONLY);
            this.genotypeIntervalIterator = locs.iterator();
            this.genotypeIntervalIterator = new OverlappingIntervalIterator(this.genotypeIntervalIterator, this.getToolkit().getIntervals().iterator());
            GenomeLoc genomeLoc = this.currentGenotypeInterval = this.genotypeIntervalIterator.hasNext() ? this.genotypeIntervalIterator.next() : null;
            if (this.DEBUG.booleanValue()) {
                System.out.println("DEBUG>> first genotyping interval=" + this.currentGenotypeInterval);
            }
            if (this.currentGenotypeInterval == null) continue;
            this.lastGenotypedPosition = this.currentGenotypeInterval.getStart() - 1;
        }
        this.location = this.getToolkit().getGenomeLocParser().createGenomeLoc(this.getToolkit().getSAMFileHeader().getSequence(0).getSequenceName(), 1);
        this.normalSamples = SampleUtils.getSAMFileSamples((SAMFileHeader)this.getToolkit().getSAMFileHeaders().get(0));
        try {
            if (this.bedOutput != null) {
                this.bedWriter = new FileWriter(this.bedOutput);
            }
            if (this.output_file != null) {
                this.bedWriter = new FileWriter(this.output_file);
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.bedOutput, "Failed to open BED file for writing.", (Exception)e);
        }
        try {
            if (this.verboseOutput != null) {
                this.verboseWriter = new FileWriter(this.verboseOutput);
            }
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.verboseOutput, "Failed to open BED file for writing.", (Exception)e);
        }
        this.vcf_writer.writeHeader(new VCFHeader(this.getVCFHeaderInfo(), SampleUtils.getSAMFileSamples((SAMFileHeader)this.getToolkit().getSAMFileHeader())));
        this.refData = new ReferenceDataSource(this.getToolkit().getArguments().referenceFile);
        if (this.FILTER_EXPRESSIONS.size() == 0) {
            if (this.call_unpaired) {
                this.FILTER_EXPRESSIONS.add("COV<6||INDEL_F<0.3||INDEL_CF<0.7");
            } else {
                this.FILTER_EXPRESSIONS.add("T_COV<6||N_COV<4||T_INDEL_F<0.3||T_INDEL_CF<0.7");
            }
        }
        for (String s : this.FILTER_EXPRESSIONS) {
            try {
                Expression e = this.jexlEngine.createExpression(s);
                this.jexlExpressions.add(e);
            }
            catch (Exception e) {
                throw new UserException.BadArgumentValue("Filter expression", "Invalid expression used (" + s + "). Please see the JEXL docs for correct syntax.");
            }
        }
    }

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (this.DEBUG.booleanValue() && read.getDuplicateReadFlag()) {
            System.out.println("DEBUG>> Duplicated read (IGNORED)");
        }
        if (AlignmentUtils.isReadUnmapped((SAMRecord)read) || read.getDuplicateReadFlag() || read.getNotPrimaryAlignmentFlag() || read.getMappingQuality() == 0) {
            return 0;
        }
        if (read.getReferenceIndex() != this.currentContigIndex) {
            if (this.DEBUG.booleanValue()) {
                System.out.println("DEBUG>>> Moved to contig " + read.getReferenceName());
            }
            if (read.getReferenceIndex() < this.currentContigIndex) {
                throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, (SAMRecord)read, "Read " + read.getReadName() + ": contig is out of order; input BAM file is unsorted");
            }
            if (this.call_somatic) {
                this.emit_somatic(1000000000L, true);
            } else {
                this.emit(1000000000L, true);
            }
            this.currentContigIndex = read.getReferenceIndex();
            this.currentPosition = read.getAlignmentStart();
            this.refName = new String(read.getReferenceName());
            this.location = this.getToolkit().getGenomeLocParser().createGenomeLoc(this.refName, this.location.getStart(), this.location.getStop());
            this.contigLength = this.getToolkit().getGenomeLocParser().getContigInfo(this.refName).getSequenceLength();
            this.outOfContigUserWarned = false;
            this.lastGenotypedPosition = -1L;
            this.normal_context.clear();
            if (this.call_somatic) {
                this.tumor_context.clear();
            }
            this.refBases = new String(this.refData.getReference().getSequence(read.getReferenceName()).getBases()).toUpperCase().getBytes();
        }
        if (read.getAlignmentStart() < this.currentPosition) {
            throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, (SAMRecord)read, "Read " + read.getReadName() + " out of order on the contig\n" + "Read starts at " + this.refName + ":" + read.getAlignmentStart() + "; last read seen started at " + this.refName + ":" + this.currentPosition + "\nLast read was: " + this.lastRead.getReadName() + " RG=" + this.lastRead.getAttribute("RG") + " at " + this.lastRead.getAlignmentStart() + "-" + this.lastRead.getAlignmentEnd() + " cigar=" + this.lastRead.getCigarString());
        }
        this.currentPosition = read.getAlignmentStart();
        this.lastRead = read;
        if (read.getAlignmentEnd() > this.contigLength) {
            if (!this.outOfContigUserWarned) {
                System.out.println("WARNING: Reads aligned past contig length on " + this.location.getContig() + "; all such reads will be skipped");
                this.outOfContigUserWarned = true;
            }
            return 0;
        }
        long alignmentEnd = read.getAlignmentEnd();
        Cigar c = read.getCigar();
        int lastNonClippedElement = 0;
        CigarOperator op = null;
        while ((op = c.getCigarElement(c.numCigarElements() - ++lastNonClippedElement).getOperator()) == CigarOperator.H || op == CigarOperator.S) {
        }
        if (op == CigarOperator.I) {
            ++alignmentEnd;
        }
        if (alignmentEnd > (long)this.normal_context.getStop()) {
            if (this.DEBUG.booleanValue()) {
                System.out.println("DEBUG>> Window at " + this.normal_context.getStart() + "-" + this.normal_context.getStop() + ", read at " + read.getAlignmentStart() + ": trying to emit and shift");
            }
            if (this.call_somatic) {
                this.emit_somatic(read.getAlignmentStart(), false);
            } else {
                this.emit(read.getAlignmentStart(), false);
            }
            if (read.getAlignmentEnd() > this.normal_context.getStop()) {
                System.out.println("WARNING: Read " + read.getReadName() + " is out of coverage window bounds. Probably window is too small and the window_size value must be increased.\n" + "  The read is ignored in this run (so all the counts/statistics reported will not include it).\n" + "  Read length=" + read.getReadLength() + "; cigar=" + read.getCigarString() + "; start=" + read.getAlignmentStart() + "; end=" + read.getAlignmentEnd() + "; window start (after trying to accomodate the read)=" + this.normal_context.getStart() + "; window end=" + this.normal_context.getStop());
                return 1;
            }
        }
        if (this.call_somatic) {
            Tags tags = this.getToolkit().getReaderIDForRead((SAMRecord)read).getTags();
            boolean assigned = false;
            for (String s : tags.getPositionalTags()) {
                if ("NORMAL".equals(s.toUpperCase())) {
                    this.normal_context.add((SAMRecord)read, ref.getBases());
                    assigned = true;
                    break;
                }
                if (!"TUMOR".equals(s.toUpperCase())) continue;
                this.tumor_context.add((SAMRecord)read, ref.getBases());
                assigned = true;
                break;
            }
            if (!assigned) {
                throw new StingException("Read " + read.getReadName() + " from " + this.getToolkit().getSourceFileForReaderID(this.getToolkit().getReaderIDForRead((SAMRecord)read)) + "has no Normal/Tumor tag associated with it");
            }
            if (this.tumor_context.getReads().size() > this.MAX_READ_NUMBER) {
                System.out.println("WARNING: a count of " + this.MAX_READ_NUMBER + " reads reached in a window " + this.refName + ':' + this.tumor_context.getStart() + '-' + this.tumor_context.getStop() + " in tumor sample. The whole window will be dropped.");
                this.tumor_context.shift(this.WINDOW_SIZE);
                this.normal_context.shift(this.WINDOW_SIZE);
            }
            if (this.normal_context.getReads().size() > this.MAX_READ_NUMBER) {
                System.out.println("WARNING: a count of " + this.MAX_READ_NUMBER + " reads reached in a window " + this.refName + ':' + this.normal_context.getStart() + '-' + this.normal_context.getStop() + " in normal sample. The whole window will be dropped");
                this.tumor_context.shift(this.WINDOW_SIZE);
                this.normal_context.shift(this.WINDOW_SIZE);
            }
        } else {
            this.normal_context.add((SAMRecord)read, ref.getBases());
            if (this.normal_context.getReads().size() > this.MAX_READ_NUMBER) {
                System.out.println("WARNING: a count of " + this.MAX_READ_NUMBER + " reads reached in a window " + this.refName + ':' + this.normal_context.getStart() + '-' + this.normal_context.getStop() + ". The whole window will be dropped");
                this.normal_context.shift(this.WINDOW_SIZE);
            }
        }
        return 1;
    }

    private boolean pastInterval(long p, GenomeLoc l) {
        return this.location.getContigIndex() > l.getContigIndex() || this.location.getContigIndex() == l.getContigIndex() && p > (long)l.getStop();
    }

    private void emit(long position, boolean force) {
        long adjustedPosition = this.adjustPosition(position);
        if (adjustedPosition == -1L) {
            this.normal_context.shift((int)(position - (long)this.normal_context.getStart()));
            return;
        }
        long move_to = adjustedPosition;
        int pos = this.normal_context.getStart();
        while ((long)pos < Math.min(adjustedPosition, (long)(this.normal_context.getStop() + 1))) {
            boolean genotype = false;
            long p = pos - 1;
            if ((long)pos > this.lastGenotypedPosition) {
                while (this.currentGenotypeInterval != null && this.location.getContigIndex() >= this.currentGenotypeInterval.getContigIndex() && (this.location.getContigIndex() != this.currentGenotypeInterval.getContigIndex() || p >= (long)this.currentGenotypeInterval.getStart())) {
                    if (this.pastInterval(p, this.currentGenotypeInterval)) {
                        this.currentGenotypeInterval = this.genotypeIntervalIterator.hasNext() ? this.genotypeIntervalIterator.next() : null;
                        continue;
                    }
                    genotype = true;
                    break;
                }
                if (this.normal_context.indelsAt(pos).size() != 0 || genotype) {
                    IndelPrecall normalCall = new IndelPrecall(this.normal_context, pos, this.NQS_WIDTH);
                    MapContext jc = new MapContext();
                    normalCall.fillContext((JexlContext)jc, singleMetricsCassette);
                    boolean discard_event = false;
                    for (Expression e : this.jexlExpressions) {
                        if (!((Boolean)e.evaluate((JexlContext)jc)).booleanValue()) continue;
                        discard_event = true;
                        break;
                    }
                    if (discard_event && !genotype) {
                        this.normal_context.indelsAt(pos).clear();
                    } else {
                        if (this.DEBUG.booleanValue()) {
                            System.out.println("DEBUG>> " + (normalCall.getAllVariantCount() == 0 ? "No Indel" : "Indel") + " at " + pos);
                        }
                        long left = Math.max(pos - this.NQS_WIDTH, this.normal_context.getStart());
                        long right = pos + (normalCall.getVariant() == null ? 0 : normalCall.getVariant().lengthOnRef()) + this.NQS_WIDTH - 1;
                        if (right >= adjustedPosition && !force) {
                            move_to = this.adjustPosition(left);
                            if (move_to == -1L) {
                                this.normal_context.shift((int)(adjustedPosition - (long)this.normal_context.getStart()));
                                return;
                            }
                            if (!this.DEBUG.booleanValue()) break;
                            System.out.println("DEBUG>> waiting for coverage; actual shift performed to " + move_to);
                            break;
                        }
                        if (right > (long)this.normal_context.getStop()) {
                            right = this.normal_context.getStop();
                        }
                        this.location = this.getToolkit().getGenomeLocParser().createGenomeLoc(this.location.getContig(), pos);
                        if (!discard_event) {
                            ++this.normalCallsMade;
                        }
                        this.printVCFLine(this.vcf_writer, normalCall, discard_event);
                        if (this.bedWriter != null) {
                            normalCall.printBedLine(this.bedWriter);
                        }
                        if (this.verboseWriter != null) {
                            this.printVerboseLine(this.verboseWriter, normalCall, discard_event);
                        }
                        this.lastGenotypedPosition = pos;
                        this.normal_context.indelsAt(pos).clear();
                    }
                }
            }
            ++pos;
        }
        if (this.DEBUG.booleanValue()) {
            System.out.println("DEBUG>> Actual shift to " + move_to + " (" + adjustedPosition + ")");
        }
        this.normal_context.shift((int)(move_to - (long)this.normal_context.getStart()));
    }

    private boolean indelsPresentInInterval(long start, long stop) {
        if (this.tumor_context == null) {
            return this.normal_context.hasIndelsInInterval(start, stop);
        }
        return this.tumor_context.hasIndelsInInterval(start, stop) || this.normal_context.hasIndelsInInterval(start, stop);
    }

    private long adjustPosition(long request) {
        long initial_request = request;
        int attempts = 0;
        boolean failure = false;
        while (this.indelsPresentInInterval(request, request + (long)this.NQS_WIDTH)) {
            request -= (long)this.NQS_WIDTH;
            if (this.DEBUG.booleanValue()) {
                System.out.println("DEBUG>> indel observations present within " + this.NQS_WIDTH + " bases ahead. Resetting shift to " + request);
            }
            if (++attempts != 4) continue;
            if (this.DEBUG.booleanValue()) {
                System.out.println("DEBUG>> attempts to preserve full NQS window failed; now trying to find any suitable position.");
            }
            failure = true;
            break;
        }
        if (failure) {
            request = initial_request;
            attempts = 0;
            while (this.indelsPresentInInterval(request, request + 1L)) {
                --request;
                if (this.DEBUG.booleanValue()) {
                    System.out.println("DEBUG>> indel observations present within " + this.NQS_WIDTH + " bases ahead. Resetting shift to " + request);
                }
                if (++attempts != 50) continue;
                System.out.println("WARNING: Indel at every position in the interval " + this.refName + ":" + request + "-" + initial_request + ". Can not find a break to shift context window to; no calls will be attempted in the current window.");
                return -1L;
            }
        }
        if (this.DEBUG.booleanValue()) {
            System.out.println("DEBUG>> Found acceptable target position " + request);
        }
        return request;
    }

    private void emit_somatic(long position, boolean force) {
        long adjustedPosition = this.adjustPosition(position);
        if (adjustedPosition == -1L) {
            this.normal_context.shift((int)(position - (long)this.normal_context.getStart()));
            this.tumor_context.shift((int)(position - (long)this.tumor_context.getStart()));
            return;
        }
        long move_to = adjustedPosition;
        if (this.DEBUG.booleanValue()) {
            System.out.println("DEBUG>> Emitting in somatic mode up to " + position + " force shift=" + force + " current window=" + this.tumor_context.getStart() + "-" + this.tumor_context.getStop());
        }
        int pos = this.tumor_context.getStart();
        while ((long)pos < Math.min(adjustedPosition, (long)(this.tumor_context.getStop() + 1))) {
            boolean genotype = false;
            long p = pos - 1;
            if ((long)pos > this.lastGenotypedPosition) {
                while (this.currentGenotypeInterval != null && this.location.getContigIndex() >= this.currentGenotypeInterval.getContigIndex() && (this.location.getContigIndex() != this.currentGenotypeInterval.getContigIndex() || p >= (long)this.currentGenotypeInterval.getStart())) {
                    if (this.pastInterval(p, this.currentGenotypeInterval)) {
                        this.currentGenotypeInterval = this.genotypeIntervalIterator.hasNext() ? this.genotypeIntervalIterator.next() : null;
                        continue;
                    }
                    genotype = true;
                    break;
                }
                if (this.tumor_context.indelsAt(pos).size() != 0 || genotype) {
                    if (this.DEBUG.booleanValue() && genotype) {
                        System.out.println("DEBUG>> Genotyping requested at " + pos);
                    }
                    IndelPrecall tumorCall = new IndelPrecall(this.tumor_context, pos, this.NQS_WIDTH);
                    IndelPrecall normalCall = new IndelPrecall(this.normal_context, pos, this.NQS_WIDTH);
                    MapContext jc = new MapContext();
                    tumorCall.fillContext((JexlContext)jc, tumorMetricsCassette);
                    normalCall.fillContext((JexlContext)jc, normalMetricsCassette);
                    boolean discard_event = false;
                    for (Expression e : this.jexlExpressions) {
                        if (!((Boolean)e.evaluate((JexlContext)jc)).booleanValue()) continue;
                        discard_event = true;
                        break;
                    }
                    if (discard_event && !genotype) {
                        this.tumor_context.indelsAt(pos).clear();
                        this.normal_context.indelsAt(pos).clear();
                    } else {
                        if (this.DEBUG.booleanValue()) {
                            System.out.print("DEBUG>> " + (tumorCall.getAllVariantCount() == 0 ? "No Indel" : "Indel") + " in tumor, ");
                            System.out.print("DEBUG>> " + (normalCall.getAllVariantCount() == 0 ? "No Indel" : "Indel") + " in normal at " + pos);
                        }
                        long left = Math.max(pos - this.NQS_WIDTH, this.tumor_context.getStart());
                        long right = pos + (tumorCall.getVariant() == null ? 0 : tumorCall.getVariant().lengthOnRef()) + this.NQS_WIDTH - 1;
                        if (right >= adjustedPosition && !force) {
                            move_to = this.adjustPosition(left);
                            if (move_to == -1L) {
                                this.normal_context.shift((int)(adjustedPosition - (long)this.normal_context.getStart()));
                                this.tumor_context.shift((int)(adjustedPosition - (long)this.tumor_context.getStart()));
                                return;
                            }
                            if (!this.DEBUG.booleanValue()) break;
                            System.out.println("DEBUG>> waiting for coverage; actual shift performed to " + move_to);
                            break;
                        }
                        if (right > (long)this.tumor_context.getStop()) {
                            right = this.tumor_context.getStop();
                        }
                        this.location = this.getToolkit().getGenomeLocParser().createGenomeLoc(this.location.getContig(), pos);
                        if (!discard_event) {
                            ++this.tumorCallsMade;
                        }
                        this.printVCFLine(this.vcf_writer, normalCall, tumorCall, discard_event);
                        if (this.bedWriter != null) {
                            tumorCall.printBedLine(this.bedWriter);
                        }
                        if (this.verboseWriter != null) {
                            this.printVerboseLine(this.verboseWriter, normalCall, tumorCall, discard_event);
                        }
                        this.lastGenotypedPosition = pos;
                        this.tumor_context.indelsAt(pos).clear();
                        this.normal_context.indelsAt(pos).clear();
                    }
                }
            }
            ++pos;
        }
        if (this.DEBUG.booleanValue()) {
            System.out.println("DEBUG>> Actual shift to " + move_to + " (" + adjustedPosition + ")");
        }
        this.tumor_context.shift((int)(move_to - (long)this.tumor_context.getStart()));
        this.normal_context.shift((int)(move_to - (long)this.normal_context.getStart()));
    }

    private String makeFullRecord(IndelPrecall normalCall, IndelPrecall tumorCall) {
        StringBuilder fullRecord = new StringBuilder();
        if (tumorCall.getVariant() != null || normalCall.getVariant() == null) {
            fullRecord.append(tumorCall.makeEventString());
        } else {
            fullRecord.append(normalCall.makeEventString());
        }
        fullRecord.append('\t');
        fullRecord.append(normalCall.makeStatsString("N_"));
        fullRecord.append('\t');
        fullRecord.append(tumorCall.makeStatsString("T_"));
        fullRecord.append('\t');
        return fullRecord.toString();
    }

    private String makeFullRecord(IndelPrecall normalCall) {
        StringBuilder fullRecord = new StringBuilder();
        fullRecord.append(normalCall.makeEventString());
        fullRecord.append('\t');
        fullRecord.append(normalCall.makeStatsString(""));
        fullRecord.append('\t');
        return fullRecord.toString();
    }

    private String getAnnotationString(RODRecordList ann) {
        if (ann == null) {
            return annGenomic;
        }
        StringBuilder b = new StringBuilder();
        if (RefSeqFeature.isExon((RODRecordList)ann)) {
            if (RefSeqFeature.isCodingExon((RODRecordList)ann)) {
                b.append(annCoding);
            } else {
                b.append(annUTR);
            }
        } else if (RefSeqFeature.isCoding((RODRecordList)ann)) {
            b.append(annIntron);
        } else {
            b.append(annUnknown);
        }
        b.append('\t');
        b.append(((Transcript)((GATKFeature)ann.get(0)).getUnderlyingObject()).getGeneName());
        return b.toString();
    }

    public void printVerboseLine(Writer verboseWriter, IndelPrecall normalCall, boolean discard_event) {
        RODRecordList annotationList = this.refseqIterator == null ? null : this.refseqIterator.seekForward(this.location);
        String annotationString = this.refseqIterator == null ? "" : this.getAnnotationString(annotationList);
        StringBuilder fullRecord = new StringBuilder();
        fullRecord.append(this.makeFullRecord(normalCall));
        fullRecord.append(annotationString);
        if (discard_event && normalCall.getVariant() != null) {
            fullRecord.append("\tFILTERED_NOCALL");
        }
        try {
            verboseWriter.write(fullRecord.toString());
            verboseWriter.write(10);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.verboseOutput, "Write failed", (Exception)e);
        }
    }

    public void printVerboseLine(Writer verboseWriter, IndelPrecall normalCall, IndelPrecall tumorCall, boolean discard_event) {
        RODRecordList annotationList = this.refseqIterator == null ? null : this.refseqIterator.seekForward(this.location);
        String annotationString = this.refseqIterator == null ? "" : this.getAnnotationString(annotationList);
        StringBuilder fullRecord = new StringBuilder();
        fullRecord.append(this.makeFullRecord(normalCall, tumorCall));
        if (normalCall.getVariant() == null && tumorCall.getVariant() == null) {
            if (normalCall.getCoverage() >= this.minNormalCoverage && tumorCall.getCoverage() >= this.minCoverage) {
                fullRecord.append("REFERENCE");
            } else if (tumorCall.getCoverage() >= this.minCoverage) {
                fullRecord.append("REFERENCE");
            } else {
                fullRecord.append("UNKNOWN");
            }
        }
        if (normalCall.getVariant() == null && tumorCall.getVariant() != null) {
            if (normalCall.getCoverage() >= this.minNormalCoverage) {
                fullRecord.append("SOMATIC");
            } else {
                fullRecord.append("EVENT_T");
            }
        }
        if (normalCall.getVariant() != null && tumorCall.getVariant() == null) {
            if (tumorCall.getCoverage() >= this.minCoverage) {
                fullRecord.append("GERMLINE_LOH");
            } else {
                fullRecord.append("GERMLINE");
            }
        }
        if (normalCall.getVariant() != null && tumorCall.getVariant() != null) {
            fullRecord.append("GERMLINE");
        }
        fullRecord.append('\t');
        fullRecord.append(annotationString);
        if (discard_event && tumorCall.getVariant() != null) {
            fullRecord.append("\tFILTERED_NOCALL");
        }
        try {
            verboseWriter.write(fullRecord.toString());
            verboseWriter.write(10);
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(this.verboseOutput, "Write failed", (Exception)e);
        }
    }

    public void printVCFLine(VCFWriter vcf, IndelPrecall call, boolean discard_event) {
        long start = call.getPosition() - 1L;
        if (start == 0L) {
            return;
        }
        long stop = start;
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        ArrayList homref_alleles = null;
        if (call.getVariant() == null) {
            alleles.add(Allele.create((byte)this.refBases[(int)start - 1], (boolean)true));
            homref_alleles = new ArrayList(2);
            homref_alleles.add(alleles.get(0));
            homref_alleles.add(alleles.get(0));
        } else {
            int event_length = call.getVariant().lengthOnRef();
            if (event_length < 0) {
                event_length = 0;
            }
            this.fillAlleleList(alleles, call);
            stop += (long)event_length;
        }
        GenotypesContext genotypes = GenotypesContext.create();
        for (String sample : this.normalSamples) {
            Map<String, Object> attrs = call.makeStatsAttributes(null);
            if (!discard_event) {
                genotypes.add(new Genotype(sample, alleles, 1.0, null, attrs, false));
                continue;
            }
            genotypes.add(new Genotype(sample, homref_alleles, 1.0, null, attrs, false));
        }
        HashSet<String> filters = null;
        if (call.getVariant() != null && discard_event) {
            filters = new HashSet<String>();
            filters.add("NoCall");
        }
        VariantContext vc = new VariantContextBuilder("IGv2_Indel_call", this.refName, start, stop, alleles).genotypes(genotypes).filters(filters).referenceBaseForIndel(Byte.valueOf(this.refBases[(int)start - 1])).make();
        vcf.add(vc);
    }

    private void fillAlleleList(List<Allele> l, IndelPrecall call) {
        int event_length = call.getVariant().lengthOnRef();
        if (event_length == 0) {
            l.add(Allele.create((String)"-", (boolean)true));
            l.add(Allele.create((String)call.getVariant().getBases(), (boolean)false));
        } else {
            l.add(Allele.create((String)call.getVariant().getBases(), (boolean)true));
            l.add(Allele.create((String)"-", (boolean)false));
        }
    }

    public void printVCFLine(VCFWriter vcf, IndelPrecall nCall, IndelPrecall tCall, boolean discard_event) {
        boolean homRefN;
        long start;
        long stop = start = tCall.getPosition() - 1L;
        if (start == 0L) {
            return;
        }
        Map<String, Object> attrsNormal = nCall.makeStatsAttributes(null);
        Map<String, Object> attrsTumor = tCall.makeStatsAttributes(null);
        HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
        boolean isSomatic = false;
        if (nCall.getVariant() == null && tCall.getVariant() != null) {
            isSomatic = true;
            attrs.put("SOMATIC", true);
        }
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        ArrayList homRefAlleles = null;
        homRefAlleles = new ArrayList(2);
        boolean homRefT = tCall.getVariant() == null;
        boolean bl = homRefN = nCall.getVariant() == null;
        if (tCall.getVariant() == null && nCall.getVariant() == null) {
            alleles.add(Allele.create((byte)this.refBases[(int)start - 1], (boolean)true));
        } else {
            int event_length = 0;
            if (tCall.getVariant() != null) {
                event_length = tCall.getVariant().lengthOnRef();
                this.fillAlleleList(alleles, tCall);
            } else {
                event_length = nCall.getVariant().lengthOnRef();
                this.fillAlleleList(alleles, nCall);
            }
            if (event_length > 0) {
                stop += (long)event_length;
            }
        }
        homRefAlleles.add(alleles.get(0));
        homRefAlleles.add(alleles.get(0));
        GenotypesContext genotypes = GenotypesContext.create();
        for (String sample : this.normalSamples) {
            genotypes.add(new Genotype(sample, homRefN ? homRefAlleles : alleles, 1.0, null, attrsNormal, false));
        }
        for (String sample : this.tumorSamples) {
            genotypes.add(new Genotype(sample, homRefT ? homRefAlleles : alleles, 1.0, null, attrsTumor, false));
        }
        HashSet<String> filters = null;
        if (tCall.getVariant() != null && discard_event) {
            filters = new HashSet<String>();
            filters.add("NoCall");
        }
        if (nCall.getCoverage() < this.minNormalCoverage) {
            if (filters == null) {
                filters = new HashSet();
            }
            filters.add("NCov");
        }
        if (tCall.getCoverage() < this.minCoverage) {
            if (filters == null) {
                filters = new HashSet();
            }
            filters.add("TCov");
        }
        VariantContext vc = new VariantContextBuilder("IGv2_Indel_call", this.refName, start, stop, alleles).genotypes(genotypes).filters(filters).attributes(attrs).referenceBaseForIndel(Byte.valueOf(this.refBases[(int)start - 1])).make();
        vcf.add(vc);
    }

    @Override
    public void onTraversalDone(Integer result) {
        if (this.DEBUG.booleanValue()) {
            System.out.println("DEBUG>> Emitting last window at " + this.normal_context.getStart() + "-" + this.normal_context.getStop());
        }
        if (this.call_somatic) {
            this.emit_somatic(1000000000L, true);
        } else {
            this.emit(1000000000L, true);
        }
        if (this.metricsWriter != null) {
            this.metricsWriter.println(String.format("Normal calls made     %d", this.normalCallsMade));
            this.metricsWriter.println(String.format("Tumor calls made      %d", this.tumorCallsMade));
            this.metricsWriter.close();
        }
        try {
            if (this.bedWriter != null) {
                this.bedWriter.close();
            }
            if (this.verboseWriter != null) {
                this.verboseWriter.close();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to close output BED file gracefully, data may be lost");
            e.printStackTrace();
        }
        super.onTraversalDone(result);
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        if (value == -1) {
            this.onTraversalDone(sum);
            System.exit(1);
        }
        sum = sum + value;
        return sum;
    }

    @Override
    public Integer reduceInit() {
        return new Integer(0);
    }

    static {
        SomaticIndelDetectorWalker.normalMetricsCassette[0] = "N_COV";
        SomaticIndelDetectorWalker.tumorMetricsCassette[0] = "T_COV";
        SomaticIndelDetectorWalker.singleMetricsCassette[0] = "COV";
        SomaticIndelDetectorWalker.normalMetricsCassette[1] = "N_CONS_CNT";
        SomaticIndelDetectorWalker.tumorMetricsCassette[1] = "T_CONS_CNT";
        SomaticIndelDetectorWalker.singleMetricsCassette[1] = "CONS_CNT";
        SomaticIndelDetectorWalker.normalMetricsCassette[2] = "N_INDEL_F";
        SomaticIndelDetectorWalker.tumorMetricsCassette[2] = "T_INDEL_F";
        SomaticIndelDetectorWalker.singleMetricsCassette[2] = "INDEL_F";
        SomaticIndelDetectorWalker.normalMetricsCassette[3] = "N_INDEL_CF";
        SomaticIndelDetectorWalker.tumorMetricsCassette[3] = "T_INDEL_CF";
        SomaticIndelDetectorWalker.singleMetricsCassette[3] = "INDEL_CF";
    }

    class ExpandedSAMRecord {
        private SAMRecord read;
        private byte[] mismatch_flags;
        private byte[] expanded_quals;
        private int mms;

        public ExpandedSAMRecord(SAMRecord r, byte[] ref, long offset, IndelListener l) {
            this.read = r;
            long rStart = this.read.getAlignmentStart();
            long rStop = this.read.getAlignmentEnd();
            byte[] readBases = this.read.getReadString().toUpperCase().getBytes();
            ref = new String(ref).toUpperCase().getBytes();
            this.mismatch_flags = new byte[(int)(rStop - rStart + 1L)];
            this.expanded_quals = new byte[(int)(rStop - rStart + 1L)];
            Cigar c = this.read.getCigar();
            int nCigarElems = c.numCigarElements();
            int readLength = 0;
            block11: for (CigarElement cel : c.getCigarElements()) {
                switch (cel.getOperator()) {
                    case H: 
                    case S: 
                    case D: 
                    case N: 
                    case P: {
                        continue block11;
                    }
                    case I: 
                    case M: {
                        readLength += cel.getLength();
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("Unexpected operator in cigar string: " + cel.getOperator());
            }
            int fromStart = 0;
            int posOnRead = 0;
            int posOnRef = 0;
            for (int i = 0; i < nCigarElems; ++i) {
                CigarElement ce = c.getCigarElement(i);
                IndelVariant.Type type = null;
                String indel_bases = null;
                int eventPosition = posOnRef;
                switch (ce.getOperator()) {
                    case H: {
                        break;
                    }
                    case I: {
                        type = IndelVariant.Type.I;
                        indel_bases = this.read.getReadString().substring(posOnRead, posOnRead + ce.getLength());
                    }
                    case S: {
                        posOnRead += ce.getLength();
                        break;
                    }
                    case D: {
                        type = IndelVariant.Type.D;
                        indel_bases = new String(ref, posOnRef, ce.getLength());
                        int k = 0;
                        while (k < ce.getLength()) {
                            this.expanded_quals[posOnRef] = -1;
                            this.mismatch_flags[posOnRef] = -1;
                            ++k;
                            ++posOnRef;
                        }
                        break;
                    }
                    case M: {
                        int k = 0;
                        while (k < ce.getLength()) {
                            if (readBases[posOnRead] != ref[posOnRef]) {
                                ++this.mms;
                                this.mismatch_flags[posOnRef] = 1;
                            }
                            this.expanded_quals[posOnRef] = this.read.getBaseQualities()[posOnRead];
                            ++k;
                            ++posOnRef;
                            ++posOnRead;
                        }
                        fromStart += ce.getLength();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected operator in cigar string: " + ce.getOperator());
                    }
                }
                if (type == null) continue;
                if (i == 0) {
                    logger.debug((Object)("Indel at the start of the read " + this.read.getReadName()));
                }
                if (i == nCigarElems - 1) {
                    logger.debug((Object)("Indel at the end of the read " + this.read.getReadName()));
                }
                int fromEnd = readLength - fromStart;
                if (type == IndelVariant.Type.I) {
                    fromEnd -= ce.getLength();
                }
                l.addObservation((int)(offset + (long)eventPosition), type, indel_bases, fromStart, fromEnd, this);
                if (type != IndelVariant.Type.I) continue;
                fromStart += ce.getLength();
            }
        }

        public SAMRecord getSAMRecord() {
            return this.read;
        }

        public byte[] getExpandedMMFlags() {
            return this.mismatch_flags;
        }

        public byte[] getExpandedQuals() {
            return this.expanded_quals;
        }

        public int getMMCount() {
            return this.mms;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.read == null) {
                return false;
            }
            if (o instanceof SAMRecord) {
                return this.read.equals(o);
            }
            if (o instanceof ExpandedSAMRecord) {
                return this.read.equals((Object)((ExpandedSAMRecord)o).read);
            }
            return false;
        }
    }

    class WindowContext
    implements IndelListener {
        private Set<ExpandedSAMRecord> reads;
        private int start = 0;
        private CircularArray<List<IndelVariant>> indels;
        private List<IndelVariant> emptyIndelList = new ArrayList<IndelVariant>();

        public WindowContext(int start, int length) {
            this.start = start;
            this.indels = new CircularArray(length);
            this.reads = new HashSet<ExpandedSAMRecord>();
        }

        public int getStart() {
            return this.start;
        }

        public int getStop() {
            return this.start + this.indels.length() - 1;
        }

        public void clear() {
            this.start = 0;
            this.reads.clear();
            this.indels.clear();
        }

        public boolean hasIndelsInInterval(long begin, long end) {
            for (long k = Math.max((long)this.start, begin); k < Math.min((long)this.getStop(), end); ++k) {
                if (this.indelsAt(k) == this.emptyIndelList) continue;
                return true;
            }
            return false;
        }

        public Set<ExpandedSAMRecord> getReads() {
            return this.reads;
        }

        public int coverageAt(long refPos, boolean countForIndels) {
            int cov = 0;
            for (ExpandedSAMRecord read : this.reads) {
                if ((long)read.getSAMRecord().getAlignmentStart() > refPos || (long)read.getSAMRecord().getAlignmentEnd() < refPos) {
                    Cigar c;
                    if (!countForIndels || (long)read.getSAMRecord().getAlignmentEnd() != refPos - 1L || (c = read.getSAMRecord().getCigar()).getCigarElement(c.numCigarElements() - 1).getOperator() != CigarOperator.I) continue;
                    ++cov;
                    continue;
                }
                ++cov;
            }
            return cov;
        }

        public void shift(int offset) {
            this.start += offset;
            this.indels.shiftData(offset);
            if (this.indels.get(0) != null && ((List)this.indels.get(0)).size() != 0) {
                IndelVariant indel = (IndelVariant)((List)this.indels.get(0)).get(0);
                System.out.println("WARNING: Indel(s) at first position in the window (" + SomaticIndelDetectorWalker.this.refName + ":" + this.start + "): currently not supported: " + (indel.getType() == IndelVariant.Type.I ? "+" : "-") + indel.getBases() + "; read: " + indel.getReadSet().iterator().next().getSAMRecord().getReadName() + "; site ignored");
                ((List)this.indels.get(0)).clear();
            }
            Iterator<ExpandedSAMRecord> read_iter = this.reads.iterator();
            while (read_iter.hasNext()) {
                ExpandedSAMRecord r = read_iter.next();
                if (r.getSAMRecord().getAlignmentEnd() >= this.start) continue;
                read_iter.remove();
            }
        }

        public void add(SAMRecord read, byte[] ref) {
            if (read.getAlignmentStart() < this.start) {
                return;
            }
            ExpandedSAMRecord er = new ExpandedSAMRecord(read, ref, read.getAlignmentStart() - this.start, this);
            if (this.reads.contains(er)) {
                return;
            }
            this.reads.add(er);
        }

        @Override
        public void addObservation(int pos, IndelVariant.Type type, String bases, int fromStart, int fromEnd, ExpandedSAMRecord rec) {
            ArrayList<IndelVariant> indelsAtSite;
            try {
                indelsAtSite = (ArrayList<IndelVariant>)this.indels.get(pos);
            }
            catch (IndexOutOfBoundsException e) {
                SAMRecord r = rec.getSAMRecord();
                System.out.println("Failed to add indel observation, probably out of coverage window bounds (trailing indel?):\nRead " + r.getReadName() + ": " + "read length=" + r.getReadLength() + "; cigar=" + r.getCigarString() + "; start=" + r.getAlignmentStart() + "; end=" + r.getAlignmentEnd() + "; window start=" + this.getStart() + "; window end=" + this.getStop());
                throw e;
            }
            if (indelsAtSite == null) {
                indelsAtSite = new ArrayList<IndelVariant>();
                this.indels.set(pos, indelsAtSite);
            }
            IndelVariant indel = null;
            for (IndelVariant v : indelsAtSite) {
                if (!v.equals(type, bases)) continue;
                indel = v;
                indel.addObservation(rec);
                break;
            }
            if (indel == null) {
                indel = new IndelVariant(rec, type, bases);
                indelsAtSite.add(indel);
            }
            indel.addReadPositions(fromStart, fromEnd);
        }

        public List<IndelVariant> indelsAt(long refPos) {
            List l = (List)this.indels.get((int)(refPos - (long)this.start));
            if (l == null) {
                return this.emptyIndelList;
            }
            return l;
        }
    }

    static interface IndelListener {
        public void addObservation(int var1, IndelVariant.Type var2, String var3, int var4, int var5, ExpandedSAMRecord var6);
    }

    class IndelPrecall {
        private int NQS_MISMATCH_CUTOFF = 1000000;
        private double AV_MISMATCHES_PER_READ = 1.5;
        private int nqs = 0;
        private IndelVariant consensus_indel = null;
        private long pos = -1L;
        private int total_coverage = 0;
        private int consensus_indel_count = 0;
        private int all_indel_count = 0;
        private int total_mismatches_in_nqs_window = 0;
        private int total_bases_in_nqs_window = 0;
        private int total_base_qual_in_nqs_window = 0;
        private int total_mismatching_base_qual_in_nqs_window = 0;
        private int indel_read_mismatches_in_nqs_window = 0;
        private int indel_read_bases_in_nqs_window = 0;
        private int indel_read_base_qual_in_nqs_window = 0;
        private int indel_read_mismatching_base_qual_in_nqs_window = 0;
        private int consensus_indel_read_mismatches_in_nqs_window = 0;
        private int consensus_indel_read_bases_in_nqs_window = 0;
        private int consensus_indel_read_base_qual_in_nqs_window = 0;
        private int consensus_indel_read_mismatching_base_qual_in_nqs_window = 0;
        private double consensus_indel_read_total_mm = 0.0;
        private double all_indel_read_total_mm = 0.0;
        private double all_read_total_mm = 0.0;
        private double consensus_indel_read_total_mapq = 0.0;
        private double all_indel_read_total_mapq = 0.0;
        private double all_read_total_mapq = 0.0;
        private PrimitivePair.Int consensus_indel_read_orientation_cnt = new PrimitivePair.Int();
        private PrimitivePair.Int all_indel_read_orientation_cnt = new PrimitivePair.Int();
        private PrimitivePair.Int all_read_orientation_cnt = new PrimitivePair.Int();
        private int from_start_median = 0;
        private int from_start_mad = 0;
        private int from_end_median = 0;
        private int from_end_mad = 0;

        public IndelPrecall(long position) {
            this.pos = position;
        }

        public IndelPrecall(WindowContext context, long position, int nqs_width) {
            this.pos = position;
            this.nqs = nqs_width;
            this.total_coverage = context.coverageAt(this.pos, true);
            List<IndelVariant> variants = context.indelsAt(this.pos);
            this.findConsensus(variants);
            long left = Math.max(this.pos - (long)this.nqs, (long)context.getStart());
            long right = Math.min(this.pos + (long)this.nqs - 1L, (long)context.getStop());
            for (ExpandedSAMRecord rec : context.getReads()) {
                SAMRecord read = rec.getSAMRecord();
                byte[] flags = rec.getExpandedMMFlags();
                byte[] quals = rec.getExpandedQuals();
                int mm = rec.getMMCount();
                if ((long)read.getAlignmentStart() > this.pos || (long)read.getAlignmentEnd() < this.pos) continue;
                long local_right = right;
                boolean read_has_a_variant = false;
                boolean read_has_consensus = this.consensus_indel != null && this.consensus_indel.getReadSet().contains(rec);
                for (IndelVariant v : variants) {
                    if (!v.getReadSet().contains(rec)) continue;
                    read_has_a_variant = true;
                    local_right += (long)v.lengthOnRef();
                    break;
                }
                if (read_has_consensus) {
                    this.consensus_indel_read_total_mm += (double)mm;
                    this.consensus_indel_read_total_mapq += (double)read.getMappingQuality();
                    if (read.getReadNegativeStrandFlag()) {
                        ++this.consensus_indel_read_orientation_cnt.second;
                    } else {
                        ++this.consensus_indel_read_orientation_cnt.first;
                    }
                }
                if (read_has_a_variant) {
                    this.all_indel_read_total_mm += (double)mm;
                    this.all_indel_read_total_mapq += (double)read.getMappingQuality();
                    if (read.getReadNegativeStrandFlag()) {
                        ++this.all_indel_read_orientation_cnt.second;
                    } else {
                        ++this.all_indel_read_orientation_cnt.first;
                    }
                }
                this.all_read_total_mm += (double)mm;
                this.all_read_total_mapq += (double)read.getMappingQuality();
                if (read.getReadNegativeStrandFlag()) {
                    ++this.all_read_orientation_cnt.second;
                } else {
                    ++this.all_read_orientation_cnt.first;
                }
                for (int pos_in_flags = Math.max((int)(left - (long)read.getAlignmentStart()), 0); pos_in_flags <= Math.min((int)local_right - read.getAlignmentStart(), flags.length - 1); ++pos_in_flags) {
                    if (flags[pos_in_flags] == -1) continue;
                    ++this.total_bases_in_nqs_window;
                    if (read_has_consensus) {
                        ++this.consensus_indel_read_bases_in_nqs_window;
                    }
                    if (read_has_a_variant) {
                        ++this.indel_read_bases_in_nqs_window;
                    }
                    if (quals[pos_in_flags] != -1) {
                        this.total_base_qual_in_nqs_window += quals[pos_in_flags];
                        if (read_has_a_variant) {
                            this.indel_read_base_qual_in_nqs_window += quals[pos_in_flags];
                        }
                        if (read_has_consensus) {
                            this.consensus_indel_read_base_qual_in_nqs_window += quals[pos_in_flags];
                        }
                    }
                    if (flags[pos_in_flags] != 1) continue;
                    ++this.total_mismatches_in_nqs_window;
                    this.total_mismatching_base_qual_in_nqs_window += quals[pos_in_flags];
                    if (read_has_consensus) {
                        ++this.consensus_indel_read_mismatches_in_nqs_window;
                        this.consensus_indel_read_mismatching_base_qual_in_nqs_window += quals[pos_in_flags];
                    }
                    if (!read_has_a_variant) continue;
                    ++this.indel_read_mismatches_in_nqs_window;
                    this.indel_read_mismatching_base_qual_in_nqs_window += quals[pos_in_flags];
                }
            }
            if (this.consensus_indel != null) {
                this.from_start_median = this.median(this.consensus_indel.getOffsetsFromStart());
                this.from_start_mad = this.mad(this.consensus_indel.getOffsetsFromStart(), this.from_start_median);
                this.from_end_median = this.median(this.consensus_indel.getOffsetsFromEnd());
                this.from_end_mad = this.mad(this.consensus_indel.getOffsetsFromEnd(), this.from_end_median);
            }
        }

        private int median(List<Integer> l) {
            Collections.sort(l);
            int k = l.size() / 2;
            return l.size() % 2 == 0 ? (l.get(k - 1) + l.get(k)) / 2 : l.get(k);
        }

        private int median(int[] l) {
            Arrays.sort(l);
            int k = l.length / 2;
            return l.length % 2 == 0 ? (l[k - 1] + l[k]) / 2 : l[k];
        }

        private int mad(List<Integer> l, int med) {
            int[] diff = new int[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                diff[i] = Math.abs(l.get(i) - med);
            }
            return this.median(diff);
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasObservation() {
            return this.consensus_indel != null;
        }

        public int getCoverage() {
            return this.total_coverage;
        }

        public double getTotalMismatches() {
            return this.all_read_total_mm;
        }

        public double getConsensusMismatches() {
            return this.consensus_indel_read_total_mm;
        }

        public double getAllVariantMismatches() {
            return this.all_indel_read_total_mm;
        }

        public double getAvConsensusMismatches() {
            return this.consensus_indel_count != 0 ? this.consensus_indel_read_total_mm / (double)this.consensus_indel_count : 0.0;
        }

        public double getAvRefMismatches() {
            int coverage_ref = this.total_coverage - this.all_indel_count;
            return coverage_ref != 0 ? (this.all_read_total_mm - this.all_indel_read_total_mm) / (double)coverage_ref : 0.0;
        }

        public PrimitivePair.Int getConsensusStrandCounts() {
            return this.consensus_indel_read_orientation_cnt;
        }

        public PrimitivePair.Int getRefStrandCounts() {
            return new PrimitivePair.Int(this.all_read_orientation_cnt.first - this.all_indel_read_orientation_cnt.first, this.all_read_orientation_cnt.second - this.all_indel_read_orientation_cnt.second);
        }

        public double getTotalMapq() {
            return this.all_read_total_mapq;
        }

        public double getConsensusMapq() {
            return this.consensus_indel_read_total_mapq;
        }

        public double getAllVariantMapq() {
            return this.all_indel_read_total_mapq;
        }

        public double getAvConsensusMapq() {
            return this.consensus_indel_count != 0 ? this.consensus_indel_read_total_mapq / (double)this.consensus_indel_count : 0.0;
        }

        public double getAvRefMapq() {
            int coverage_ref = this.total_coverage - this.all_indel_count;
            return coverage_ref != 0 ? (this.all_read_total_mapq - this.all_indel_read_total_mapq) / (double)coverage_ref : 0.0;
        }

        public double getNQSConsensusMMRate() {
            if (this.consensus_indel_read_bases_in_nqs_window == 0) {
                return 0.0;
            }
            return (double)this.consensus_indel_read_mismatches_in_nqs_window / (double)this.consensus_indel_read_bases_in_nqs_window;
        }

        public double getNQSRefMMRate() {
            int num_ref_bases = this.total_bases_in_nqs_window - this.indel_read_bases_in_nqs_window;
            if (num_ref_bases == 0) {
                return 0.0;
            }
            return (double)(this.total_mismatches_in_nqs_window - this.indel_read_mismatches_in_nqs_window) / (double)num_ref_bases;
        }

        public double getNQSConsensusAvQual() {
            if (this.consensus_indel_read_bases_in_nqs_window == 0) {
                return 0.0;
            }
            return (double)this.consensus_indel_read_base_qual_in_nqs_window / (double)this.consensus_indel_read_bases_in_nqs_window;
        }

        public double getNQSRefAvQual() {
            int num_ref_bases = this.total_bases_in_nqs_window - this.indel_read_bases_in_nqs_window;
            if (num_ref_bases == 0) {
                return 0.0;
            }
            return (double)(this.total_base_qual_in_nqs_window - this.indel_read_base_qual_in_nqs_window) / (double)num_ref_bases;
        }

        public int getTotalNQSMismatches() {
            return this.total_mismatches_in_nqs_window;
        }

        public int getAllVariantCount() {
            return this.all_indel_count;
        }

        public int getConsensusVariantCount() {
            return this.consensus_indel_count;
        }

        public IndelVariant getVariant() {
            return this.consensus_indel;
        }

        public void fillContext(JexlContext context, String[] cassette) {
            context.set(cassette[2], (Object)((double)this.consensus_indel_count / (double)this.total_coverage));
            context.set(cassette[3], (Object)((double)this.consensus_indel_count / (double)this.all_indel_count));
            context.set(cassette[0], (Object)this.total_coverage);
            context.set(cassette[1], (Object)this.consensus_indel_count);
        }

        private void findConsensus(List<IndelVariant> variants) {
            for (IndelVariant var : variants) {
                if (SomaticIndelDetectorWalker.this.DEBUG.booleanValue()) {
                    System.out.println("DEBUG>> Variant " + var.getBases() + " (cnt=" + var.getCount() + ")");
                }
                int cnt = var.getCount();
                this.all_indel_count += cnt;
                if (cnt <= this.consensus_indel_count) continue;
                this.consensus_indel = var;
                this.consensus_indel_count = cnt;
            }
            if (SomaticIndelDetectorWalker.this.DEBUG.booleanValue() && this.consensus_indel != null) {
                System.out.println("DEBUG>> Returning: " + this.consensus_indel.getBases() + " (cnt=" + this.consensus_indel.getCount() + ") with total count of " + this.all_indel_count);
            }
        }

        public void printBedLine(Writer bed) {
            int event_length;
            if (this.consensus_indel == null) {
                event_length = 0;
            } else {
                event_length = this.consensus_indel.lengthOnRef();
                if (event_length < 0) {
                    event_length = 0;
                }
            }
            StringBuffer message = new StringBuffer();
            message.append(SomaticIndelDetectorWalker.this.refName + "\t" + (this.pos - 1L) + "\t");
            message.append(this.pos - 1L + (long)event_length + "\t");
            if (this.consensus_indel != null) {
                message.append((event_length > 0 ? "-" : "+") + this.consensus_indel.getBases());
            } else {
                message.append('.');
            }
            message.append(":" + this.all_indel_count + "/" + this.total_coverage);
            try {
                bed.write(message.toString() + "\n");
            }
            catch (IOException e) {
                throw new UserException.CouldNotCreateOutputFile(SomaticIndelDetectorWalker.this.bedOutput, "Error encountered while writing into output BED file", (Exception)e);
            }
        }

        public String makeEventString() {
            int event_length;
            if (this.consensus_indel == null) {
                event_length = 0;
            } else {
                event_length = this.consensus_indel.lengthOnRef();
                if (event_length < 0) {
                    event_length = 0;
                }
            }
            StringBuffer message = new StringBuffer();
            message.append(SomaticIndelDetectorWalker.this.refName);
            message.append('\t');
            message.append(this.pos - 1L);
            message.append('\t');
            message.append(this.pos - 1L + (long)event_length);
            message.append('\t');
            if (this.consensus_indel != null) {
                message.append(event_length > 0 ? (char)'-' : '+');
                message.append(this.consensus_indel.getBases());
            } else {
                message.append('.');
            }
            return message.toString();
        }

        public String makeStatsString(String prefix) {
            StringBuilder message = new StringBuilder();
            message.append(prefix + "OBS_COUNTS[C/A/T]:" + this.getConsensusVariantCount() + "/" + this.getAllVariantCount() + "/" + this.getCoverage());
            message.append('\t');
            message.append(prefix + "AV_MM[C/R]:" + String.format("%.2f/%.2f", this.getAvConsensusMismatches(), this.getAvRefMismatches()));
            message.append('\t');
            message.append(prefix + "AV_MAPQ[C/R]:" + String.format("%.2f/%.2f", this.getAvConsensusMapq(), this.getAvRefMapq()));
            message.append('\t');
            message.append(prefix + "NQS_MM_RATE[C/R]:" + String.format("%.2f/%.2f", this.getNQSConsensusMMRate(), this.getNQSRefMMRate()));
            message.append('\t');
            message.append(prefix + "NQS_AV_QUAL[C/R]:" + String.format("%.2f/%.2f", this.getNQSConsensusAvQual(), this.getNQSRefAvQual()));
            PrimitivePair.Int strand_cons = this.getConsensusStrandCounts();
            PrimitivePair.Int strand_ref = this.getRefStrandCounts();
            message.append('\t');
            message.append(prefix + "STRAND_COUNTS[C/C/R/R]:" + strand_cons.first + "/" + strand_cons.second + "/" + strand_ref.first + "/" + strand_ref.second);
            message.append('\t');
            message.append(prefix + "OFFSET_RSTART:" + this.from_start_median + "/" + this.from_start_mad);
            message.append('\t');
            message.append(prefix + "OFFSET_REND:" + this.from_end_median + "/" + this.from_end_mad);
            return message.toString();
        }

        public Map<String, Object> makeStatsAttributes(Map<String, Object> attr) {
            if (attr == null) {
                attr = new HashMap<String, Object>();
            }
            VCFIndelAttributes.recordDepth(this.getConsensusVariantCount(), this.getAllVariantCount(), this.getCoverage(), attr);
            VCFIndelAttributes.recordAvMM(this.getAvConsensusMismatches(), this.getAvRefMismatches(), attr);
            VCFIndelAttributes.recordAvMapQ(this.getAvConsensusMapq(), this.getAvRefMapq(), attr);
            VCFIndelAttributes.recordNQSMMRate(this.getNQSConsensusMMRate(), this.getNQSRefMMRate(), attr);
            VCFIndelAttributes.recordNQSAvQ(this.getNQSConsensusAvQual(), this.getNQSRefAvQual(), attr);
            VCFIndelAttributes.recordOffsetFromStart(this.from_start_median, this.from_start_mad, attr);
            VCFIndelAttributes.recordOffsetFromEnd(this.from_end_median, this.from_end_mad, attr);
            PrimitivePair.Int strand_cons = this.getConsensusStrandCounts();
            PrimitivePair.Int strand_ref = this.getRefStrandCounts();
            VCFIndelAttributes.recordStrandCounts(strand_cons.first, strand_cons.second, strand_ref.first, strand_ref.second, attr);
            return attr;
        }
    }

    static class IndelVariant {
        private String bases;
        private Type type;
        private ArrayList<Integer> fromStartOffsets = null;
        private ArrayList<Integer> fromEndOffsets = null;
        private Set<ExpandedSAMRecord> reads = new HashSet<ExpandedSAMRecord>();
        private Set<String> samples = new HashSet<String>();

        public IndelVariant(ExpandedSAMRecord read, Type type, String bases) {
            this.type = type;
            this.bases = bases.toUpperCase();
            this.addObservation(read);
            this.fromStartOffsets = new ArrayList();
            this.fromEndOffsets = new ArrayList();
        }

        public void addObservation(ExpandedSAMRecord read) {
            if (this.reads.contains(read)) {
                return;
            }
            this.reads.add(read);
            String sample = null;
            if (read.getSAMRecord().getReadGroup() != null) {
                sample = read.getSAMRecord().getReadGroup().getSample();
            }
            if (sample != null) {
                this.samples.add(sample);
            }
        }

        public int lengthOnRef() {
            if (this.type == Type.D) {
                return this.bases.length();
            }
            return 0;
        }

        public void addSample(String sample) {
            if (sample != null) {
                this.samples.add(sample);
            }
        }

        public void addReadPositions(int fromStart, int fromEnd) {
            this.fromStartOffsets.add(fromStart);
            this.fromEndOffsets.add(fromEnd);
        }

        public List<Integer> getOffsetsFromStart() {
            return this.fromStartOffsets;
        }

        public List<Integer> getOffsetsFromEnd() {
            return this.fromEndOffsets;
        }

        public String getSamples() {
            StringBuffer sb = new StringBuffer();
            Iterator<String> i = this.samples.iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        public Set<ExpandedSAMRecord> getReadSet() {
            return this.reads;
        }

        public int getCount() {
            return this.reads.size();
        }

        public String getBases() {
            return this.bases;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndelVariant)) {
                return false;
            }
            IndelVariant that = (IndelVariant)o;
            return this.type == that.type && this.bases.equals(that.bases);
        }

        public boolean equals(Type type, String bases) {
            return this.type == type && this.bases.equals(bases.toUpperCase());
        }

        public static enum Type {
            I,
            D;

        }
    }

    static enum CallType {
        NOCOVERAGE,
        BADCOVERAGE,
        NOEVIDENCE,
        GERMLINE,
        SOMATIC;

    }
}

