/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffValue;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

@Invariant(value={"name != null", "value != null", "parent != null || name.equals(\"ROOT\")", "value == null || value.getBinding() == this"})
public class DiffElement {
    public static final DiffElement ROOT = new DiffElement();
    private final String name;
    private final DiffElement parent;
    private final DiffValue value;

    private DiffElement() {
        this.name = "ROOT";
        this.parent = null;
        this.value = new DiffValue(this, (Object)"ROOT");
    }

    @Requires(value={"name != null", "parent != null", "value != null"})
    public DiffElement(String name, DiffElement parent, DiffValue value) {
        if (name.equals("ROOT")) {
            throw new IllegalArgumentException("Cannot use reserved name ROOT");
        }
        this.name = name;
        this.parent = parent;
        this.value = value;
        this.value.setBinding(this);
    }

    @Ensures(value={"result != null"})
    public String getName() {
        return this.name;
    }

    public DiffElement getParent() {
        return this.parent;
    }

    @Ensures(value={"result != null"})
    public DiffValue getValue() {
        return this.value;
    }

    public boolean isRoot() {
        return this == ROOT;
    }

    @Ensures(value={"result != null"})
    public String toString() {
        return this.getName() + "=" + this.getValue().toString();
    }

    public String toString(int offset) {
        return (offset > 0 ? Utils.dupString((char)' ', (int)offset) : Integer.valueOf(0)) + this.getName() + "=" + this.getValue().toString(offset);
    }

    @Ensures(value={"result != null"})
    public final String fullyQualifiedName() {
        if (this.isRoot()) {
            return "";
        }
        if (this.parent.isRoot()) {
            return this.name;
        }
        return this.parent.fullyQualifiedName() + "." + this.name;
    }

    @Ensures(value={"result != null"})
    public String toOneLineString() {
        return this.getName() + "=" + this.getValue().toOneLineString();
    }

    @Ensures(value={"result != null"})
    public DiffNode getValueAsNode() {
        if (this.getValue().isCompound()) {
            return (DiffNode)this.getValue();
        }
        throw new ReviewedStingException("Illegal request conversion of a DiffValue into a DiffNode: " + this);
    }

    public int size() {
        return 1 + this.getValue().size();
    }
}

