/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.CoveredLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;

public class TraverseLoci<M, T>
extends TraversalEngine<M, T, LocusWalker<M, T>, LocusShardDataProvider> {
    protected static Logger logger = Logger.getLogger(TraversalEngine.class);

    @Override
    protected String getTraversalType() {
        return "sites";
    }

    @Override
    public T traverse(LocusWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        RodLocusView rodLocusView;
        long nSkipped;
        logger.debug((Object)String.format("TraverseLoci.traverse: Shard is %s", dataProvider));
        LocusView locusView = this.getLocusView(walker, dataProvider);
        boolean done = false;
        if (locusView.hasNext()) {
            ReferenceOrderedView referenceOrderedDataView = null;
            referenceOrderedDataView = WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA ? new ManagingReferenceOrderedView(dataProvider) : (RodLocusView)locusView;
            LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
            while (locusView.hasNext() && !done) {
                AlignmentContext locus = locusView.next();
                GenomeLoc location = locus.getLocation();
                dataProvider.getShard().getReadMetrics().incrementNumIterations();
                if (locus.hasExtendedEventPileup()) {
                    location = this.engine.getGenomeLocParser().setStop(location, location.getStop() + locus.getExtendedEventPileup().getMaxDeletionLength());
                    referenceView.expandBoundsToAccomodateLoc(location);
                }
                ReferenceContext refContext = referenceView.getReferenceContext(location);
                RefMetaDataTracker tracker = referenceOrderedDataView.getReferenceOrderedDataAtLocus(locus.getLocation(), refContext);
                boolean keepMeP = walker.filter(tracker, refContext, locus);
                if (keepMeP) {
                    M x = walker.map(tracker, refContext, locus);
                    sum = walker.reduce(x, sum);
                    done = walker.isDone();
                }
                this.printProgress(dataProvider.getShard(), locus.getLocation());
            }
        }
        if (WalkerManager.getWalkerDataSource(walker) == DataSource.REFERENCE_ORDERED_DATA && !walker.isDone() && (nSkipped = (rodLocusView = (RodLocusView)locusView).getLastSkippedBases()) > 0L) {
            GenomeLoc site = rodLocusView.getLocOneBeyondShard();
            AlignmentContext ac = new AlignmentContext(site, (ReadBackedPileup)new ReadBackedPileupImpl(site), nSkipped);
            M x = walker.map(null, null, ac);
            sum = walker.reduce(x, sum);
        }
        return sum;
    }

    private LocusView getLocusView(Walker<M, T> walker, LocusShardDataProvider dataProvider) {
        DataSource dataSource = WalkerManager.getWalkerDataSource(walker);
        if (dataSource == DataSource.READS) {
            return new CoveredLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE) {
            return new AllLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE_ORDERED_DATA) {
            return new RodLocusView(dataProvider);
        }
        throw new UnsupportedOperationException("Unsupported traversal type: " + (Object)((Object)dataSource));
    }
}

