/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata.tracks;

import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureSource;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.FeatureToGATKFeatureIterator;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class RMDTrack {
    private static final Logger logger = Logger.getLogger(RMDTrackBuilder.class);
    private final Class type;
    private final String name;
    private final File file;
    private FeatureSource reader;
    private final SAMSequenceDictionary dictionary;
    private final GenomeLocParser genomeLocParser;
    private final FeatureCodec codec;

    public Class getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public RMDTrack(Class type, String name, File file, FeatureSource reader, SAMSequenceDictionary dict, GenomeLocParser genomeLocParser, FeatureCodec codec) {
        this.type = type;
        this.name = name;
        this.file = file;
        this.reader = reader;
        this.dictionary = dict;
        this.genomeLocParser = genomeLocParser;
        this.codec = codec;
    }

    public CloseableIterator<GATKFeature> getIterator() {
        try {
            return new FeatureToGATKFeatureIterator(this.genomeLocParser, (CloseableTribbleIterator<Feature>)this.reader.iterator(), this.getName());
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.getFile(), "Unable to read from file", (Exception)e);
        }
    }

    public CloseableIterator<GATKFeature> query(GenomeLoc interval) throws IOException {
        CloseableTribbleIterator iter = this.reader.query(interval.getContig(), interval.getStart(), interval.getStop());
        return new FeatureToGATKFeatureIterator(this.genomeLocParser, (CloseableTribbleIterator<Feature>)iter, this.getName());
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new UserException.MalformedFile("Unable to close reader " + this.reader.toString(), (Exception)e);
        }
        this.reader = null;
    }

    public FeatureSource getReader() {
        return this.reader;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.dictionary;
    }

    public Object getHeader() {
        return this.reader.getHeader();
    }

    public FeatureCodec getCodec() {
        return this.codec;
    }
}

