/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class CountingFilteringIterator
implements CloseableIterator<SAMRecord> {
    private final ReadMetrics runtimeMetrics;
    private final Iterator<SAMRecord> iterator;
    private final Collection<ReadFilter> filters;
    private SAMRecord next = null;

    public CountingFilteringIterator(ReadMetrics metrics, Iterator<SAMRecord> iterator, Collection<ReadFilter> filters) {
        this.runtimeMetrics = metrics;
        this.iterator = iterator;
        this.filters = filters;
        this.next = this.getNextRecord();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public SAMRecord next() {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator has no more elements.");
        }
        SAMRecord result = this.next;
        this.next = this.getNextRecord();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported by CountingFilteringIterator");
    }

    public void close() {
        CloserUtil.close(this.iterator);
    }

    private SAMRecord getNextRecord() {
        while (this.iterator.hasNext()) {
            SAMRecord record = this.iterator.next();
            this.runtimeMetrics.incrementNumReadsSeen();
            boolean filtered = false;
            for (ReadFilter filter : this.filters) {
                if (!filter.filterOut(record)) continue;
                this.runtimeMetrics.incrementFilter(filter);
                filtered = true;
                break;
            }
            if (filtered) continue;
            return record;
        }
        return null;
    }
}

