/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public abstract class Accumulator {
    protected final Walker walker;

    protected Accumulator(Walker walker) {
        this.walker = walker;
    }

    public static Accumulator create(GenomeAnalysisEngine engine, Walker walker) {
        if (walker.isReduceByInterval() && engine.getIntervals() != null) {
            return new IntervalAccumulator(walker, engine.getIntervals());
        }
        return new StandardAccumulator(walker);
    }

    public abstract Object getReduceInit();

    public abstract void accumulate(ShardDataProvider var1, Object var2);

    public abstract Object finishTraversal();

    private static class IntervalAccumulator
    extends Accumulator {
        private boolean startingNewInterval = true;
        private final Iterator<GenomeLoc> intervalIterator;
        private GenomeLoc currentInterval = null;
        private final List<Pair<GenomeLoc, Object>> intervalAccumulator = new ArrayList<Pair<GenomeLoc, Object>>();
        private Object nextReduceInit = null;

        protected IntervalAccumulator(Walker walker, GenomeLocSortedSet intervals) {
            super(walker);
            this.intervalIterator = intervals.iterator();
            if (this.intervalIterator.hasNext()) {
                this.currentInterval = this.intervalIterator.next();
            }
        }

        @Override
        public Object getReduceInit() {
            if (this.startingNewInterval) {
                this.startingNewInterval = false;
                this.nextReduceInit = this.walker.reduceInit();
            }
            return this.nextReduceInit;
        }

        @Override
        public void accumulate(ShardDataProvider provider, Object result) {
            if (!(provider instanceof LocusShardDataProvider)) {
                throw new ReviewedStingException("Unable to reduce by interval on reads traversals at this time.");
            }
            GenomeLoc location = ((LocusShardDataProvider)provider).getLocus();
            while ((this.currentInterval == null || this.currentInterval.isBefore(location)) && this.intervalIterator.hasNext()) {
                this.currentInterval = this.intervalIterator.next();
            }
            if (this.currentInterval != null && this.currentInterval.getContig().equals(location.getContig()) && this.currentInterval.getStop() == location.getStop()) {
                this.intervalAccumulator.add((Pair<GenomeLoc, Object>)new Pair((Object)this.currentInterval, result));
                this.startingNewInterval = true;
            } else {
                this.nextReduceInit = result;
            }
        }

        @Override
        public Object finishTraversal() {
            this.walker.onTraversalDone(this.intervalAccumulator);
            return this.intervalAccumulator;
        }
    }

    private static class StandardAccumulator
    extends Accumulator {
        private Object accumulator = null;
        private boolean initialized = false;

        protected StandardAccumulator(Walker walker) {
            super(walker);
        }

        @Override
        public Object getReduceInit() {
            if (!this.initialized) {
                this.initialized = true;
                return this.walker.reduceInit();
            }
            return this.accumulator;
        }

        @Override
        public void accumulate(ShardDataProvider provider, Object result) {
            this.accumulator = result;
        }

        @Override
        public Object finishTraversal() {
            this.walker.onTraversalDone(this.getReduceInit());
            return this.accumulator;
        }
    }
}

