/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.Chunk;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.PicardNamespaceUtils;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.RuntimeIOException;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.BAMAccessPlan;
import org.broadinstitute.sting.gatk.datasources.reads.BGZFBlockLoadingDispatcher;
import org.broadinstitute.sting.gatk.datasources.reads.BlockInputStream;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.IntervalOverlapFilteringIterator;
import org.broadinstitute.sting.gatk.datasources.reads.IntervalSharder;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardBalancer;
import org.broadinstitute.sting.gatk.filters.CountingFilteringIterator;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.iterators.DownsampleIterator;
import org.broadinstitute.sting.gatk.iterators.MalformedBAMErrorReformatingIterator;
import org.broadinstitute.sting.gatk.iterators.ReadFormattingIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIteratorAdapter;
import org.broadinstitute.sting.gatk.iterators.VerifyingSamIterator;
import org.broadinstitute.sting.gatk.resourcemanagement.ThreadAllocation;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.baq.BAQSamIterator;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.BQSRSamIterator;
import org.broadinstitute.sting.utils.recalibration.BaseRecalibration;
import org.broadinstitute.sting.utils.sam.GATKSamRecordFactory;

public class SAMDataSource {
    private static final GATKSamRecordFactory factory = new GATKSamRecordFactory();
    protected final ReadProperties readProperties;
    private final ReadMetrics readMetrics;
    protected final GenomeLocParser genomeLocParser;
    private final Collection<SAMReaderID> readerIDs;
    private final SAMFileReader.ValidationStringency validationStringency;
    private final Map<SAMReaderID, GATKBAMIndex> bamIndices = new HashMap<SAMReaderID, GATKBAMIndex>();
    private final Map<SAMReaderID, GATKBAMFileSpan> readerPositions = new HashMap<SAMReaderID, GATKBAMFileSpan>();
    private final SAMFileHeader mergedHeader;
    private final Map<SAMReaderID, SAMFileHeader> headers = new HashMap<SAMReaderID, SAMFileHeader>();
    private SAMFileHeader.SortOrder sortOrder = null;
    private final boolean hasReadGroupCollisions;
    private final ReadGroupMapping mergedToOriginalReadGroupMappings = new ReadGroupMapping();
    private final Map<SAMReaderID, ReadGroupMapping> originalToMergedReadGroupMappings = new HashMap<SAMReaderID, ReadGroupMapping>();
    private static Logger logger = Logger.getLogger(SAMDataSource.class);
    private final SAMResourcePool resourcePool;
    private final BGZFBlockLoadingDispatcher dispatcher;
    private final ThreadAllocation threadAllocation;

    public SAMDataSource(Collection<SAMReaderID> samFiles, ThreadAllocation threadAllocation, Integer numFileHandles, GenomeLocParser genomeLocParser) {
        this(samFiles, threadAllocation, numFileHandles, genomeLocParser, false, SAMFileReader.ValidationStringency.STRICT, null, null, new ValidationExclusion(), new ArrayList<ReadFilter>(), false);
    }

    public SAMDataSource(Collection<SAMReaderID> samFiles, ThreadAllocation threadAllocation, Integer numFileHandles, GenomeLocParser genomeLocParser, boolean useOriginalBaseQualities, SAMFileReader.ValidationStringency strictness, Integer readBufferSize, DownsamplingMethod downsamplingMethod, ValidationExclusion exclusionList, Collection<ReadFilter> supplementalFilters, boolean includeReadsWithDeletionAtLoci) {
        this(samFiles, threadAllocation, numFileHandles, genomeLocParser, useOriginalBaseQualities, strictness, readBufferSize, downsamplingMethod, exclusionList, supplementalFilters, includeReadsWithDeletionAtLoci, BAQ.CalculationMode.OFF, BAQ.QualityMode.DONT_MODIFY, null, null, -1);
    }

    public SAMDataSource(Collection<SAMReaderID> samFiles, ThreadAllocation threadAllocation, Integer numFileHandles, GenomeLocParser genomeLocParser, boolean useOriginalBaseQualities, SAMFileReader.ValidationStringency strictness, Integer readBufferSize, DownsamplingMethod downsamplingMethod, ValidationExclusion exclusionList, Collection<ReadFilter> supplementalFilters, boolean includeReadsWithDeletionAtLoci, BAQ.CalculationMode cmode, BAQ.QualityMode qmode, IndexedFastaSequenceFile refReader, BaseRecalibration bqsrApplier, byte defaultBaseQualities) {
        SAMFileReader reader;
        this.readMetrics = new ReadMetrics();
        this.genomeLocParser = genomeLocParser;
        this.readerIDs = samFiles;
        this.threadAllocation = threadAllocation;
        if (this.threadAllocation.getNumIOThreads() > 0) {
            logger.info((Object)("Running in asynchronous I/O mode; number of threads = " + this.threadAllocation.getNumIOThreads()));
            this.dispatcher = new BGZFBlockLoadingDispatcher(this.threadAllocation.getNumIOThreads(), numFileHandles != null ? numFileHandles : 1);
        } else {
            this.dispatcher = null;
        }
        this.validationStringency = strictness;
        if (readBufferSize != null) {
            ReadShard.setReadBufferSize(readBufferSize);
        } else {
            ReadShard.setReadBufferSize(Math.min(1000 * samFiles.size(), 250000));
        }
        this.resourcePool = new SAMResourcePool(Integer.MAX_VALUE);
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        for (SAMReaderID readerID : this.readerIDs) {
            SAMFileHeader.SortOrder sortOrder;
            if (!readerID.samFile.canRead()) {
                throw new UserException.CouldNotReadInputFile(readerID.samFile, "file is not present or user does not have appropriate permissions.  Please check that the file is present and readable and try again.");
            }
            reader = readers.getReader(readerID);
            SAMFileHeader header = reader.getFileHeader();
            this.headers.put(readerID, header);
            if (header.getReadGroups().isEmpty()) {
                throw new UserException.MalformedBAM(readers.getReaderID((SAMFileReader)reader).samFile, "SAM file doesn't have any read groups defined in the header.  The GATK no longer supports SAM files without read groups");
            }
            SAMFileHeader.SortOrder sortOrder2 = sortOrder = header.getSortOrder() != SAMFileHeader.SortOrder.unsorted ? header.getSortOrder() : SAMFileHeader.SortOrder.coordinate;
            if (this.sortOrder != null && this.sortOrder != sortOrder) {
                throw new UserException.MissortedBAM(String.format("Attempted to process mixed of files sorted as %s and %s.", this.sortOrder, sortOrder));
            }
            this.sortOrder = sortOrder;
        }
        this.initializeReaderPositions(readers);
        this.mergedHeader = readers.getMergedHeader();
        this.hasReadGroupCollisions = readers.hasReadGroupCollisions();
        this.readProperties = new ReadProperties(samFiles, this.mergedHeader, useOriginalBaseQualities, strictness, downsamplingMethod, exclusionList, supplementalFilters, includeReadsWithDeletionAtLoci, cmode, qmode, refReader, bqsrApplier, defaultBaseQualities);
        for (SAMReaderID id : this.readerIDs) {
            reader = readers.getReader(id);
            ReadGroupMapping mappingToMerged = new ReadGroupMapping();
            List readGroups = reader.getFileHeader().getReadGroups();
            for (SAMReadGroupRecord readGroup : readGroups) {
                if (this.hasReadGroupCollisions) {
                    mappingToMerged.put(readGroup.getReadGroupId(), readers.getReadGroupId(id, readGroup.getReadGroupId()));
                    this.mergedToOriginalReadGroupMappings.put(readers.getReadGroupId(id, readGroup.getReadGroupId()), readGroup.getReadGroupId());
                    continue;
                }
                mappingToMerged.put(readGroup.getReadGroupId(), readGroup.getReadGroupId());
                this.mergedToOriginalReadGroupMappings.put(readGroup.getReadGroupId(), readGroup.getReadGroupId());
            }
            this.originalToMergedReadGroupMappings.put(id, mappingToMerged);
        }
        for (SAMReaderID id : this.readerIDs) {
            File indexFile = this.findIndexFile(id.samFile);
            if (indexFile == null) continue;
            this.bamIndices.put(id, new GATKBAMIndex(indexFile));
        }
        this.resourcePool.releaseReaders(readers);
    }

    public ReadProperties getReadsInfo() {
        return this.readProperties;
    }

    public boolean isEmpty() {
        return this.readProperties.getSAMReaderIDs().size() == 0;
    }

    public File getSAMFile(SAMReaderID id) {
        return id.samFile;
    }

    public Collection<SAMReaderID> getReaderIDs() {
        return this.readerIDs;
    }

    public SAMReaderID getReaderID(SAMRecord read) {
        return this.resourcePool.getReaderID(read.getFileSource().getReader());
    }

    public Map<SAMReaderID, GATKBAMFileSpan> getCurrentPosition() {
        return this.readerPositions;
    }

    public SAMFileHeader getHeader() {
        return this.mergedHeader;
    }

    public SAMFileHeader getHeader(SAMReaderID id) {
        return this.headers.get(id);
    }

    public String getReadGroupId(SAMReaderID reader, String originalReadGroupId) {
        return (String)this.originalToMergedReadGroupMappings.get(reader).get(originalReadGroupId);
    }

    public String getOriginalReadGroupId(String mergedReadGroupId) {
        return (String)this.mergedToOriginalReadGroupMappings.get(mergedReadGroupId);
    }

    public boolean hasIndex() {
        return this.readerIDs.size() == this.bamIndices.size();
    }

    public GATKBAMIndex getIndex(SAMReaderID id) {
        return this.bamIndices.get(id);
    }

    public SAMFileHeader.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMetrics getCumulativeReadMetrics() {
        ReadMetrics readMetrics = this.readMetrics;
        synchronized (readMetrics) {
            return this.readMetrics.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incorporateReadMetrics(ReadMetrics readMetrics) {
        ReadMetrics readMetrics2 = this.readMetrics;
        synchronized (readMetrics2) {
            this.readMetrics.incrementMetrics(readMetrics);
        }
    }

    public void fillShard(Shard shard) {
        if (!shard.buffersReads()) {
            throw new ReviewedStingException("Attempting to fill a non-buffering shard.");
        }
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        SAMRecord read = null;
        IdentityHashMap<SAMFileReader, GATKBAMFileSpan> positionUpdates = new IdentityHashMap<SAMFileReader, GATKBAMFileSpan>();
        StingSAMIterator iterator = this.getIterator(readers, shard, this.sortOrder == SAMFileHeader.SortOrder.coordinate);
        while (!shard.isBufferFull() && iterator.hasNext()) {
            read = (SAMRecord)iterator.next();
            shard.addRead(read);
            this.noteFilePositionUpdate(positionUpdates, read);
        }
        if (this.sortOrder == SAMFileHeader.SortOrder.queryname) {
            while (iterator.hasNext()) {
                SAMRecord nextRead = (SAMRecord)iterator.next();
                if (read == null || !read.getReadName().equals(nextRead.getReadName())) break;
                shard.addRead(nextRead);
                this.noteFilePositionUpdate(positionUpdates, nextRead);
            }
        }
        iterator.close();
        for (Map.Entry positionUpdate : positionUpdates.entrySet()) {
            this.readerPositions.put(readers.getReaderID((SAMFileReader)positionUpdate.getKey()), (GATKBAMFileSpan)positionUpdate.getValue());
        }
    }

    private void noteFilePositionUpdate(Map<SAMFileReader, GATKBAMFileSpan> positionMapping, SAMRecord read) {
        GATKBAMFileSpan endChunk = new GATKBAMFileSpan(read.getFileSource().getFilePointer().getContentsFollowing());
        positionMapping.put(read.getFileSource().getReader(), endChunk);
    }

    public StingSAMIterator seek(Shard shard) {
        if (shard.buffersReads()) {
            return shard.iterator();
        }
        SAMReaders readers = this.resourcePool.getAvailableReaders();
        return this.getIterator(readers, shard, shard instanceof ReadShard);
    }

    private SAMReaderID getReaderID(SAMReaders readers, SAMRecord read) {
        for (SAMReaderID id : this.getReaderIDs()) {
            if (readers.getReader(id) != read.getFileSource().getReader()) continue;
            return id;
        }
        throw new ReviewedStingException("Unable to find id for reader associated with read " + read.getReadName());
    }

    private void initializeReaderPositions(SAMReaders readers) {
        for (SAMReaderID id : this.getReaderIDs()) {
            this.readerPositions.put(id, new GATKBAMFileSpan(readers.getReader(id).getFilePointerSpanningReads()));
        }
    }

    private StingSAMIterator getIterator(SAMReaders readers, Shard shard, boolean enableVerification) {
        HashMap<SAMFileReader, CloseableIterator<SAMRecord>> iteratorMap = new HashMap<SAMFileReader, CloseableIterator<SAMRecord>>();
        for (SAMReaderID id : this.getReaderIDs()) {
            Object iterator = null;
            if (shard.getFileSpans().get(id) == null) {
                throw new ReviewedStingException("SAMDataSource: received null location for reader " + id + ", but null locations are no longer supported.");
            }
            try {
                if (this.threadAllocation.getNumIOThreads() > 0) {
                    BlockInputStream inputStream = readers.getInputStream(id);
                    inputStream.submitAccessPlan(new BAMAccessPlan(id, inputStream, (GATKBAMFileSpan)shard.getFileSpans().get(id)));
                    BAMRecordCodec codec = new BAMRecordCodec(this.getHeader(id), (SAMRecordFactory)factory);
                    codec.setInputStream((InputStream)inputStream);
                    iterator = new BAMCodecIterator(inputStream, readers.getReader(id), codec);
                } else {
                    iterator = readers.getReader(id).iterator(shard.getFileSpans().get(id));
                }
            }
            catch (RuntimeException e) {
                throw new UserException.MalformedBAM(id.samFile, e.getMessage());
            }
            iterator = new MalformedBAMErrorReformatingIterator(id.samFile, (CloseableIterator<SAMRecord>)iterator);
            if (shard.getGenomeLocs().size() > 0) {
                iterator = new IntervalOverlapFilteringIterator((CloseableIterator<SAMRecord>)iterator, shard.getGenomeLocs());
            }
            iteratorMap.put(readers.getReader(id), (CloseableIterator<SAMRecord>)iterator);
        }
        MergingSamRecordIterator mergingIterator = readers.createMergingIterator(iteratorMap);
        return this.applyDecoratingIterators(shard.getReadMetrics(), enableVerification, this.readProperties.useOriginalBaseQualities(), new ReleasingIterator(readers, StingSAMIteratorAdapter.adapt((CloseableIterator<SAMRecord>)mergingIterator)), this.readProperties.getDownsamplingMethod().toFraction, this.readProperties.getValidationExclusionList().contains(ValidationExclusion.TYPE.NO_READ_ORDER_VERIFICATION), this.readProperties.getSupplementalFilters(), this.readProperties.getBAQCalculationMode(), this.readProperties.getBAQQualityMode(), this.readProperties.getRefReader(), this.readProperties.getBQSRApplier(), this.readProperties.defaultBaseQualities());
    }

    protected StingSAMIterator applyDecoratingIterators(ReadMetrics readMetrics, boolean enableVerification, boolean useOriginalBaseQualities, StingSAMIterator wrappedIterator, Double downsamplingFraction, Boolean noValidationOfReadOrder, Collection<ReadFilter> supplementalFilters, BAQ.CalculationMode cmode, BAQ.QualityMode qmode, IndexedFastaSequenceFile refReader, BaseRecalibration bqsrApplier, byte defaultBaseQualities) {
        if (useOriginalBaseQualities || defaultBaseQualities >= 0) {
            wrappedIterator = new ReadFormattingIterator(wrappedIterator, useOriginalBaseQualities, defaultBaseQualities);
        }
        if (downsamplingFraction != null) {
            wrappedIterator = new DownsampleIterator(wrappedIterator, downsamplingFraction);
        }
        if (!noValidationOfReadOrder.booleanValue() && enableVerification) {
            wrappedIterator = new VerifyingSamIterator(this.genomeLocParser, wrappedIterator);
        }
        if (bqsrApplier != null) {
            wrappedIterator = new BQSRSamIterator(wrappedIterator, bqsrApplier);
        }
        if (cmode != BAQ.CalculationMode.OFF) {
            wrappedIterator = new BAQSamIterator(refReader, wrappedIterator, cmode, qmode);
        }
        wrappedIterator = StingSAMIteratorAdapter.adapt(new CountingFilteringIterator(readMetrics, (Iterator<SAMRecord>)((Object)wrappedIterator), supplementalFilters));
        return wrappedIterator;
    }

    private File findIndexFile(File bamFile) {
        File indexFile;
        try {
            Class<?> bamFileReaderClass = Class.forName("net.sf.samtools.BAMFileReader");
            Method indexFileLocator = bamFileReaderClass.getDeclaredMethod("findIndexFile", File.class);
            indexFileLocator.setAccessible(true);
            indexFile = (File)indexFileLocator.invoke(null, bamFile);
        }
        catch (ClassNotFoundException ex) {
            throw new ReviewedStingException("Unable to locate BAMFileReader class, used to check for index files");
        }
        catch (NoSuchMethodException ex) {
            throw new ReviewedStingException("Unable to locate Picard index file locator.");
        }
        catch (IllegalAccessException ex) {
            throw new ReviewedStingException("Unable to access Picard index file locator.");
        }
        catch (InvocationTargetException ex) {
            throw new ReviewedStingException("Unable to invoke Picard index file locator.");
        }
        return indexFile;
    }

    public Iterable<Shard> createShardIteratorOverAllReads(ShardBalancer shardBalancer) {
        shardBalancer.initialize(this, IntervalSharder.shardOverAllReads(this, this.genomeLocParser), this.genomeLocParser);
        return shardBalancer;
    }

    public Iterable<Shard> createShardIteratorOverMappedReads(SAMSequenceDictionary sequenceDictionary, ShardBalancer shardBalancer) {
        shardBalancer.initialize(this, IntervalSharder.shardOverMappedReads(this, sequenceDictionary, this.genomeLocParser), this.genomeLocParser);
        return shardBalancer;
    }

    public Iterable<Shard> createShardIteratorOverIntervals(GenomeLocSortedSet intervals, ShardBalancer shardBalancer) {
        if (intervals == null) {
            throw new ReviewedStingException("Unable to create schedule from intervals; no intervals were provided.");
        }
        shardBalancer.initialize(this, IntervalSharder.shardOverIntervals(this, intervals), this.genomeLocParser);
        return shardBalancer;
    }

    private class ReadGroupMapping
    extends HashMap<String, String> {
        private ReadGroupMapping() {
        }
    }

    private class ReleasingIterator
    implements StingSAMIterator {
        private final SAMReaders resource;
        private final StingSAMIterator wrappedIterator;

        public ReleasingIterator(SAMReaders resource, StingSAMIterator wrapped) {
            this.resource = resource;
            this.wrappedIterator = wrapped;
        }

        public ReleasingIterator iterator() {
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove from a StingSAMIterator");
        }

        public void close() {
            this.wrappedIterator.close();
            SAMDataSource.this.resourcePool.releaseReaders(this.resource);
        }

        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        public SAMRecord next() {
            return (SAMRecord)this.wrappedIterator.next();
        }
    }

    class ReaderInitializer
    implements Callable<ReaderInitializer> {
        final SAMReaderID readerID;
        BlockInputStream blockInputStream = null;
        SAMFileReader reader;

        public ReaderInitializer(SAMReaderID readerID) {
            this.readerID = readerID;
        }

        @Override
        public ReaderInitializer call() {
            File indexFile = SAMDataSource.this.findIndexFile(this.readerID.samFile);
            try {
                if (SAMDataSource.this.threadAllocation.getNumIOThreads() > 0) {
                    this.blockInputStream = new BlockInputStream(SAMDataSource.this.dispatcher, this.readerID, false);
                }
                this.reader = new SAMFileReader(this.readerID.samFile, indexFile, false);
            }
            catch (RuntimeIOException e) {
                throw new UserException.CouldNotReadInputFile(this.readerID.samFile, (Exception)((Object)e));
            }
            catch (SAMFormatException e) {
                throw new UserException.MalformedBAM(this.readerID.samFile, e.getMessage());
            }
            this.reader.setSAMRecordFactory((SAMRecordFactory)factory);
            this.reader.enableFileSource(true);
            this.reader.setValidationStringency(SAMDataSource.this.validationStringency);
            return this;
        }
    }

    private class SAMReaders
    implements Iterable<SAMFileReader> {
        private final SamFileHeaderMerger headerMerger;
        private final Map<SAMReaderID, SAMFileReader> readers = new LinkedHashMap<SAMReaderID, SAMFileReader>();
        private final Map<SAMReaderID, BlockInputStream> inputStreams = new LinkedHashMap<SAMReaderID, BlockInputStream>();

        public SAMReaders(Collection<SAMReaderID> readerIDs, SAMFileReader.ValidationStringency validationStringency) {
            int totalNumberOfFiles = readerIDs.size();
            int readerNumber = 1;
            SimpleTimer timer = new SimpleTimer().start();
            if (totalNumberOfFiles > 0) {
                logger.info((Object)"Initializing SAMRecords in serial");
            }
            int tickSize = 50;
            int nExecutedTotal = 0;
            long lastTick = timer.currentTime();
            for (SAMReaderID readerID : readerIDs) {
                ReaderInitializer init = new ReaderInitializer(readerID).call();
                if (SAMDataSource.this.threadAllocation.getNumIOThreads() > 0) {
                    this.inputStreams.put(init.readerID, init.blockInputStream);
                }
                logger.debug((Object)String.format("Processing file (%d of %d) %s...", readerNumber++, totalNumberOfFiles, readerID.samFile));
                this.readers.put(init.readerID, init.reader);
                if (++nExecutedTotal % 50 != 0) continue;
                double tickInSec = (double)(timer.currentTime() - lastTick) / 1000.0;
                this.printReaderPerformance(nExecutedTotal, 50, totalNumberOfFiles, timer, tickInSec);
                lastTick = timer.currentTime();
            }
            if (totalNumberOfFiles > 0) {
                logger.info((Object)String.format("Done initializing BAM readers: total time %.2f", timer.getElapsedTime()));
            }
            LinkedList<SAMFileHeader> headers = new LinkedList<SAMFileHeader>();
            for (SAMFileReader reader : this.readers.values()) {
                headers.add(reader.getFileHeader());
            }
            this.headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, true);
        }

        private final void printReaderPerformance(int nExecutedTotal, int nExecutedInTick, int totalNumberOfFiles, SimpleTimer timer, double tickDurationInSec) {
            int pendingSize = totalNumberOfFiles - nExecutedTotal;
            double totalTimeInSeconds = timer.getElapsedTime();
            double nTasksPerSecond = (double)nExecutedTotal / (1.0 * totalTimeInSeconds);
            int nRemaining = pendingSize;
            double estTimeToComplete = (double)pendingSize / nTasksPerSecond;
            logger.info((Object)String.format("Init %d BAMs in last %.2f s, %d of %d in %.2f s / %.2f m (%.2f tasks/s).  %d remaining with est. completion in %.2f s / %.2f m", nExecutedInTick, tickDurationInSec, nExecutedTotal, totalNumberOfFiles, totalTimeInSeconds, totalTimeInSeconds / 60.0, nTasksPerSecond, nRemaining, estTimeToComplete, estTimeToComplete / 60.0));
        }

        public SAMFileHeader getMergedHeader() {
            return this.headerMerger.getMergedHeader();
        }

        public boolean hasReadGroupCollisions() {
            return this.headerMerger.hasReadGroupCollisions();
        }

        public String getReadGroupId(SAMReaderID readerID, String originalReadGroupID) {
            SAMFileHeader header = this.readers.get(readerID).getFileHeader();
            return this.headerMerger.getReadGroupId(header, originalReadGroupID);
        }

        public MergingSamRecordIterator createMergingIterator(Map<SAMFileReader, CloseableIterator<SAMRecord>> iteratorMap) {
            return new MergingSamRecordIterator(this.headerMerger, iteratorMap, true);
        }

        public SAMFileReader getReader(SAMReaderID id) {
            if (!this.readers.containsKey(id)) {
                throw new NoSuchElementException("No reader is associated with id " + id);
            }
            return this.readers.get(id);
        }

        public BlockInputStream getInputStream(SAMReaderID id) {
            return this.inputStreams.get(id);
        }

        protected SAMReaderID getReaderID(SAMFileReader reader) {
            for (Map.Entry<SAMReaderID, SAMFileReader> entry : this.readers.entrySet()) {
                if (reader != entry.getValue()) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<SAMFileReader> iterator() {
            return this.readers.values().iterator();
        }

        public boolean isEmpty() {
            return this.readers.isEmpty();
        }
    }

    private class SAMResourcePool {
        private final int maxEntries;
        private List<SAMReaders> allResources = new ArrayList<SAMReaders>();
        private List<SAMReaders> availableResources = new ArrayList<SAMReaders>();

        public SAMResourcePool(int maxEntries) {
            this.maxEntries = maxEntries;
        }

        public synchronized SAMReaders getAvailableReaders() {
            if (this.availableResources.size() == 0) {
                this.createNewResource();
            }
            SAMReaders readers = this.availableResources.get(0);
            this.availableResources.remove(readers);
            return readers;
        }

        public synchronized void releaseReaders(SAMReaders readers) {
            if (!this.allResources.contains(readers)) {
                throw new ReviewedStingException("Tried to return readers from the pool that didn't originate in the pool.");
            }
            this.availableResources.add(readers);
        }

        protected synchronized SAMReaderID getReaderID(SAMFileReader reader) {
            for (SAMReaders readers : this.allResources) {
                SAMReaderID id = readers.getReaderID(reader);
                if (id == null) continue;
                return id;
            }
            throw new ReviewedStingException("No such reader id is available");
        }

        private synchronized void createNewResource() {
            if (this.allResources.size() > this.maxEntries) {
                throw new ReviewedStingException("Cannot create a new resource pool.  All resources are in use.");
            }
            SAMReaders readers = new SAMReaders(SAMDataSource.this.readerIDs, SAMDataSource.this.validationStringency);
            this.allResources.add(readers);
            this.availableResources.add(readers);
        }
    }

    private class BAMCodecIterator
    implements CloseableIterator<SAMRecord> {
        private final BlockInputStream inputStream;
        private final SAMFileReader reader;
        private final BAMRecordCodec codec;
        private SAMRecord nextRead;

        private BAMCodecIterator(BlockInputStream inputStream, SAMFileReader reader, BAMRecordCodec codec) {
            this.inputStream = inputStream;
            this.reader = reader;
            this.codec = codec;
            this.advance();
        }

        public boolean hasNext() {
            return this.nextRead != null;
        }

        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Unable to retrieve next record from BAMCodecIterator; input stream is empty");
            }
            SAMRecord currentRead = this.nextRead;
            this.advance();
            return currentRead;
        }

        public void close() {
        }

        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from BAMCodecIterator");
        }

        private void advance() {
            long startCoordinate = this.inputStream.getFilePointer();
            this.nextRead = this.codec.decode();
            long stopCoordinate = this.inputStream.getFilePointer();
            if (this.reader != null && this.nextRead != null) {
                PicardNamespaceUtils.setFileSource((SAMRecord)this.nextRead, (SAMFileSource)new SAMFileSource(this.reader, (SAMFileSpan)new GATKBAMFileSpan((Chunk)new GATKChunk(startCoordinate, stopCoordinate))));
            }
        }
    }
}

