/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArray;
import org.broadinstitute.sting.alignment.reference.packing.UnsignedIntPackedOutputStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class SuffixArrayWriter {
    private OutputStream outputStream;

    public SuffixArrayWriter(File outputFile) {
        try {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (FileNotFoundException ex) {
            throw new ReviewedStingException("Unable to open input file", (Throwable)ex);
        }
    }

    public void write(SuffixArray suffixArray) {
        UnsignedIntPackedOutputStream uintPackedOutputStream = new UnsignedIntPackedOutputStream(this.outputStream, ByteOrder.LITTLE_ENDIAN);
        try {
            uintPackedOutputStream.write(suffixArray.inverseSA0);
            uintPackedOutputStream.write(suffixArray.occurrences.toArray(true));
            uintPackedOutputStream.write(1L);
            uintPackedOutputStream.write(suffixArray.length() - 1L);
            uintPackedOutputStream.write(suffixArray.sequence, 1, suffixArray.sequence.length - 1);
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to read BWT from input stream.", (Throwable)ex);
        }
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to close input file", (Throwable)ex);
        }
    }
}

