/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.alignment.reference.bwt.Bases;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class Counts
implements Cloneable {
    private Map<Byte, Long> counts = new HashMap<Byte, Long>();
    private Map<Byte, Long> cumulativeCounts = new HashMap<Byte, Long>();

    public Counts() {
        for (byte base : Bases.instance) {
            this.counts.put(base, 0L);
            this.cumulativeCounts.put(base, 0L);
        }
    }

    public Counts(long[] data, boolean cumulative) {
        if (cumulative) {
            long priorCount = 0L;
            for (byte base : Bases.instance) {
                long count = data[Bases.toPack(base)];
                this.counts.put(base, count - priorCount);
                this.cumulativeCounts.put(base, priorCount);
                priorCount = count;
            }
        } else {
            long priorCount = 0L;
            for (byte base : Bases.instance) {
                long count = data[Bases.toPack(base)];
                this.counts.put(base, count);
                this.cumulativeCounts.put(base, priorCount);
                priorCount += count;
            }
        }
    }

    public long[] toArray(boolean cumulative) {
        long[] countArray = new long[this.counts.size()];
        if (cumulative) {
            int index = 0;
            boolean first = true;
            for (byte base : Bases.instance) {
                if (first) {
                    first = false;
                    continue;
                }
                countArray[index++] = this.getCumulative(base);
            }
            countArray[countArray.length - 1] = this.getTotal();
        } else {
            int index = 0;
            for (byte base : Bases.instance) {
                countArray[index++] = this.counts.get(base);
            }
        }
        return countArray;
    }

    public Counts clone() {
        Counts other;
        try {
            other = (Counts)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ReviewedStingException("Unable to clone counts object", (Throwable)ex);
        }
        other.counts = new HashMap<Byte, Long>(this.counts);
        other.cumulativeCounts = new HashMap<Byte, Long>(this.cumulativeCounts);
        return other;
    }

    public void increment(byte base) {
        this.counts.put(base, this.counts.get(base) + 1L);
        boolean increment = false;
        for (byte cumulative : Bases.instance) {
            if (increment) {
                this.cumulativeCounts.put(cumulative, this.cumulativeCounts.get(cumulative) + 1L);
            }
            increment |= cumulative == base;
        }
    }

    public long get(byte base) {
        return this.counts.get(base);
    }

    public long getCumulative(byte base) {
        return this.cumulativeCounts.get(base);
    }

    public long getTotal() {
        int accumulator = 0;
        for (byte base : Bases.instance) {
            accumulator = (int)((long)accumulator + this.get(base));
        }
        return accumulator;
    }
}

