/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.picard.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;

public class PicardFileSystemUtil {
    private static final Log log = Log.getInstance(PicardFileSystemUtil.class);
    public static final String SOLEXA_IC = "Solexa-IC";
    private static final Pattern ANALYSIS_DIR_PATTERN = Pattern.compile("C([0-9]+-[0-9]+)_([0-9]{4}-[0-9]{2}-[0-9]{2})_([0-9]{4}-[0-9]{2}-[0-9]{2})");
    private static final String ANALYSIS_DIR_DATE_FORMAT = "yyyy-MM-dd";
    private File startingPoint = new File("/seq/picard");
    private File aggregationStartingPoint = new File("/seq/picard_aggregation");
    private static List<String> IGNORES = Arrays.asList("by_project", "old_by_project");
    private static final String AGGREGATION_PENDING_DIR = ".pending_aggregations";

    public File getStartingPoint() {
        return this.startingPoint;
    }

    public void setStartingPoint(File startingPoint) {
        this.startingPoint = startingPoint;
    }

    public File getAggregationStartingPoint() {
        return this.aggregationStartingPoint;
    }

    public void setAggregationStartingPoint(File aggregationStartingPoint) {
        this.aggregationStartingPoint = aggregationStartingPoint;
    }

    public File getAggregationPendingDirectory() {
        return new File(this.aggregationStartingPoint, AGGREGATION_PENDING_DIR);
    }

    public Date getRunDateFromAnalysisDir(File analysisDir) {
        return this.getDateFromAnalysisDir(1, analysisDir);
    }

    public Date getAnalysisDateFromAnalysisDir(File analysisDir) {
        return this.getDateFromAnalysisDir(2, analysisDir);
    }

    private Date getDateFromAnalysisDir(int tokenNumber, File analysisDir) {
        Date date = null;
        SimpleDateFormat simpleFormat = new SimpleDateFormat(ANALYSIS_DIR_DATE_FORMAT);
        String[] tokens = analysisDir.getName().split("_");
        if (tokens.length < 3) {
            return null;
        }
        try {
            date = simpleFormat.parse(tokens[tokenNumber]);
        }
        catch (ParseException pExc) {
            date = null;
        }
        return date;
    }

    public File[] findFlowcellAnalysisFiles(FileFilter filter) {
        return this.findFlowcellAnalysisFiles(filter, true);
    }

    public File[] findFlowcellAnalysisFiles(FileFilter filter, boolean latestOnly) {
        ArrayList<File> results = new ArrayList<File>();
        for (File flowcell : this.findFlowcellDirectories()) {
            for (File analysis : this.findLibraryAnalysisDirectories(flowcell, latestOnly)) {
                for (File file : analysis.listFiles(filter)) {
                    results.add(file);
                }
            }
        }
        return this.asArray(results);
    }

    public File[] findFlowcellDirectories() {
        return this.startingPoint.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File parent, String name) {
                return !IGNORES.contains(name) && !name.startsWith(".");
            }
        });
    }

    public File[] findLaneDirectories(File flowcellAnalysisDir) {
        return flowcellAnalysisDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !"info".equals(file.getName());
            }
        });
    }

    public File[] findLibraryAnalysisDirectories(File flowcell, boolean latestOnly) {
        File[] analysisDirectories = this.findFlowcellAnalysisDirectories(flowcell, latestOnly);
        return this.findLibraryAnalysisDirectories(analysisDirectories);
    }

    public File[] findLibraryAnalysisDirectories(File ... flowcellAnalysisDirectory) {
        ArrayList<File> libraryDirectories = new ArrayList<File>();
        for (File analysis : flowcellAnalysisDirectory) {
            File[] lanes = this.findLaneDirectories(analysis);
            for (File lib : this.findLibraryAnalysisDirectoriesByLane(lanes)) {
                libraryDirectories.add(lib);
            }
        }
        return this.asArray(libraryDirectories);
    }

    public File[] findLibraryAnalysisDirectoriesByLane(File ... lanes) {
        ArrayList<File> libraryDirectories = new ArrayList<File>();
        for (File lane : lanes) {
            File[] libraries = lane.listFiles();
            if (libraries == null) continue;
            for (File library : libraries) {
                if (!library.isDirectory() || library.getName().startsWith(".")) continue;
                libraryDirectories.add(library);
            }
        }
        return this.asArray(libraryDirectories);
    }

    public File[] findFlowcellAnalysisDirectories(File flowcell, boolean latestOnly) {
        File[] analysisDirectories = flowcell.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File parent, String name) {
                return ANALYSIS_DIR_PATTERN.matcher(name).matches();
            }
        });
        if (latestOnly && flowcell.isDirectory()) {
            File latest = null;
            for (File analysis : analysisDirectories) {
                if (latest == null) {
                    latest = analysis;
                    continue;
                }
                Matcher m1 = ANALYSIS_DIR_PATTERN.matcher(latest.getName());
                Matcher m2 = ANALYSIS_DIR_PATTERN.matcher(analysis.getName());
                if (!m1.matches() || !m2.matches()) {
                    throw new IllegalStateException("Analysis directory didn't match pattern.");
                }
                if (m2.group(3).compareTo(m1.group(3)) <= 0) continue;
                latest = analysis;
            }
            if (latest != null) {
                analysisDirectories = new File[]{latest};
            } else {
                return new File[0];
            }
        }
        return analysisDirectories;
    }

    public File[] findParamsFiles(File flowcell, boolean latestOnly) {
        File[] libraryDirectories = this.findLibraryAnalysisDirectories(flowcell, latestOnly);
        ArrayList<File> params = new ArrayList<File>();
        for (File dir : libraryDirectories) {
            File tmp = new File(dir, "params.txt");
            if (!tmp.exists()) continue;
            params.add(tmp);
        }
        return this.asArray(params);
    }

    public File[] findParamsFiles(File ... laneDirectories) {
        throw new UnsupportedOperationException("findParamsFiles on an array of laneDirectories is not supported!  This previously returned null.");
    }

    public List<File> findAllParamsFiles(File analysisDir) {
        ArrayList<File> results = new ArrayList<File>();
        File[] laneDirs = this.findLaneDirectories(analysisDir);
        Object params = null;
        for (File laneDir : laneDirs) {
            File[] libDirs;
            for (File dir : libDirs = this.findLibraryAnalysisDirectoriesByLane(laneDir)) {
                File tmp = new File(dir, "params.txt");
                if (!tmp.exists()) continue;
                results.add(tmp);
            }
        }
        return results;
    }

    public File findAnyParamsFile(File analysisDir) {
        File[] laneDirs = this.findLaneDirectories(analysisDir);
        File params = null;
        block0: for (File laneDir : laneDirs) {
            File[] libDirs;
            for (File dir : libDirs = this.findLibraryAnalysisDirectoriesByLane(laneDir)) {
                File tmp = new File(dir, "params.txt");
                if (!tmp.exists()) continue;
                params = tmp;
                continue block0;
            }
        }
        return params;
    }

    public File findParamsFile(File libDirectory) {
        File params = new File(libDirectory, "params.txt");
        if (params.exists()) {
            return params;
        }
        return null;
    }

    private File[] asArray(List<File> files) {
        return files.toArray(new File[files.size()]);
    }

    public int getLatestAggregationVersion(String project, String sampleAlias) {
        int maxVersion = 0;
        File dir = new File(this.getAggregationStartingPoint().getAbsolutePath() + "/" + project + "/" + IoUtil.makeFileNameSafe((String)sampleAlias));
        if (!dir.exists()) {
            return maxVersion;
        }
        for (File f : dir.listFiles()) {
            int ver;
            if (!f.isDirectory() || !f.getName().startsWith("v") || (ver = Integer.parseInt(f.getName().substring(1))) <= maxVersion) continue;
            maxVersion = ver;
        }
        return maxVersion;
    }

    public File getLatestAggregationDirectory(String project, String sampleAlias) {
        int maxVersion = this.getLatestAggregationVersion(project, sampleAlias);
        if (maxVersion > 0) {
            return new File(this.getAggregationStartingPoint().getAbsolutePath() + "/" + project + "/" + IoUtil.makeFileNameSafe((String)sampleAlias) + "/v" + maxVersion);
        }
        return null;
    }
}

