/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.internal.Double3NTTConvolutionStrategy;
import org.apfloat.internal.DoubleKaratsubaConvolutionStrategy;
import org.apfloat.internal.DoubleMediumConvolutionStrategy;
import org.apfloat.internal.DoubleShortConvolutionStrategy;
import org.apfloat.spi.ConvolutionBuilder;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.NTTBuilder;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleConvolutionBuilder
implements ConvolutionBuilder {
    private static final double LOG2_3 = Math.log(3.0) / Math.log(2.0);

    public ConvolutionStrategy createConvolution(int radix, long size1, long size2, long resultSize) {
        float nttCost;
        long minSize = Math.min(size1, size2);
        long maxSize = Math.max(size1, size2);
        long totalSize = size1 + size2;
        if (minSize == 1L) {
            return new DoubleShortConvolutionStrategy(radix);
        }
        if (minSize <= 15L) {
            return new DoubleMediumConvolutionStrategy(radix);
        }
        float mediumCost = (float)minSize * (float)maxSize;
        float karatsubaCost = 4.3f * (float)Math.pow(minSize, LOG2_3) * (float)maxSize / (float)minSize;
        if (mediumCost <= Math.min(karatsubaCost, nttCost = 6.2f * (float)totalSize * (float)Util.log2down(totalSize))) {
            return new DoubleMediumConvolutionStrategy(radix);
        }
        if (karatsubaCost <= nttCost) {
            return new DoubleKaratsubaConvolutionStrategy(radix);
        }
        ApfloatContext ctx = ApfloatContext.getContext();
        NTTBuilder nttBuilder = ctx.getBuilderFactory().getNTTBuilder();
        NTTStrategy transform2 = nttBuilder.createNTT(totalSize);
        return new Double3NTTConvolutionStrategy(radix, transform2);
    }
}

