/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ToCanonical {
    static Configuration config = Configuration.getDefaultConfiguration();

    public static void main(String[] args) {
        config.setWhitespaceStripping(false);
        if (args.length == 0) {
            ToCanonical.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            File f2 = new File(args[i]);
            if (!f2.exists()) {
                System.err.println("File " + f2 + " doesn't exist.");
            }
            try {
                ToCanonical.convertFile(f2);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error converting file: " + f2);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void convertFile(File f2) throws IOException {
        File fullPath = f2.getAbsoluteFile();
        File dir = fullPath.getParentFile();
        String filename = fullPath.getName();
        File convertedFile = new File(dir, filename + ".canonical");
        config.setDirectoryForTemplateLoading(dir);
        Template template = config.getTemplate(filename);
        FileWriter output2 = new FileWriter(convertedFile);
        try {
            template.dump(output2);
        }
        finally {
            output2.close();
        }
    }

    static void usage() {
        System.err.println("Usage: java freemarker.template.utility.ToCanonical <filename(s)>");
    }
}

