/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jdom;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Collections12;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class NodeListModel
implements TemplateHashModel,
TemplateMethodModel,
TemplateCollectionModel,
TemplateSequenceModel,
TemplateScalarModel {
    private static final AttributeXMLOutputter OUTPUT = new AttributeXMLOutputter();
    private static final NodeListModel EMPTY = new NodeListModel(null, false);
    private static final Map XPATH_CACHE = new WeakHashMap();
    private static final NamedNodeOperator NAMED_CHILDREN_OP = new NamedChildrenOp();
    private static final NamedNodeOperator NAMED_ATTRIBUTE_OP = new NamedAttributeOp();
    private static final NodeOperator ALL_ATTRIBUTES_OP = new AllAttributesOp();
    private static final NodeOperator ALL_CHILDREN_OP = new AllChildrenOp();
    private static final Map OPERATIONS = NodeListModel.createOperations();
    private static final Map SPECIAL_OPERATIONS = NodeListModel.createSpecialOperations();
    private static final int SPECIAL_OPERATION_COPY = 0;
    private static final int SPECIAL_OPERATION_UNIQUE = 1;
    private static final int SPECIAL_OPERATION_FILTER_NAME = 2;
    private static final int SPECIAL_OPERATION_FILTER_TYPE = 3;
    private static final int SPECIAL_OPERATION_QUERY_TYPE = 4;
    private static final int SPECIAL_OPERATION_REGISTER_NAMESPACE = 5;
    private static final int SPECIAL_OPERATION_PLAINTEXT = 6;
    private final List nodes;
    private final Map namespaces;

    public NodeListModel(Document document2) {
        this.nodes = document2 == null ? Collections.EMPTY_LIST : Collections12.singletonList(document2);
        this.namespaces = new HashMap();
    }

    public NodeListModel(Element element) {
        this.nodes = element == null ? Collections.EMPTY_LIST : Collections12.singletonList(element);
        this.namespaces = new HashMap();
    }

    private NodeListModel(Object object, Map namespaces) {
        this.nodes = object == null ? Collections.EMPTY_LIST : Collections12.singletonList(object);
        this.namespaces = namespaces;
    }

    public NodeListModel(List nodes) {
        this(nodes, true);
    }

    public NodeListModel(List nodes, boolean copy) {
        this.nodes = copy && nodes != null ? new ArrayList(nodes) : (nodes == null ? Collections.EMPTY_LIST : nodes);
        this.namespaces = new HashMap();
    }

    private NodeListModel(List nodes, Map namespaces) {
        this.nodes = nodes == null ? Collections.EMPTY_LIST : nodes;
        this.namespaces = namespaces;
    }

    private static final NodeListModel createNodeListModel(List list2, Map namespaces) {
        if (list2 == null || list2.isEmpty()) {
            if (namespaces.isEmpty()) {
                return EMPTY;
            }
            return new NodeListModel(Collections.EMPTY_LIST, namespaces);
        }
        if (list2.size() == 1) {
            return new NodeListModel(list2.get(0), namespaces);
        }
        return new NodeListModel(list2, namespaces);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public String getAsString() throws TemplateModelException {
        if (this.isEmpty()) {
            return "";
        }
        StringWriter sw = new StringWriter(this.nodes.size() * 128);
        try {
            Iterator i = this.nodes.iterator();
            while (i.hasNext()) {
                Object node = i.next();
                if (node instanceof Element) {
                    OUTPUT.output((Element)node, sw);
                    continue;
                }
                if (node instanceof Attribute) {
                    OUTPUT.output((Attribute)node, sw);
                    continue;
                }
                if (node instanceof String) {
                    sw.write(OUTPUT.escapeElementEntities(node.toString()));
                    continue;
                }
                if (node instanceof Text) {
                    OUTPUT.output((Text)node, sw);
                    continue;
                }
                if (node instanceof Document) {
                    OUTPUT.output((Document)node, sw);
                    continue;
                }
                if (node instanceof ProcessingInstruction) {
                    OUTPUT.output((ProcessingInstruction)node, sw);
                    continue;
                }
                if (node instanceof Comment) {
                    OUTPUT.output((Comment)node, sw);
                    continue;
                }
                if (node instanceof CDATA) {
                    OUTPUT.output((CDATA)node, sw);
                    continue;
                }
                if (node instanceof DocType) {
                    OUTPUT.output((DocType)node, sw);
                    continue;
                }
                if (node instanceof EntityRef) {
                    OUTPUT.output((EntityRef)node, sw);
                    continue;
                }
                throw new TemplateModelException(node.getClass().getName() + " is not a core JDOM class");
            }
        }
        catch (IOException e) {
            throw new TemplateModelException(e.getMessage());
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModel get(String key) throws TemplateModelException {
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (key == null || key.length() == 0) {
            throw new TemplateModelException("Invalid key [" + key + "]");
        }
        NodeOperator op = null;
        NamedNodeOperator nop = null;
        String name = null;
        switch (key.charAt(0)) {
            case '@': {
                if (key.length() != 2 || key.charAt(1) != '*') {
                    nop = NAMED_ATTRIBUTE_OP;
                    name = key.substring(1);
                    break;
                }
                op = ALL_ATTRIBUTES_OP;
                break;
            }
            case '*': {
                if (key.length() == 1) {
                    op = ALL_CHILDREN_OP;
                    break;
                }
                throw new TemplateModelException("Invalid key [" + key + "]");
            }
            case '_': 
            case 'x': {
                Integer specop;
                op = (NodeOperator)OPERATIONS.get(key);
                if (op != null || (specop = (Integer)SPECIAL_OPERATIONS.get(key)) == null) break;
                switch (specop) {
                    case 0: {
                        Map map2 = this.namespaces;
                        synchronized (map2) {
                            return new NodeListModel(this.nodes, (Map)((HashMap)this.namespaces).clone());
                        }
                    }
                    case 1: {
                        return new NodeListModel(NodeListModel.removeDuplicates(this.nodes), this.namespaces);
                    }
                    case 2: {
                        return new NameFilter();
                    }
                    case 3: {
                        return new TypeFilter();
                    }
                    case 4: {
                        return this.getType();
                    }
                    case 5: {
                        return new RegisterNamespace();
                    }
                    case 6: {
                        return this.getPlainText();
                    }
                }
            }
        }
        if (op == null && nop == null) {
            nop = NAMED_CHILDREN_OP;
            name = key;
        }
        List list2 = null;
        if (op != null) {
            list2 = NodeListModel.evaluateElementOperation(op, this.nodes);
        } else {
            String localName = name;
            Namespace namespace = Namespace.NO_NAMESPACE;
            int colon2 = name.indexOf(58);
            if (colon2 != -1) {
                localName = name.substring(colon2 + 1);
                String nsPrefix = name.substring(0, colon2);
                Map map3 = this.namespaces;
                synchronized (map3) {
                    namespace = (Namespace)this.namespaces.get(nsPrefix);
                }
                if (namespace == null) {
                    if (nsPrefix.equals("xml")) {
                        namespace = Namespace.XML_NAMESPACE;
                    } else {
                        throw new TemplateModelException("Unregistered namespace prefix '" + nsPrefix + "'");
                    }
                }
            }
            list2 = NodeListModel.evaluateNamedElementOperation(nop, localName, namespace, this.nodes);
        }
        return NodeListModel.createNodeListModel(list2, this.namespaces);
    }

    private TemplateModel getType() {
        if (this.nodes.size() == 0) {
            return new SimpleScalar("");
        }
        Object firstNode = this.nodes.get(0);
        char code = firstNode instanceof Element ? (char)'e' : (firstNode instanceof Text || firstNode instanceof String ? (char)'x' : (firstNode instanceof Attribute ? (char)'a' : (firstNode instanceof EntityRef ? (char)'n' : (firstNode instanceof Document ? (char)'d' : (firstNode instanceof DocType ? (char)'t' : (firstNode instanceof Comment ? (char)'c' : (firstNode instanceof ProcessingInstruction ? (char)'p' : '?')))))));
        return new SimpleScalar(new String(new char[]{code}));
    }

    private SimpleScalar getPlainText() throws TemplateModelException {
        List list2 = NodeListModel.evaluateElementOperation((TextOp)OPERATIONS.get("_text"), this.nodes);
        StringBuffer buf = new StringBuffer();
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            buf.append(it.next());
        }
        return new SimpleScalar(buf.toString());
    }

    public TemplateModelIterator iterator() {
        return new TemplateModelIterator(){
            private final Iterator it;
            {
                this.it = NodeListModel.this.nodes.iterator();
            }

            public TemplateModel next() {
                return this.it.hasNext() ? new NodeListModel(this.it.next(), NodeListModel.this.namespaces) : null;
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }
        };
    }

    public TemplateModel get(int i) throws TemplateModelException {
        try {
            return new NodeListModel(this.nodes.get(i), this.namespaces);
        }
        catch (IndexOutOfBoundsException e) {
            throw new TemplateModelException("Index out of bounds: " + e.getMessage());
        }
    }

    public int size() {
        return this.nodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments == null || arguments.size() != 1) {
            throw new TemplateModelException("Exactly one argument required for execute() on NodeTemplate");
        }
        String xpathString = (String)arguments.get(0);
        JDOMXPathEx xpath = null;
        try {
            Map map2 = XPATH_CACHE;
            synchronized (map2) {
                xpath = (JDOMXPathEx)((Object)XPATH_CACHE.get(xpathString));
                if (xpath == null) {
                    xpath = new JDOMXPathEx(xpathString);
                    XPATH_CACHE.put(xpathString, xpath);
                }
            }
            return NodeListModel.createNodeListModel(xpath.selectNodes(this.nodes, this.namespaces), this.namespaces);
        }
        catch (Exception e) {
            throw new TemplateModelException("Could not evaulate XPath expression " + xpathString, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNamespace(String prefix, String uri) {
        Map map2 = this.namespaces;
        synchronized (map2) {
            this.namespaces.put(prefix, Namespace.getNamespace((String)prefix, (String)uri));
        }
    }

    private static final Element getParent(Object node) {
        if (node instanceof Element) {
            return ((Element)node).getParent();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getParent();
        }
        if (node instanceof Text) {
            return ((Text)node).getParent();
        }
        if (node instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)node).getParent();
        }
        if (node instanceof Comment) {
            return ((Comment)node).getParent();
        }
        if (node instanceof EntityRef) {
            return ((EntityRef)node).getParent();
        }
        return null;
    }

    private static final List evaluateElementOperation(NodeOperator op, List nodes) throws TemplateModelException {
        int s = nodes.size();
        List[] lists = new List[s];
        int l = 0;
        int i = 0;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            List list2 = op.operate(it.next());
            if (list2 == null) continue;
            lists[i++] = list2;
            l += list2.size();
        }
        ArrayList retval = new ArrayList(l);
        for (int i2 = 0; i2 < s; ++i2) {
            if (lists[i2] == null) continue;
            retval.addAll(lists[i2]);
        }
        return retval;
    }

    private static final List evaluateNamedElementOperation(NamedNodeOperator op, String localName, Namespace namespace, List nodes) throws TemplateModelException {
        int s = nodes.size();
        List[] lists = new List[s];
        int l = 0;
        int i = 0;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            List list2 = op.operate(it.next(), localName, namespace);
            lists[i++] = list2;
            l += list2.size();
        }
        ArrayList retval = new ArrayList(l);
        for (int i2 = 0; i2 < s; ++i2) {
            retval.addAll(lists[i2]);
        }
        return retval;
    }

    private static final List removeDuplicates(List list2) {
        int s = list2.size();
        ArrayList ulist2 = new ArrayList(s);
        HashSet set = new HashSet(s * 4 / 3, 0.75f);
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!set.add(o)) continue;
            ulist2.add(o);
        }
        ulist2.trimToSize();
        return ulist2;
    }

    private static final Map createOperations() {
        HashMap<String, NodeOperator> map2 = new HashMap<String, NodeOperator>();
        map2.put("_ancestor", new AncestorOp());
        map2.put("_ancestorOrSelf", new AncestorOrSelfOp());
        map2.put("_attributes", ALL_ATTRIBUTES_OP);
        map2.put("_children", ALL_CHILDREN_OP);
        map2.put("_cname", new CanonicalNameOp());
        map2.put("_content", new ContentOp());
        map2.put("_descendant", new DescendantOp());
        map2.put("_descendantOrSelf", new DescendantOrSelfOp());
        map2.put("_document", new DocumentOp());
        map2.put("_doctype", new DocTypeOp());
        map2.put("_name", new NameOp());
        map2.put("_nsprefix", new NamespacePrefixOp());
        map2.put("_nsuri", new NamespaceUriOp());
        map2.put("_parent", new ParentOp());
        map2.put("_qname", new QNameOp());
        map2.put("_text", new TextOp());
        return map2;
    }

    private static final Map createSpecialOperations() {
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        Integer copy = new Integer(0);
        Integer unique2 = new Integer(1);
        Integer fname = new Integer(2);
        Integer ftype = new Integer(3);
        Integer type = new Integer(4);
        Integer regns = new Integer(5);
        Integer plaintext = new Integer(6);
        map2.put("_copy", copy);
        map2.put("_unique", unique2);
        map2.put("_fname", fname);
        map2.put("_ftype", ftype);
        map2.put("_type", type);
        map2.put("_registerNamespace", regns);
        map2.put("_plaintext", plaintext);
        map2.put("x_copy", copy);
        map2.put("x_unique", unique2);
        map2.put("x_fname", fname);
        map2.put("x_ftype", ftype);
        map2.put("x_type", type);
        return map2;
    }

    public static void main(String[] args) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document document2 = builder.build(System.in);
        SimpleHash model = new SimpleHash();
        model.put("document", new NodeListModel(document2));
        FileReader fr = new FileReader(args[0]);
        Template template = new Template(args[0], fr);
        OutputStreamWriter w = new OutputStreamWriter(System.out);
        template.process(model, w);
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    private static final class JDOMXPathEx
    extends JDOMXPath {
        JDOMXPathEx(String path) throws JaxenException {
            super(path);
        }

        public List selectNodes(Object object, Map namespaces) throws JaxenException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext((NamespaceContext)new NamespaceContextImpl(namespaces));
            return this.selectNodesForContext(context);
        }

        private static final class NamespaceContextImpl
        implements NamespaceContext {
            private final Map namespaces;

            NamespaceContextImpl(Map namespaces) {
                this.namespaces = namespaces;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String translateNamespacePrefixToUri(String prefix) {
                if (prefix.length() == 0) {
                    return prefix;
                }
                Map map2 = this.namespaces;
                synchronized (map2) {
                    Namespace ns = (Namespace)this.namespaces.get(prefix);
                    return ns == null ? null : ns.getURI();
                }
            }
        }
    }

    private static final class AttributeXMLOutputter
    extends XMLOutputter {
        private AttributeXMLOutputter() {
        }

        public void output(Attribute attribute, Writer out) throws IOException {
            out.write(" ");
            out.write(attribute.getQualifiedName());
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
        }
    }

    private final class TypeFilter
    implements TemplateMethodModel {
        private TypeFilter() {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments == null || arguments.size() == 0) {
                throw new TemplateModelException("_type expects exactly one argument");
            }
            String arg = (String)arguments.get(0);
            boolean invert = arg.indexOf(33) != -1;
            boolean a = invert != (arg.indexOf(97) == -1);
            boolean c = invert != (arg.indexOf(99) == -1);
            boolean d = invert != (arg.indexOf(100) == -1);
            boolean e = invert != (arg.indexOf(101) == -1);
            boolean n = invert != (arg.indexOf(110) == -1);
            boolean p = invert != (arg.indexOf(112) == -1);
            boolean t2 = invert != (arg.indexOf(116) == -1);
            boolean x2 = invert != (arg.indexOf(120) == -1);
            LinkedList list2 = new LinkedList(NodeListModel.this.nodes);
            Iterator it = list2.iterator();
            while (it.hasNext()) {
                Object node = it.next();
                if (!(node instanceof Element && e || node instanceof Attribute && a || node instanceof String && x2 || node instanceof Text && x2 || node instanceof ProcessingInstruction && p || node instanceof Comment && c || node instanceof EntityRef && n || node instanceof Document && d) && (!(node instanceof DocType) || !t2)) continue;
                it.remove();
            }
            return NodeListModel.createNodeListModel(list2, NodeListModel.this.namespaces);
        }
    }

    private final class NameFilter
    implements TemplateMethodModel {
        private NameFilter() {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object exec(List arguments) {
            HashSet names = new HashSet(arguments);
            LinkedList list2 = new LinkedList(NodeListModel.this.nodes);
            Iterator it = list2.iterator();
            while (it.hasNext()) {
                Object node = it.next();
                String name = null;
                if (node instanceof Element) {
                    name = ((Element)node).getName();
                } else if (node instanceof Attribute) {
                    name = ((Attribute)node).getName();
                } else if (node instanceof ProcessingInstruction) {
                    name = ((ProcessingInstruction)node).getTarget();
                } else if (node instanceof EntityRef) {
                    name = ((EntityRef)node).getName();
                } else if (node instanceof DocType) {
                    name = ((DocType)node).getPublicID();
                }
                if (name != null && names.contains(name)) continue;
                it.remove();
            }
            return NodeListModel.createNodeListModel(list2, NodeListModel.this.namespaces);
        }
    }

    private final class RegisterNamespace
    implements TemplateMethodModel {
        private RegisterNamespace() {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 2) {
                throw new TemplateModelException("_registerNamespace(prefix, uri) requires two arguments");
            }
            NodeListModel.this.registerNamespace((String)arguments.get(0), (String)arguments.get(1));
            return TemplateScalarModel.EMPTY_STRING;
        }
    }

    private static final class TextOp
    implements NodeOperator {
        private TextOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return Collections12.singletonList(((Element)node).getTextTrim());
            }
            if (node instanceof Attribute) {
                return Collections12.singletonList(((Attribute)node).getValue());
            }
            if (node instanceof CDATA) {
                return Collections12.singletonList(((CDATA)node).getText());
            }
            if (node instanceof Comment) {
                return Collections12.singletonList(((Comment)node).getText());
            }
            if (node instanceof ProcessingInstruction) {
                return Collections12.singletonList(((ProcessingInstruction)node).getData());
            }
            return null;
        }
    }

    private static final class ContentOp
    implements NodeOperator {
        private ContentOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return ((Element)node).getContent();
            }
            if (node instanceof Document) {
                return ((Document)node).getContent();
            }
            return null;
        }
    }

    private static final class DocTypeOp
    implements NodeOperator {
        private DocTypeOp() {
        }

        public List operate(Object node) {
            if (node instanceof Document) {
                DocType doctype = ((Document)node).getDocType();
                return doctype == null ? Collections.EMPTY_LIST : Collections12.singletonList(doctype);
            }
            return null;
        }
    }

    private static final class DocumentOp
    implements NodeOperator {
        private DocumentOp() {
        }

        public List operate(Object node) {
            Document doc = null;
            if (node instanceof Element) {
                doc = ((Element)node).getDocument();
            } else if (node instanceof Attribute) {
                Element parent = ((Attribute)node).getParent();
                doc = parent == null ? null : parent.getDocument();
            } else if (node instanceof Text) {
                Element parent = ((Text)node).getParent();
                doc = parent == null ? null : parent.getDocument();
            } else if (node instanceof Document) {
                doc = (Document)node;
            } else if (node instanceof ProcessingInstruction) {
                doc = ((ProcessingInstruction)node).getDocument();
            } else if (node instanceof EntityRef) {
                doc = ((EntityRef)node).getDocument();
            } else if (node instanceof Comment) {
                doc = ((Comment)node).getDocument();
            } else {
                return null;
            }
            return doc == null ? Collections.EMPTY_LIST : Collections12.singletonList(doc);
        }
    }

    private static final class DescendantOrSelfOp
    extends DescendantOp {
        private DescendantOrSelfOp() {
        }

        public List operate(Object node) {
            LinkedList list2 = (LinkedList)super.operate(node);
            list2.addFirst(node);
            return list2;
        }
    }

    private static class DescendantOp
    implements NodeOperator {
        private DescendantOp() {
        }

        public List operate(Object node) {
            LinkedList<Element> list2 = new LinkedList<Element>();
            if (node instanceof Element) {
                this.addChildren((Element)node, list2);
            } else if (node instanceof Document) {
                Element root2 = ((Document)node).getRootElement();
                list2.add(root2);
                this.addChildren(root2, list2);
            } else {
                return null;
            }
            return list2;
        }

        private void addChildren(Element element, List list2) {
            List children2 = element.getChildren();
            Iterator it = children2.iterator();
            while (it.hasNext()) {
                Element child = (Element)it.next();
                list2.add(child);
                this.addChildren(child, list2);
            }
        }
    }

    private static final class AncestorOrSelfOp
    implements NodeOperator {
        private AncestorOrSelfOp() {
        }

        public List operate(Object node) {
            Element parent = NodeListModel.getParent(node);
            if (parent == null) {
                return Collections12.singletonList(node);
            }
            LinkedList<Object> list2 = new LinkedList<Object>();
            list2.addFirst(node);
            do {
                list2.addFirst(parent);
            } while ((parent = parent.getParent()) != null);
            return list2;
        }
    }

    private static final class AncestorOp
    implements NodeOperator {
        private AncestorOp() {
        }

        public List operate(Object node) {
            Element parent = NodeListModel.getParent(node);
            if (parent == null) {
                return Collections.EMPTY_LIST;
            }
            LinkedList<Element> list2 = new LinkedList<Element>();
            do {
                list2.addFirst(parent);
            } while ((parent = parent.getParent()) != null);
            return list2;
        }
    }

    private static final class ParentOp
    implements NodeOperator {
        private ParentOp() {
        }

        public List operate(Object node) {
            Element parent = NodeListModel.getParent(node);
            return parent == null ? Collections.EMPTY_LIST : Collections12.singletonList(parent);
        }
    }

    private static final class CanonicalNameOp
    implements NodeOperator {
        private CanonicalNameOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                Element element = (Element)node;
                return Collections12.singletonList(element.getNamespace().getURI() + element.getName());
            }
            if (node instanceof Attribute) {
                Attribute attribute = (Attribute)node;
                return Collections12.singletonList(attribute.getNamespace().getURI() + attribute.getName());
            }
            return null;
        }
    }

    private static final class NamespacePrefixOp
    implements NodeOperator {
        private NamespacePrefixOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return Collections12.singletonList(((Element)node).getNamespace().getPrefix());
            }
            if (node instanceof Attribute) {
                return Collections12.singletonList(((Attribute)node).getNamespace().getPrefix());
            }
            return null;
        }
    }

    private static final class NamespaceUriOp
    implements NodeOperator {
        private NamespaceUriOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return Collections12.singletonList(((Element)node).getNamespace().getURI());
            }
            if (node instanceof Attribute) {
                return Collections12.singletonList(((Attribute)node).getNamespace().getURI());
            }
            return null;
        }
    }

    private static final class QNameOp
    implements NodeOperator {
        private QNameOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return Collections12.singletonList(((Element)node).getQualifiedName());
            }
            if (node instanceof Attribute) {
                return Collections12.singletonList(((Attribute)node).getQualifiedName());
            }
            return null;
        }
    }

    private static final class NameOp
    implements NodeOperator {
        private NameOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return Collections12.singletonList(((Element)node).getName());
            }
            if (node instanceof Attribute) {
                return Collections12.singletonList(((Attribute)node).getName());
            }
            if (node instanceof EntityRef) {
                return Collections12.singletonList(((EntityRef)node).getName());
            }
            if (node instanceof ProcessingInstruction) {
                return Collections12.singletonList(((ProcessingInstruction)node).getTarget());
            }
            if (node instanceof DocType) {
                return Collections12.singletonList(((DocType)node).getPublicID());
            }
            return null;
        }
    }

    private static final class NamedAttributeOp
    implements NamedNodeOperator {
        private NamedAttributeOp() {
        }

        public List operate(Object node, String localName, Namespace namespace) {
            Attribute attr = null;
            if (node instanceof Element) {
                Element element = (Element)node;
                attr = element.getAttribute(localName, namespace);
            } else if (node instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                attr = "target".equals(localName) ? new Attribute("target", pi.getTarget()) : ("data".equals(localName) ? new Attribute("data", pi.getData()) : new Attribute(localName, pi.getValue(localName)));
            } else if (node instanceof DocType) {
                DocType doctype = (DocType)node;
                if ("publicId".equals(localName)) {
                    attr = new Attribute("publicId", doctype.getPublicID());
                } else if ("systemId".equals(localName)) {
                    attr = new Attribute("systemId", doctype.getSystemID());
                } else if ("elementName".equals(localName)) {
                    attr = new Attribute("elementName", doctype.getElementName());
                }
            } else {
                return null;
            }
            return attr == null ? Collections.EMPTY_LIST : Collections12.singletonList(attr);
        }
    }

    private static final class AllAttributesOp
    implements NodeOperator {
        private AllAttributesOp() {
        }

        public List operate(Object node) {
            if (!(node instanceof Element)) {
                return null;
            }
            return ((Element)node).getAttributes();
        }
    }

    private static final class NamedChildrenOp
    implements NamedNodeOperator {
        private NamedChildrenOp() {
        }

        public List operate(Object node, String localName, Namespace namespace) {
            if (node instanceof Element) {
                return ((Element)node).getChildren(localName, namespace);
            }
            if (node instanceof Document) {
                Element root2 = ((Document)node).getRootElement();
                if (root2 != null && root2.getName().equals(localName) && root2.getNamespaceURI().equals(namespace.getURI())) {
                    return Collections12.singletonList(root2);
                }
                return Collections.EMPTY_LIST;
            }
            return null;
        }
    }

    private static final class AllChildrenOp
    implements NodeOperator {
        private AllChildrenOp() {
        }

        public List operate(Object node) {
            if (node instanceof Element) {
                return ((Element)node).getChildren();
            }
            if (node instanceof Document) {
                Element root2 = ((Document)node).getRootElement();
                return root2 == null ? Collections.EMPTY_LIST : Collections12.singletonList(root2);
            }
            return null;
        }
    }

    private static interface NamedNodeOperator {
        public List operate(Object var1, String var2, Namespace var3) throws TemplateModelException;
    }

    private static interface NodeOperator {
        public List operate(Object var1) throws TemplateModelException;
    }
}

