/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.NodeModel;
import freemarker.template.TemplateScalarModel;
import org.w3c.dom.Attr;

class AttributeNodeModel
extends NodeModel
implements TemplateScalarModel {
    public AttributeNodeModel(Attr att) {
        super(att);
    }

    public String getAsString() {
        return ((Attr)this.node).getValue();
    }

    public String getNodeName() {
        String result2 = this.node.getLocalName();
        if (result2 == null || result2.equals("")) {
            result2 = this.node.getNodeName();
        }
        return result2;
    }

    public boolean isEmpty() {
        return true;
    }

    String getQualifiedName() {
        String nsURI = this.node.getNamespaceURI();
        if (nsURI == null || nsURI.equals("")) {
            return this.node.getNodeName();
        }
        Environment env = Environment.getCurrentEnvironment();
        String defaultNS = env.getDefaultNS();
        String prefix = null;
        prefix = nsURI.equals(defaultNS) ? "D" : env.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return null;
        }
        return prefix + ":" + this.node.getLocalName();
    }
}

