/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import flanagan.math.MinimisationFunction;
import flanagan.math.MinimizationFunction;
import java.util.ArrayList;

public class Minimisation {
    protected boolean iseOption = true;
    protected int nParam = 0;
    protected double[] paramValue = null;
    protected String[] paraName = null;
    protected double functValue = 0.0;
    protected double lastFunctValNoCnstrnt = 0.0;
    protected double minimum = 0.0;
    protected int prec = 4;
    protected int field = 13;
    protected boolean convStatus = false;
    protected boolean suppressNoConvergenceMessage = false;
    protected int scaleOpt = 0;
    protected double[] scale = null;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double constraintTolerance = 1.0E-4;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fTol = 1.0E-13;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected int minTest = 0;
    protected double simplexSd = 0.0;

    public void suppressNoConvergenceMessage() {
        this.suppressNoConvergenceMessage = true;
    }

    public void supressNoConvergenceMessage() {
        this.suppressNoConvergenceMessage = true;
    }

    public void nelderMead(MinimisationFunction gg, double[] start, double[] step2, double fTol, int nMax) {
        MinimisationFunction g = gg;
        this.nelderMead((Object)g, start, step2, fTol, nMax);
    }

    public void nelderMead(MinimizationFunction gg, double[] start, double[] step2, double fTol, int nMax) {
        MinimizationFunction g = gg;
        this.nelderMead((Object)g, start, step2, fTol, nMax);
    }

    public void nelderMead(Object g, double[] start, double[] step2, double fTol, int nMax) {
        int i;
        Integer itemp;
        boolean testContract = false;
        int np = start.length;
        if (this.maxConstraintIndex >= np) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + np + ")");
        }
        this.nParam = np;
        this.convStatus = true;
        int nnp = np + 1;
        this.lastFunctValNoCnstrnt = 0.0;
        if (this.scaleOpt < 2) {
            this.scale = new double[np];
        }
        if (this.scaleOpt == 2 && this.scale.length != start.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (step2.length != start.length) {
            throw new IllegalArgumentException("step array length " + step2.length + " and initial estimate array length " + start.length + " are of different");
        }
        int i2 = 0;
        while (i2 < np) {
            if (step2[i2] == 0.0) {
                if (start[i2] != 0.0) {
                    step2[i2] = start[i2] * 0.1;
                } else {
                    step2[i2] = 1.0;
                    System.out.println("As no step size has been entered for an itial estimate of zero an initial step size of unity has been used");
                    System.out.println("You are advised to repeat the minimization using one of the methods allowing the setting of an appropriate non-zero initial step size");
                }
            }
            ++i2;
        }
        this.paramValue = new double[np];
        this.startH = new double[np];
        this.step = new double[np];
        double[] pmin = new double[np];
        double[][] pp = new double[nnp][nnp];
        double[] yy = new double[nnp];
        double[] pbar = new double[nnp];
        double[] pstar = new double[nnp];
        double[] p2star = new double[nnp];
        if (this.penalty) {
            itemp = (Integer)this.penalties.get(1);
            this.nConstraints = itemp;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            Double dtemp = null;
            int j = 2;
            int i3 = 0;
            while (i3 < this.nConstraints) {
                itemp = (Integer)this.penalties.get(j);
                this.penaltyParam[i3] = itemp;
                itemp = (Integer)this.penalties.get(++j);
                this.penaltyCheck[i3] = itemp;
                dtemp = (Double)this.penalties.get(++j);
                this.constraints[i3] = dtemp;
                ++j;
                ++i3;
            }
        }
        if (this.sumPenalty) {
            itemp = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = itemp;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            int[] itempArray = null;
            double[] dtempArray = null;
            Double dtemp = null;
            int j = 2;
            int i4 = 0;
            while (i4 < this.nSumConstraints) {
                itemp = (Integer)this.sumPenalties.get(j);
                this.sumPenaltyNumber[i4] = itemp;
                itempArray = (int[])this.sumPenalties.get(++j);
                this.sumPenaltyParam[i4] = itempArray;
                dtempArray = (double[])this.sumPenalties.get(++j);
                this.sumPlusOrMinus[i4] = dtempArray;
                itemp = (Integer)this.sumPenalties.get(++j);
                this.sumPenaltyCheck[i4] = itemp;
                dtemp = (Double)this.sumPenalties.get(++j);
                this.sumConstraints[i4] = dtemp;
                ++j;
                ++i4;
            }
        }
        int i5 = 0;
        while (i5 < np) {
            this.startH[i5] = start[i5];
            ++i5;
        }
        if (this.scaleOpt > 0) {
            boolean testzero = false;
            int i6 = 0;
            while (i6 < np) {
                if (start[i6] == 0.0) {
                    testzero = true;
                }
                ++i6;
            }
            if (testzero) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                i5 = 0;
                while (i5 < np) {
                    this.scale[i5] = 1.0;
                    ++i5;
                }
                break;
            }
            case 1: {
                i5 = 0;
                while (i5 < np) {
                    this.scale[i5] = 1.0 / start[i5];
                    step2[i5] = step2[i5] / start[i5];
                    start[i5] = 1.0;
                    ++i5;
                }
                break;
            }
            case 2: {
                i5 = 0;
                while (i5 < np) {
                    int n = i5;
                    step2[n] = step2[n] * this.scale[i5];
                    int n2 = i5;
                    start[n2] = start[n2] * this.scale[i5];
                    ++i5;
                }
                break;
            }
        }
        this.fTol = fTol;
        this.nMax = nMax;
        this.nIter = 0;
        i5 = 0;
        while (i5 < np) {
            this.step[i5] = step2[i5];
            this.scale[i5] = this.scale[i5];
            ++i5;
        }
        double sho = 0.0;
        int i7 = 0;
        while (i7 < np) {
            pstar[i7] = sho = start[i7];
            p2star[i7] = sho;
            pmin[i7] = sho;
            ++i7;
        }
        int jcount = this.konvge;
        int i8 = 0;
        while (i8 < np) {
            pp[i8][nnp - 1] = start[i8];
            ++i8;
        }
        yy[nnp - 1] = this.functionValue(g, start);
        int j = 0;
        while (j < np) {
            start[j] = start[j] + step2[j];
            int i9 = 0;
            while (i9 < np) {
                pp[i9][j] = start[i9];
                ++i9;
            }
            yy[j] = this.functionValue(g, start);
            start[j] = start[j] - step2[j];
            ++j;
        }
        double ynewlo = 0.0;
        double ystar = 0.0;
        double y2star = 0.0;
        double ylo = 0.0;
        double curMin = 0.0;
        double sumnm = 0.0;
        double summnm = 0.0;
        double zn = 0.0;
        int ilo = 0;
        int ihi = 0;
        int ln = 0;
        boolean test2 = true;
        while (test2) {
            int i10;
            int j2;
            ynewlo = ylo = yy[0];
            ilo = 0;
            ihi = 0;
            i = 1;
            while (i < nnp) {
                if (yy[i] < ylo) {
                    ylo = yy[i];
                    ilo = i;
                }
                if (yy[i] > ynewlo) {
                    ynewlo = yy[i];
                    ihi = i;
                }
                ++i;
            }
            i = 0;
            while (i < np) {
                zn = 0.0;
                int j3 = 0;
                while (j3 < nnp) {
                    zn += pp[i][j3];
                    ++j3;
                }
                pbar[i] = (zn -= pp[i][ihi]) / (double)np;
                ++i;
            }
            i = 0;
            while (i < np) {
                pstar[i] = (1.0 + this.rCoeff) * pbar[i] - this.rCoeff * pp[i][ihi];
                ++i;
            }
            ystar = this.functionValue(g, pstar);
            ++this.nIter;
            if (ystar < ylo) {
                i = 0;
                while (i < np) {
                    p2star[i] = pstar[i] * (1.0 + this.eCoeff) - this.eCoeff * pbar[i];
                    ++i;
                }
                y2star = this.functionValue(g, p2star);
                ++this.nIter;
                if (y2star < ylo) {
                    i = 0;
                    while (i < np) {
                        pp[i][ihi] = p2star[i];
                        ++i;
                    }
                    yy[ihi] = y2star;
                } else {
                    i = 0;
                    while (i < np) {
                        pp[i][ihi] = pstar[i];
                        ++i;
                    }
                    yy[ihi] = ystar;
                }
            } else {
                ln = 0;
                i = 0;
                while (i < nnp) {
                    if (i != ihi && ystar > yy[i]) {
                        ++ln;
                    }
                    ++i;
                }
                if (ln == np) {
                    if (ystar <= yy[ihi]) {
                        i = 0;
                        while (i < np) {
                            pp[i][ihi] = pstar[i];
                            ++i;
                        }
                        yy[ihi] = ystar;
                    }
                    i = 0;
                    while (i < np) {
                        p2star[i] = this.cCoeff * pp[i][ihi] + (1.0 - this.cCoeff) * pbar[i];
                        ++i;
                    }
                    y2star = this.functionValue(g, p2star);
                    ++this.nIter;
                    if (y2star > yy[ihi]) {
                        j2 = 0;
                        while (j2 < nnp) {
                            i10 = 0;
                            while (i10 < np) {
                                pp[i10][j2] = 0.5 * (pp[i10][j2] + pp[i10][ilo]);
                                pmin[i10] = pp[i10][j2];
                                ++i10;
                            }
                            yy[j2] = this.functionValue(g, pmin);
                            ++j2;
                        }
                        this.nIter += nnp;
                    } else {
                        i = 0;
                        while (i < np) {
                            pp[i][ihi] = p2star[i];
                            ++i;
                        }
                        yy[ihi] = y2star;
                    }
                } else {
                    i = 0;
                    while (i < np) {
                        pp[i][ihi] = pstar[i];
                        ++i;
                    }
                    yy[ihi] = ystar;
                }
            }
            sumnm = 0.0;
            ynewlo = yy[0];
            ilo = 0;
            i = 0;
            while (i < nnp) {
                sumnm += yy[i];
                if (ynewlo > yy[i]) {
                    ynewlo = yy[i];
                    ilo = i;
                }
                ++i;
            }
            sumnm /= (double)nnp;
            summnm = 0.0;
            i = 0;
            while (i < nnp) {
                zn = yy[i] - sumnm;
                summnm += zn * zn;
                ++i;
            }
            curMin = Math.sqrt(summnm / (double)np);
            switch (this.minTest) {
                case 0: {
                    if (!(curMin < fTol)) break;
                    test2 = false;
                }
            }
            this.minimum = ynewlo;
            if (!test2) {
                i = 0;
                while (i < np) {
                    pmin[i] = pp[i][ilo];
                    ++i;
                }
                yy[nnp - 1] = ynewlo;
                this.simplexSd = curMin;
                if (--jcount > 0) {
                    test2 = true;
                    j2 = 0;
                    while (j2 < np) {
                        pmin[j2] = pmin[j2] + step2[j2];
                        i10 = 0;
                        while (i10 < np) {
                            pp[i10][j2] = pmin[i10];
                            ++i10;
                        }
                        yy[j2] = this.functionValue(g, pmin);
                        pmin[j2] = pmin[j2] - step2[j2];
                        ++j2;
                    }
                }
            }
            if (!test2 || this.nIter <= this.nMax) continue;
            if (!this.suppressNoConvergenceMessage) {
                System.out.println("Maximum iteration number reached, in Minimisation.simplex(...)");
                System.out.println("without the convergence criterion being satisfied");
                System.out.println("Current parameter estimates and function value returned");
            }
            this.convStatus = false;
            i = 0;
            while (i < np) {
                pmin[i] = pp[i][ilo];
                ++i;
            }
            yy[nnp - 1] = ynewlo;
            test2 = false;
        }
        i = 0;
        while (i < np) {
            pmin[i] = pp[i][ilo];
            this.paramValue[i] = pmin[i] / this.scale[i];
            ++i;
        }
        this.minimum = ynewlo;
        this.kRestart = this.konvge - jcount;
    }

    public void nelderMead(MinimisationFunction g, double[] start, double[] step2, double fTol) {
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step2, fTol, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double[] step2, double fTol) {
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step2, fTol, nMaxx);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double[] step2, int nMax) {
        double fToll = this.fTol;
        this.nelderMead(g, start, step2, fToll, nMax);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double[] step2, int nMax) {
        double fToll = this.fTol;
        this.nelderMead(g, start, step2, fToll, nMax);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double[] step2) {
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step2, fToll, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double[] step2) {
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.nelderMead(g, start, step2, fToll, nMaxx);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double fTol, int nMax) {
        int n = start.length;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fTol, nMax);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double fTol, int nMax) {
        int n = start.length;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fTol, nMax);
    }

    public void nelderMead(MinimisationFunction g, double[] start, double fTol) {
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fTol, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start, double fTol) {
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fTol, nMaxx);
    }

    public void nelderMead(MinimisationFunction g, double[] start, int nMax) {
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fToll, nMax);
    }

    public void nelderMead(MinimizationFunction g, double[] start, int nMax) {
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fToll, nMax);
    }

    public void nelderMead(MinimisationFunction g, double[] start) {
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fToll, nMaxx);
    }

    public void nelderMead(MinimizationFunction g, double[] start) {
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        int i = 0;
        while (i < n) {
            stepp[i] = this.dStep * start[i];
            ++i;
        }
        this.nelderMead(g, start, stepp, fToll, nMaxx);
    }

    protected double functionValue(Object g, double[] x2) {
        if (this.iseOption) {
            return this.functionValue((MinimisationFunction)g, x2);
        }
        return this.functionValue((MinimizationFunction)g, x2);
    }

    protected double functionValue(MinimisationFunction g, double[] x2) {
        double[] param2 = new double[this.nParam];
        int i = 0;
        while (i < this.nParam) {
            param2[i] = x2[i] / this.scale[i];
            ++i;
        }
        boolean test2 = this.functionValueCommon(x2, param2);
        if (test2) {
            this.lastFunctValNoCnstrnt = this.functValue = g.function(param2);
        }
        return this.functValue;
    }

    protected double functionValue(MinimizationFunction g, double[] x2) {
        double[] param2 = new double[this.nParam];
        int i = 0;
        while (i < this.nParam) {
            param2[i] = x2[i] / this.scale[i];
            ++i;
        }
        boolean test2 = this.functionValueCommon(x2, param2);
        if (test2) {
            this.lastFunctValNoCnstrnt = this.functValue = g.function(param2);
        }
        return this.functValue;
    }

    protected boolean functionValueCommon(double[] x2, double[] param2) {
        double tempFunctVal = this.lastFunctValNoCnstrnt;
        boolean test2 = true;
        if (this.penalty) {
            int k = 0;
            int i = 0;
            while (i < this.nConstraints) {
                k = this.penaltyParam[i];
                switch (this.penaltyCheck[i]) {
                    case -1: {
                        if (!(param2[k] < this.constraints[i])) break;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.constraints[i] - param2[k]);
                        test2 = false;
                        break;
                    }
                    case 0: {
                        if (param2[k] < this.constraints[i] * (1.0 - this.constraintTolerance)) {
                            this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.constraints[i] * (1.0 - this.constraintTolerance) - param2[k]);
                            test2 = false;
                        }
                        if (!(param2[k] > this.constraints[i] * (1.0 + this.constraintTolerance))) break;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(param2[k] - this.constraints[i] * (1.0 + this.constraintTolerance));
                        test2 = false;
                        break;
                    }
                    case 1: {
                        if (!(param2[k] > this.constraints[i])) break;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(param2[k] - this.constraints[i]);
                        test2 = false;
                    }
                }
                ++i;
            }
        }
        if (this.sumPenalty) {
            int kk = 0;
            double pSign = 0.0;
            int i = 0;
            while (i < this.nSumConstraints) {
                double sumPenaltySum = 0.0;
                int j = 0;
                while (j < this.sumPenaltyNumber[i]) {
                    kk = this.sumPenaltyParam[i][j];
                    pSign = this.sumPlusOrMinus[i][j];
                    sumPenaltySum += param2[kk] * pSign;
                    ++j;
                }
                switch (this.sumPenaltyCheck[i]) {
                    case -1: {
                        if (!(sumPenaltySum < this.sumConstraints[i])) break;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.sumConstraints[i] - sumPenaltySum);
                        test2 = false;
                        break;
                    }
                    case 0: {
                        if (sumPenaltySum < this.sumConstraints[i] * (1.0 - this.constraintTolerance)) {
                            this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(this.sumConstraints[i] * (1.0 - this.constraintTolerance) - sumPenaltySum);
                            test2 = false;
                        }
                        if (!(sumPenaltySum > this.sumConstraints[i] * (1.0 + this.constraintTolerance))) break;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(sumPenaltySum - this.sumConstraints[i] * (1.0 + this.constraintTolerance));
                        test2 = false;
                        break;
                    }
                    case 1: {
                        if (!(sumPenaltySum > this.sumConstraints[i])) break;
                        this.functValue = tempFunctVal + this.penaltyWeight * Fmath.square(sumPenaltySum - this.sumConstraints[i]);
                        test2 = false;
                    }
                }
                ++i;
            }
        }
        return test2;
    }

    public void addConstraint(int paramIndex, int conDir, double constraint) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(new Integer(this.constraintMethod));
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(new Integer(1));
        } else {
            int nPC = (Integer)this.penalties.get(1);
            this.penalties.set(1, new Integer(++nPC));
        }
        this.penalties.add(new Integer(paramIndex));
        this.penalties.add(new Integer(conDir));
        this.penalties.add(new Double(constraint));
        if (paramIndex > this.maxConstraintIndex) {
            this.maxConstraintIndex = paramIndex;
        }
    }

    public void addConstraint(int[] paramIndices, int[] plusOrMinus, int conDir, double constraint) {
        ArrayMaths am = new ArrayMaths(plusOrMinus);
        double[] dpom = am.getArray_as_double();
        this.addConstraint(paramIndices, dpom, conDir, constraint);
    }

    public void addConstraint(int[] paramIndices, double[] plusOrMinus, int conDir, double constraint) {
        int nCon = paramIndices.length;
        int nPorM = plusOrMinus.length;
        if (nCon != nPorM) {
            throw new IllegalArgumentException("num of parameters, " + nCon + ", does not equal number of parameter signs, " + nPorM);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(new Integer(this.constraintMethod));
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(new Integer(1));
        } else {
            int nPC = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, new Integer(++nPC));
        }
        this.sumPenalties.add(new Integer(nCon));
        this.sumPenalties.add(paramIndices);
        this.sumPenalties.add(plusOrMinus);
        this.sumPenalties.add(new Integer(conDir));
        this.sumPenalties.add(new Double(constraint));
        ArrayMaths am = new ArrayMaths(paramIndices);
        int maxI = am.getMaximum_as_int();
        if (maxI > this.maxConstraintIndex) {
            this.maxConstraintIndex = maxI;
        }
    }

    public void setConstraintMethod(int conMeth) {
        this.constraintMethod = conMeth;
        if (!this.penalties.isEmpty()) {
            this.penalties.set(0, new Integer(this.constraintMethod));
        }
    }

    public void removeConstraints() {
        int i;
        int m;
        if (!this.penalties.isEmpty()) {
            m = this.penalties.size();
            i = m - 1;
            while (i >= 0) {
                this.penalties.remove(i);
                --i;
            }
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            m = this.sumPenalties.size();
            i = m - 1;
            while (i >= 0) {
                this.sumPenalties.remove(i);
                --i;
            }
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double tolerance) {
        this.constraintTolerance = tolerance;
    }

    public void print(String filename, int prec) {
        this.prec = prec;
        this.print(filename);
    }

    public void print(int prec) {
        this.prec = prec;
        String filename = "MinimisationOutput.txt";
        this.print(filename);
    }

    public void print(String filename) {
        if (filename.indexOf(46) == -1) {
            filename = String.valueOf(filename) + ".txt";
        }
        FileOutput fout = new FileOutput(filename, 'n');
        fout.dateAndTimeln(filename);
        fout.println(" ");
        fout.println("Simplex minimisation, using the method of Nelder and Mead,");
        fout.println("of the function y = f(c[0], c[1], c[2] . . .)");
        this.paraName = new String[this.nParam];
        int i = 0;
        while (i < this.nParam) {
            this.paraName[i] = "c[" + i + "]";
            ++i;
        }
        fout.println();
        if (!this.convStatus) {
            fout.println("Convergence criterion was not satisfied");
            fout.println("The following results are the current estimates on exiting the minimisation method");
            fout.println();
        }
        fout.println("Value of parameters at the minimum");
        fout.println(" ");
        fout.printtab(" ", this.field);
        fout.printtab("Value at", this.field);
        fout.printtab("Initial", this.field);
        fout.println("Initial");
        fout.printtab(" ", this.field);
        fout.printtab("mimium", this.field);
        fout.printtab("estimate", this.field);
        fout.println("step");
        i = 0;
        while (i < this.nParam) {
            fout.printtab(this.paraName[i], this.field);
            fout.printtab(Fmath.truncate(this.paramValue[i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.startH[i], this.prec), this.field);
            fout.println(Fmath.truncate(this.step[i], this.prec));
            ++i;
        }
        fout.println();
        fout.println(" ");
        fout.printtab("Number of paramaters");
        fout.println(this.nParam);
        fout.printtab("Number of iterations taken");
        fout.println(this.nIter);
        fout.printtab("Maximum number of iterations allowed");
        fout.println(this.nMax);
        fout.printtab("Number of restarts taken");
        fout.println(this.kRestart);
        fout.printtab("Maximum number of restarts allowed");
        fout.println(this.konvge);
        fout.printtab("Standard deviation of the simplex at the minimum");
        fout.println(Fmath.truncate(this.simplexSd, this.prec));
        fout.printtab("Convergence tolerance");
        fout.println(this.fTol);
        switch (this.minTest) {
            case 0: {
                if (this.convStatus) {
                    fout.println("simplex sd < the tolerance");
                    break;
                }
                fout.println("NOTE!!! simplex sd > the tolerance");
            }
        }
        fout.println();
        fout.println("End of file");
        fout.close();
    }

    public void print() {
        String filename = "MinimisationOutput.txt";
        this.print(filename);
    }

    public boolean getConvStatus() {
        return this.convStatus;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setScale(double[] sc) {
        this.scale = sc;
        this.scaleOpt = 2;
    }

    public double[] getScale() {
        return this.scale;
    }

    public void setMinTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double[] getParamValues() {
        return this.paramValue;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public int getNiter() {
        return this.nIter;
    }

    public void setNmax(int nmax) {
        this.nMax = nmax;
    }

    public int getNmax() {
        return this.nMax;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public void setNrestartsMax(int nrs) {
        this.konvge = nrs;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public void setNMreflect(double refl) {
        this.rCoeff = refl;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public void setNMextend(double ext) {
        this.eCoeff = ext;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public void setNMcontract(double con) {
        this.cCoeff = con;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public void setTolerance(double tol) {
        this.fTol = tol;
    }

    public double getTolerance() {
        return this.fTol;
    }
}

