/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class PropIntDeriv
extends BlackBox {
    private double kp = 1.0;
    private double ti = Double.POSITIVE_INFINITY;
    private double ki = 0.0;
    private double td = 0.0;
    private double kd = 0.0;

    public PropIntDeriv() {
        super("PropIntDeriv");
        super.setSnumer(new ComplexPoly(0.0, 1.0, 0.0));
        super.setSdenom(new ComplexPoly(0.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setKp(double kp) {
        this.kp = kp;
        this.sNumer.resetCoeff(1, new Complex(kp, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setKi(double ki) {
        this.ki = ki;
        this.ti = this.kp / ki;
        this.sNumer.resetCoeff(0, new Complex(ki, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setTi(double ti) {
        this.ti = ti;
        this.ki = this.kp / ti;
        this.sNumer.resetCoeff(0, new Complex(this.ki, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setKd(double kd) {
        this.kd = kd;
        this.td = kd / this.kp;
        this.sNumer.resetCoeff(2, new Complex(kd, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setTd(double td) {
        this.td = td;
        this.kd = this.kp * td;
        this.sNumer.resetCoeff(2, new Complex(this.kd, 0.0));
        super.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getKp() {
        return this.kp;
    }

    public double getKi() {
        return this.ki;
    }

    public double getTi() {
        return this.ti;
    }

    public double getKd() {
        return this.kd;
    }

    public double getTd() {
        return this.td;
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in PropIntDeriv with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            double kit = this.ki * this.deltaT;
            double kdt = this.kd / this.deltaT;
            Complex[] coef = Complex.oneDarray(3);
            coef[0].reset(0.0, 0.0);
            coef[1].reset(-1.0, 0.0);
            coef[2].reset(1.0, 0.0);
            this.zDenom.resetPoly(coef);
            switch (this.integMethod) {
                case 0: {
                    coef[0].reset(kdt, 0.0);
                    coef[1].reset(kit / 2.0 - 2.0 * kdt - this.kp, 0.0);
                    coef[2].reset(this.kp + kit / 2.0 + kdt, 0.0);
                    this.zNumer.resetPoly(coef);
                    break;
                }
                case 1: {
                    coef[0].reset(kdt, 0.0);
                    coef[1].reset(-2.0 * kdt - this.kp, 0.0);
                    coef[2].reset(this.kp + kit + kdt, 0.0);
                    this.zNumer.resetPoly(coef);
                    break;
                }
                case 2: {
                    coef[0].reset(kdt, 0.0);
                    coef[1].reset(kit - 2.0 * kdt - this.kp, 0.0);
                    coef[2].reset(this.kp + kdt, 0.0);
                    this.zNumer.resetPoly(coef);
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropIntDeriv must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
        this.zZeros = this.zNumer.roots();
        this.zPoles = this.zDenom.roots();
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        this.zTransform();
    }

    public void calcPolesZerosZ() {
        if (this.deltaT == 0.0) {
            System.out.println("z-pole and z-zero calculation attempted in PropIntDeriv.calcPolesZerosZ( with a zero sampling period");
        }
        this.zTransform();
        this.zPoles[0].reset(0.0, 0.0);
        this.zPoles[1].reset(1.0, 0.0);
        this.zZeros = this.zNumer.roots();
    }

    public void calcPolesZerosZ(double deltaT) {
        this.deltaT = deltaT;
        this.calcPolesZerosZ();
    }

    @Override
    public void stepInput(double stepMag, double finalTime) {
        int n = 50;
        double incrT = finalTime / (double)(n - 1);
        double[][] cdata = new double[2][n];
        double sum2 = 0.0;
        cdata[0][0] = 0.0;
        int i = 1;
        while (i < n) {
            cdata[0][i] = cdata[0][i - 1] + incrT;
            ++i;
        }
        double kpterm = this.kp * stepMag;
        int i2 = 0;
        while (i2 < n) {
            cdata[1][i2] = kpterm + (sum2 += this.ki * incrT * stepMag);
            ++i2;
        }
        if (this.deadTime != 0.0) {
            i2 = 0;
            while (i2 < n) {
                double[] dArray = cdata[0];
                int n2 = i2++;
                dArray[n2] = dArray[n2] + this.deadTime;
            }
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
        pg.setGraphTitle2(this.getName());
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.plot();
    }

    @Override
    public void stepInput(double finalTime) {
        this.stepInput(1.0, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, int rampOrder, double finalTime) {
        if (rampOrder == 0) {
            this.stepInput(rampGradient, finalTime);
        } else {
            int n = 50;
            double incrT = finalTime / (double)(n - 1);
            double[][] cdata = new double[2][n];
            double sum2 = 0.0;
            cdata[0][0] = 0.0;
            cdata[1][0] = 0.0;
            int i = 1;
            while (i < n) {
                cdata[0][i] = cdata[0][i - 1] + incrT;
                cdata[1][i] = this.kp * rampGradient * Math.pow(cdata[0][i], rampOrder) + (sum2 += this.ki * rampGradient * (Math.pow(cdata[0][i], rampOrder + 1) - Math.pow(cdata[0][i - 1], rampOrder + 1)) / (double)(rampOrder + 1));
                ++i;
            }
            if (this.deadTime != 0.0) {
                i = 0;
                while (i < n) {
                    double[] dArray = cdata[0];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Ramp (a.t^n) Input Transient:   ramp gradient (a) = " + rampGradient + " ramp order (n) = " + rampOrder);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.plot();
        }
    }

    @Override
    public void rampInput(int rampOrder, double finalTime) {
        double rampGradient = 1.0;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double rampGradient, double finalTime) {
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public void rampInput(double finalTime) {
        double rampGradient = 1.0;
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        Complex term1 = Complex.plusOne();
        Complex term2 = Complex.plusOne();
        Complex term3 = Complex.plusOne();
        term1 = term1.times(this.kp);
        term2 = term2.times(this.ki);
        term2 = term2.over(this.sValue);
        term3 = term3.times(this.kd);
        term3 = term3.times(this.sValue);
        Complex term = term1.plus(term2.plus(term3));
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public Complex getOutputS() {
        Complex term1 = Complex.plusOne();
        Complex term2 = Complex.plusOne();
        Complex term3 = Complex.plusOne();
        term1 = term1.times(this.kp);
        term2 = term2.times(this.ki);
        term2 = term2.over(this.sValue);
        term3 = term3.times(this.kd);
        term3 = term3.times(this.sValue);
        Complex term = term1.plus(term2.plus(term3));
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void calcOutputT(double ttime, double inp) {
        super.setInputT(ttime, inp);
        this.calcOutputT();
    }

    public void calcOutputT() {
        super.deadTimeWarning("zTransform");
        this.outputT[this.sampLen - 1] = this.kp * this.inputT[this.sampLen - 1];
        if (this.forgetFactor == 1.0) {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum += (this.inputT[this.sampLen - 1] + this.inputT[this.sampLen - 2]) * this.deltaT / 2.0;
                    break;
                }
                case 1: {
                    this.integrationSum += this.inputT[this.sampLen - 1] * this.deltaT;
                    break;
                }
                case 2: {
                    this.integrationSum += this.inputT[this.sampLen - 2] * this.deltaT;
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                    break;
                }
            }
        } else {
            switch (this.integMethod) {
                case 0: {
                    this.integrationSum = 0.0;
                    int i = 1;
                    while (i < this.sampLen) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - i) * (this.inputT[i - 1] + this.inputT[i]) * this.deltaT / 2.0;
                        ++i;
                    }
                    break;
                }
                case 1: {
                    this.integrationSum = 0.0;
                    int i = 1;
                    while (i < this.sampLen) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - i) * this.inputT[i] * this.deltaT;
                        ++i;
                    }
                    break;
                }
                case 2: {
                    this.integrationSum = 0.0;
                    int i = 1;
                    while (i < this.sampLen) {
                        this.integrationSum += Math.pow(this.forgetFactor, this.sampLen - 1 - i) * this.inputT[i - 1] * this.deltaT;
                        ++i;
                    }
                    break;
                }
                default: {
                    System.out.println("Integration method option in PropInt must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("getOutput not performed");
                }
            }
        }
        int n = this.sampLen - 1;
        this.outputT[n] = this.outputT[n] + this.ki * this.integrationSum;
        int n2 = this.sampLen - 1;
        this.outputT[n2] = this.outputT[n2] + this.kd * (this.inputT[this.sampLen - 1] - this.inputT[this.sampLen - 2]) / this.deltaT;
    }

    @Override
    public PropIntDeriv copy() {
        if (this == null) {
            return null;
        }
        PropIntDeriv bb = new PropIntDeriv();
        this.copyBBvariables(bb);
        bb.kp = this.kp;
        bb.ti = this.ti;
        bb.td = this.td;
        bb.kd = this.kd;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

