/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Cronbach;
import flanagan.analysis.PCA;
import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class RankAnalysis {
    private double[][] values = null;
    private double[][] errors = null;
    private double[] valuesDiagonal = null;
    private double[] errorsDiagonal = null;
    private double[][] reducedValues = null;
    private double[][] reducedErrors = null;
    private double[] reducedValuesDiagonal = null;
    private double[] reducedErrorsDiagonal = null;
    private double[] reducedValueOverError = null;
    private double[] probabilityValues = null;
    private double[] mcMullen = null;
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private int diagonalLength = 0;
    private int errorType = 3;
    private double[] errorRowMeans = null;
    private double[] errorColumnMeans = null;
    private int numberOfMissingErrors = 0;
    private boolean rowOption = true;
    private boolean rankAnalysisDone = false;

    public RankAnalysis(double[][] values2, double[][] errors) {
        this.values = Conv.copy(values2);
        this.errors = Conv.copy(errors);
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(float[][] values2, float[][] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(long[][] values2, long[][] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(int[][] values2, int[][] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigDecimal[][] values2, BigDecimal[][] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigInteger[][] values2, BigInteger[][] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayMaths[] values2, ArrayMaths[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayList<Object>[] values2, ArrayList<Object>[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(Vector<Object>[] values2, Vector<Object>[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(Matrix values2, Matrix errors) {
        this.values = values2.getArrayCopy();
        this.errors = errors.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(double[][] values2, double[] errors) {
        this.values = Conv.copy(values2);
        this.errors = this.oneToTwo(Conv.copy(errors), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(float[][] values2, float[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(long[][] values2, long[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(int[][] values2, int[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigDecimal[][] values2, BigDecimal[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigInteger[][] values2, BigInteger[] errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayMaths[] values2, ArrayMaths errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errors = this.oneToTwo(errors.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayList<Object>[] values2, ArrayList<Object> errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Vector<Object>[] values2, Vector<Object> errors) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Scores values2) {
        this.values = values2.usedScoresAsRowPerItem();
        Matrix mat = new Matrix(this.values);
        double[] errors = mat.rowStandardDeviations();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Cronbach values2) {
        this.values = values2.usedScoresAsRowPerItem();
        Matrix mat = new Matrix(this.values);
        double[] errors = mat.rowStandardDeviations();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(PCA values2) {
        this.values = values2.usedScoresAsRowPerItem();
        Matrix mat = new Matrix(this.values);
        double[] errors = mat.rowStandardDeviations();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(double[][] values2, double commonError) {
        this.values = Conv.copy(values2);
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(float[][] values2, float commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(long[][] values2, long commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(int[][] values2, int commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(BigDecimal[][] values2, BigDecimal commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError.doubleValue());
    }

    public RankAnalysis(BigInteger[][] values2, BigInteger commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError.doubleValue());
    }

    public RankAnalysis(ArrayMaths[] values2, double commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(ArrayList<Object>[] values2, double commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(Vector<Object>[] values2, double commonError) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(Matrix values2, double commonError) {
        this.values = values2.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(double[][] values2) {
        this.values = Conv.copy(values2);
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(float[][] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(long[][] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(int[][] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(BigDecimal[][] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(BigInteger[][] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(ArrayMaths[] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(ArrayList<Object>[] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(Vector<Object>[] values2) {
        Matrix matv = new Matrix(values2);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(Matrix values2) {
        this.values = values2.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    private double[][] oneToTwo(double[] errors, int nCols) {
        int nRows = errors.length;
        double[][] ret = new double[nRows][nCols];
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nCols) {
                ret[i][j] = errors[i];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private void preprocessDataOne() {
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (this.values[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfRows) {
            if (this.errors[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows of the error matrix must be of the same length as those of the value matrix");
            }
            ++i;
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                double[] dArray = this.errors[i];
                int n = j;
                dArray[n] = dArray[n] * this.errors[i][j];
                ++j;
            }
            ++i;
        }
    }

    private void preprocessDataTwo(double commonError) {
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (this.values[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
            }
            ++i;
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        this.errors = new double[this.numberOfRows][this.numberOfColumns];
        i = 0;
        while (i < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                this.errors[i][j] = commonError * commonError;
                ++j;
            }
            ++i;
        }
    }

    private void preprocessDataThree() {
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        int i = 1;
        while (i < this.numberOfRows) {
            if (this.values[i].length != this.numberOfColumns) {
                throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
            }
            ++i;
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        this.errors = new double[this.numberOfRows][this.numberOfColumns];
        double error = 0.0;
        int i2 = 0;
        while (i2 < this.numberOfRows) {
            int j = 0;
            while (j < this.numberOfColumns) {
                error = Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.values[i2][j])))) * 5.0E-16;
                this.errors[i2][j] = error * error;
                ++j;
            }
            ++i2;
        }
    }

    public void useErrorRowMean() {
        this.rowOption = true;
    }

    public void useErrorColumnMean() {
        this.rowOption = false;
    }

    public int nMissingErrors() {
        return this.numberOfMissingErrors;
    }

    private void rankAnalysis() {
        int j;
        int j2;
        int counter;
        this.errorRowMeans = new double[this.numberOfRows];
        this.errorColumnMeans = new double[this.numberOfColumns];
        this.numberOfMissingErrors = 0;
        int i = 0;
        while (i < this.numberOfRows) {
            counter = 0;
            j2 = 0;
            while (j2 < this.numberOfColumns) {
                if (!Double.isNaN(this.errors[i][j2])) {
                    if (this.errors[i][j2] < 0.0) {
                        double[] dArray = this.errors[i];
                        int n = j2;
                        dArray[n] = dArray[n] * -1.0;
                    }
                    int n = i;
                    this.errorRowMeans[n] = this.errorRowMeans[n] + this.errors[i][j2];
                    ++counter;
                } else {
                    ++this.numberOfMissingErrors;
                }
                ++j2;
            }
            int n = i++;
            this.errorRowMeans[n] = this.errorRowMeans[n] / (double)counter;
        }
        i = 0;
        while (i < this.numberOfColumns) {
            counter = 0;
            j2 = 0;
            while (j2 < this.numberOfRows) {
                if (!Double.isNaN(this.errors[j2][i])) {
                    int n = i;
                    this.errorColumnMeans[n] = this.errorColumnMeans[n] + this.errors[j2][i];
                    ++counter;
                }
                ++j2;
            }
            int n = i++;
            this.errorColumnMeans[n] = this.errorColumnMeans[n] / (double)counter;
        }
        if (this.numberOfMissingErrors > 0) {
            i = 0;
            while (i < this.numberOfRows) {
                int j3 = 0;
                while (j3 < this.numberOfColumns) {
                    if (Double.isNaN(this.errors[i][j3])) {
                        this.errors[i][j3] = this.rowOption ? this.errorRowMeans[i] : this.errorColumnMeans[i];
                    }
                    ++j3;
                }
                ++i;
            }
        }
        this.reducedValues = this.values;
        this.reducedErrors = this.errors;
        Matrix matv0 = new Matrix(this.reducedValues);
        Matrix mate0 = new Matrix(this.reducedErrors);
        int nn = this.diagonalLength - 1;
        int i2 = 0;
        while (i2 < nn) {
            matv0 = new Matrix(this.reducedValues);
            int nrow = this.numberOfRows - i2;
            int ncol = this.numberOfColumns - i2;
            Matrix mat1 = matv0.getSubMatrix(i2, i2, this.numberOfRows - 1, this.numberOfColumns - 1);
            double[][] subv = mat1.getArrayCopy();
            int[] max2 = mat1.pivot();
            int pivotI = max2[0] + i2;
            int pivotJ = max2[1] + i2;
            double[] holdv1 = this.reducedValues[i2];
            double[] holde1 = this.reducedErrors[i2];
            this.reducedValues[i2] = this.reducedValues[pivotI];
            this.reducedErrors[i2] = this.reducedErrors[pivotI];
            this.reducedValues[pivotI] = holdv1;
            this.reducedErrors[pivotI] = holde1;
            double holdv2 = 0.0;
            double holde2 = 0.0;
            int j4 = 0;
            while (j4 < this.numberOfRows) {
                holdv2 = this.reducedValues[j4][i2];
                holde2 = this.reducedErrors[j4][i2];
                this.reducedValues[j4][i2] = this.reducedValues[j4][pivotJ];
                this.reducedErrors[j4][i2] = this.reducedErrors[j4][pivotJ];
                this.reducedValues[j4][pivotJ] = holdv2;
                this.reducedErrors[j4][pivotJ] = holde2;
                ++j4;
            }
            Matrix matValueHold = new Matrix(this.reducedValues);
            Matrix matErrorHold = new Matrix(this.reducedErrors);
            double[][] valueHold = matValueHold.getArrayCopy();
            double[][] errorHold = matErrorHold.getArrayCopy();
            int j5 = i2 + 1;
            while (j5 < this.numberOfRows) {
                int k = i2;
                while (k < this.numberOfColumns) {
                    double ratio1 = 1.0;
                    if (this.reducedValues[j5][i2] != this.reducedValues[i2][i2]) {
                        ratio1 = this.reducedValues[j5][i2] / this.reducedValues[i2][i2];
                    }
                    valueHold[j5][k] = this.reducedValues[j5][k] - ratio1 * this.reducedValues[i2][k];
                    double hold = this.reducedErrors[j5][k] + this.reducedErrors[i2][k] * ratio1 * ratio1;
                    double ratio2 = 1.0;
                    if (this.reducedValues[i2][k] != this.reducedValues[i2][i2]) {
                        ratio2 = this.reducedValues[i2][k] / this.reducedValues[i2][i2];
                    }
                    errorHold[j5][k] = (hold += this.reducedErrors[j5][i2] * ratio2 * ratio2) + this.reducedErrors[i2][i2] * ratio1 * ratio1 * ratio2 * ratio2;
                    ++k;
                }
                ++j5;
            }
            matValueHold = new Matrix(valueHold);
            matErrorHold = new Matrix(errorHold);
            this.reducedValues = matValueHold.getArrayCopy();
            this.reducedErrors = matErrorHold.getArrayCopy();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numberOfRows) {
            j = 0;
            while (j < this.numberOfColumns) {
                this.reducedErrors[i2][j] = Math.sqrt(this.reducedErrors[i2][j]);
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < this.diagonalLength) {
            j = 0;
            while (j < i2) {
                this.reducedValues[i2][j] = 0.0;
                this.reducedErrors[i2][j] = 0.0;
                ++j;
            }
            ++i2;
        }
        if (this.diagonalLength < this.numberOfRows) {
            i2 = this.diagonalLength;
            while (i2 < this.numberOfRows) {
                j = 0;
                while (j < this.numberOfColumns) {
                    this.reducedValues[i2][j] = 0.0;
                    this.reducedErrors[i2][j] = 0.0;
                    ++j;
                }
                ++i2;
            }
        }
        this.reducedValuesDiagonal = new double[this.diagonalLength];
        this.reducedErrorsDiagonal = new double[this.diagonalLength];
        this.reducedValueOverError = new double[this.diagonalLength];
        this.probabilityValues = new double[this.diagonalLength];
        this.mcMullen = new double[this.numberOfRows];
        i2 = 0;
        while (i2 < this.diagonalLength) {
            this.reducedValuesDiagonal[i2] = this.reducedValues[i2][i2];
            this.reducedErrorsDiagonal[i2] = this.reducedErrors[i2][i2];
            this.reducedValueOverError[i2] = Math.abs(this.reducedValuesDiagonal[i2] / this.reducedErrorsDiagonal[i2]);
            this.probabilityValues[i2] = 1.0 - Stat.gaussianCDF(0.0, 1.0, -this.reducedValueOverError[i2], this.reducedValueOverError[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numberOfRows) {
            double sum2 = 0.0;
            int j6 = i2;
            while (j6 < this.numberOfColumns) {
                sum2 += this.reducedValues[i2][j6] * this.reducedValues[i2][j6];
                ++j6;
            }
            this.mcMullen[i2] = Math.sqrt(sum2) / (double)(this.numberOfColumns - i2);
            ++i2;
        }
        this.rankAnalysisDone = true;
    }

    public void analysis() {
        this.analysis("RankAnalysisOutput.txt");
    }

    public void analysis(String fileName) {
        int posdot;
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        if ((posdot = fileName.indexOf(".")) == -1) {
            fileName = String.valueOf(fileName) + ".txt";
        }
        FileOutput fout = new FileOutput(fileName);
        fout.println("Rank Analysis");
        fout.println("File name:   " + fileName);
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        fout.println("Number of rows    " + this.numberOfRows);
        fout.println("Number of columns " + this.numberOfColumns);
        if (this.numberOfMissingErrors > 0) {
            fout.println("Number of substituted missing errors" + this.numberOfMissingErrors);
            if (this.rowOption) {
                fout.println("Row means used as the substituted value/s");
            } else {
                fout.println("Column means used as the substituted value/s");
            }
        }
        fout.println();
        switch (this.errorType) {
            case 0: {
                fout.println("Matrix of individual errors supplied");
                break;
            }
            case 1: {
                fout.println("Common error for all elements in each each row supplied");
                break;
            }
            case 2: {
                fout.println("Single common error for all elements in the matrix supplied");
                break;
            }
            case 3: {
                fout.println("No errors supplied - estimate of the rounding errors used");
            }
        }
        fout.println();
        int field1 = 30;
        int field2 = 15;
        int trunc = 4;
        if (this.errorType != 3) {
            fout.print("Reduced", field2);
            fout.print("Reduced", field2);
            fout.print("V/E Ratio", field2);
            fout.print("P-value", field2);
            fout.println("McMullen");
            fout.print("Value", field2);
            fout.print("Error", field2);
            fout.print("    ", field2);
            fout.print("    ", field2);
            fout.println("rms");
            fout.print("Diagonal (V)", field2);
            fout.print("Diagonal (E)", field2);
            fout.print("   ", field2);
            fout.print("   ", field2);
            fout.println("   ");
        } else {
            fout.print("Reduced", field2);
            fout.print("Reduced", field2);
            fout.print("V/E Ratio", field2);
            fout.print("P-value", field2);
            fout.println("McMullen");
            fout.print("Value", field2);
            fout.print("Estimated", field2);
            fout.print("    ", field2);
            fout.print("    ", field2);
            fout.println("rms");
            fout.print("Diagonal (V)", field2);
            fout.print("Rounding", field2);
            fout.print("   ", field2);
            fout.print("   ", field2);
            fout.println("   ");
            fout.print("   ", field2);
            fout.print("Error (E)", field2);
            fout.print("   ", field2);
            fout.print("   ", field2);
            fout.println("   ");
        }
        int i = 0;
        while (i < this.diagonalLength) {
            fout.print(Fmath.truncate(this.reducedValuesDiagonal[i], trunc), field2);
            fout.print(Fmath.truncate(this.reducedErrorsDiagonal[i], trunc), field2);
            fout.print(Fmath.truncate(this.reducedValueOverError[i], trunc), field2);
            fout.print(Fmath.truncate(this.probabilityValues[i], trunc), field2);
            fout.println(Fmath.truncate(this.mcMullen[i], trunc));
            ++i;
        }
        System.out.println("Analysis written to text file " + fileName);
        fout.close();
    }

    public double[][] originalValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.values;
    }

    public double[][] originalErrors() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.errors;
    }

    public double[][] reducedValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValues;
    }

    public double[][] reducedErrors() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedErrors;
    }

    public double[] reducedValuesDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValuesDiagonal;
    }

    public double[] reducedErrorsDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedErrorsDiagonal;
    }

    public double[] reducedRatiosDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValueOverError;
    }

    public double[] probabilityValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.probabilityValues;
    }

    public double[] mcMullenValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.mcMullen;
    }

    public int nRows() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.numberOfRows;
    }

    public int nColumns() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.numberOfColumns;
    }

    public int nDiagonalElements() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.diagonalLength;
    }
}

