/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.math.ArrayMaths;
import flanagan.math.MaximizationFunction;

class BoxCoxFunction
implements MaximizationFunction {
    public double[] shiftedData = null;
    public int nData = 0;
    public double[] yTransform = null;
    public double[] gaussianOrderMedians = null;
    public Regression reg = null;
    public ArrayMaths am = null;
    public Stat st = null;

    BoxCoxFunction() {
    }

    @Override
    public double function(double[] x2) {
        int i;
        if (x2[0] == 0.0) {
            i = 0;
            while (i < this.nData) {
                this.yTransform[i] = Math.log(this.shiftedData[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nData) {
                this.yTransform[i] = (Math.pow(this.shiftedData[i], x2[0]) - 1.0) / x2[0];
                ++i;
            }
        }
        this.am = new ArrayMaths(this.yTransform);
        this.am = this.am.sort();
        double[] yTrans = this.am.array();
        this.st = new Stat(yTrans);
        this.yTransform = this.st.standardize();
        this.reg = new Regression(this.gaussianOrderMedians, this.yTransform);
        this.reg.linear();
        return this.reg.getSampleR();
    }
}

