/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.util;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Random;

public class GprSeq {
    public static final char FASTQ_SANGER_ZERO = '!';
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    public static final char[] AMINO_ACIDS = new char[]{'A', 'R', 'N', 'D', 'C', 'E', 'Q', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
    public static final String[] KNOWN_FILE_EXTENSIONS = new String[]{".fa", ".fasta", ".fq", ".fastq", ".sai", ".sam", ".bam", ".bcf", ".vcf", "pileup", "mpileup"};

    public static String changeQuality(String qualityStr, FastqVariant fqSrc, FastqVariant fqDst) {
        int dst;
        int src;
        if (fqSrc == fqDst) {
            return qualityStr;
        }
        switch (fqSrc) {
            case FASTQ_SOLEXA: 
            case FASTQ_ILLUMINA: {
                src = 64;
                break;
            }
            case FASTQ_SANGER: {
                src = 33;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented fastq variant '" + (Object)((Object)fqSrc) + "'");
            }
        }
        switch (fqDst) {
            case FASTQ_SOLEXA: 
            case FASTQ_ILLUMINA: {
                dst = 64;
                break;
            }
            case FASTQ_SANGER: {
                dst = 33;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented fastq variant '" + (Object)((Object)fqDst) + "'");
            }
        }
        int diff2 = dst - src;
        if (diff2 == 0) {
            return qualityStr;
        }
        char[] oldQ = qualityStr.toCharArray();
        char[] newQ = new char[oldQ.length];
        int i = 0;
        while (i < oldQ.length) {
            int q = oldQ[i] - src;
            if (q < -5) {
                throw new RuntimeException("Invalid quality char '" + oldQ[i] + "' (quality = " + q + "). This doesn't look like a valid '" + (Object)((Object)fqSrc) + "' format");
            }
            newQ[i] = (char)(Math.max(0, q) + dst);
            ++i;
        }
        return new String(newQ);
    }

    public static String fastaSimpleRead(String fastaFile) {
        BufferedReader inFile;
        StringBuilder sb;
        block4: {
            sb = new StringBuilder();
            inFile = Gpr.reader(fastaFile);
            if (inFile != null) break block4;
            return "";
        }
        try {
            String line = inFile.readLine();
            while (inFile.ready()) {
                line = inFile.readLine().trim();
                sb.append(line);
            }
            inFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static String fastqId(Fastq fastq) {
        return GprSeq.readId(fastq.getDescription().substring(1));
    }

    public static boolean isAmbiguous(String sequence2) {
        char[] seq2 = sequence2.toLowerCase().toCharArray();
        int i = 0;
        while (i < seq2.length) {
            char c = seq2[i];
            if (c != 'a' && c != 'c' && c != 'g' && c != 't') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static char randBase(Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        throw new RuntimeException("This should never happen!");
    }

    public static String randSequence(Random random, int len) {
        char[] bases = new char[len];
        int i = 0;
        while (i < len) {
            bases[i] = GprSeq.randBase(random);
            ++i;
        }
        return new String(bases);
    }

    public static String readId(String line) {
        String id = line.split("\\s")[0];
        if (id.endsWith("/1")) {
            return id.substring(0, id.length() - 2);
        }
        if (id.endsWith("/2")) {
            return id.substring(0, id.length() - 2);
        }
        return id;
    }

    public static String removeExt(String fileName) {
        return Gpr.removeExt(fileName, KNOWN_FILE_EXTENSIONS);
    }

    public static String reverse(String seq2) {
        char[] bases;
        char[] reverse2 = new char[seq2.length()];
        int i = reverse2.length - 1;
        char[] cArray = bases = seq2.toCharArray();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            char base = cArray[n2];
            reverse2[i--] = base;
            ++n2;
        }
        return new String(reverse2);
    }

    public static String reverseWc(String seq2) {
        char[] bases;
        char[] rwc = new char[seq2.length()];
        int i = rwc.length - 1;
        char[] cArray = bases = seq2.toCharArray();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            char base = cArray[n2];
            rwc[i--] = GprSeq.wc(base);
            ++n2;
        }
        return new String(rwc);
    }

    public static String string2fasta(String name, String sequence2) {
        StringBuffer sb = new StringBuffer();
        sb.append(">" + name + "\n");
        int lineLen = 80;
        int i = 0;
        while (i < sequence2.length()) {
            int max2 = Math.min(i + lineLen, sequence2.length());
            sb.append(String.valueOf(sequence2.substring(i, max2)) + "\n");
            i += lineLen;
        }
        return sb.toString();
    }

    public static char wc(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 'T';
            }
            case 'C': 
            case 'c': {
                return 'G';
            }
            case 'G': 
            case 'g': {
                return 'C';
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 'A';
            }
            case 'N': 
            case 'n': {
                return 'N';
            }
        }
        return base;
    }

    public static String wc(String seq2) {
        char[] rwc = new char[seq2.length()];
        char[] bases = seq2.toCharArray();
        int i = 0;
        while (i < bases.length) {
            rwc[i] = GprSeq.wc(bases[i]);
            ++i;
        }
        return new String(rwc);
    }
}

