/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility.bootstrap;

import ca.mcgill.mcb.pcingola.probablility.bootstrap.ReSampleInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class ReSampleMapRank
extends ReSampleInt {
    HashMap<String, Double> scoreByName;
    HashMap<String, Integer> rankByName;

    public ReSampleMapRank(HashMap<String, Double> scoresByName, int sampleSize) {
        super(null, sampleSize);
        this.scoreByName = scoresByName;
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(scoresByName.keySet());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return ReSampleMapRank.this.scoreByName.get(arg0).compareTo(ReSampleMapRank.this.scoreByName.get(arg1));
            }
        });
        this.rankByName = new HashMap();
        this.scores = new int[names.size()];
        double latest = Double.NaN;
        int rank = 0;
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            double score = scoresByName.get(name);
            if (latest != score) {
                ++rank;
            }
            latest = score;
            this.rankByName.put(name, rank);
            this.scores[i] = rank;
            ++i;
        }
    }

    public int score(Collection<String> names) {
        int sum2 = 0;
        for (String name : names) {
            if (this.rankByName.get(name) == null) {
                throw new RuntimeException("Error: Entry '" + name + "' not found!");
            }
            sum2 += this.rankByName.get(name).intValue();
        }
        return sum2;
    }
}

