/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.probablility;

public class RankSumNoReplacementSimulate {
    int n;
    int numberOfSamples;
    long[][] rankSum;
    int[][] samples;

    public static void main(String[] args) {
        System.out.println("Begin: RankSumNoReplacementSimulate");
        int numberOfSamples = 100000;
        int n = 2;
        while (true) {
            RankSumNoReplacementSimulate rss = new RankSumNoReplacementSimulate(numberOfSamples, n);
            int nt = 1;
            while (nt <= rss.n) {
                double mu = rss.mean(nt);
                double muSample = rss.sampleMean(nt);
                double muErr = mu != 0.0 ? Math.abs(mu - muSample) / mu : 0.0;
                double sigmaSample = Math.sqrt(rss.sampleVariance(nt));
                double sigma = Math.sqrt(rss.variance(nt));
                double simgaErr = sigma != 0.0 ? Math.abs(sigma - sigmaSample) / sigma : 0.0;
                System.out.println("N:" + n + "\tNT:" + nt + "\tmu:" + mu + "\tmuSample:" + muSample + "\terr%:" + muErr + "\t|\tsigma:" + sigma + "\tsigmaSample:" + sigmaSample + "\terr%:" + simgaErr);
                ++nt;
            }
            ++n;
        }
    }

    public RankSumNoReplacementSimulate(int numberOfSamples, int n) {
        this.numberOfSamples = numberOfSamples;
        this.n = n;
        this.samples = new int[numberOfSamples][n];
        this.rankSum = new long[numberOfSamples][n];
        this.initSamples();
        this.randomizeSamples();
        this.rankSum();
    }

    public int getN() {
        return this.n;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public long[][] getRankSum() {
        return this.rankSum;
    }

    public int[][] getSamples() {
        return this.samples;
    }

    public void initSamples() {
        int ns = 0;
        while (ns < this.numberOfSamples) {
            int i = 0;
            while (i < this.n) {
                this.samples[ns][i] = i + 1;
                this.rankSum[ns][i] = 0L;
                ++i;
            }
            ++ns;
        }
    }

    public double mean(int nt) {
        double mean = (double)(nt * (this.n + 1)) / 2.0;
        return mean;
    }

    public void randomizeSamples() {
        int ns = 0;
        while (ns < this.numberOfSamples) {
            int i = 0;
            while (i < this.n) {
                int r1 = i++;
                int r2 = (int)(Math.random() * (double)this.n);
                int tmp = this.samples[ns][r1];
                this.samples[ns][r1] = this.samples[ns][r2];
                this.samples[ns][r2] = tmp;
            }
            ++ns;
        }
    }

    public void rankSum() {
        int ns = 0;
        while (ns < this.numberOfSamples) {
            long rs = 0L;
            int i = 0;
            while (i < this.n) {
                this.rankSum[ns][i] = rs += (long)this.samples[ns][i];
                ++i;
            }
            ++ns;
        }
    }

    public double sampleMean(int nt) {
        if (nt < 1 || nt > this.n) {
            return 0.0;
        }
        double mean = 0.0;
        int ns = 0;
        while (ns < this.numberOfSamples) {
            mean += (double)this.rankSum[ns][nt - 1];
            ++ns;
        }
        return mean /= (double)this.numberOfSamples;
    }

    public double sampleVariance(int nt) {
        if (nt < 1 || nt > this.n) {
            return 0.0;
        }
        double mean = this.mean(nt);
        double sum2 = 0.0;
        int ns = 0;
        while (ns < this.numberOfSamples) {
            double d = (double)this.rankSum[ns][nt - 1] - mean;
            sum2 += d * d;
            ++ns;
        }
        double var = sum2 / (double)(this.numberOfSamples - 1);
        return var;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setNumberOfSamples(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public void setRankSum(long[][] rankSum) {
        this.rankSum = rankSum;
    }

    public void setSamples(int[][] samples) {
        this.samples = samples;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("numberOfSamples:" + this.numberOfSamples + "\tN:" + this.n + "\nSamples:\n");
        int ns = 0;
        while (ns < this.numberOfSamples) {
            sb.append(String.valueOf(ns) + ":\t");
            i = 0;
            while (i < this.n) {
                sb.append(String.valueOf(this.samples[ns][i]) + " ");
                ++i;
            }
            sb.append("\n");
            ++ns;
        }
        sb.append("\nRankSums:\n");
        ns = 0;
        while (ns < this.numberOfSamples) {
            sb.append(String.valueOf(ns) + ":\t");
            i = 0;
            while (i < this.n) {
                sb.append(String.valueOf(this.rankSum[ns][i]) + " ");
                ++i;
            }
            sb.append("\n");
            ++ns;
        }
        return sb.toString();
    }

    public double variance(int nt) {
        double var = 0.0;
        double dnt = nt;
        double dn = this.n;
        double mu = this.mean(nt);
        int i = 1;
        while (i <= this.n) {
            int j = 1;
            while (j <= this.n) {
                double di = i;
                double dj = j;
                var = i == j ? (var += di * dj * dnt / dn) : (var += di * dj * dnt * (dnt - 1.0) / (dn * (dn - 1.0)));
                ++j;
            }
            ++i;
        }
        return var -= mu * mu;
    }
}

