/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import java.io.Serializable;

public class Interval
implements Comparable<Interval>,
Serializable {
    private static final long serialVersionUID = -3547434510230920403L;
    protected int start;
    protected int end;
    protected byte strand;
    protected String id = "";
    protected Interval parent;

    protected Interval() {
        this.start = -1;
        this.end = -1;
        this.id = null;
        this.strand = 0;
        this.parent = null;
    }

    public Interval(Interval parent, int start, int end, int strand, String id) {
        if (start > end) {
            throw new RuntimeException("Interval error: end before start. Start:" + start + ", End: " + end);
        }
        this.start = start;
        this.end = end;
        this.id = id;
        this.strand = (byte)strand;
        this.parent = parent;
    }

    @Override
    public int compareTo(Interval i2) {
        if (this.start > i2.start) {
            return 1;
        }
        if (this.start < i2.start) {
            return -1;
        }
        if (this.end > i2.end) {
            return 1;
        }
        if (this.end < i2.end) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Interval interval) {
        return this.compareTo(interval) == 0;
    }

    public int getEnd() {
        return this.end;
    }

    public String getId() {
        return this.id;
    }

    public Interval getParent() {
        return this.parent;
    }

    public int getStart() {
        return this.start;
    }

    public int getStrand() {
        return this.strand;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = hashCode * 31 + this.start;
        hashCode = hashCode * 31 + this.end;
        hashCode = hashCode * 31 + this.strand;
        hashCode = hashCode * 31 + this.id.hashCode();
        return hashCode;
    }

    public boolean intersects(Interval interval) {
        return interval.getEnd() >= this.start && interval.getStart() <= this.end;
    }

    public boolean intersects(long point) {
        return (long)this.start <= point && point <= (long)this.end;
    }

    public boolean isStrandMinus() {
        return this.strand < 0;
    }

    public boolean isStrandPlus() {
        return this.strand >= 0;
    }

    public boolean isValid() {
        return this.start >= 0 && this.start <= this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParent(Interval parent) {
        this.parent = parent;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setStrand(int strand) {
        this.strand = (byte)strand;
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public String toString() {
        return String.valueOf(this.start) + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public String toStringAsciiArt(int maxLen) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < maxLen) {
            if (i >= this.start && i <= this.end) {
                sb.append('-');
            } else {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }
}

