/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.io.IOException;

public class VcfHapMapFileIterator
extends MarkerFileIterator<VcfEntry> {
    static final String format = "GT";
    protected Genome genome;
    String fatsaFileName;
    String seq = "";
    VcfFileIterator vcfFile;
    Chromosome chr;

    public VcfHapMapFileIterator(String hapMapFileName, String fatsaFileName, Genome genome) {
        super(hapMapFileName, 1);
        this.fatsaFileName = fatsaFileName;
        this.genome = genome;
    }

    VcfEntry parseHapMapLine(String line) {
        String[] recs = line.split("\t");
        String id = recs[0];
        int start = this.parsePosition(recs[1]);
        if (start >= this.seq.length() || start < 0) {
            throw new RuntimeException("Position out of chromosome range " + start + ".\n\tLine number: " + this.lineNum + "\t" + line);
        }
        String ref = this.seq.substring(start, start + 1);
        int[] count2 = new int[4];
        int i = 2;
        while (i < recs.length) {
            String[] alts;
            String[] stringArray = alts = recs[i].toUpperCase().split(" ");
            int n = alts.length;
            int n2 = 0;
            while (n2 < n) {
                String alt = stringArray[n2];
                if (alt.equals("A")) {
                    count2[0] = count2[0] + 1;
                } else if (alt.equals("C")) {
                    count2[1] = count2[1] + 1;
                } else if (alt.equals("G")) {
                    count2[2] = count2[2] + 1;
                } else if (alt.equals("T")) {
                    count2[3] = count2[3] + 1;
                }
                ++n2;
            }
            ++i;
        }
        if (ref.equals("A")) {
            count2[0] = 0;
        } else if (ref.equals("C")) {
            count2[1] = 0;
        } else if (ref.equals("G")) {
            count2[2] = 0;
        } else if (ref.equals("T")) {
            count2[3] = 0;
        }
        String altStr = "";
        if (count2[0] > 0) {
            altStr = String.valueOf(altStr) + "A";
        }
        if (count2[1] > 0) {
            altStr = String.valueOf(altStr) + (altStr.isEmpty() ? "" : ",") + "C";
        }
        if (count2[2] > 0) {
            altStr = String.valueOf(altStr) + (altStr.isEmpty() ? "" : ",") + "G";
        }
        if (count2[3] > 0) {
            altStr = String.valueOf(altStr) + (altStr.isEmpty() ? "" : ",") + "T";
        }
        VcfEntry vcfEntry = null;
        if (altStr.length() <= 3) {
            vcfEntry = new VcfEntry(this.vcfFile, this.genome, this.chr.getId(), start, id, ref, altStr, 0.0, "", "", format);
            int i2 = 2;
            while (i2 < recs.length) {
                String[] alts = recs[i2].split(" ");
                String gen = "";
                gen = alts[0].equals(alts[1]) ? (alts[0].equals(ref) ? "0|0" : "1|1") : (alts[0].equals(ref) ? "0|1" : "1|0");
                vcfEntry.addGenotype(gen);
                ++i2;
            }
        } else {
            Gpr.debug("WARNING! Skipping entry:\t" + line);
        }
        return vcfEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected VcfEntry readNext() {
        if (this.seq == null || this.seq.isEmpty()) {
            this.readSequence();
        }
        try {
            while (this.ready()) {
                VcfEntry vcfEntry;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.lineNum <= 1 || (vcfEntry = this.parseHapMapLine(this.line)) == null) continue;
                return vcfEntry;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
    }

    void readSequence() {
        FastaFileIterator ffi = new FastaFileIterator(this.fatsaFileName);
        this.seq = ((String)ffi.next()).toUpperCase();
        String chrName = ffi.getName();
        if (this.genome.getChromosome(chrName) == null) {
            this.chr = new Chromosome(this.genome, 0, this.seq.length(), 1, chrName);
            this.genome.add(this.chr);
        } else {
            this.chr = this.genome.getChromosome(chrName);
        }
        ffi.close();
    }
}

