/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.RegulationFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import java.io.IOException;

public class RegulationGffFileIterator
extends RegulationFileIterator {
    public static final int GFF_OFFSET = 1;

    public RegulationGffFileIterator(String fileName) {
        super(fileName, 1);
    }

    public RegulationGffFileIterator(String fileName, Genome genome) {
        super(fileName, genome, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Regulation readNext() {
        try {
            String[] infos;
            String[] fields;
            do {
                if (!this.ready()) {
                    return null;
                }
                this.line = this.readLine();
                if (this.line != null) continue;
                return null;
            } while (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3);
            String chromosome = fields[0].trim();
            Chromosome chromo = this.getChromosome(chromosome);
            this.sanityCheckChromo(chromosome, chromo);
            int start = this.parsePosition(fields[3]);
            int end = this.parsePosition(fields[4]);
            String id = "line_" + this.lineNum;
            String strandStr = fields[6];
            int strand = strandStr.equals("-") ? -1 : 1;
            String info = fields[8];
            String name = "";
            String cellType = "";
            String[] stringArray = infos = info.split(";");
            int n = infos.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return new Regulation(chromo, start, end, strand, id, name, cellType);
                }
                String nv = stringArray[n2];
                String[] nameValue = nv.split("=");
                if (nameValue.length > 0) {
                    String attr = nameValue[0].trim();
                    String val = nameValue[1].trim();
                    if (attr.equals("Name")) {
                        name = val;
                    } else if (attr.equals("Alias")) {
                        cellType = val.split("_")[0];
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

