/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

public class NeedlemanWunsch {
    String alignment;
    char[] a;
    char[] b;
    int[][] score;
    int match = 1;
    int missMatch = -1;
    int deletion = -2;
    int offset = 0;

    public NeedlemanWunsch(String a, String b) {
        this.score = new int[a.length() + 1][b.length() + 1];
        this.a = a.toCharArray();
        this.b = b.toCharArray();
    }

    public String align() {
        this.scoreMatrix();
        this.calcAlignments();
        return this.alignment;
    }

    void calcAlignments() {
        int maxLen = Math.max(this.a.length, this.b.length);
        char[] alignmentA = new char[maxLen];
        char[] alignmentB = new char[maxLen];
        int i = this.a.length;
        int j = this.b.length;
        int h = maxLen - 1;
        while (i > 0 && j > 0 && h >= 0) {
            int s = this.getScore(i, j);
            int scorediag = this.getScore(i - 1, j - 1);
            int scoreup = this.getScore(i, j - 1);
            int scoreleft = this.getScore(i - 1, j);
            if (s == scoreup + this.deletion) {
                alignmentA[h] = 45;
                alignmentB[h] = this.b[j - 1];
                --j;
            } else if (s == scoreleft + this.deletion) {
                alignmentA[h] = this.a[i - 1];
                alignmentB[h] = 45;
                --i;
            } else if (s == scorediag + this.simmilarity(i, j)) {
                alignmentA[h] = 32;
                alignmentB[h] = 32;
                --i;
                --j;
            } else {
                throw new RuntimeException("This should never happen!");
            }
            --h;
        }
        while (i > 0 && h >= 0) {
            alignmentA[h] = this.a[i - 1];
            alignmentB[h] = 45;
            --i;
            --h;
        }
        while (j > 0 && h >= 0) {
            alignmentA[h] = 45;
            alignmentB[h] = this.b[j - 1];
            --j;
            --h;
        }
        this.offset = 0;
        while (this.offset < maxLen && alignmentA[this.offset] == ' ') {
            ++this.offset;
        }
        StringBuffer alsb = new StringBuffer();
        int prev = 32;
        i = 0;
        while (i < maxLen) {
            if (alignmentA[i] == '-') {
                if (prev != 45) {
                    alsb.append('-');
                }
                alsb.append(alignmentB[i]);
                prev = 45;
            } else if (alignmentB[i] == '-') {
                if (prev != 43) {
                    alsb.append('+');
                }
                alsb.append(alignmentA[i]);
                prev = 43;
            }
            ++i;
        }
        this.alignment = alsb.toString();
    }

    public int getAligmentScore() {
        return this.getScore(this.a.length, this.b.length);
    }

    public String getAlignment() {
        return this.alignment;
    }

    public int getOffset() {
        return this.offset;
    }

    int getScore(int i, int j) {
        return this.score[i][j];
    }

    void scoreMatrix() {
        int i = 0;
        while (i <= this.a.length) {
            this.setScore(i, 0, this.deletion * i);
            ++i;
        }
        int j = 0;
        while (j <= this.b.length) {
            this.setScore(0, j, this.deletion * j);
            ++j;
        }
        i = 1;
        while (i <= this.a.length) {
            int j2 = 1;
            while (j2 <= this.b.length) {
                int match = this.getScore(i - 1, j2 - 1) + this.simmilarity(i, j2);
                int del = this.getScore(i - 1, j2) + this.deletion;
                int ins = this.getScore(i, j2 - 1) + this.deletion;
                int s = Math.max(match, Math.max(del, ins));
                this.setScore(i, j2, s);
                ++j2;
            }
            ++i;
        }
    }

    public void setDeletion(int deletion) {
        this.deletion = deletion;
    }

    public void setMatch(int match) {
        this.match = match;
    }

    public void setMissMatch(int missMatch) {
        this.missMatch = missMatch;
    }

    void setScore(int i, int j, int val) {
        this.score[i][j] = val;
    }

    int simmilarity(int i, int j) {
        if (this.a[i - 1] != this.b[j - 1]) {
            return this.missMatch;
        }
        return this.match;
    }
}

