/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.MarkerFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.GenericMarker;
import java.io.IOException;

public class GenericMarkerFileIterator
extends MarkerFileIterator<GenericMarker> {
    int colChr = 0;
    int colStart = 1;
    int colEnd = 2;

    public GenericMarkerFileIterator(String fileName, int colChr, int colStart, int colEnd, int inOffset) {
        super(fileName, inOffset);
        this.colChr = colChr;
        this.colStart = colStart;
        this.colEnd = colEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected GenericMarker readNext() {
        try {
            String[] fields;
            do {
                if (!this.ready()) {
                    return null;
                }
                this.line = this.readLine();
                if (this.line != null) continue;
                return null;
            } while (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\\s")).length < 2);
            String chromosome = fields[this.colChr].trim();
            Chromosome chromo = this.getChromosome(chromosome);
            this.sanityCheckChromo(chromosome, chromo);
            int start = 0;
            if (fields.length > this.colStart) {
                start = this.parsePosition(fields[this.colStart]);
            }
            int end = start;
            if (fields.length > this.colEnd) {
                end = this.parsePosition(fields[this.colEnd]);
            }
            String id = "line_" + this.lineNum;
            if (fields.length > 3 && !fields[3].isEmpty()) {
                id = fields[3];
            }
            GenericMarker genericMarker = new GenericMarker(chromo, start, end, id);
            genericMarker.setLine(this.line);
            return genericMarker;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

