/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.binseq;

import ca.mcgill.mcb.pcingola.binseq.BinarySequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.collections.OpenBitSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class DnaNSequence
extends DnaSequence {
    private static final long serialVersionUID = 843945646419836582L;
    OpenBitSet hasN;
    private static DnaNSequence EMPTY = null;

    public static DnaNSequence empty() {
        if (EMPTY == null) {
            EMPTY = new DnaNSequence("");
        }
        return EMPTY;
    }

    public DnaNSequence(int length, long[] codes) {
        super(length, codes);
        this.hasN = new OpenBitSet(length);
    }

    public DnaNSequence(String seqStr) {
        super(null);
        if (seqStr == null) {
            this.hasN = new OpenBitSet();
        } else {
            this.set(seqStr);
        }
    }

    @Override
    protected DnaNSequence factory() {
        return new DnaNSequence(null);
    }

    @Override
    DnaSequence factory(int length, long[] codes) {
        return new DnaNSequence(length, codes);
    }

    @Override
    public char getBase(int index2) {
        if (this.hasN.fastGet(index2)) {
            return 'N';
        }
        return super.getBase(index2);
    }

    @Override
    public String getBases(int index2, int len) {
        char[] bases = new char[len];
        int j = index2 / this.coder.basesPerWord();
        int k = this.coder.lastBaseinWord() - index2 % this.coder.basesPerWord();
        int i = 0;
        int idx = index2;
        while (i < len) {
            bases[i] = this.hasN.fastGet(idx) ? 78 : this.coder.toBase(this.codes[j], k);
            if (--k < 0) {
                k = this.coder.lastBaseinWord();
                ++j;
            }
            ++i;
            ++idx;
        }
        return new String(bases);
    }

    @Override
    public BinarySequence read(DataInputStream dataInStream) throws IOException {
        DnaNSequence binSeq = new DnaNSequence(null);
        try {
            binSeq.readDataStream(dataInStream);
        }
        catch (EOFException e) {
            return null;
        }
        return binSeq;
    }

    @Override
    protected void readDataStream(DataInputStream dataInStream) throws IOException {
        super.readDataStream(dataInStream);
        long[] bits2 = new long[OpenBitSet.bits2words(this.length)];
        int i = 0;
        while (i < bits2.length) {
            bits2[i] = dataInStream.readLong();
            ++i;
        }
        this.hasN = new OpenBitSet(bits2, bits2.length);
    }

    @Override
    public BinarySequence reverseWc() {
        DnaNSequence rwc = this.factory();
        rwc.codes = new long[this.codes.length];
        rwc.length = this.length;
        rwc.hasN.ensureCapacity(this.length);
        int j = 0;
        int k = 0;
        long s = 0L;
        int index2 = this.length - 1;
        int i = 0;
        while (index2 >= 0) {
            int idx = index2 / this.coder.basesPerWord();
            int off = this.coder.lastBaseinWord() - index2 % this.coder.basesPerWord();
            int c = this.coder.decodeWord(this.codes[idx], off);
            c = 3 & ~c;
            s <<= 2;
            s |= (long)c;
            if (++k >= this.coder.basesPerWord()) {
                rwc.codes[j] = s;
                k = 0;
                ++j;
                s = 0L;
            }
            if (this.hasN.get(index2)) {
                rwc.hasN.set(i);
            }
            --index2;
            ++i;
        }
        if (k < 64 && k != 0) {
            rwc.codes[j] = s <<= 64 - (k << 1);
        }
        return rwc;
    }

    @Override
    public void set(String seqStr) {
        super.set(seqStr, true);
        this.hasN = new OpenBitSet(seqStr.length());
        char[] seqChar = seqStr.toCharArray();
        int i = 0;
        while (i < seqChar.length) {
            switch (seqChar[i]) {
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': 
                case 'U': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': 
                case 'u': {
                    break;
                }
                default: {
                    this.hasN.fastSet(i);
                }
            }
            ++i;
        }
    }

    @Override
    public void setBase(int index2, char base) {
        if (base == 'N' || base == 'n') {
            this.hasN.fastSet(index2);
        } else {
            this.hasN.fastClear(index2);
            super.setBase(index2, base);
        }
    }

    @Override
    public String toString() {
        return this.getSequence();
    }

    @Override
    public void write(DataOutputStream dataOutStream) throws IOException {
        super.write(dataOutStream);
        long[] bits2 = this.hasN.getBits();
        int i = 0;
        while (i < bits2.length) {
            dataOutStream.writeLong(bits2[i]);
            ++i;
        }
    }

    public static /* bridge */ /* synthetic */ DnaSequence empty() {
        return DnaNSequence.empty();
    }
}

