/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class Config2DownloadTable
extends SnpEff {
    public static final String DARK_ROW = "bgcolor=#CCCCCC";
    public static final String LIGHT_ROW = "bgcolor=#EEEEEE";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String FTP_PROTOCOL = "ftp://";
    boolean galaxy = false;
    Config config = new Config("hg19");
    HashSet<String> names = new HashSet();
    ArrayList<String> namesSorted;
    ArrayList<String> genVerSorted;

    public static void main(String[] args) {
        Config2DownloadTable conf2down = new Config2DownloadTable();
        conf2down.parseArgs(args);
        conf2down.run();
    }

    public Config2DownloadTable() {
        for (String genVer : this.config) {
            this.names.add(this.config.getName(genVer));
        }
        this.namesSorted = new ArrayList();
        this.namesSorted.addAll(this.names);
        Collections.sort(this.namesSorted);
        this.genVerSorted = new ArrayList();
        for (String genVer : this.config) {
            this.genVerSorted.add(genVer);
        }
        Collections.sort(this.genVerSorted, Collections.reverseOrder());
    }

    void downloadTable() {
        boolean dark = false;
        String bg = "";
        System.out.println("\t<table> <tr bgcolor=#CCCCCC> <td> <b> Genome </b> </td>  <td> <b> Version </b> </td>  <td> <b> Reference </b> </td> </tr>");
        for (String name : this.namesSorted) {
            bg = dark ? DARK_ROW : LIGHT_ROW;
            dark = !dark;
            boolean showName = true;
            for (String genVer : this.genVerSorted) {
                String n = this.config.getName(genVer);
                if (!name.equals(n)) continue;
                System.out.println("\t\t<tr " + bg + ">");
                String name2show = showName ? name.replace('_', ' ') : "&nbsp;";
                System.out.println("\t\t\t<td> " + name2show + " </td>");
                showName = false;
                String url = "http://sourceforge.net/projects/snpeff/files/databases/v3.0/snpEff_v3.0_" + genVer + ".zip";
                System.out.println("\t\t\t<td> <a class=\"body\" href=\"" + url + "\"> " + genVer + " </a> </td>");
                String ref = this.config.getReference(genVer);
                String link2 = "";
                if (ref != null) {
                    if (ref.indexOf(44) > 0) {
                        ref = ref.substring(0, ref.indexOf(44));
                    }
                    link2 = ref;
                    int idx = ref.indexOf(47, HTTP_PROTOCOL.length());
                    if (idx > 0) {
                        ref = ref.substring(0, idx);
                    }
                    if (ref.startsWith(HTTP_PROTOCOL)) {
                        ref = ref.substring(HTTP_PROTOCOL.length());
                    }
                    if (ref.startsWith(FTP_PROTOCOL)) {
                        ref = ref.substring(FTP_PROTOCOL.length());
                    }
                } else {
                    ref = "";
                }
                System.out.println("\t\t\t<td> <a class=\"body\" href=\"" + link2 + "\">" + ref + "</a> </td>");
                System.out.println("\t\t</tr>");
            }
        }
        System.out.println("\t</table>");
    }

    void galaxyConfig() {
        System.out.println("\t<param name=\"genomeVersion\" type=\"select\" label=\"Genome\">");
        for (String name : this.namesSorted) {
            for (String genVer : this.genVerSorted) {
                String n = this.config.getName(genVer);
                if (!name.equals(n)) continue;
                System.out.println("\t\t<option value=\"" + genVer + "\">" + name.replace('_', ' ') + " : " + genVer + "</option>");
            }
        }
        System.out.println("\t</param>");
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length != 1) {
            this.usage(null);
        }
        this.galaxy = args[0].equals("galaxy");
    }

    @Override
    public boolean run() {
        if (this.galaxy) {
            this.galaxyConfig();
        } else {
            this.downloadTable();
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("Usage: snpEff cfg2table [download | galaxy]");
        System.exit(-1);
    }
}

