/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.util;

import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Objects;
import com.google.java.contract.util.Predicate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class Predicates {
    private static final Predicate<Object> TRUE = new Predicate<Object>(){

        @Override
        public boolean apply(Object object) {
            return true;
        }
    };
    private static final Predicate<Object> FALSE = new Predicate<Object>(){

        @Override
        public boolean apply(Object object) {
            return false;
        }
    };
    private static final Predicate<Object> IS_NULL = new Predicate<Object>(){

        @Override
        public boolean apply(Object object) {
            return object == null;
        }
    };
    private static final Predicate<Object> NON_NULL = new Predicate<Object>(){

        @Override
        public boolean apply(Object object) {
            return object != null;
        }
    };

    private Predicates() {
    }

    public static <S, T extends S> Predicate<T> narrow(Predicate<S> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> constant(boolean bl) {
        return bl ? Predicates.narrow(TRUE) : Predicates.narrow(FALSE);
    }

    public static <T> Predicate<T> equalTo(final T t) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t2) {
                return Objects.equal(t2, t);
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return Predicates.narrow(IS_NULL);
    }

    public static <T> Predicate<T> nonNull() {
        return Predicates.narrow(NON_NULL);
    }

    public static <T extends Comparable<T>> Predicate<T> between(final T t, final T t2) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T comparable) {
                return !(comparable == null || t != null && comparable.compareTo((Comparable)t) < 0 || t2 != null && comparable.compareTo((Comparable)t2) >= 0);
            }
        };
    }

    public static <T> Predicate<T> in(final Iterable<T> iterable) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                for (Object t2 : iterable) {
                    if (!Objects.equal(t2, t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> in(final Collection<T> collection) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                return collection.contains(t);
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<? super T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                return !predicate.apply(t);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> ... predicateArray) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                for (Predicate predicate : predicateArray) {
                    if (predicate.apply(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> ... predicateArray) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                for (Predicate predicate : predicateArray) {
                    if (!predicate.apply(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<Iterable<T>> all(final Predicate<? super T> predicate) {
        return new Predicate<Iterable<T>>(){

            @Override
            public boolean apply(Iterable<T> iterable) {
                return Iterables.all(iterable, predicate);
            }
        };
    }

    public static <T> Predicate<Iterable<T>> any(final Predicate<? super T> predicate) {
        return new Predicate<Iterable<T>>(){

            @Override
            public boolean apply(Iterable<T> iterable) {
                return Iterables.any(iterable, predicate);
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> forEntries(final Predicate<? super Set<Map.Entry<K, V>>> predicate) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean apply(Map<K, V> map) {
                return predicate.apply(map.entrySet());
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> forKeys(final Predicate<? super Set<K>> predicate) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean apply(Map<K, V> map) {
                return predicate.apply(map.keySet());
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> forValues(final Predicate<? super Collection<V>> predicate) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean apply(Map<K, V> map) {
                return predicate.apply(map.values());
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> anyEntry(Predicate<? super Map.Entry<K, V>> predicate) {
        return Predicates.forEntries(Predicates.any(predicate));
    }

    public static <K, V> Predicate<Map<K, V>> anyKey(Predicate<? super K> predicate) {
        return Predicates.forKeys(Predicates.any(predicate));
    }

    public static <K, V> Predicate<Map<K, V>> anyValue(Predicate<? super V> predicate) {
        return Predicates.forValues(Predicates.any(predicate));
    }

    public static <K, V> Predicate<Map<K, V>> allEntries(Predicate<? super Map.Entry<K, V>> predicate) {
        return Predicates.forEntries(Predicates.all(predicate));
    }

    public static <K, V> Predicate<Map<K, V>> allKeys(Predicate<? super K> predicate) {
        return Predicates.forKeys(Predicates.all(predicate));
    }

    public static <K, V> Predicate<Map<K, V>> allValues(Predicate<? super V> predicate) {
        return Predicates.forValues(Predicates.all(predicate));
    }
}

