/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.JavaTokenizer;
import java.io.IOException;
import java.io.Reader;

@Invariant(value={"currentLineNumber >= 1"})
public class LineNumberingTokenizer
extends JavaTokenizer {
    protected long currentLineNumber = 1L;

    @Requires(value={"reader != null"})
    public LineNumberingTokenizer(Reader reader) {
        super(reader);
    }

    @Override
    protected boolean lex() throws IOException {
        if (!super.lex()) {
            return false;
        }
        if (this.nextToken.kind == JavaTokenizer.TokenKind.SPACE || this.nextToken.kind == JavaTokenizer.TokenKind.COMMENT) {
            int n = -1;
            while ((n = this.nextToken.text.indexOf(10, n + 1)) != -1) {
                ++this.currentLineNumber;
            }
        }
        return true;
    }

    @Ensures(value={"result >= 1"})
    public long getCurrentLineNumber() {
        return this.currentLineNumber;
    }
}

