/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.util.EmptyElementVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class ElementScanner
extends EmptyElementVisitor {
    @Requires(value={"elements != null", "!elements.contains(null)"})
    public void scan(List<? extends ElementModel> list) {
        ArrayList<? extends ElementModel> arrayList = new ArrayList<ElementModel>(list);
        for (ElementModel elementModel : arrayList) {
            elementModel.accept(this);
        }
    }

    @Override
    public void visitType(TypeModel typeModel) {
        this.scan(typeModel.getEnclosedElements());
    }

    @Override
    public void visitVariable(VariableModel variableModel) {
        this.scan(variableModel.getEnclosedElements());
    }

    @Override
    public void visitMethod(MethodModel methodModel) {
        this.scan(methodModel.getEnclosedElements());
    }

    @Override
    public void visitContractMethod(ContractMethodModel contractMethodModel) {
        this.scan(contractMethodModel.getEnclosedElements());
    }

    @Override
    public void visitContractAnnotation(ContractAnnotationModel contractAnnotationModel) {
        this.scan(contractAnnotationModel.getEnclosedElements());
    }
}

