/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.TypeModel;
import java.util.Collections;
import java.util.Iterator;

public class HelperTypeModel
extends TypeModel {
    @Requires(value={"original != null", "original.getKind() == ElementKind.INTERFACE"})
    public HelperTypeModel(TypeModel typeModel) {
        super(typeModel);
        this.kind = ElementKind.CLASS;
        String string = this.name.getQualifiedName();
        String string2 = string + "$com$google$java$contract$H";
        String string3 = this.name.getDeclaredName().replace(string, string2);
        this.name = new ClassName(this.name.getBinaryName() + "$com$google$java$contract$H", string3, this.name.getSimpleName() + "$com$google$java$contract$H");
        this.simpleName = this.name.getSimpleName();
        this.interfaces = Collections.singleton(typeModel.getName());
        this.superArguments = Collections.emptyList();
        Iterator iterator = this.enclosedElements.iterator();
        while (iterator.hasNext()) {
            if (!((ElementModel)iterator.next()).getKind().isType()) continue;
            iterator.remove();
        }
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public HelperTypeModel(HelperTypeModel helperTypeModel) {
        super(helperTypeModel);
    }

    @Override
    public HelperTypeModel clone() {
        return new HelperTypeModel(this);
    }
}

