/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Invariant(value={"getTypeParameters() != null", "!getTypeParameters().contains(null)"})
public abstract class GenericElementModel
extends QualifiedElementModel {
    protected List<TypeName> typeParameters;

    @Requires(value={"kind != null", "name != null"})
    protected GenericElementModel(ElementKind elementKind, String string) {
        super(elementKind, string);
        this.typeParameters = new ArrayList<TypeName>();
    }

    @Requires(value={"that != null"})
    protected GenericElementModel(GenericElementModel genericElementModel) {
        super(genericElementModel);
        this.typeParameters = new ArrayList<TypeName>(genericElementModel.typeParameters);
    }

    @Override
    protected GenericElementModel clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public List<? extends TypeName> getTypeParameters() {
        return Collections.unmodifiableList(this.typeParameters);
    }

    @Ensures(value={"getTypeParameters().isEmpty()"})
    public void clearTypeParameters() {
        this.typeParameters.clear();
    }

    @Requires(value={"typeName != null"})
    @Ensures(value={"getTypeParameters().size() == old(getTypeParameters().size()) + 1", "getTypeParameters().contains(typeName)"})
    public void addTypeParameter(TypeName typeName) {
        this.typeParameters.add(typeName);
    }
}

