/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ContractVariance;

public enum ContractKind {
    PRE,
    POST,
    SIGNAL,
    INVARIANT,
    OLD,
    SIGNAL_OLD,
    ACCESS,
    HELPER;


    @Ensures(value={"result == (!isMethodContract() && !isHelperContract())"})
    public boolean isClassContract() {
        switch (this) {
            case INVARIANT: {
                return true;
            }
        }
        return false;
    }

    @Ensures(value={"result == (!isClassContract() && !isHelperContract())"})
    public boolean isMethodContract() {
        switch (this) {
            case PRE: 
            case POST: 
            case SIGNAL: 
            case OLD: 
            case SIGNAL_OLD: {
                return true;
            }
        }
        return false;
    }

    @Ensures(value={"result == (!isClassContract() && !isMethodContract())"})
    public boolean isHelperContract() {
        return !this.isClassContract() && !this.isMethodContract();
    }

    @Ensures(value={"!result || isMethodContract()", "!(result && isOld())"})
    public boolean isPostcondition() {
        switch (this) {
            case POST: 
            case SIGNAL: {
                return true;
            }
        }
        return false;
    }

    @Ensures(value={"!result || isMethodContract()", "!(result && isPostcondition())"})
    public boolean isOld() {
        switch (this) {
            case OLD: 
            case SIGNAL_OLD: {
                return true;
            }
        }
        return false;
    }

    @Requires(value={"isPostcondition()"})
    public ContractKind getOldKind() {
        switch (this) {
            case POST: {
                return OLD;
            }
            case SIGNAL: {
                return SIGNAL_OLD;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean hasNameSpace() {
        return this != HELPER;
    }

    @Requires(value={"hasNameSpace()"})
    @Ensures(value={"ClassName.isSimpleName(result)"})
    public String getNameSpace() {
        switch (this) {
            case PRE: {
                return "com$google$java$contract$P";
            }
            case POST: {
                return "com$google$java$contract$Q";
            }
            case SIGNAL: {
                return "com$google$java$contract$E";
            }
            case INVARIANT: {
                return "com$google$java$contract$I";
            }
            case OLD: {
                return "com$google$java$contract$QO";
            }
            case SIGNAL_OLD: {
                return "com$google$java$contract$EO";
            }
            case ACCESS: {
                return "access";
            }
        }
        throw new IllegalArgumentException();
    }

    @Requires(value={"!isHelperContract()"})
    @Ensures(value={"ClassName.isSimpleName(result)"})
    public String getHelperNameSpace() {
        switch (this) {
            case PRE: {
                return "com$google$java$contract$PH";
            }
            case POST: {
                return "com$google$java$contract$QH";
            }
            case SIGNAL: {
                return "com$google$java$contract$EH";
            }
            case INVARIANT: {
                return "com$google$java$contract$IH";
            }
            case OLD: {
                return "com$google$java$contract$QOH";
            }
            case SIGNAL_OLD: {
                return "com$google$java$contract$EOH";
            }
        }
        throw new IllegalArgumentException();
    }

    public ContractVariance getVariance() {
        switch (this) {
            case PRE: {
                return ContractVariance.CONTRAVARIANT;
            }
            case INVARIANT: 
            case POST: 
            case SIGNAL: {
                return ContractVariance.COVARIANT;
            }
        }
        return null;
    }
}

