/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.util.Predicate;

@Invariant(value={"isSimpleName(getSimpleName())", "isQualifiedName(getQualifiedName())", "isQualifiedName(getSemiQualifiedName())", "isBinaryName(getBinaryName())"})
public class ClassName
extends TypeName {
    protected String simpleName;
    protected String qualifiedName;
    protected String semiQualifiedName;
    protected String binaryName;
    protected static final Predicate<String> IS_SIMPLE_NAME = new Predicate<String>(){

        @Override
        public boolean apply(String string) {
            return ClassName.isSimpleName(string);
        }
    };
    private static final Predicate<String> IS_QUALIFIED_NAME = new Predicate<String>(){

        @Override
        public boolean apply(String string) {
            return ClassName.isQualifiedName(string);
        }
    };
    private static final Predicate<String> IS_BINARY_NAME = new Predicate<String>(){

        @Override
        public boolean apply(String string) {
            return ClassName.isBinaryName(string);
        }
    };

    @Requires(value={"isBinaryName(binaryName)"})
    @Ensures(value={"binaryName.equals(getBinaryName())"})
    public ClassName(String string) {
        this.binaryName = string;
        this.simpleName = null;
        this.inferSemiQualifiedName();
        this.inferQualifiedName();
        this.inferSimpleName();
        this.declaredName = this.qualifiedName;
    }

    @Requires(value={"isBinaryName(binaryName)", "declaredName != null"})
    @Ensures(value={"binaryName.equals(getBinaryName())", "declaredName.equals(getDeclaredName())"})
    public ClassName(String string, String string2) {
        this.binaryName = string;
        this.declaredName = string2;
        this.simpleName = null;
        this.inferSemiQualifiedName();
        this.inferQualifiedName();
        this.inferSimpleName();
        this.assertDeclaredQualifiedMatch();
    }

    @Requires(value={"binaryName != null", "declaredName != null", "simpleName != null", "binaryName.endsWith(simpleName)"})
    @Ensures(value={"binaryName.equals(getBinaryName())", "declaredName.equals(getDeclaredName())", "simpleName.equals(getSimpleName())"})
    public ClassName(String string, String string2, String string3) {
        this.binaryName = string;
        this.declaredName = string2;
        this.simpleName = string3;
        this.inferSemiQualifiedName();
        this.inferQualifiedName();
        this.assertDeclaredQualifiedMatch();
    }

    protected void assertDeclaredQualifiedMatch() {
        if (!this.declaredName.replaceAll("<[^.]*>", "").startsWith(this.qualifiedName)) {
            throw new IllegalArgumentException("declared name '" + this.declaredName + "' does not match qualified name '" + this.qualifiedName + "'");
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    @Requires(value={"pathName != null"})
    @Ensures(value={"result != null"})
    public static String getRelativeName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    @Requires(value={"pathName != null"})
    @Ensures(value={"result != null"})
    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getSemiQualifiedName() {
        return this.semiQualifiedName;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    private void inferSemiQualifiedName() {
        this.semiQualifiedName = this.binaryName.replace('/', '.');
    }

    private void inferQualifiedName() {
        if (this.simpleName == null) {
            this.qualifiedName = this.semiQualifiedName.replace('$', '.');
        } else {
            int n = this.semiQualifiedName.length() - this.simpleName.length();
            String string = this.semiQualifiedName.substring(0, n);
            this.qualifiedName = string.replace('$', '.') + this.simpleName;
        }
    }

    private void inferSimpleName() {
        int n = this.qualifiedName.lastIndexOf(46);
        this.simpleName = n == -1 ? this.qualifiedName : this.qualifiedName.substring(n + 1);
    }

    public boolean equals(Object object) {
        return object instanceof ClassName && this.binaryName.equals(((ClassName)object).binaryName) && this.declaredName.equals(((ClassName)object).declaredName);
    }

    public int hashCode() {
        return this.binaryName.hashCode() ^ this.declaredName.hashCode();
    }

    public static boolean isSimpleName(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Predicate<String> isSimpleName() {
        return IS_SIMPLE_NAME;
    }

    @Ensures(value={"result == isBinaryName(name.replace('.', '/'))"})
    public static boolean isQualifiedName(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (String string2 : stringArray = string.split("\\.")) {
            if (ClassName.isSimpleName(string2)) continue;
            return false;
        }
        return true;
    }

    public static Predicate<String> isQualifiedName() {
        return IS_QUALIFIED_NAME;
    }

    public static boolean isStarQualifiedName(String string) {
        return string != null && string.endsWith(".*") && ClassName.isQualifiedName(string.substring(0, string.length() - 2));
    }

    @Ensures(value={"result == isQualifiedName(name.replace('/', '.'))"})
    public static boolean isBinaryName(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (String string2 : stringArray = string.split("/")) {
            if (ClassName.isSimpleName(string2)) continue;
            return false;
        }
        return true;
    }

    public static Predicate<String> isBinaryName() {
        return IS_BINARY_NAME;
    }
}

