/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.AbstractTypeBuilder;
import com.google.java.contract.core.apt.AnnotationSourceInfo;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.apt.SuperCallBuilder;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.VariableModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@Invariant(value={"diagnosticManager != null", "methodMap != null"})
class TypeBuilder
extends AbstractTypeBuilder {
    protected DiagnosticManager diagnosticManager;
    protected ClassLoader sourceDependencyLoader;
    protected TypeModel type;
    protected TypeElement rootMirror;
    protected Set<String> importNames;
    protected HashMap<String, ArrayList<ContractableMethod>> methodMap;

    TypeBuilder(Set<String> set, Iterator<Long> iterator, FactoryUtils factoryUtils, ClassLoader classLoader, DiagnosticManager diagnosticManager) {
        super(factoryUtils);
        this.sourceDependencyLoader = classLoader;
        this.diagnosticManager = diagnosticManager;
        this.type = null;
        this.rootMirror = null;
        this.importNames = set;
        this.rootLineNumberIterator = iterator;
        this.methodMap = new HashMap();
    }

    TypeBuilder(FactoryUtils factoryUtils, ClassLoader classLoader, DiagnosticManager diagnosticManager) {
        this(null, null, factoryUtils, classLoader, diagnosticManager);
    }

    TypeModel getType() {
        return this.type;
    }

    @Override
    @Ensures(value={"type != null"})
    public Void visitType(TypeElement typeElement, ElementModel elementModel) {
        Object object;
        Object object2;
        Object object3;
        if (this.type != null) {
            TypeBuilder typeBuilder = new TypeBuilder(this.importNames, this.rootLineNumberIterator, this.utils, this.sourceDependencyLoader, this.diagnosticManager);
            typeElement.accept(typeBuilder, elementModel);
            elementModel.addEnclosedElement(typeBuilder.type);
            return null;
        }
        this.rootMirror = typeElement;
        ElementKind elementKind = null;
        switch (typeElement.getKind()) {
            case INTERFACE: {
                elementKind = ElementKind.INTERFACE;
                break;
            }
            case ENUM: {
                elementKind = ElementKind.ENUM;
                break;
            }
            case CLASS: {
                elementKind = ElementKind.CLASS;
                break;
            }
            case ANNOTATION_TYPE: {
                elementKind = ElementKind.ANNOTATION_TYPE;
                break;
            }
            default: {
                return null;
            }
        }
        this.type = new TypeModel(elementKind, this.utils.getClassNameForType(typeElement.asType()));
        this.utils.copyModifiers(typeElement, this.type);
        if (elementKind == ElementKind.ENUM) {
            this.type.removeModifier(ElementModifier.FINAL);
        }
        if (this.importNames == null) {
            if (this.sourceDependencyLoader != null) {
                try {
                    this.fetchSourceDependency();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.importNames == null) {
                this.importNames = this.getImportNames(typeElement);
            }
            object3 = this.importNames.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                this.type.addImportName((String)object2);
            }
        }
        if ((object3 = typeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
            this.type.setSuperclass(this.utils.getClassNameForType((TypeMirror)object3));
        }
        object2 = typeElement.getInterfaces();
        List<? extends TypeParameterElement> list = object2.iterator();
        while (list.hasNext()) {
            object = list.next();
            this.type.addInterface(this.utils.getClassNameForType((TypeMirror)object));
        }
        if (elementKind != ElementKind.ENUM && (list = typeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
            object = (TypeElement)this.utils.typeUtils.asElement((TypeMirror)((Object)list));
            SuperCallBuilder object4 = new SuperCallBuilder((DeclaredType)((Object)list), this.type, this.utils);
            object.accept(object4, null);
        }
        list = typeElement.getTypeParameters();
        for (TypeParameterElement typeParameterElement : list) {
            this.type.addTypeParameter(this.utils.getGenericTypeName(typeParameterElement));
        }
        this.scanAnnotations(typeElement, true, this.type.getName(), this.type);
        this.scan(typeElement.getEnclosedElements(), this.type);
        this.scanSuper(typeElement);
        return null;
    }

    @Override
    protected void visitAnnotation(Element element, AnnotationMirror annotationMirror, boolean bl, ClassName className, ElementModel elementModel) {
        if (this.utils.isContractAnnotation(annotationMirror)) {
            ContractAnnotationModel contractAnnotationModel = this.createContractModel(element, annotationMirror, bl, className);
            if (this.type.getKind() == ElementKind.ANNOTATION_TYPE) {
                AnnotationSourceInfo annotationSourceInfo = (AnnotationSourceInfo)contractAnnotationModel.getSourceInfo();
                this.diagnosticManager.warning("Contracts can't be applied to annotations. The following annotation will not perform any contract check: " + this.type.toString(), ((Object)annotationSourceInfo.getAnnotationValue()).toString(), 0, 0, 0, annotationSourceInfo);
            } else {
                elementModel.addEnclosedElement(contractAnnotationModel);
            }
        }
    }

    @Requires(value={"sourceDependencyLoader != null", "type != null"})
    @Ensures(value={"importNames != null", "rootLineNumberIterator != null"})
    protected void fetchSourceDependency() throws IOException {
        String string = this.type.getName().getBinaryName() + ".java.d";
        InputStream inputStream = this.sourceDependencyLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        try {
            this.importNames = (Set)objectInputStream.readObject();
            this.rootLineNumberIterator = ((List)objectInputStream.readObject()).iterator();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException);
        }
        objectInputStream.close();
    }

    @Override
    public Void visitVariable(VariableElement variableElement, ElementModel elementModel) {
        ElementKind elementKind = null;
        switch (variableElement.getKind()) {
            case ENUM_CONSTANT: {
                elementKind = ElementKind.CONSTANT;
                break;
            }
            default: {
                elementKind = elementModel.getKind().isType() ? ElementKind.FIELD : ElementKind.PARAMETER;
            }
        }
        VariableModel variableModel = new VariableModel(elementKind, variableElement.getSimpleName().toString(), this.utils.getTypeNameForType(variableElement.asType()));
        this.utils.copyModifiers(variableElement, variableModel);
        this.scanAnnotations(variableElement, true, this.type.getName(), variableModel);
        elementModel.addEnclosedElement(variableModel);
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement executableElement, ElementModel elementModel) {
        Iterator<? extends TypeMirror> iterator;
        Object object;
        MethodModel methodModel = null;
        String string = executableElement.getSimpleName().toString();
        if (elementModel.getKind() == ElementKind.ENUM) {
            object = (ExecutableType)executableElement.asType();
            if (string.equals("values")) {
                if (object.getParameterTypes().isEmpty()) {
                    return null;
                }
            } else if (string.equals("valueOf")) {
                iterator = Collections.singletonList(this.utils.elementUtils.getTypeElement("java.lang.String").asType());
                if (((Object)object.getParameterTypes()).equals(iterator)) {
                    return null;
                }
            }
        }
        methodModel = string.toString().equals("<init>") ? new MethodModel() : new MethodModel(ElementKind.METHOD, string, this.utils.getTypeNameForType(executableElement.getReturnType()));
        this.utils.copyModifiers(executableElement, methodModel);
        object = executableElement.getTypeParameters();
        iterator = object.iterator();
        while (iterator.hasNext()) {
            TypeParameterElement annotatedConstruct = (TypeParameterElement)iterator.next();
            methodModel.addTypeParameter(this.utils.getGenericTypeName(annotatedConstruct));
        }
        this.scan(executableElement.getParameters(), methodModel);
        methodModel.setVariadic(executableElement.isVarArgs());
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            methodModel.addException(this.utils.getTypeNameForType(typeMirror));
        }
        this.scanAnnotations(executableElement, true, this.type.getName(), methodModel);
        elementModel.addEnclosedElement(methodModel);
        this.addMethod(string, executableElement, methodModel);
        return null;
    }

    protected void addMethod(String string, ExecutableElement executableElement, MethodModel methodModel) {
        ArrayList<ContractableMethod> arrayList = this.methodMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.methodMap.put(string, arrayList);
        }
        arrayList.add(new ContractableMethod(executableElement, methodModel));
    }

    protected void scanSuper(TypeElement typeElement) {
        TypeElement typeElement2 = (TypeElement)this.utils.typeUtils.asElement(typeElement.getSuperclass());
        if (typeElement2 != null) {
            typeElement2.accept(new ContractExtensionBuilder(), this.type);
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            TypeElement typeElement3 = (TypeElement)this.utils.typeUtils.asElement(typeMirror);
            typeElement3.accept(new ContractExtensionBuilder(), this.type);
        }
    }

    protected class ContractExtensionBuilder
    extends AbstractTypeBuilder {
        protected TypeElement mirror;

        public ContractExtensionBuilder() {
            super(TypeBuilder.this.utils);
        }

        @Override
        public Void visitType(TypeElement typeElement, ElementModel elementModel) {
            if (this.mirror != null) {
                throw new IllegalStateException();
            }
            this.mirror = typeElement;
            this.scanAnnotations(typeElement, false, this.utils.getClassNameForType(typeElement.asType()), TypeBuilder.this.type);
            this.scan(ElementFilter.methodsIn(typeElement.getEnclosedElements()), TypeBuilder.this.type);
            TypeBuilder.this.scanSuper(typeElement);
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement executableElement, ElementModel elementModel) {
            String string = executableElement.getSimpleName().toString();
            ArrayList<ContractableMethod> arrayList = TypeBuilder.this.methodMap.get(string);
            if (arrayList == null) {
                return null;
            }
            for (ContractableMethod contractableMethod : arrayList) {
                if (!this.utils.elementUtils.overrides(contractableMethod.mirror, executableElement, TypeBuilder.this.rootMirror)) continue;
                this.scanAnnotations(executableElement, false, this.utils.getClassNameForType(this.mirror.asType()), contractableMethod.element);
            }
            return null;
        }
    }

    protected class ContractableMethod {
        protected ExecutableElement mirror;
        protected MethodModel element;

        public ContractableMethod(ExecutableElement executableElement, MethodModel methodModel) {
            this.mirror = executableElement;
            this.element = methodModel;
        }
    }
}

