/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.ContractCreation;
import com.google.java.contract.core.apt.ContractExpressionCreationTrait;
import com.google.java.contract.core.apt.ContractExpressionTransformer;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.util.ElementScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@Invariant(value={"diagnosticManager != null", "transformer != null"})
public class MethodContractCreator
extends ElementScanner {
    protected DiagnosticManager diagnosticManager;
    protected MethodModel method;
    protected ContractMethodModel preMethod;
    protected ContractMethodModel postMethod;
    protected ContractMethodModel postSignalMethod;
    protected ContractExpressionTransformer transformer;

    @Requires(value={"diagnosticManager != null"})
    public MethodContractCreator(DiagnosticManager diagnosticManager) {
        this.diagnosticManager = diagnosticManager;
        this.method = null;
        this.preMethod = null;
        this.postMethod = null;
        this.postSignalMethod = null;
        this.transformer = new ContractExpressionTransformer(diagnosticManager, true);
    }

    @Override
    public void visitMethod(MethodModel methodModel) {
        if (this.method != null) {
            throw new IllegalStateException();
        }
        this.method = methodModel;
        super.visitMethod(methodModel);
    }

    @Override
    public void visitContractAnnotation(ContractAnnotationModel contractAnnotationModel) {
        List<String> list = contractAnnotationModel.getValues();
        if (contractAnnotationModel.getKind().equals((Object)ElementKind.REQUIRES)) {
            PreMethodCreationTrait preMethodCreationTrait = new PreMethodCreationTrait(this.transformer);
            this.preMethod = ContractCreation.createContractMethods(preMethodCreationTrait, this.preMethod, contractAnnotationModel);
        } else if (contractAnnotationModel.getKind().equals((Object)ElementKind.ENSURES)) {
            PostMethodCreationTrait postMethodCreationTrait = new PostMethodCreationTrait(this.transformer);
            this.postMethod = ContractCreation.createContractMethods(postMethodCreationTrait, this.postMethod, contractAnnotationModel);
        } else if (contractAnnotationModel.getKind().equals((Object)ElementKind.THROW_ENSURES)) {
            PostSignalMethodCreationTrait postSignalMethodCreationTrait = new PostSignalMethodCreationTrait(this.transformer);
            this.postSignalMethod = ContractCreation.createContractMethods(postSignalMethodCreationTrait, this.postSignalMethod, contractAnnotationModel);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Requires(value={"type != null"})
    @Ensures(value={"result != null"})
    private static VariableModel getResultVariable(TypeName typeName) {
        VariableModel variableModel = new VariableModel(ElementKind.PARAMETER, "result", typeName);
        variableModel.addModifier(ElementModifier.FINAL);
        return variableModel;
    }

    @Ensures(value={"result != null"})
    private static VariableModel getSignalVariable() {
        VariableModel variableModel = new VariableModel(ElementKind.PARAMETER, "signal", new ClassName("java/lang/Exception"));
        variableModel.addModifier(ElementModifier.FINAL);
        return variableModel;
    }

    @Requires(value={"kind != null", "pos >= 0", "id >= 0", "pos <= id", "expr != null", "annotation != null", "kind.isOld()", "lineNumber == null || lineNumber >= 1"})
    private void createOldMethods(ContractKind contractKind, int n, int n2, String string, ContractAnnotationModel contractAnnotationModel, Long l) {
        ContractMethodModel contractMethodModel;
        MethodModel methodModel = ContractCreation.createBlankContractHelper(contractKind, contractAnnotationModel, "$" + Integer.toString(n));
        methodModel.setReturnType(new ClassName("java/lang/Object"));
        if (methodModel.getKind() == ElementKind.CONTRACT_METHOD) {
            contractMethodModel = (ContractMethodModel)methodModel;
            if (l != null) {
                contractMethodModel.setLineNumbers(Collections.singletonList(l));
            }
            String string2 = string;
            if (!contractAnnotationModel.isVirtual()) {
                string2 = ContractCreation.rebaseLocalCalls(string, "com$google$java$contract$local$that", null);
            }
            contractMethodModel.addStatement("return " + string2 + ";");
        }
        contractMethodModel = ContractCreation.createBlankContractMethod(contractKind, contractAnnotationModel, "$" + n2);
        contractMethodModel.setReturnType(new ClassName("java/lang/Object"));
        contractMethodModel.setId(n2);
        contractMethodModel.addStatement("return " + ContractCreation.getHelperCallCode(methodModel, contractAnnotationModel) + ";");
    }

    protected class PostSignalMethodCreationTrait
    extends CommonPostMethodCreationTrait {
        protected List<String> messages;
        protected List<String> sourceCode;

        @Requires(value={"transformer != null"})
        public PostSignalMethodCreationTrait(ContractExpressionTransformer contractExpressionTransformer) {
            super(contractExpressionTransformer);
        }

        @Override
        public boolean visit(ContractAnnotationModel contractAnnotationModel) {
            this.annotation = contractAnnotationModel;
            List<String> list = contractAnnotationModel.getValues();
            int n = list.size() / 2;
            ArrayList<String> arrayList = new ArrayList<String>(n);
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            ArrayList<String> arrayList3 = new ArrayList<String>(n);
            ArrayList<Long> arrayList4 = new ArrayList<Long>(n);
            Iterator<String> iterator = list.iterator();
            Iterator<Long> iterator2 = contractAnnotationModel.getLineNumbers().iterator();
            try {
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    String string2 = iterator.next();
                    arrayList.add("!(signal instanceof " + string + ") || " + string2);
                    arrayList2.add(string + " => " + string2);
                    arrayList3.add(string2);
                    iterator2.next();
                    arrayList4.add(iterator2.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                MethodContractCreator.this.diagnosticManager.warning("extra exception type in 'com.google.java.contract.ThrowEnsures'; ignored", list.get(list.size() - 1), 0, 0, 0, contractAnnotationModel.getSourceInfo());
            }
            if (!this.transform(arrayList, arrayList4, contractAnnotationModel.getSourceInfo())) {
                return false;
            }
            this.messages = arrayList2;
            this.sourceCode = arrayList3;
            return true;
        }

        @Override
        public List<? extends VariableModel> getInitialParameters() {
            return Collections.singletonList(MethodContractCreator.getSignalVariable());
        }

        @Override
        public List<String> getMessages() {
            return this.messages;
        }

        @Override
        public List<String> getSourceExpressions() {
            return this.sourceCode;
        }
    }

    protected class PostMethodCreationTrait
    extends CommonPostMethodCreationTrait {
        @Requires(value={"transformer != null"})
        public PostMethodCreationTrait(ContractExpressionTransformer contractExpressionTransformer) {
            super(contractExpressionTransformer);
        }

        @Override
        public List<? extends VariableModel> getInitialParameters() {
            if (MethodContractCreator.this.method.isConstructor() || MethodContractCreator.this.method.getReturnType().getDeclaredName().equals("void")) {
                return Collections.emptyList();
            }
            return Collections.singletonList(MethodContractCreator.getResultVariable(MethodContractCreator.this.method.getReturnType()));
        }

        @Override
        public List<? extends VariableModel> getInitialMockParameters() {
            if (MethodContractCreator.this.method.isConstructor() || MethodContractCreator.this.method.getReturnType().getDeclaredName().equals("void")) {
                return Collections.emptyList();
            }
            return Collections.singletonList(MethodContractCreator.getResultVariable(this.annotation.getReturnType()));
        }
    }

    protected class CommonPostMethodCreationTrait
    extends ContractExpressionCreationTrait {
        @Requires(value={"transformer != null"})
        public CommonPostMethodCreationTrait(ContractExpressionTransformer contractExpressionTransformer) {
            super(contractExpressionTransformer);
        }

        @Override
        public boolean transform(List<String> list, List<Long> list2, Object object) {
            int n = this.transformer.getNextOldId();
            this.transformer.setAcceptOld(true);
            boolean bl = super.transform(list, list2, object);
            if (bl) {
                ContractKind contractKind = ContractCreation.getContractKind(this.annotation).getOldKind();
                Iterator<String> iterator = this.transformer.getOldParametersCode().iterator();
                Iterator<Long> iterator2 = this.transformer.getOldParametersLineNumbers().iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    MethodContractCreator.this.createOldMethods(contractKind, n2++, n++, iterator.next(), this.annotation, iterator2.next());
                }
            }
            return bl;
        }

        @Override
        public List<? extends VariableModel> getExtraParameters() {
            return this.transformer.getOldParameters();
        }

        @Override
        public String getExceptionName() {
            return "com.google.java.contract.PostconditionError";
        }
    }

    protected class PreMethodCreationTrait
    extends ContractExpressionCreationTrait {
        @Requires(value={"transformer != null"})
        public PreMethodCreationTrait(ContractExpressionTransformer contractExpressionTransformer) {
            super(contractExpressionTransformer);
        }

        @Override
        public boolean transform(List<String> list, List<Long> list2, Object object) {
            this.transformer.setAcceptOld(false);
            return super.transform(list, list2, object);
        }

        @Override
        public String getExceptionName() {
            return "com.google.java.contract.PreconditionError";
        }
    }
}

